"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_secrets_1 = require("../handler/secrets/action-secrets");
class ActionSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const handler = new action_secrets_1.ActionSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionSecretCustomResourceHandler',
            description: 'Handles the creation/deletion of a GitHub Action (repository) secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'SecretProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionSecret = ActionSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionSecret[_a] = { fqn: "cdk-github.ActionSecret", version: "0.0.18" };
//# sourceMappingURL=data:application/json;base64,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