# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-03 01:42
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('main', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Environment',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=40, unique=True)),
                ('type', models.CharField(default='Default', max_length=20)),
                ('key', models.CharField(blank=True, max_length=2048, null=True)),
                ('_data', models.CharField(db_column='data', default='{}', max_length=2048)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('group', models.BooleanField(default=False)),
                ('address', models.CharField(default=uuid.uuid1, max_length=128, unique=True)),
                ('name', models.CharField(default='null', max_length=100)),
                ('auth_user', models.CharField(default='', max_length=64)),
                ('auth_type', models.CharField(default='PASSWD', max_length=6)),
                ('auth_data', models.CharField(default='', max_length=4096)),
                ('nodeid', models.CharField(blank=True, max_length=256, null=True)),
                ('environment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='hosts', to='main.Environment')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='hosts', to='main.Host')),
            ],
            options={
                'default_related_name': 'hosts',
            },
        ),
        migrations.CreateModel(
            name='Scenario',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('group', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.Scenario')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('group', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('data', models.TextField()),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.Task')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TaskList',
            fields=[
                ('id', models.AutoField(max_length=20, primary_key=True, serialize=False)),
                ('priority', models.PositiveIntegerField(default=0)),
                ('scenario', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasklist', to='main.Scenario')),
                ('task', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tasklist', to='main.Task')),
            ],
            options={
                'ordering': ['scenario', 'priority', 'id'],
                'default_related_name': 'tasklist',
            },
        ),
        migrations.AlterUniqueTogether(
            name='tasklist',
            unique_together=set([('scenario', 'task', 'priority')]),
        ),
    ]
