# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: mapped/cloud/types/calendar_period.proto, mapped/cloud/types/date.proto, mapped/cloud/types/dayofweek.proto, mapped/cloud/types/geojson.proto, mapped/cloud/types/interval.proto, mapped/cloud/types/metadata.proto, mapped/cloud/types/money.proto, mapped/cloud/types/month.proto, mapped/cloud/types/phone_number.proto, mapped/cloud/types/postal_address.proto, mapped/cloud/types/timeofday.proto, mapped/cloud/types/typed_value.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import (
    Dict,
    List,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


class CalendarPeriod(betterproto.Enum):
    """
    A `CalendarPeriod` represents the abstract concept of a time period that
    has a canonical start. Grammatically, "the start of the current
    `CalendarPeriod`." All calendar times begin at midnight UTC.
    """

    CALENDAR_PERIOD_UNSPECIFIED = 0
    """Undefined period, raises an error."""

    DAY = 1
    """A day."""

    WEEK = 2
    """
    A week. Weeks begin on Monday, following [ISO
    8601](https://en.wikipedia.org/wiki/ISO_week_date).
    """

    FORTNIGHT = 3
    """
    A fortnight. The first calendar fortnight of the year begins at the start
    of week 1 according to [ISO
    8601](https://en.wikipedia.org/wiki/ISO_week_date).
    """

    MONTH = 4
    """A month."""

    QUARTER = 5
    """
    A quarter. Quarters start on dates 1-Jan, 1-Apr, 1-Jul, and 1-Oct of each
    year.
    """

    HALF = 6
    """A half-year. Half-years start on dates 1-Jan and 1-Jul."""

    YEAR = 7
    """A year."""


class DayOfWeek(betterproto.Enum):
    """Represents a day of the week."""

    DAY_OF_WEEK_UNSPECIFIED = 0
    """The day of the week is unspecified."""

    MONDAY = 1
    """Monday"""

    TUESDAY = 2
    """Tuesday"""

    WEDNESDAY = 3
    """Wednesday"""

    THURSDAY = 4
    """Thursday"""

    FRIDAY = 5
    """Friday"""

    SATURDAY = 6
    """Saturday"""

    SUNDAY = 7
    """Sunday"""


class Month(betterproto.Enum):
    """Represents a month in the Gregorian calendar."""

    MONTH_UNSPECIFIED = 0
    """The unspecifed month."""

    JANUARY = 1
    """The month of January."""

    FEBRUARY = 2
    """The month of February."""

    MARCH = 3
    """The month of March."""

    APRIL = 4
    """The month of April."""

    MAY = 5
    """The month of May."""

    JUNE = 6
    """The month of June."""

    JULY = 7
    """The month of July."""

    AUGUST = 8
    """The month of August."""

    SEPTEMBER = 9
    """The month of September."""

    OCTOBER = 10
    """The month of October."""

    NOVEMBER = 11
    """The month of November."""

    DECEMBER = 12
    """The month of December."""


@dataclass(eq=False, repr=False)
class Date(betterproto.Message):
    """
    Represents a whole or partial calendar date, such as a birthday. The time
    of day and time zone are either specified elsewhere or are insignificant.
    The date is relative to the Gregorian Calendar. This can represent one of
    the following: * A full date, with non-zero year, month, and day values * A
    month and day value, with a zero year, such as an anniversary * A year on
    its own, with zero month and day values * A year and month value, with a
    zero day, such as a credit card expiration date Related types are
    [com.mapped.cloud.types.TimeOfDay][com.mapped.cloud.types.TimeOfDay] and
    `google.protobuf.Timestamp`. ISO-8601 compatible date only... Lacking a
    language specific "date onnly" format, it is recommended to hold this as a
    string in the ISO-8601 format ("yyyy-MM-dd")
    """

    year: int = betterproto.int32_field(1)
    """
    Year of the date. Must be from 1 to 9999, or 0 to specify a date without a
    year.
    """

    month: int = betterproto.int32_field(2)
    """
    Month of a year. Must be from 1 to 12, or 0 to specify a year without a
    month and day.
    """

    day: int = betterproto.int32_field(3)
    """
    Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
    to specify a year by itself or a year and month where the day isn't
    significant.
    """


@dataclass(eq=False, repr=False)
class GeoPoint(betterproto.Message):
    """Represents a GeoPoint"""

    type: str = betterproto.string_field(1)
    coordinates: List[float] = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class Interval(betterproto.Message):
    """
    Represents a time interval, encoded as a Timestamp start (inclusive) and a
    Timestamp end (exclusive). The start must be less than or equal to the end.
    When the start equals the end, the interval is empty (matches no time).
    When both start and end are unspecified, the interval matches any time.
    """

    start_time: datetime = betterproto.message_field(1)
    """
    Optional. Inclusive start of the interval. If specified, a Timestamp
    matching this interval will have to be the same or after the start.
    """

    end_time: datetime = betterproto.message_field(2)
    """
    Optional. Exclusive end of the interval. If specified, a Timestamp matching
    this interval will have to be before the end.
    """


@dataclass(eq=False, repr=False)
class MetadataRecord(betterproto.Message):
    key: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MetadataValue(betterproto.Message):
    values: List["MetadataRecord"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MetadataUpdate(betterproto.Message):
    granular: "MetadataUpdateGranular" = betterproto.message_field(1, group="update")
    replace: "MetadataValue" = betterproto.message_field(2, group="update")


@dataclass(eq=False, repr=False)
class MetadataUpdateGranular(betterproto.Message):
    add: List["MetadataRecord"] = betterproto.message_field(1)
    remove: List["MetadataRecord"] = betterproto.message_field(2)
    remove_all: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Money(betterproto.Message):
    """Represents an amount of money with its currency type."""

    currency_code: str = betterproto.string_field(1)
    """The three-letter currency code defined in ISO 4217."""

    units: int = betterproto.int64_field(2)
    """
    The whole units of the amount. For example if `currencyCode` is `"USD"`,
    then 1 unit is one US dollar.
    """

    nanos: int = betterproto.int32_field(3)
    """
    Number of nano (10^-9) units of the amount. The value must be between
    -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
    must be positive or zero. If `units` is zero, `nanos` can be positive,
    zero, or negative. If `units` is negative, `nanos` must be negative or
    zero. For example $-1.75 is represented as `units`=-1 and
    `nanos`=-750,000,000.
    """


@dataclass(eq=False, repr=False)
class PhoneNumber(betterproto.Message):
    """
    An object representing a phone number, suitable as an API wire format. This
    representation:  - should not be used for locale-specific formatting of a
    phone number, such    as "+1 (650) 253-0000 ext. 123"  - is not designed
    for efficient storage  - may not be suitable for dialing - specialized
    libraries (see references)    should be used to parse the number for that
    purpose To do something meaningful with this number, such as format it for
    various use-cases, convert it to an `i18n.phonenumbers.PhoneNumber` object
    first. For instance, in Java this would be:
    com.mapped.cloud.types.PhoneNumber wireProto =
    com.mapped.cloud.types.PhoneNumber.newBuilder().build();
    com.google.i18n.phonenumbers.Phonenumber.PhoneNumber phoneNumber =
    PhoneNumberUtil.getInstance().parse(wireProto.getE164Number(), "ZZ");    if
    (!wireProto.getExtension().isEmpty()) {
    phoneNumber.setExtension(wireProto.getExtension());    }  Reference(s):   -
    https://github.com/google/libphonenumber
    """

    e164_number: str = betterproto.string_field(1, group="kind")
    """
    The phone number, represented as a leading plus sign ('+'), followed by a
    phone number that uses a relaxed ITU E.164 format consisting of the country
    calling code (1 to 3 digits) and the subscriber number, with no additional
    spaces or formatting, e.g.:  - correct: "+15552220123"  - incorrect: "+1
    (555) 222-01234 x123". The ITU E.164 format limits the latter to 12 digits,
    but in practice not all countries respect that, so we relax that
    restriction here. National-only numbers are not allowed. References:  -
    https://www.itu.int/rec/T-REC-E.164-201011-I  -
    https://en.wikipedia.org/wiki/E.164.  -
    https://en.wikipedia.org/wiki/List_of_country_calling_codes
    """

    short_code: "PhoneNumberShortCode" = betterproto.message_field(2, group="kind")
    """
    A short code. Reference(s):  - https://en.wikipedia.org/wiki/Short_code
    """

    extension: str = betterproto.string_field(3)
    """
    The phone number's extension. The extension is not standardized in ITU
    recommendations, except for being defined as a series of numbers with a
    maximum length of 40 digits. Other than digits, some other dialing
    characters such as ',' (indicating a wait) or '#' may be stored here. Note
    that no regions currently use extensions with short codes, so this field is
    normally only set in conjunction with an E.164 number. It is held
    separately from the E.164 number to allow for short code extensions in the
    future.
    """


@dataclass(eq=False, repr=False)
class PhoneNumberShortCode(betterproto.Message):
    """
    An object representing a short code, which is a phone number that is
    typically much shorter than regular phone numbers and can be used to
    address messages in MMS and SMS systems, as well as for abbreviated dialing
    (e.g. "Text 611 to see how many minutes you have remaining on your plan.").
    Short codes are restricted to a region and are not internationally
    dialable, which means the same short code can exist in different regions,
    with different usage and pricing, even if those regions share the same
    country calling code (e.g. US and CA).
    """

    region_code: str = betterproto.string_field(1)
    """
    Required. The BCP-47 region code of the location where calls to this short
    code can be made, such as "US" and "BB". Reference(s):  -
    http://www.unicode.org/reports/tr35/#unicode_region_subtag
    """

    number: str = betterproto.string_field(2)
    """
    Required. The short code digits, without a leading plus ('+') or country
    calling code, e.g. "611".
    """


@dataclass(eq=False, repr=False)
class PostalAddress(betterproto.Message):
    """
    Represents a postal address, e.g. for postal delivery or payments
    addresses. Given a postal address, a postal service can deliver items to a
    premise, P.O. Box or similar. It is not intended to model geographical
    locations (roads, towns, mountains). In typical usage an address would be
    created via user input or from importing existing data, depending on the
    type of process. Advice on address input / editing:  - Use an i18n-ready
    address widget such as    https://github.com/google/libaddressinput) -
    Users should not be presented with UI elements for input or editing of
    fields outside countries where that field is used. For more guidance on how
    to use this schema, please see:
    https://support.google.com/business/answer/6397478
    """

    revision: int = betterproto.int32_field(1)
    """
    The schema revision of the `PostalAddress`. This must be set to 0, which is
    the latest revision. All new revisions **must** be backward compatible with
    old revisions.
    """

    region_code: str = betterproto.string_field(2)
    """
    Required. CLDR region code of the country/region of the address. This is
    never inferred and it is up to the user to ensure the value is correct. See
    http://cldr.unicode.org/ and http://www.unicode.org/cldr/charts/30/suppleme
    ntal/territory_information.html for details. Example: "CH" for Switzerland.
    """

    language_code: str = betterproto.string_field(3)
    """
    Optional. BCP-47 language code of the contents of this address (if known).
    This is often the UI language of the input form or is expected to match one
    of the languages used in the address' country/region, or their
    transliterated equivalents. This can affect formatting in certain
    countries, but is not critical to the correctness of the data and will
    never affect any validation or other non-formatting related operations. If
    this value is not known, it should be omitted (rather than specifying a
    possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
    """

    postal_code: str = betterproto.string_field(4)
    """
    Optional. Postal code of the address. Not all countries use or require
    postal codes to be present, but where they are used, they may trigger
    additional validation with other parts of the address (e.g. state/zip
    validation in the U.S.A.).
    """

    sorting_code: str = betterproto.string_field(5)
    """
    Optional. Additional, country-specific, sorting code. This is not used in
    most regions. Where it is used, the value is either a string like "CEDEX",
    optionally followed by a number (e.g. "CEDEX 7"), or just a number alone,
    representing the "sector code" (Jamaica), "delivery area indicator"
    (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
    """

    administrative_area: str = betterproto.string_field(6)
    """
    Optional. Highest administrative subdivision which is used for postal
    addresses of a country or region. For example, this can be a state, a
    province, an oblast, or a prefecture. Specifically, for Spain this is the
    province and not the autonomous community (e.g. "Barcelona" and not
    "Catalonia"). Many countries don't use an administrative area in postal
    addresses. E.g. in Switzerland this should be left unpopulated.
    """

    locality: str = betterproto.string_field(7)
    """
    Optional. Generally refers to the city/town portion of the address.
    Examples: US city, IT comune, UK post town. In regions of the world where
    localities are not well defined or do not fit into this structure well,
    leave locality empty and use address_lines.
    """

    sublocality: str = betterproto.string_field(8)
    """
    Optional. Sublocality of the address. For example, this can be
    neighborhoods, boroughs, districts.
    """

    address_lines: List[str] = betterproto.string_field(9)
    """
    Unstructured address lines describing the lower levels of an address.
    Because values in address_lines do not have type information and may
    sometimes contain multiple values in a single field (e.g. "Austin, TX"), it
    is important that the line order is clear. The order of address lines
    should be "envelope order" for the country/region of the address. In places
    where this can vary (e.g. Japan), address_language is used to make it
    explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for
    small-to-large). This way, the most specific line of an address can be
    selected based on the language. The minimum permitted structural
    representation of an address consists of a region_code with all remaining
    information placed in the address_lines. It would be possible to format
    such an address very approximately without geocoding, but no semantic
    reasoning could be made about any of the address components until it was at
    least partially resolved. Creating an address only containing a region_code
    and address_lines, and then geocoding is the recommended way to handle
    completely unstructured addresses (as opposed to guessing which parts of
    the address should be localities or administrative areas).
    """

    recipients: List[str] = betterproto.string_field(10)
    """
    Optional. The recipient at the address. This field may, under certain
    circumstances, contain multiline information. For example, it might contain
    "care of" information.
    """

    organization: str = betterproto.string_field(11)
    """Optional. The name of the organization at the address."""


@dataclass(eq=False, repr=False)
class TimeOfDay(betterproto.Message):
    """
    Represents a time of day. The date and time zone are either not significant
    or are specified elsewhere. An API may choose to allow leap seconds.
    Related types are
    [com.mapped.cloud.types.Date][com.mapped.cloud.types.Date] and
    `google.protobuf.Timestamp`. ISO-8601 doesn't support time only, but we use
    the same fields here Lacking a language specific "time" format, it is
    recommended to hold this as a string in the ISO-8601 format
    ("HH:mm:ss.fffffffzzz")
    """

    hours: int = betterproto.int32_field(1)
    """
    Hours of day in 24 hour format. Should be from 0 to 23. An API may choose
    to allow the value "24:00:00" for scenarios like business closing time.
    """

    minutes: int = betterproto.int32_field(2)
    """Minutes of hour of day. Must be from 0 to 59."""

    seconds: int = betterproto.int32_field(3)
    """
    Seconds of minutes of the time. Must normally be from 0 to 59. An API may
    allow the value 60 if it allows leap-seconds.
    """

    nanos: int = betterproto.int32_field(4)
    """Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999."""


@dataclass(eq=False, repr=False)
class ContextLinkedData(betterproto.Message):
    type: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AnyLinkedData(betterproto.Message):
    """AnyLinkedData is used to represent JSONLD"""

    context: "ContextLinkedData" = betterproto.message_field(1)
    value: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AnyLinkedDataMap(betterproto.Message):
    map: Dict[str, "AnyLinkedData"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class TypedValue(betterproto.Message):
    bool_value: bool = betterproto.bool_field(10, group="value")
    uint32_value: int = betterproto.uint32_field(11, group="value")
    uint64_value: int = betterproto.uint64_field(12, group="value")
    int32_value: int = betterproto.int32_field(13, group="value")
    int64_value: int = betterproto.int64_field(14, group="value")
    float32_value: float = betterproto.float_field(15, group="value")
    float64_value: float = betterproto.double_field(16, group="value")
    byte_array_value: bytes = betterproto.bytes_field(17, group="value")
    string_value: str = betterproto.string_field(18, group="value")
    uuid_value: bytes = betterproto.bytes_field(19, group="value")
    bool_array_value: "BoolArray" = betterproto.message_field(20, group="value")
    enum_value: int = betterproto.uint32_field(21, group="value")
    date_value: "Date" = betterproto.message_field(22, group="value")
    time_value: "TimeOfDay" = betterproto.message_field(23, group="value")
    timestamp_value: datetime = betterproto.message_field(24, group="value")
    geojson_value: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        25, group="value"
    )
    geopoint_value: "GeoPoint" = betterproto.message_field(28, group="value")
    json: "AnyLinkedData" = betterproto.message_field(29, group="value")
    calendar_period_value: "CalendarPeriod" = betterproto.enum_field(100, group="value")
    """Proposed types"""

    day_of_week_value: "DayOfWeek" = betterproto.enum_field(101, group="value")
    interval_value: "Interval" = betterproto.message_field(102, group="value")
    money_value: "Money" = betterproto.message_field(103, group="value")
    month_value: "Month" = betterproto.enum_field(104, group="value")
    phone_number_value: "PhoneNumber" = betterproto.message_field(105, group="value")
    postal_address_value: "PostalAddress" = betterproto.message_field(
        106, group="value"
    )


@dataclass(eq=False, repr=False)
class TypedValueMap(betterproto.Message):
    map: Dict[str, "TypedValue"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class BoolArray(betterproto.Message):
    values: List[bool] = betterproto.bool_field(1)
