# *********************************************************************
# *
# * Authors:     Roberto Marabini (roberto@cnb.csic.es)
# *
# *
# * This program is free software; you can redistribute it and/or modify
# * it under the terms of the GNU General Public License as published by
# * the Free Software Foundation; either version 2 of the License, or
# * (at your option) any later version.
# *
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU General Public License for more details.
# *
# * You should have received a copy of the GNU General Public License
# * along with this program; if not, write to the Free Software
# * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# * 02111-1307  USA
# *
# *  All comments concerning this program package may be sent to the
# *  e-mail address 'scipion@cnb.csic.es'
# *
# ********************************************************************

import os
import random
import numpy as np

from pyworkflow.tests import BaseTest, setupTestProject
from pyworkflow.plugin import Domain
from pwem.objects import (SetOfParticles, Acquisition, Particle, Transform,
                          CTFModel, VolumeMask)
from pwem.constants import ALIGN_PROJ
from pwem.protocols import ProtImportParticles, ProtImportMask, ProtImportVolumes

from pwem import emlib
from xmipp3 import Plugin
from xmipp3.convert import writeSetOfParticles
from xmipp3.protocols import XmippProtSubtractProjection

ProtRelionSubtract = Domain.importFromPlugin('relion.protocols',
                                             'ProtRelionSubtract', doRaise=True)
ProtRelionRefine3D = Domain.importFromPlugin('relion.protocols',
                                             'ProtRelionRefine3D')

ProtRelionCreateMask3D = Domain.importFromPlugin('relion.protocols',
                                                 'ProtRelionCreateMask3D')


proj1 = [(0, 0, 53, 55, 0.5), (0, 0, 53, 56, 1.0), (0, 0, 53, 57, 0.5), (0, 0, 53, 63, 0.5), (0, 0, 53, 64, 1.0),
         (0, 0, 53, 65, 0.5), (0, 0, 54, 54, 1.75), (0, 0, 54, 55, 4.0), (0, 0, 54, 56, 4.5), (0, 0, 54, 57, 4.0),
         (0, 0, 54, 58, 1.75), (0, 0, 54, 62, 1.75), (0, 0, 54, 63, 4.0), (0, 0, 54, 64, 4.5), (0, 0, 54, 65, 4.0),
         (0, 0, 54, 66, 1.75), (0, 0, 55, 53, 0.5), (0, 0, 55, 54, 4.0), (0, 0, 55, 55, 5.25), (0, 0, 55, 56, 5.5),
         (0, 0, 55, 57, 5.25), (0, 0, 55, 58, 4.0), (0, 0, 55, 59, 0.5), (0, 0, 55, 61, 0.5), (0, 0, 55, 62, 4.0),
         (0, 0, 55, 63, 5.25), (0, 0, 55, 64, 5.5), (0, 0, 55, 65, 5.25), (0, 0, 55, 66, 4.0), (0, 0, 55, 67, 0.5),
         (0, 0, 56, 53, 1.0), (0, 0, 56, 54, 4.5), (0, 0, 56, 55, 5.5), (0, 0, 56, 56, 6.0), (0, 0, 56, 57, 5.5),
         (0, 0, 56, 58, 4.5), (0, 0, 56, 59, 1.0), (0, 0, 56, 61, 1.0), (0, 0, 56, 62, 4.5), (0, 0, 56, 63, 5.5),
         (0, 0, 56, 64, 6.0), (0, 0, 56, 65, 5.5), (0, 0, 56, 66, 4.5), (0, 0, 56, 67, 1.0), (0, 0, 57, 53, 0.5),
         (0, 0, 57, 54, 4.0), (0, 0, 57, 55, 5.25), (0, 0, 57, 56, 5.5), (0, 0, 57, 57, 5.25), (0, 0, 57, 58, 4.0),
         (0, 0, 57, 59, 0.5), (0, 0, 57, 61, 0.5), (0, 0, 57, 62, 4.0), (0, 0, 57, 63, 5.25), (0, 0, 57, 64, 5.5),
         (0, 0, 57, 65, 5.25), (0, 0, 57, 66, 4.0), (0, 0, 57, 67, 0.5), (0, 0, 58, 54, 1.75), (0, 0, 58, 55, 4.0),
         (0, 0, 58, 56, 4.5), (0, 0, 58, 57, 4.0), (0, 0, 58, 58, 1.75), (0, 0, 58, 62, 1.75), (0, 0, 58, 63, 4.0),
         (0, 0, 58, 64, 4.5), (0, 0, 58, 65, 4.0), (0, 0, 58, 66, 1.75), (0, 0, 59, 55, 0.5), (0, 0, 59, 56, 1.0),
         (0, 0, 59, 57, 0.5), (0, 0, 59, 63, 0.5), (0, 0, 59, 64, 1.0), (0, 0, 59, 65, 0.5), (0, 0, 61, 63, 0.5),
         (0, 0, 61, 64, 1.0), (0, 0, 61, 65, 0.5), (0, 0, 62, 62, 1.75), (0, 0, 62, 63, 4.0), (0, 0, 62, 64, 4.5),
         (0, 0, 62, 65, 4.0), (0, 0, 62, 66, 1.75), (0, 0, 63, 61, 0.5), (0, 0, 63, 62, 4.0), (0, 0, 63, 63, 5.25),
         (0, 0, 63, 64, 5.5), (0, 0, 63, 65, 5.25), (0, 0, 63, 66, 4.0), (0, 0, 63, 67, 0.5), (0, 0, 64, 61, 1.0),
         (0, 0, 64, 62, 4.5), (0, 0, 64, 63, 5.5), (0, 0, 64, 64, 6.0), (0, 0, 64, 65, 5.5), (0, 0, 64, 66, 4.5),
         (0, 0, 64, 67, 1.0), (0, 0, 65, 61, 0.5), (0, 0, 65, 62, 4.0), (0, 0, 65, 63, 5.25), (0, 0, 65, 64, 5.5),
         (0, 0, 65, 65, 5.25), (0, 0, 65, 66, 4.0), (0, 0, 65, 67, 0.5), (0, 0, 66, 62, 1.75), (0, 0, 66, 63, 4.0),
         (0, 0, 66, 64, 4.5), (0, 0, 66, 65, 4.0), (0, 0, 66, 66, 1.75), (0, 0, 67, 63, 0.5), (0, 0, 67, 64, 1.0),
         (0, 0, 67, 65, 0.5), (0, 0, 69, 63, 0.5), (0, 0, 69, 64, 1.0), (0, 0, 69, 65, 0.5), (0, 0, 69, 71, 0.5),
         (0, 0, 69, 72, 1.0), (0, 0, 69, 73, 0.5), (0, 0, 70, 62, 1.75), (0, 0, 70, 63, 4.0), (0, 0, 70, 64, 4.5),
         (0, 0, 70, 65, 4.0), (0, 0, 70, 66, 1.75), (0, 0, 70, 70, 1.75), (0, 0, 70, 71, 4.0), (0, 0, 70, 72, 4.5),
         (0, 0, 70, 73, 4.0), (0, 0, 70, 74, 1.75), (0, 0, 71, 61, 0.5), (0, 0, 71, 62, 4.0), (0, 0, 71, 63, 5.25),
         (0, 0, 71, 64, 5.5), (0, 0, 71, 65, 5.25), (0, 0, 71, 66, 4.0), (0, 0, 71, 67, 0.5), (0, 0, 71, 69, 0.5),
         (0, 0, 71, 70, 4.0), (0, 0, 71, 71, 5.25), (0, 0, 71, 72, 5.5), (0, 0, 71, 73, 5.25), (0, 0, 71, 74, 4.0),
         (0, 0, 71, 75, 0.5), (0, 0, 72, 61, 1.0), (0, 0, 72, 62, 4.5), (0, 0, 72, 63, 5.5), (0, 0, 72, 64, 6.0),
         (0, 0, 72, 65, 5.5), (0, 0, 72, 66, 4.5), (0, 0, 72, 67, 1.0), (0, 0, 72, 69, 1.0), (0, 0, 72, 70, 4.5),
         (0, 0, 72, 71, 5.5), (0, 0, 72, 72, 6.0), (0, 0, 72, 73, 5.5), (0, 0, 72, 74, 4.5), (0, 0, 72, 75, 1.0),
         (0, 0, 73, 61, 0.5), (0, 0, 73, 62, 4.0), (0, 0, 73, 63, 5.25), (0, 0, 73, 64, 5.5), (0, 0, 73, 65, 5.25),
         (0, 0, 73, 66, 4.0), (0, 0, 73, 67, 0.5), (0, 0, 73, 69, 0.5), (0, 0, 73, 70, 4.0), (0, 0, 73, 71, 5.25),
         (0, 0, 73, 72, 5.5), (0, 0, 73, 73, 5.25), (0, 0, 73, 74, 4.0), (0, 0, 73, 75, 0.5), (0, 0, 74, 62, 1.75),
         (0, 0, 74, 63, 4.0), (0, 0, 74, 64, 4.5), (0, 0, 74, 65, 4.0), (0, 0, 74, 66, 1.75), (0, 0, 74, 70, 1.75),
         (0, 0, 74, 71, 4.0), (0, 0, 74, 72, 4.5), (0, 0, 74, 73, 4.0), (0, 0, 74, 74, 1.75), (0, 0, 75, 63, 0.5),
         (0, 0, 75, 64, 1.0), (0, 0, 75, 65, 0.5), (0, 0, 75, 71, 0.5), (0, 0, 75, 72, 1.0), (0, 0, 75, 73, 0.5)]
proj2 = [(0, 0, 67, 90, 1.125), (0, 0, 67, 91, 3.0), (0, 0, 67, 92, 3.125), (0, 0, 67, 93, 1.5), (0, 0, 68, 89, 1.0),
         (0, 0, 68, 90, 4.0), (0, 0, 68, 91, 5.0), (0, 0, 68, 92, 5.125), (0, 0, 68, 93, 4.25), (0, 0, 68, 94, 2.0),
         (0, 0, 69, 76, 1.25), (0, 0, 69, 77, 1.375), (0, 0, 69, 78, 0.5), (0, 0, 69, 89, 2.5), (0, 0, 69, 90, 4.875),
         (0, 0, 69, 91, 6.0), (0, 0, 69, 92, 6.0), (0, 0, 69, 93, 5.125), (0, 0, 69, 94, 3.375), (0, 0, 70, 74, 0.25),
         (0, 0, 70, 75, 2.875), (0, 0, 70, 76, 4.375), (0, 0, 70, 77, 4.5), (0, 0, 70, 78, 3.875), (0, 0, 70, 79, 1.0),
         (0, 0, 70, 89, 2.5), (0, 0, 70, 90, 4.75), (0, 0, 70, 91, 5.875), (0, 0, 70, 92, 6.0), (0, 0, 70, 93, 5.125),
         (0, 0, 70, 94, 3.25), (0, 0, 71, 74, 1.375), (0, 0, 71, 75, 4.5), (0, 0, 71, 76, 5.5), (0, 0, 71, 77, 5.75),
         (0, 0, 71, 78, 5.0), (0, 0, 71, 79, 3.25), (0, 0, 71, 83, 0.5), (0, 0, 71, 84, 1.0), (0, 0, 71, 85, 0.5),
         (0, 0, 71, 89, 1.0), (0, 0, 71, 90, 4.0), (0, 0, 71, 91, 4.875), (0, 0, 71, 92, 5.0), (0, 0, 71, 93, 4.25),
         (0, 0, 71, 94, 1.5), (0, 0, 72, 74, 2.0), (0, 0, 72, 75, 4.75), (0, 0, 72, 76, 5.875), (0, 0, 72, 77, 6.0),
         (0, 0, 72, 78, 5.25), (0, 0, 72, 79, 3.75), (0, 0, 72, 82, 1.75), (0, 0, 72, 83, 4.0), (0, 0, 72, 84, 4.5),
         (0, 0, 72, 85, 4.0), (0, 0, 72, 86, 1.75), (0, 0, 72, 90, 1.0), (0, 0, 72, 91, 2.625), (0, 0, 72, 92, 3.0),
         (0, 0, 72, 93, 1.25), (0, 0, 73, 74, 1.25), (0, 0, 73, 75, 4.25), (0, 0, 73, 76, 5.375), (0, 0, 73, 77, 5.5),
         (0, 0, 73, 78, 5.0), (0, 0, 73, 79, 3.125), (0, 0, 73, 81, 0.5), (0, 0, 73, 82, 4.0), (0, 0, 73, 83, 5.25),
         (0, 0, 73, 84, 5.5), (0, 0, 73, 85, 5.25), (0, 0, 73, 86, 4.0), (0, 0, 73, 87, 0.5), (0, 0, 73, 91, 0.875),
         (0, 0, 73, 92, 0.375), (0, 0, 74, 75, 2.125), (0, 0, 74, 76, 3.75), (0, 0, 74, 77, 4.25),
         (0, 0, 74, 78, 3.125), (0, 0, 74, 79, 0.625), (0, 0, 74, 81, 1.0), (0, 0, 74, 82, 4.5), (0, 0, 74, 83, 5.5),
         (0, 0, 74, 84, 6.0), (0, 0, 74, 85, 5.5), (0, 0, 74, 86, 4.5), (0, 0, 74, 87, 1.0), (0, 0, 74, 89, 0.625),
         (0, 0, 74, 90, 3.125), (0, 0, 74, 91, 4.25), (0, 0, 74, 92, 3.75), (0, 0, 74, 93, 2.125),
         (0, 0, 75, 76, 0.375), (0, 0, 75, 77, 0.875), (0, 0, 75, 81, 0.5), (0, 0, 75, 82, 4.0), (0, 0, 75, 83, 5.25),
         (0, 0, 75, 84, 5.5), (0, 0, 75, 85, 5.25), (0, 0, 75, 86, 4.0), (0, 0, 75, 87, 0.5), (0, 0, 75, 89, 3.125),
         (0, 0, 75, 90, 5.0), (0, 0, 75, 91, 5.5), (0, 0, 75, 92, 5.375), (0, 0, 75, 93, 4.25), (0, 0, 75, 94, 1.25),
         (0, 0, 76, 75, 1.25), (0, 0, 76, 76, 3.0), (0, 0, 76, 77, 2.625), (0, 0, 76, 78, 1.0), (0, 0, 76, 82, 1.75),
         (0, 0, 76, 83, 4.0), (0, 0, 76, 84, 4.5), (0, 0, 76, 85, 4.0), (0, 0, 76, 86, 1.75), (0, 0, 76, 89, 3.75),
         (0, 0, 76, 90, 5.25), (0, 0, 76, 91, 6.0), (0, 0, 76, 92, 5.875), (0, 0, 76, 93, 4.75), (0, 0, 76, 94, 2.0),
         (0, 0, 77, 74, 1.5), (0, 0, 77, 75, 4.25), (0, 0, 77, 76, 5.0), (0, 0, 77, 77, 4.875), (0, 0, 77, 78, 4.0),
         (0, 0, 77, 79, 1.0), (0, 0, 77, 83, 0.5), (0, 0, 77, 84, 1.0), (0, 0, 77, 85, 0.5), (0, 0, 77, 89, 3.25),
         (0, 0, 77, 90, 5.0), (0, 0, 77, 91, 5.75), (0, 0, 77, 92, 5.5), (0, 0, 77, 93, 4.5), (0, 0, 77, 94, 1.375),
         (0, 0, 78, 74, 3.25), (0, 0, 78, 75, 5.125), (0, 0, 78, 76, 6.0), (0, 0, 78, 77, 5.875), (0, 0, 78, 78, 4.75),
         (0, 0, 78, 79, 2.5), (0, 0, 78, 89, 1.0), (0, 0, 78, 90, 3.875), (0, 0, 78, 91, 4.5), (0, 0, 78, 92, 4.375),
         (0, 0, 78, 93, 2.875), (0, 0, 78, 94, 0.25), (0, 0, 79, 74, 3.375), (0, 0, 79, 75, 5.125), (0, 0, 79, 76, 6.0),
         (0, 0, 79, 77, 6.0), (0, 0, 79, 78, 4.875), (0, 0, 79, 79, 2.5), (0, 0, 79, 90, 0.5), (0, 0, 79, 91, 1.375),
         (0, 0, 79, 92, 1.25), (0, 0, 80, 74, 2.0), (0, 0, 80, 75, 4.25), (0, 0, 80, 76, 5.125), (0, 0, 80, 77, 5.0),
         (0, 0, 80, 78, 4.0), (0, 0, 80, 79, 1.0), (0, 0, 81, 75, 1.5), (0, 0, 81, 76, 3.125), (0, 0, 81, 77, 3.0),
         (0, 0, 81, 78, 1.125)]
proj3 = [(0, 0, 67, 35, 1.5), (0, 0, 67, 36, 3.125), (0, 0, 67, 37, 3.0), (0, 0, 67, 38, 1.125), (0, 0, 68, 34, 2.0),
         (0, 0, 68, 35, 4.25), (0, 0, 68, 36, 5.125), (0, 0, 68, 37, 5.0), (0, 0, 68, 38, 4.0), (0, 0, 68, 39, 1.0),
         (0, 0, 69, 34, 3.375), (0, 0, 69, 35, 5.125), (0, 0, 69, 36, 6.0), (0, 0, 69, 37, 6.0), (0, 0, 69, 38, 4.875),
         (0, 0, 69, 39, 2.5), (0, 0, 69, 50, 0.5), (0, 0, 69, 51, 1.375), (0, 0, 69, 52, 1.25), (0, 0, 70, 34, 3.25),
         (0, 0, 70, 35, 5.125), (0, 0, 70, 36, 6.0), (0, 0, 70, 37, 5.875), (0, 0, 70, 38, 4.75), (0, 0, 70, 39, 2.5),
         (0, 0, 70, 49, 1.0), (0, 0, 70, 50, 3.875), (0, 0, 70, 51, 4.5), (0, 0, 70, 52, 4.375), (0, 0, 70, 53, 2.875),
         (0, 0, 70, 54, 0.25), (0, 0, 71, 34, 1.5), (0, 0, 71, 35, 4.25), (0, 0, 71, 36, 5.0), (0, 0, 71, 37, 4.875),
         (0, 0, 71, 38, 4.0), (0, 0, 71, 39, 1.0), (0, 0, 71, 43, 0.5), (0, 0, 71, 44, 1.0), (0, 0, 71, 45, 0.5),
         (0, 0, 71, 49, 3.25), (0, 0, 71, 50, 5.0), (0, 0, 71, 51, 5.75), (0, 0, 71, 52, 5.5), (0, 0, 71, 53, 4.5),
         (0, 0, 71, 54, 1.375), (0, 0, 72, 35, 1.25), (0, 0, 72, 36, 3.0), (0, 0, 72, 37, 2.625), (0, 0, 72, 38, 1.0),
         (0, 0, 72, 42, 1.75), (0, 0, 72, 43, 4.0), (0, 0, 72, 44, 4.5), (0, 0, 72, 45, 4.0), (0, 0, 72, 46, 1.75),
         (0, 0, 72, 49, 3.75), (0, 0, 72, 50, 5.25), (0, 0, 72, 51, 6.0), (0, 0, 72, 52, 5.875), (0, 0, 72, 53, 4.75),
         (0, 0, 72, 54, 2.0), (0, 0, 73, 36, 0.375), (0, 0, 73, 37, 0.875), (0, 0, 73, 41, 0.5), (0, 0, 73, 42, 4.0),
         (0, 0, 73, 43, 5.25), (0, 0, 73, 44, 5.5), (0, 0, 73, 45, 5.25), (0, 0, 73, 46, 4.0), (0, 0, 73, 47, 0.5),
         (0, 0, 73, 49, 3.125), (0, 0, 73, 50, 5.0), (0, 0, 73, 51, 5.5), (0, 0, 73, 52, 5.375), (0, 0, 73, 53, 4.25),
         (0, 0, 73, 54, 1.25), (0, 0, 74, 35, 2.125), (0, 0, 74, 36, 3.75), (0, 0, 74, 37, 4.25), (0, 0, 74, 38, 3.125),
         (0, 0, 74, 39, 0.625), (0, 0, 74, 41, 1.0), (0, 0, 74, 42, 4.5), (0, 0, 74, 43, 5.5), (0, 0, 74, 44, 6.0),
         (0, 0, 74, 45, 5.5), (0, 0, 74, 46, 4.5), (0, 0, 74, 47, 1.0), (0, 0, 74, 49, 0.625), (0, 0, 74, 50, 3.125),
         (0, 0, 74, 51, 4.25), (0, 0, 74, 52, 3.75), (0, 0, 74, 53, 2.125), (0, 0, 75, 34, 1.25), (0, 0, 75, 35, 4.25),
         (0, 0, 75, 36, 5.375), (0, 0, 75, 37, 5.5), (0, 0, 75, 38, 5.0), (0, 0, 75, 39, 3.125), (0, 0, 75, 41, 0.5),
         (0, 0, 75, 42, 4.0), (0, 0, 75, 43, 5.25), (0, 0, 75, 44, 5.5), (0, 0, 75, 45, 5.25), (0, 0, 75, 46, 4.0),
         (0, 0, 75, 47, 0.5), (0, 0, 75, 51, 0.875), (0, 0, 75, 52, 0.375), (0, 0, 76, 34, 2.0), (0, 0, 76, 35, 4.75),
         (0, 0, 76, 36, 5.875), (0, 0, 76, 37, 6.0), (0, 0, 76, 38, 5.25), (0, 0, 76, 39, 3.75), (0, 0, 76, 42, 1.75),
         (0, 0, 76, 43, 4.0), (0, 0, 76, 44, 4.5), (0, 0, 76, 45, 4.0), (0, 0, 76, 46, 1.75), (0, 0, 76, 50, 1.0),
         (0, 0, 76, 51, 2.625), (0, 0, 76, 52, 3.0), (0, 0, 76, 53, 1.25), (0, 0, 77, 34, 1.375), (0, 0, 77, 35, 4.5),
         (0, 0, 77, 36, 5.5), (0, 0, 77, 37, 5.75), (0, 0, 77, 38, 5.0), (0, 0, 77, 39, 3.25), (0, 0, 77, 43, 0.5),
         (0, 0, 77, 44, 1.0), (0, 0, 77, 45, 0.5), (0, 0, 77, 49, 1.0), (0, 0, 77, 50, 4.0), (0, 0, 77, 51, 4.875),
         (0, 0, 77, 52, 5.0), (0, 0, 77, 53, 4.25), (0, 0, 77, 54, 1.5), (0, 0, 78, 34, 0.25), (0, 0, 78, 35, 2.875),
         (0, 0, 78, 36, 4.375), (0, 0, 78, 37, 4.5), (0, 0, 78, 38, 3.875), (0, 0, 78, 39, 1.0), (0, 0, 78, 49, 2.5),
         (0, 0, 78, 50, 4.75), (0, 0, 78, 51, 5.875), (0, 0, 78, 52, 6.0), (0, 0, 78, 53, 5.125), (0, 0, 78, 54, 3.25),
         (0, 0, 79, 36, 1.25), (0, 0, 79, 37, 1.375), (0, 0, 79, 38, 0.5), (0, 0, 79, 49, 2.5), (0, 0, 79, 50, 4.875),
         (0, 0, 79, 51, 6.0), (0, 0, 79, 52, 6.0), (0, 0, 79, 53, 5.125), (0, 0, 79, 54, 3.375), (0, 0, 80, 49, 1.0),
         (0, 0, 80, 50, 4.0), (0, 0, 80, 51, 5.0), (0, 0, 80, 52, 5.125), (0, 0, 80, 53, 4.25), (0, 0, 80, 54, 2.0),
         (0, 0, 81, 50, 1.125), (0, 0, 81, 51, 3.0), (0, 0, 81, 52, 3.125), (0, 0, 81, 53, 1.5)]
vol1 = [(0, 65, 53, 55, 0.125), (0, 63, 53, 56, 0.25), (0, 64, 53, 56, 0.5), (0, 65, 53, 56, 0.25),
       (0, 63, 53, 57, 0.125), (0, 64, 53, 57, 0.25), (0, 65, 53, 57, 0.125), (0, 63, 53, 63, 0.125),
       (0, 64, 53, 63, 0.25), (0, 65, 53, 63, 0.125), (0, 63, 53, 64, 0.25), (0, 64, 53, 64, 0.5),
       (0, 65, 53, 64, 0.25), (0, 63, 53, 65, 0.125), (0, 64, 53, 65, 0.25), (0, 65, 53, 65, 0.125),
       (0, 63, 54, 54, 0.5), (0, 64, 54, 54, 0.75), (0, 65, 54, 54, 0.5), (0, 62, 54, 55, 0.5), (0, 63, 54, 55, 1.0),
       (0, 64, 54, 55, 1.0), (0, 65, 54, 55, 1.0), (0, 66, 54, 55, 0.5), (0, 62, 54, 56, 0.75), (0, 63, 54, 56, 1.0),
       (0, 64, 54, 56, 1.0), (0, 65, 54, 56, 1.0), (0, 66, 54, 56, 0.75), (0, 62, 54, 57, 0.5), (0, 63, 54, 57, 1.0),
       (0, 64, 54, 57, 1.0), (0, 65, 54, 57, 1.0), (0, 66, 54, 57, 0.5), (0, 63, 54, 58, 0.5), (0, 64, 54, 58, 0.75),
       (0, 65, 54, 58, 0.5), (0, 63, 54, 62, 0.5), (0, 64, 54, 62, 0.75), (0, 65, 54, 62, 0.5), (0, 62, 54, 63, 0.5),
       (0, 63, 54, 63, 1.0), (0, 64, 54, 63, 1.0), (0, 65, 54, 63, 1.0), (0, 66, 54, 63, 0.5), (0, 62, 54, 64, 0.75),
       (0, 63, 54, 64, 1.0), (0, 64, 54, 64, 1.0), (0, 65, 54, 64, 1.0), (0, 66, 54, 64, 0.75), (0, 62, 54, 65, 0.5),
       (0, 63, 54, 65, 1.0), (0, 64, 54, 65, 1.0), (0, 65, 54, 65, 1.0), (0, 66, 54, 65, 0.5), (0, 63, 54, 66, 0.5),
       (0, 64, 54, 66, 0.75), (0, 65, 54, 66, 0.5), (0, 63, 55, 53, 0.125), (0, 64, 55, 53, 0.25),
       (0, 65, 55, 53, 0.125), (0, 62, 55, 54, 0.5), (0, 63, 55, 54, 1.0), (0, 64, 55, 54, 1.0), (0, 65, 55, 54, 1.0),
       (0, 66, 55, 54, 0.5), (0, 61, 55, 55, 0.125), (0, 62, 55, 55, 1.0), (0, 63, 55, 55, 1.0), (0, 64, 55, 55, 1.0),
       (0, 65, 55, 55, 1.0), (0, 66, 55, 55, 1.0), (0, 67, 55, 55, 0.125), (0, 61, 55, 56, 0.25), (0, 62, 55, 56, 1.0),
       (0, 63, 55, 56, 1.0), (0, 64, 55, 56, 1.0), (0, 65, 55, 56, 1.0), (0, 66, 55, 56, 1.0), (0, 67, 55, 56, 0.25),
       (0, 61, 55, 57, 0.125), (0, 62, 55, 57, 1.0), (0, 63, 55, 57, 1.0), (0, 64, 55, 57, 1.0), (0, 65, 55, 57, 1.0),
       (0, 66, 55, 57, 1.0), (0, 67, 55, 57, 0.125), (0, 62, 55, 58, 0.5), (0, 63, 55, 58, 1.0), (0, 64, 55, 58, 1.0),
       (0, 65, 55, 58, 1.0), (0, 66, 55, 58, 0.5), (0, 63, 55, 59, 0.125), (0, 64, 55, 59, 0.25),
       (0, 65, 55, 59, 0.125), (0, 63, 55, 61, 0.125), (0, 64, 55, 61, 0.25), (0, 65, 55, 61, 0.125),
       (0, 62, 55, 62, 0.5), (0, 63, 55, 62, 1.0), (0, 64, 55, 62, 1.0), (0, 65, 55, 62, 1.0), (0, 66, 55, 62, 0.5),
       (0, 61, 55, 63, 0.125), (0, 62, 55, 63, 1.0), (0, 63, 55, 63, 1.0), (0, 64, 55, 63, 1.0), (0, 65, 55, 63, 1.0),
       (0, 66, 55, 63, 1.0), (0, 67, 55, 63, 0.125), (0, 61, 55, 64, 0.25), (0, 62, 55, 64, 1.0), (0, 63, 55, 64, 1.0),
       (0, 64, 55, 64, 1.0), (0, 65, 55, 64, 1.0), (0, 66, 55, 64, 1.0), (0, 67, 55, 64, 0.25), (0, 61, 55, 65, 0.125),
       (0, 62, 55, 65, 1.0), (0, 63, 55, 65, 1.0), (0, 64, 55, 65, 1.0), (0, 65, 55, 65, 1.0), (0, 66, 55, 65, 1.0),
       (0, 67, 55, 65, 0.125), (0, 62, 55, 66, 0.5), (0, 63, 55, 66, 1.0), (0, 64, 55, 66, 1.0), (0, 65, 55, 66, 1.0),
       (0, 66, 55, 66, 0.5), (0, 63, 55, 67, 0.125), (0, 64, 55, 67, 0.25), (0, 65, 55, 67, 0.125),
       (0, 63, 56, 53, 0.25), (0, 64, 56, 53, 0.5), (0, 65, 56, 53, 0.25), (0, 62, 56, 54, 0.75), (0, 63, 56, 54, 1.0),
       (0, 64, 56, 54, 1.0), (0, 65, 56, 54, 1.0), (0, 66, 56, 54, 0.75), (0, 61, 56, 55, 0.25), (0, 62, 56, 55, 1.0),
       (0, 63, 56, 55, 1.0), (0, 64, 56, 55, 1.0), (0, 65, 56, 55, 1.0), (0, 66, 56, 55, 1.0), (0, 67, 56, 55, 0.25),
       (0, 61, 56, 56, 0.5), (0, 62, 56, 56, 1.0), (0, 63, 56, 56, 1.0), (0, 64, 56, 56, 1.0), (0, 65, 56, 56, 1.0),
       (0, 66, 56, 56, 1.0), (0, 67, 56, 56, 0.5), (0, 61, 56, 57, 0.25), (0, 62, 56, 57, 1.0), (0, 63, 56, 57, 1.0),
       (0, 64, 56, 57, 1.0), (0, 65, 56, 57, 1.0), (0, 66, 56, 57, 1.0), (0, 67, 56, 57, 0.25), (0, 62, 56, 58, 0.75),
       (0, 63, 56, 58, 1.0), (0, 64, 56, 58, 1.0), (0, 65, 56, 58, 1.0), (0, 66, 56, 58, 0.75), (0, 63, 56, 59, 0.25),
       (0, 64, 56, 59, 0.5), (0, 65, 56, 59, 0.25), (0, 63, 56, 61, 0.25), (0, 64, 56, 61, 0.5), (0, 65, 56, 61, 0.25),
       (0, 62, 56, 62, 0.75), (0, 63, 56, 62, 1.0), (0, 64, 56, 62, 1.0), (0, 65, 56, 62, 1.0), (0, 66, 56, 62, 0.75),
       (0, 61, 56, 63, 0.25), (0, 62, 56, 63, 1.0), (0, 63, 56, 63, 1.0), (0, 64, 56, 63, 1.0), (0, 65, 56, 63, 1.0),
       (0, 66, 56, 63, 1.0), (0, 67, 56, 63, 0.25), (0, 61, 56, 64, 0.5), (0, 62, 56, 64, 1.0), (0, 63, 56, 64, 1.0),
       (0, 64, 56, 64, 1.0), (0, 65, 56, 64, 1.0), (0, 66, 56, 64, 1.0), (0, 67, 56, 64, 0.5), (0, 61, 56, 65, 0.25),
       (0, 62, 56, 65, 1.0), (0, 63, 56, 65, 1.0), (0, 64, 56, 65, 1.0), (0, 65, 56, 65, 1.0), (0, 66, 56, 65, 1.0),
       (0, 67, 56, 65, 0.25), (0, 62, 56, 66, 0.75), (0, 63, 56, 66, 1.0), (0, 64, 56, 66, 1.0), (0, 65, 56, 66, 1.0),
       (0, 66, 56, 66, 0.75), (0, 63, 56, 67, 0.25), (0, 64, 56, 67, 0.5), (0, 65, 56, 67, 0.25),
       (0, 63, 57, 53, 0.125), (0, 64, 57, 53, 0.25), (0, 65, 57, 53, 0.125), (0, 62, 57, 54, 0.5),
       (0, 63, 57, 54, 1.0), (0, 64, 57, 54, 1.0), (0, 65, 57, 54, 1.0), (0, 66, 57, 54, 0.5), (0, 61, 57, 55, 0.125),
       (0, 62, 57, 55, 1.0), (0, 63, 57, 55, 1.0), (0, 64, 57, 55, 1.0), (0, 65, 57, 55, 1.0), (0, 66, 57, 55, 1.0),
       (0, 67, 57, 55, 0.125), (0, 61, 57, 56, 0.25), (0, 62, 57, 56, 1.0), (0, 63, 57, 56, 1.0), (0, 64, 57, 56, 1.0),
       (0, 65, 57, 56, 1.0), (0, 66, 57, 56, 1.0), (0, 67, 57, 56, 0.25), (0, 61, 57, 57, 0.125), (0, 62, 57, 57, 1.0),
       (0, 63, 57, 57, 1.0), (0, 64, 57, 57, 1.0), (0, 65, 57, 57, 1.0), (0, 66, 57, 57, 1.0), (0, 67, 57, 57, 0.125),
       (0, 62, 57, 58, 0.5), (0, 63, 57, 58, 1.0), (0, 64, 57, 58, 1.0), (0, 65, 57, 58, 1.0), (0, 66, 57, 58, 0.5),
       (0, 63, 57, 59, 0.125), (0, 64, 57, 59, 0.25), (0, 65, 57, 59, 0.125), (0, 63, 57, 61, 0.125),
       (0, 64, 57, 61, 0.25), (0, 65, 57, 61, 0.125), (0, 62, 57, 62, 0.5), (0, 63, 57, 62, 1.0), (0, 64, 57, 62, 1.0),
       (0, 65, 57, 62, 1.0), (0, 66, 57, 62, 0.5), (0, 61, 57, 63, 0.125), (0, 62, 57, 63, 1.0), (0, 63, 57, 63, 1.0),
       (0, 64, 57, 63, 1.0), (0, 65, 57, 63, 1.0), (0, 66, 57, 63, 1.0), (0, 67, 57, 63, 0.125), (0, 61, 57, 64, 0.25),
       (0, 62, 57, 64, 1.0), (0, 63, 57, 64, 1.0), (0, 64, 57, 64, 1.0), (0, 65, 57, 64, 1.0), (0, 66, 57, 64, 1.0),
       (0, 67, 57, 64, 0.25), (0, 61, 57, 65, 0.125), (0, 62, 57, 65, 1.0), (0, 63, 57, 65, 1.0), (0, 64, 57, 65, 1.0),
       (0, 65, 57, 65, 1.0), (0, 66, 57, 65, 1.0), (0, 67, 57, 65, 0.125), (0, 62, 57, 66, 0.5), (0, 63, 57, 66, 1.0),
       (0, 64, 57, 66, 1.0), (0, 65, 57, 66, 1.0), (0, 66, 57, 66, 0.5), (0, 63, 57, 67, 0.125), (0, 64, 57, 67, 0.25),
       (0, 65, 57, 67, 0.125), (0, 63, 58, 54, 0.5), (0, 64, 58, 54, 0.75), (0, 65, 58, 54, 0.5), (0, 62, 58, 55, 0.5),
       (0, 63, 58, 55, 1.0), (0, 64, 58, 55, 1.0), (0, 65, 58, 55, 1.0), (0, 66, 58, 55, 0.5), (0, 62, 58, 56, 0.75),
       (0, 63, 58, 56, 1.0), (0, 64, 58, 56, 1.0), (0, 65, 58, 56, 1.0), (0, 66, 58, 56, 0.75), (0, 62, 58, 57, 0.5),
       (0, 63, 58, 57, 1.0), (0, 64, 58, 57, 1.0), (0, 65, 58, 57, 1.0), (0, 66, 58, 57, 0.5), (0, 63, 58, 58, 0.5),
       (0, 64, 58, 58, 0.75), (0, 65, 58, 58, 0.5), (0, 63, 58, 62, 0.5), (0, 64, 58, 62, 0.75), (0, 65, 58, 62, 0.5),
       (0, 62, 58, 63, 0.5), (0, 63, 58, 63, 1.0), (0, 64, 58, 63, 1.0), (0, 65, 58, 63, 1.0), (0, 66, 58, 63, 0.5),
       (0, 62, 58, 64, 0.75), (0, 63, 58, 64, 1.0), (0, 64, 58, 64, 1.0), (0, 65, 58, 64, 1.0), (0, 66, 58, 64, 0.75),
       (0, 62, 58, 65, 0.5), (0, 63, 58, 65, 1.0), (0, 64, 58, 65, 1.0), (0, 65, 58, 65, 1.0), (0, 66, 58, 65, 0.5),
       (0, 63, 58, 66, 0.5), (0, 64, 58, 66, 0.75), (0, 65, 58, 66, 0.5), (0, 63, 59, 55, 0.125), (0, 64, 59, 55, 0.25),
       (0, 65, 59, 55, 0.125), (0, 63, 59, 56, 0.25), (0, 64, 59, 56, 0.5), (0, 65, 59, 56, 0.25),
       (0, 63, 59, 57, 0.125), (0, 64, 59, 57, 0.25), (0, 65, 59, 57, 0.125), (0, 63, 59, 63, 0.125),
       (0, 64, 59, 63, 0.25), (0, 65, 59, 63, 0.125), (0, 63, 59, 64, 0.25), (0, 64, 59, 64, 0.5),
       (0, 65, 59, 64, 0.25), (0, 63, 59, 65, 0.125), (0, 64, 59, 65, 0.25), (0, 65, 59, 65, 0.125),
       (0, 63, 61, 63, 0.125), (0, 64, 61, 63, 0.25), (0, 65, 61, 63, 0.125), (0, 63, 61, 64, 0.25),
       (0, 64, 61, 64, 0.5), (0, 65, 61, 64, 0.25), (0, 63, 61, 65, 0.125), (0, 64, 61, 65, 0.25),
       (0, 65, 61, 65, 0.125), (0, 63, 62, 62, 0.5), (0, 64, 62, 62, 0.75), (0, 65, 62, 62, 0.5), (0, 62, 62, 63, 0.5),
       (0, 63, 62, 63, 1.0), (0, 64, 62, 63, 1.0), (0, 65, 62, 63, 1.0), (0, 66, 62, 63, 0.5), (0, 62, 62, 64, 0.75),
       (0, 63, 62, 64, 1.0), (0, 64, 62, 64, 1.0), (0, 65, 62, 64, 1.0), (0, 66, 62, 64, 0.75), (0, 62, 62, 65, 0.5),
       (0, 63, 62, 65, 1.0), (0, 64, 62, 65, 1.0), (0, 65, 62, 65, 1.0), (0, 66, 62, 65, 0.5), (0, 63, 62, 66, 0.5),
       (0, 64, 62, 66, 0.75), (0, 65, 62, 66, 0.5), (0, 63, 63, 61, 0.125), (0, 64, 63, 61, 0.25),
       (0, 65, 63, 61, 0.125), (0, 62, 63, 62, 0.5), (0, 63, 63, 62, 1.0), (0, 64, 63, 62, 1.0), (0, 65, 63, 62, 1.0),
       (0, 66, 63, 62, 0.5), (0, 61, 63, 63, 0.125), (0, 62, 63, 63, 1.0), (0, 63, 63, 63, 1.0), (0, 64, 63, 63, 1.0),
       (0, 65, 63, 63, 1.0), (0, 66, 63, 63, 1.0), (0, 67, 63, 63, 0.125), (0, 61, 63, 64, 0.25), (0, 62, 63, 64, 1.0),
       (0, 63, 63, 64, 1.0), (0, 64, 63, 64, 1.0), (0, 65, 63, 64, 1.0), (0, 66, 63, 64, 1.0), (0, 67, 63, 64, 0.25),
       (0, 61, 63, 65, 0.125), (0, 62, 63, 65, 1.0), (0, 63, 63, 65, 1.0), (0, 64, 63, 65, 1.0), (0, 65, 63, 65, 1.0),
       (0, 66, 63, 65, 1.0), (0, 67, 63, 65, 0.125), (0, 62, 63, 66, 0.5), (0, 63, 63, 66, 1.0), (0, 64, 63, 66, 1.0),
       (0, 65, 63, 66, 1.0), (0, 66, 63, 66, 0.5), (0, 63, 63, 67, 0.125), (0, 64, 63, 67, 0.25),
       (0, 65, 63, 67, 0.125), (0, 63, 64, 61, 0.25), (0, 64, 64, 61, 0.5), (0, 65, 64, 61, 0.25),
       (0, 62, 64, 62, 0.75), (0, 63, 64, 62, 1.0), (0, 64, 64, 62, 1.0), (0, 65, 64, 62, 1.0), (0, 66, 64, 62, 0.75),
       (0, 61, 64, 63, 0.25), (0, 62, 64, 63, 1.0), (0, 63, 64, 63, 1.0), (0, 64, 64, 63, 1.0), (0, 65, 64, 63, 1.0),
       (0, 66, 64, 63, 1.0), (0, 67, 64, 63, 0.25), (0, 61, 64, 64, 0.5), (0, 62, 64, 64, 1.0), (0, 63, 64, 64, 1.0),
       (0, 64, 64, 64, 1.0), (0, 65, 64, 64, 1.0), (0, 66, 64, 64, 1.0), (0, 67, 64, 64, 0.5), (0, 61, 64, 65, 0.25),
       (0, 62, 64, 65, 1.0), (0, 63, 64, 65, 1.0), (0, 64, 64, 65, 1.0), (0, 65, 64, 65, 1.0), (0, 66, 64, 65, 1.0),
       (0, 67, 64, 65, 0.25), (0, 62, 64, 66, 0.75), (0, 63, 64, 66, 1.0), (0, 64, 64, 66, 1.0), (0, 65, 64, 66, 1.0),
       (0, 66, 64, 66, 0.75), (0, 63, 64, 67, 0.25), (0, 64, 64, 67, 0.5), (0, 65, 64, 67, 0.25),
       (0, 63, 65, 61, 0.125), (0, 64, 65, 61, 0.25), (0, 65, 65, 61, 0.125), (0, 62, 65, 62, 0.5),
       (0, 63, 65, 62, 1.0), (0, 64, 65, 62, 1.0), (0, 65, 65, 62, 1.0), (0, 66, 65, 62, 0.5), (0, 61, 65, 63, 0.125),
       (0, 62, 65, 63, 1.0), (0, 63, 65, 63, 1.0), (0, 64, 65, 63, 1.0), (0, 65, 65, 63, 1.0), (0, 66, 65, 63, 1.0),
       (0, 67, 65, 63, 0.125), (0, 61, 65, 64, 0.25), (0, 62, 65, 64, 1.0), (0, 63, 65, 64, 1.0), (0, 64, 65, 64, 1.0),
       (0, 65, 65, 64, 1.0), (0, 66, 65, 64, 1.0), (0, 67, 65, 64, 0.25), (0, 61, 65, 65, 0.125), (0, 62, 65, 65, 1.0),
       (0, 63, 65, 65, 1.0), (0, 64, 65, 65, 1.0), (0, 65, 65, 65, 1.0), (0, 66, 65, 65, 1.0), (0, 67, 65, 65, 0.125),
       (0, 62, 65, 66, 0.5), (0, 63, 65, 66, 1.0), (0, 64, 65, 66, 1.0), (0, 65, 65, 66, 1.0), (0, 66, 65, 66, 0.5),
       (0, 63, 65, 67, 0.125), (0, 64, 65, 67, 0.25), (0, 65, 65, 67, 0.125), (0, 63, 66, 62, 0.5),
       (0, 64, 66, 62, 0.75), (0, 65, 66, 62, 0.5), (0, 62, 66, 63, 0.5), (0, 63, 66, 63, 1.0), (0, 64, 66, 63, 1.0),
       (0, 65, 66, 63, 1.0), (0, 66, 66, 63, 0.5), (0, 62, 66, 64, 0.75), (0, 63, 66, 64, 1.0), (0, 64, 66, 64, 1.0),
       (0, 65, 66, 64, 1.0), (0, 66, 66, 64, 0.75), (0, 62, 66, 65, 0.5), (0, 63, 66, 65, 1.0), (0, 64, 66, 65, 1.0),
       (0, 65, 66, 65, 1.0), (0, 66, 66, 65, 0.5), (0, 63, 66, 66, 0.5), (0, 64, 66, 66, 0.75), (0, 65, 66, 66, 0.5),
       (0, 63, 67, 63, 0.125), (0, 64, 67, 63, 0.25), (0, 65, 67, 63, 0.125), (0, 63, 67, 64, 0.25),
       (0, 64, 67, 64, 0.5), (0, 65, 67, 64, 0.25), (0, 63, 67, 65, 0.125), (0, 64, 67, 65, 0.25),
       (0, 65, 67, 65, 0.125), (0, 63, 69, 63, 0.125), (0, 64, 69, 63, 0.25), (0, 65, 69, 63, 0.125),
       (0, 63, 69, 64, 0.25), (0, 64, 69, 64, 0.5), (0, 65, 69, 64, 0.25), (0, 63, 69, 65, 0.125),
       (0, 64, 69, 65, 0.25), (0, 65, 69, 65, 0.125), (0, 63, 69, 71, 0.125), (0, 64, 69, 71, 0.25),
       (0, 65, 69, 71, 0.125), (0, 63, 69, 72, 0.25), (0, 64, 69, 72, 0.5), (0, 65, 69, 72, 0.25),
       (0, 63, 69, 73, 0.125), (0, 64, 69, 73, 0.25), (0, 65, 69, 73, 0.125), (0, 63, 70, 62, 0.5),
       (0, 64, 70, 62, 0.75), (0, 65, 70, 62, 0.5), (0, 62, 70, 63, 0.5), (0, 63, 70, 63, 1.0), (0, 64, 70, 63, 1.0),
       (0, 65, 70, 63, 1.0), (0, 66, 70, 63, 0.5), (0, 62, 70, 64, 0.75), (0, 63, 70, 64, 1.0), (0, 64, 70, 64, 1.0),
       (0, 65, 70, 64, 1.0), (0, 66, 70, 64, 0.75), (0, 62, 70, 65, 0.5), (0, 63, 70, 65, 1.0), (0, 64, 70, 65, 1.0),
       (0, 65, 70, 65, 1.0), (0, 66, 70, 65, 0.5), (0, 63, 70, 66, 0.5), (0, 64, 70, 66, 0.75), (0, 65, 70, 66, 0.5),
       (0, 63, 70, 70, 0.5), (0, 64, 70, 70, 0.75), (0, 65, 70, 70, 0.5), (0, 62, 70, 71, 0.5), (0, 63, 70, 71, 1.0),
       (0, 64, 70, 71, 1.0), (0, 65, 70, 71, 1.0), (0, 66, 70, 71, 0.5), (0, 62, 70, 72, 0.75), (0, 63, 70, 72, 1.0),
       (0, 64, 70, 72, 1.0), (0, 65, 70, 72, 1.0), (0, 66, 70, 72, 0.75), (0, 62, 70, 73, 0.5), (0, 63, 70, 73, 1.0),
       (0, 64, 70, 73, 1.0), (0, 65, 70, 73, 1.0), (0, 66, 70, 73, 0.5), (0, 63, 70, 74, 0.5), (0, 64, 70, 74, 0.75),
       (0, 65, 70, 74, 0.5), (0, 63, 71, 61, 0.125), (0, 64, 71, 61, 0.25), (0, 65, 71, 61, 0.125),
       (0, 62, 71, 62, 0.5), (0, 63, 71, 62, 1.0), (0, 64, 71, 62, 1.0), (0, 65, 71, 62, 1.0), (0, 66, 71, 62, 0.5),
       (0, 61, 71, 63, 0.125), (0, 62, 71, 63, 1.0), (0, 63, 71, 63, 1.0), (0, 64, 71, 63, 1.0), (0, 65, 71, 63, 1.0),
       (0, 66, 71, 63, 1.0), (0, 67, 71, 63, 0.125), (0, 61, 71, 64, 0.25), (0, 62, 71, 64, 1.0), (0, 63, 71, 64, 1.0),
       (0, 64, 71, 64, 1.0), (0, 65, 71, 64, 1.0), (0, 66, 71, 64, 1.0), (0, 67, 71, 64, 0.25), (0, 61, 71, 65, 0.125),
       (0, 62, 71, 65, 1.0), (0, 63, 71, 65, 1.0), (0, 64, 71, 65, 1.0), (0, 65, 71, 65, 1.0), (0, 66, 71, 65, 1.0),
       (0, 67, 71, 65, 0.125), (0, 62, 71, 66, 0.5), (0, 63, 71, 66, 1.0), (0, 64, 71, 66, 1.0), (0, 65, 71, 66, 1.0),
       (0, 66, 71, 66, 0.5), (0, 63, 71, 67, 0.125), (0, 64, 71, 67, 0.25), (0, 65, 71, 67, 0.125),
       (0, 63, 71, 69, 0.125), (0, 64, 71, 69, 0.25), (0, 65, 71, 69, 0.125), (0, 62, 71, 70, 0.5),
       (0, 63, 71, 70, 1.0), (0, 64, 71, 70, 1.0), (0, 65, 71, 70, 1.0), (0, 66, 71, 70, 0.5), (0, 61, 71, 71, 0.125),
       (0, 62, 71, 71, 1.0), (0, 63, 71, 71, 1.0), (0, 64, 71, 71, 1.0), (0, 65, 71, 71, 1.0), (0, 66, 71, 71, 1.0),
       (0, 67, 71, 71, 0.125), (0, 61, 71, 72, 0.25), (0, 62, 71, 72, 1.0), (0, 63, 71, 72, 1.0), (0, 64, 71, 72, 1.0),
       (0, 65, 71, 72, 1.0), (0, 66, 71, 72, 1.0), (0, 67, 71, 72, 0.25), (0, 61, 71, 73, 0.125), (0, 62, 71, 73, 1.0),
       (0, 63, 71, 73, 1.0), (0, 64, 71, 73, 1.0), (0, 65, 71, 73, 1.0), (0, 66, 71, 73, 1.0), (0, 67, 71, 73, 0.125),
       (0, 62, 71, 74, 0.5), (0, 63, 71, 74, 1.0), (0, 64, 71, 74, 1.0), (0, 65, 71, 74, 1.0), (0, 66, 71, 74, 0.5),
       (0, 63, 71, 75, 0.125), (0, 64, 71, 75, 0.25), (0, 65, 71, 75, 0.125), (0, 63, 72, 61, 0.25),
       (0, 64, 72, 61, 0.5), (0, 65, 72, 61, 0.25), (0, 62, 72, 62, 0.75), (0, 63, 72, 62, 1.0), (0, 64, 72, 62, 1.0),
       (0, 65, 72, 62, 1.0), (0, 66, 72, 62, 0.75), (0, 61, 72, 63, 0.25), (0, 62, 72, 63, 1.0), (0, 63, 72, 63, 1.0),
       (0, 64, 72, 63, 1.0), (0, 65, 72, 63, 1.0), (0, 66, 72, 63, 1.0), (0, 67, 72, 63, 0.25), (0, 61, 72, 64, 0.5),
       (0, 62, 72, 64, 1.0), (0, 63, 72, 64, 1.0), (0, 64, 72, 64, 1.0), (0, 65, 72, 64, 1.0), (0, 66, 72, 64, 1.0),
       (0, 67, 72, 64, 0.5), (0, 61, 72, 65, 0.25), (0, 62, 72, 65, 1.0), (0, 63, 72, 65, 1.0), (0, 64, 72, 65, 1.0),
       (0, 65, 72, 65, 1.0), (0, 66, 72, 65, 1.0), (0, 67, 72, 65, 0.25), (0, 62, 72, 66, 0.75), (0, 63, 72, 66, 1.0),
       (0, 64, 72, 66, 1.0), (0, 65, 72, 66, 1.0), (0, 66, 72, 66, 0.75), (0, 63, 72, 67, 0.25), (0, 64, 72, 67, 0.5),
       (0, 65, 72, 67, 0.25), (0, 63, 72, 69, 0.25), (0, 64, 72, 69, 0.5), (0, 65, 72, 69, 0.25), (0, 62, 72, 70, 0.75),
       (0, 63, 72, 70, 1.0), (0, 64, 72, 70, 1.0), (0, 65, 72, 70, 1.0), (0, 66, 72, 70, 0.75), (0, 61, 72, 71, 0.25),
       (0, 62, 72, 71, 1.0), (0, 63, 72, 71, 1.0), (0, 64, 72, 71, 1.0), (0, 65, 72, 71, 1.0), (0, 66, 72, 71, 1.0),
       (0, 67, 72, 71, 0.25), (0, 61, 72, 72, 0.5), (0, 62, 72, 72, 1.0), (0, 63, 72, 72, 1.0), (0, 64, 72, 72, 1.0),
       (0, 65, 72, 72, 1.0), (0, 66, 72, 72, 1.0), (0, 67, 72, 72, 0.5), (0, 61, 72, 73, 0.25), (0, 62, 72, 73, 1.0),
       (0, 63, 72, 73, 1.0), (0, 64, 72, 73, 1.0), (0, 65, 72, 73, 1.0), (0, 66, 72, 73, 1.0), (0, 67, 72, 73, 0.25),
       (0, 62, 72, 74, 0.75), (0, 63, 72, 74, 1.0), (0, 64, 72, 74, 1.0), (0, 65, 72, 74, 1.0), (0, 66, 72, 74, 0.75),
       (0, 63, 72, 75, 0.25), (0, 64, 72, 75, 0.5), (0, 65, 72, 75, 0.25), (0, 63, 73, 61, 0.125),
       (0, 64, 73, 61, 0.25), (0, 65, 73, 61, 0.125), (0, 62, 73, 62, 0.5), (0, 63, 73, 62, 1.0), (0, 64, 73, 62, 1.0),
       (0, 65, 73, 62, 1.0), (0, 66, 73, 62, 0.5), (0, 61, 73, 63, 0.125), (0, 62, 73, 63, 1.0), (0, 63, 73, 63, 1.0),
       (0, 64, 73, 63, 1.0), (0, 65, 73, 63, 1.0), (0, 66, 73, 63, 1.0), (0, 67, 73, 63, 0.125), (0, 61, 73, 64, 0.25),
       (0, 62, 73, 64, 1.0), (0, 63, 73, 64, 1.0), (0, 64, 73, 64, 1.0), (0, 65, 73, 64, 1.0), (0, 66, 73, 64, 1.0),
       (0, 67, 73, 64, 0.25), (0, 61, 73, 65, 0.125), (0, 62, 73, 65, 1.0), (0, 63, 73, 65, 1.0), (0, 64, 73, 65, 1.0),
       (0, 65, 73, 65, 1.0), (0, 66, 73, 65, 1.0), (0, 67, 73, 65, 0.125), (0, 62, 73, 66, 0.5), (0, 63, 73, 66, 1.0),
       (0, 64, 73, 66, 1.0), (0, 65, 73, 66, 1.0), (0, 66, 73, 66, 0.5), (0, 63, 73, 67, 0.125), (0, 64, 73, 67, 0.25),
       (0, 65, 73, 67, 0.125), (0, 63, 73, 69, 0.125), (0, 64, 73, 69, 0.25), (0, 65, 73, 69, 0.125),
       (0, 62, 73, 70, 0.5), (0, 63, 73, 70, 1.0), (0, 64, 73, 70, 1.0), (0, 65, 73, 70, 1.0), (0, 66, 73, 70, 0.5),
       (0, 61, 73, 71, 0.125), (0, 62, 73, 71, 1.0), (0, 63, 73, 71, 1.0), (0, 64, 73, 71, 1.0), (0, 65, 73, 71, 1.0),
       (0, 66, 73, 71, 1.0), (0, 67, 73, 71, 0.125), (0, 61, 73, 72, 0.25), (0, 62, 73, 72, 1.0), (0, 63, 73, 72, 1.0),
       (0, 64, 73, 72, 1.0), (0, 65, 73, 72, 1.0), (0, 66, 73, 72, 1.0), (0, 67, 73, 72, 0.25), (0, 61, 73, 73, 0.125),
       (0, 62, 73, 73, 1.0), (0, 63, 73, 73, 1.0), (0, 64, 73, 73, 1.0), (0, 65, 73, 73, 1.0), (0, 66, 73, 73, 1.0),
       (0, 67, 73, 73, 0.125), (0, 62, 73, 74, 0.5), (0, 63, 73, 74, 1.0), (0, 64, 73, 74, 1.0), (0, 65, 73, 74, 1.0),
       (0, 66, 73, 74, 0.5), (0, 63, 73, 75, 0.125), (0, 64, 73, 75, 0.25), (0, 65, 73, 75, 0.125),
       (0, 63, 74, 62, 0.5), (0, 64, 74, 62, 0.75), (0, 65, 74, 62, 0.5), (0, 62, 74, 63, 0.5), (0, 63, 74, 63, 1.0),
       (0, 64, 74, 63, 1.0), (0, 65, 74, 63, 1.0), (0, 66, 74, 63, 0.5), (0, 62, 74, 64, 0.75), (0, 63, 74, 64, 1.0),
       (0, 64, 74, 64, 1.0), (0, 65, 74, 64, 1.0), (0, 66, 74, 64, 0.75), (0, 62, 74, 65, 0.5), (0, 63, 74, 65, 1.0),
       (0, 64, 74, 65, 1.0), (0, 65, 74, 65, 1.0), (0, 66, 74, 65, 0.5), (0, 63, 74, 66, 0.5), (0, 64, 74, 66, 0.75),
       (0, 65, 74, 66, 0.5), (0, 63, 74, 70, 0.5), (0, 64, 74, 70, 0.75), (0, 65, 74, 70, 0.5), (0, 62, 74, 71, 0.5),
       (0, 63, 74, 71, 1.0), (0, 64, 74, 71, 1.0), (0, 65, 74, 71, 1.0), (0, 66, 74, 71, 0.5), (0, 62, 74, 72, 0.75),
       (0, 63, 74, 72, 1.0), (0, 64, 74, 72, 1.0), (0, 65, 74, 72, 1.0), (0, 66, 74, 72, 0.75), (0, 62, 74, 73, 0.5),
       (0, 63, 74, 73, 1.0), (0, 64, 74, 73, 1.0), (0, 65, 74, 73, 1.0), (0, 66, 74, 73, 0.5), (0, 63, 74, 74, 0.5),
       (0, 64, 74, 74, 0.75), (0, 65, 74, 74, 0.5), (0, 63, 75, 63, 0.125), (0, 64, 75, 63, 0.25),
       (0, 65, 75, 63, 0.125), (0, 63, 75, 64, 0.25), (0, 64, 75, 64, 0.5), (0, 65, 75, 64, 0.25),
       (0, 63, 75, 65, 0.125), (0, 64, 75, 65, 0.25), (0, 65, 75, 65, 0.125), (0, 63, 75, 71, 0.125),
       (0, 64, 75, 71, 0.25), (0, 65, 75, 71, 0.125), (0, 63, 75, 72, 0.25), (0, 64, 75, 72, 0.5),
       (0, 65, 75, 72, 0.25), (0, 63, 75, 73, 0.125), (0, 64, 75, 73, 0.25), (0, 65, 75, 73, 0.125)]

# projection matrices
mList = [
    [[1., 0., 0., 0.],  # a1
     [0., 1., 0., 0.],
     [0., 0., 1., 0.],
     [0., 0., 0., 1.]],
    [[0.04341204, -0.82959837, 0.5566704, 7.42774284],  # -50, -40,-30
     [0.90961589, 0.26325835, 0.3213938, -20.82490128],
     [-0.41317591, 0.49240388, 0.76604444, 3.33947946],
     [0., 0., 0., 1.]],
    [[0.04341204, 0.82959837, 0.5566704, -7.42774284],  # a3
     [0.90961589, -0.26325835, 0.3213938, 20.82490128],
     [0.41317591, 0.49240388, -0.76604444, 3.33947946],
     [0., 0., 0., 1.]]
]
defocusList = [15000.,20000.,25000.]
defocusAngle = [0., 10., 20.]
projSize = 128


setPartSqliteName       = "particles.sqlite"
setPartSqliteCtfName    = "particles_ctf.sqlite"
setPartSqliteCTfPosName = "particles_ctf_pos.sqlite"

setPartName = "particles.stk"
setPartCtfName = "particlesCtf.stk"
setPartCtfPosName = "particlesCtfPos.stk"

volName = "vol.spi"
maskName="mask.spi"

setPartNameMd = "particles.xmd" # temporary file for xmipp programs

samplingRate = 2.
maskRadius= 20.

class TestSubProj(BaseTest):
    @classmethod
    def setUpClass(cls):
        setupTestProject(cls)

    def createSetOfParticles(self, setPartSqliteName, partFn,
                             doCtf=False):
        # create a set of particles

        self.partSet = SetOfParticles(filename=setPartSqliteName)
        self.partSet.setAlignment(ALIGN_PROJ)
        self.partSet.setAcquisition(Acquisition(voltage=300,
                                           sphericalAberration=2,
                                           amplitudeContrast=0.1,
                                           magnification=60000))
        self.partSet.setSamplingRate(samplingRate)
        self.partSet.setHasCTF(True)
        aList = [np.array(m) for m in mList]
        #defocus=15000 + 5000* random.random()
        for i, a in enumerate(aList):
            p = Particle()
            if doCtf:
                defocusU = defocusList[i]#+500.
                defocusV = defocusList[i]
                ctf = CTFModel(defocusU=defocusU,
                               defocusV=defocusV,
                               defocusAngle=defocusAngle[i])
                ctf.standardize()
                p.setCTF(ctf)

            p.setLocation(i + 1, partFn)
            p.setTransform(Transform(a))
            self.partSet.append(p)

        self.partSet.write()

    def createProjection(self, proj, num, baseName):
        img = emlib.Image()
        img.setDataType(emlib.DT_FLOAT)
        img.resize(projSize, projSize)

        #img.initRandom(0., 1., emlib.XMIPP_RND_GAUSSIAN)
        img.initConstant(0.)
        for coor in proj:
            value = img.getPixel(coor[0], coor[1], coor[2], coor[3])
            img.setPixel(coor[0], coor[1], coor[2], coor[3], coor[4]+value)  # coor4 is the pixel value
        img.write("%d@"%num + baseName)

    def createVol(self, volume):
        vol = emlib.Image()
        vol.setDataType(emlib.DT_FLOAT)
        vol.resize(projSize, projSize, projSize)

        #vol.initRandom(0., .5, emlib.XMIPP_RND_UNIFORM)
        vol.initConstant(0.)
        for coor in volume:
            vol.setPixel(coor[0], coor[1], coor[2], coor[3], coor[4])  # coor4 is the pixel value
        vol.write(self.volBaseFn)

    def createMask(self, _maskName):
        vol = emlib.Image()
        vol.setDataType(emlib.DT_FLOAT)
        vol.resize(projSize, projSize, projSize)

        vol.initConstant(0.0)#ROB: not sure this is needed
        halfDim = int(projSize/2)
        maskRadius2 = maskRadius * maskRadius
        for i in range(-halfDim,halfDim):
           for j in range(-halfDim,halfDim):
              for k in range(-halfDim,halfDim):
                  if(i*i+j*j+k*k) < maskRadius2:
                      vol.setPixel(0, k+halfDim, i+halfDim, j+halfDim, 1.)  # coor4 is the pixel value
        vol.write(_maskName)

    def applyCTF(self, setPartMd):

        writeSetOfParticles(self.partSet,setPartMd)
        md1 = emlib.MetaData()
        md1.setColumnFormat(False)
        idctf = md1.addObject()
        _acquisition = self.partSet.getAcquisition()
        for part in self.partSet:
            baseFnCtf = self.proj.getTmpPath("kk")#self._getTmpPath("ctf_%d.param"%mic)

            md1.setValue(emlib.MDL_CTF_SAMPLING_RATE, samplingRate, idctf)
            md1.setValue(emlib.MDL_CTF_VOLTAGE, 200., idctf);
            ctf = part.getCTF()
            udefocus = ctf.getDefocusU()
            vdefocus = ctf.getDefocusV()
            angle = ctf.getDefocusAngle()
            md1.setValue(emlib.MDL_CTF_DEFOCUSU, udefocus, idctf);
            md1.setValue(emlib.MDL_CTF_DEFOCUSV, vdefocus, idctf);
            md1.setValue(emlib.MDL_CTF_DEFOCUS_ANGLE, 180.0 * random.random(), idctf);
            md1.setValue(emlib.MDL_CTF_CS, 2., idctf);
            md1.setValue(emlib.MDL_CTF_Q0, 0.07, idctf);
            md1.setValue(emlib.MDL_CTF_K, 1., idctf);

            md1.write(baseFnCtf)
        ##writeSetOfParticles(self.partSet, setPartMd)
        #apply ctf
        args  = " -i %s"%setPartMd
        args += " -o %s"%self.proj.getTmpPath(setPartCtfName)
        args += " -f ctf %s"%baseFnCtf
        args += " --sampling %f"%samplingRate
        Plugin.runXmippProgram("xmipp_transform_filter", args)

        args  = " -i %s"%setPartMd
        args += " -o %s"%self.proj.getTmpPath(setPartCtfPosName)
        args += " -f ctfpos %s"%baseFnCtf
        args += " --sampling %f"%samplingRate
        Plugin.runXmippProgram("xmipp_transform_filter", args)

    def importData(self, baseFn, objLabel, protType, importFrom):
        prot = self.newProtocol(protType,
                     objLabel=objLabel,
                     filesPath=baseFn,
                     maskPath=baseFn,
                     sqliteFile=baseFn,
                     haveDataBeenPhaseFlipped=False,
                     magnification=10000,
                     samplingRate=samplingRate,
                     importFrom=importFrom
                     )
        self.launchProtocol(prot)
        return prot

    def test_pattern(self):
        #1) create fake protocol so I have a place to save data
        #prot = self.launchFakeProtocol()
        #output stack
        self.setPartName = self.proj.getTmpPath(setPartName)
        self.setPartSqliteName = self.proj.getTmpPath(setPartSqliteName)
        self.setPartSqliteCtfName = self.proj.getTmpPath(setPartSqliteCtfName)
        self.setPartSqliteCTfPosName = self.proj.getTmpPath(setPartSqliteCTfPosName)
        self.kksqlite = self.proj.getTmpPath("kk.sqlite")
        self.setPartMd = self.proj.getTmpPath(setPartNameMd)
        self.volBaseFn = self.proj.getTmpPath(volName)
        self.maskName = self.proj.getTmpPath(maskName)

        #2) create projections and sets of particles
        self.createProjection(proj1, 1, self.setPartName)
        self.createProjection(proj2, 2, self.setPartName)
        self.createProjection(proj3, 3, self.setPartName)
        self.createSetOfParticles(self.setPartSqliteCTfPosName, self.proj.getTmpPath(setPartCtfPosName), True)
        self.createSetOfParticles(self.setPartSqliteCtfName, self.proj.getTmpPath(setPartCtfName), True)
        self.createSetOfParticles(self.setPartSqliteName, self.setPartName, False)
        #create auxiliary setofparticles
        self.createSetOfParticles(self.kksqlite, self.setPartName, True)
        #4) apply CTF
        self.applyCTF(self.setPartMd)
        #5) create volume
        self.createVol(vol1)
        #6) create mask
        self.createMask(self.maskName)

        #import three projection datasets, volume and mask
        protPlainProj   = self.importData(self.setPartSqliteName, "plain projection",
                                          ProtImportParticles,
                                          ProtImportParticles.IMPORT_FROM_SCIPION)
        protCTFProj     = self.importData(self.setPartSqliteCtfName,"ctf projection",
                                          ProtImportParticles,
                                          ProtImportParticles.IMPORT_FROM_SCIPION)
        protCTFposProj  = self.importData(self.setPartSqliteCTfPosName, "pos ctf projection",
                                          ProtImportParticles,
                                          ProtImportParticles.IMPORT_FROM_SCIPION)
        _protImportVol   = self.importData(os.path.abspath(self.proj.getTmpPath(volName)), "3D reference",
                                           ProtImportVolumes,
                                           ProtImportParticles.IMPORT_FROM_FILES)
        _protImportMask  = self.importData(self.proj.getTmpPath(maskName), "3D mask",
                                           ProtImportMask,
                                           ProtImportParticles.IMPORT_FROM_FILES)
        mask = VolumeMask()
        mask.setFileName(self.proj.getTmpPath(maskName))
        mask.setSamplingRate(samplingRate)

        #launch substract protocol <<<<<<<<<<<<<<<<<<<<<<<<<<
        protSubtract = self.newProtocol(XmippProtSubtractProjection)
        protSubtract.inputParticles.set(protPlainProj.outputParticles)
        protSubtract.inputVolume.set(_protImportVol.outputVolume)
        protSubtract.refMask.set(_protImportMask.outputMask)
        protSubtract.projType.set(XmippProtSubtractProjection.CORRECT_NONE)
        self.launchProtocol(protSubtract)

        protSubtractCTF = self.newProtocol(XmippProtSubtractProjection)
        protSubtractCTF.inputParticles.set(protCTFProj.outputParticles)
        protSubtractCTF.inputVolume.set(_protImportVol.outputVolume)
        protSubtractCTF.refMask.set(_protImportMask.outputMask)
        protSubtractCTF.projType.set(XmippProtSubtractProjection.CORRECT_FULL_CTF)
        self.launchProtocol(protSubtractCTF)

        protSubtractCTFpos = self.newProtocol(XmippProtSubtractProjection)
        protSubtractCTFpos.inputParticles.set(protCTFposProj.outputParticles)
        protSubtractCTFpos.inputVolume.set(_protImportVol.outputVolume)
        protSubtractCTFpos.refMask.set(_protImportMask.outputMask)
        protSubtractCTFpos.projType.set(XmippProtSubtractProjection.CORRECT_PHASE_FLIP)
        self.launchProtocol(protSubtractCTFpos)

        protRelionRefine3D = self.newProtocol(ProtRelionRefine3D,
                                              doCTF=False, runMode=1,
                                              maskDiameterA=340,
                                              symmetryGroup="c1",
                                              numberOfMpi=3, numberOfThreads=2)
        protRelionRefine3D.inputParticles.set(protCTFProj.outputParticles)
        protRelionRefine3D.referenceVolume.set(_protImportVol.outputVolume)
        protRelionRefine3D.doGpu.set(False)
        self.launchProtocol(protRelionRefine3D)

        protMask = self.newProtocol(ProtRelionCreateMask3D, threshold=0.045)
        protMask.inputVolume.set(protRelionRefine3D.outputVolume)
        self.launchProtocol(protMask)

        protSubtract = self.newProtocol(ProtRelionSubtract,
                                        refMask=protMask.outputMask,
                                        numberOfMpi=2)
        protSubtract.inputProtocol.set(protRelionRefine3D)
        self.launchProtocol(protSubtract)
        self.assertIsNotNone(protSubtract.outputParticles,
                             "There was a problem with subtract projection")

        self.assertTrue(True)
        # create 3D reconstruction
        # create mask
        # call protocol to be tested
