/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.PlotMaker;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugIn,
Measurements,
PlotMaker {
    private static String[] choices = new String[]{"time", "z-axis"};
    private static String choice = choices[0];
    private boolean showingDialog;
    private ImagePlus imp;
    private boolean isPlotMaker;
    private boolean timeProfile;
    private boolean firstTime = true;

    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        this.isPlotMaker = roi != null && !IJ.macroRunning();
        Plot plot = this.getPlot();
        if (plot != null) {
            if (this.isPlotMaker) {
                plot.setPlotMaker(this);
            }
            plot.show();
        }
    }

    public Plot getPlot() {
        String title;
        Roi roi = this.imp.getRoi();
        ImageProcessor ip = this.imp.getProcessor();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        boolean hyperstack = this.imp.isHyperStack();
        float[] y = hyperstack ? this.getHyperstackProfile(roi, minThreshold, maxThreshold) : this.getZAxisProfile(roi, minThreshold, maxThreshold);
        if (y == null) {
            return null;
        }
        float[] x = new float[y.length];
        String xAxisLabel = this.showingDialog && choice.equals(choices[0]) ? "Frame" : "Slice";
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            float c = 1.0f;
            if (this.timeProfile) {
                c = (float)cal.frameInterval;
                xAxisLabel = "[" + cal.getTimeUnit() + "]";
            } else {
                c = (float)cal.pixelDepth;
                xAxisLabel = "[" + cal.getZUnit() + "]";
            }
            for (int i = 0; i < x.length; ++i) {
                x[i] = (float)i * c;
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                x[i] = i + 1;
            }
        }
        if (roi != null) {
            Rectangle r = roi.getBounds();
            title = this.imp.getTitle() + "-" + r.x + "-" + r.y;
        } else {
            title = this.imp.getTitle() + "-0-0";
        }
        Plot plot = new Plot(title, xAxisLabel, "Mean", x, y);
        if (x.length <= 60) {
            plot.setColor(Color.red);
            plot.addPoints(x, y, 0);
            plot.setColor(Color.black);
        }
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        if (ymin != 0.0 || ymax != 0.0) {
            double[] a = Tools.getMinMax(x);
            double xmin = a[0];
            double xmax = a[1];
            plot.setLimits(xmin, xmax, ymin, ymax);
        }
        if (!this.firstTime) {
            double xx;
            int pos = this.imp.getCurrentSlice();
            int size = this.imp.getStackSize();
            if (hyperstack) {
                if (this.timeProfile) {
                    pos = this.imp.getT();
                    size = this.imp.getNFrames();
                } else {
                    pos = this.imp.getZ();
                    size = this.imp.getNSlices();
                }
            }
            if ((xx = ((double)pos - 1.0) / ((double)size - 1.0)) == 0.0) {
                plot.setLineWidth(2);
            }
            plot.setColor(Color.blue);
            plot.drawNormalizedLine(xx, 0.0, xx, 1.0);
            plot.setColor(Color.black);
            plot.setLineWidth(1);
        }
        this.firstTime = false;
        return plot;
    }

    public ImagePlus getSourceImage() {
        return this.imp;
    }

    private float[] getHyperstackProfile(Roi roi, double minThreshold, double maxThreshold) {
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c = this.imp.getC();
        int z = this.imp.getZ();
        int t = this.imp.getT();
        int size = slices;
        if (this.firstTime) {
            boolean bl = this.timeProfile = slices == 1 && frames > 1;
        }
        if (slices > 1 && frames > 1 && (!this.isPlotMaker || this.firstTime)) {
            this.showingDialog = true;
            GenericDialog gd = new GenericDialog("Profiler");
            gd.addChoice("Profile", choices, choice);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            choice = gd.getNextChoice();
            this.timeProfile = choice.equals(choices[0]);
        }
        size = this.timeProfile ? frames : slices;
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        ImageStack stack = this.imp.getStack();
        for (int i = 1; i <= size; ++i) {
            int index = 1;
            index = this.timeProfile ? this.imp.getStackIndex(c, z, i) : this.imp.getStackIndex(c, i, t);
            ImageProcessor ip = stack.getProcessor(index);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            ResultsTable rt = Analyzer.getResultsTable();
            rt.show("Results");
        }
        return values;
    }

    private float[] getZAxisProfile(Roi roi, double minThreshold, double maxThreshold) {
        ImageStack stack = this.imp.getStack();
        if (this.firstTime) {
            int slices = this.imp.getNSlices();
            int frames = this.imp.getNFrames();
            this.timeProfile = slices == 1 && frames > 1;
        }
        int size = stack.getSize();
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        boolean showingLabels = this.firstTime && showResults && ((measurements & 0x400) != 0 || (measurements & 0x100000) != 0);
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        int current = this.imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            if (showingLabels) {
                this.imp.setSlice(i);
            }
            ImageProcessor ip = stack.getProcessor(i);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            ResultsTable rt = Analyzer.getResultsTable();
            rt.show("Results");
        }
        if (showingLabels) {
            this.imp.setSlice(current);
        }
        return values;
    }
}

