/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.components;

import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SpinnerRangeDouble
extends JSpinner {
    private SpinnerNumberModel model;
    private double defValue;
    private double minValue;
    private double maxValue;
    private double incValue;

    public SpinnerRangeDouble(double defValue, double minValue, double maxValue, double incValue) {
        this.defValue = defValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incValue = incValue;
        Double def = new Double(defValue);
        Double min = new Double(minValue);
        Double max = new Double(maxValue);
        Double inc = new Double(incValue);
        this.model = new SpinnerNumberModel(def, min, max, inc);
        this.setModel(this.model);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        tf.setColumns(7);
    }

    public SpinnerRangeDouble(double defValue, double minValue, double maxValue, double incValue, String format) {
        this.defValue = defValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incValue = incValue;
        Double def = new Double(defValue);
        Double min = new Double(minValue);
        Double max = new Double(maxValue);
        Double inc = new Double(incValue);
        this.model = new SpinnerNumberModel(def, min, max, inc);
        this.setModel(this.model);
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, format));
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        tf.setColumns(7);
    }

    public SpinnerRangeDouble(double defValue, double minValue, double maxValue, double incValue, int visibleChars) {
        this.defValue = defValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incValue = incValue;
        Double def = new Double(defValue);
        Double min = new Double(minValue);
        Double max = new Double(maxValue);
        Double inc = new Double(incValue);
        this.model = new SpinnerNumberModel(def, min, max, inc);
        this.setModel(this.model);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        tf.setColumns(visibleChars);
    }

    public void setFormat(String format) {
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, format));
    }

    public void setLimit(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        double value = this.get();
        Double min = new Double(minValue);
        Double max = new Double(maxValue);
        Double inc = new Double(this.incValue);
        this.defValue = value > maxValue ? maxValue : (value < minValue ? minValue : value);
        Double def = new Double(this.defValue);
        this.model = new SpinnerNumberModel(def, min, max, inc);
        this.setModel(this.model);
    }

    public void setIncrement(double incValue) {
        this.incValue = incValue;
        Double def = (Double)this.getModel().getValue();
        Double min = new Double(this.minValue);
        Double max = new Double(this.maxValue);
        Double inc = new Double(incValue);
        this.model = new SpinnerNumberModel(def, min, max, inc);
        this.setModel(this.model);
    }

    public double getIncrement() {
        return this.incValue;
    }

    public void set(double value) {
        value = value > this.maxValue ? this.maxValue : (value < this.minValue ? this.minValue : value);
        this.model.setValue(new Double(value));
    }

    public double get() {
        if (this.model.getValue() instanceof Integer) {
            Integer i = (Integer)this.model.getValue();
            double ii = i.intValue();
            return ii > this.maxValue ? this.maxValue : (ii < this.minValue ? this.minValue : ii);
        }
        if (this.model.getValue() instanceof Double) {
            Double i = (Double)this.model.getValue();
            double ii = i;
            return ii > this.maxValue ? this.maxValue : (ii < this.minValue ? this.minValue : ii);
        }
        if (this.model.getValue() instanceof Float) {
            Float i = (Float)this.model.getValue();
            double ii = i.floatValue();
            return ii > this.maxValue ? this.maxValue : (ii < this.minValue ? this.minValue : ii);
        }
        return 0.0;
    }

    public double getRangeMaximum() {
        return this.maxValue;
    }

    public double getRangeMinimum() {
        return this.minValue;
    }
}

