EESchema Schematic File Version 4
EELAYER 30 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 6 9
Title "LUNA: Power Supplies"
Date "2021-03-10"
Rev "r0"
Comp "Copyright 2019-2021 Great Scott Gadgets"
Comment1 "Katherine J. Temkin"
Comment2 ""
Comment3 "Licensed under the CERN-OHL-P v2"
Comment4 ""
$EndDescr
$Comp
L fpgas_and_processors:ECP5-BGA256 IC1
U 1 1 5DA7C210
P 8350 3400
F 0 "IC1" H 9100 3568 50  0000 C CNN
F 1 "ECP5-BGA256" H 9100 3477 50  0000 C CNN
F 2 "luna:lattice_cabga256" H 5150 6850 50  0001 L CNN
F 3 "" H 4700 7800 50  0001 L CNN
F 4 "FPGA - Field Programmable Gate Array ECP5; 12k LUTs; 1.1V" H 4700 7700 50  0001 L CNN "Description"
F 5 "Lattice" H 4750 8650 50  0001 L CNN "Manufacturer"
F 6 "LFE5U-12F-6BG256C" H 4750 8550 50  0001 L CNN "Part Number"
F 7 "LFE5U-12F-*BG256*" H 8350 3400 50  0001 C CNN "Substitution"
	1    8350 3400
	1    0    0    -1  
$EndComp
Wire Wire Line
	9850 6100 9950 6100
Wire Wire Line
	9950 6100 9950 6200
$Comp
L power:GND #PWR038
U 1 1 5DAB225F
P 9950 6200
F 0 "#PWR038" H 9950 5950 50  0001 C CNN
F 1 "GND" H 9955 6027 50  0000 C CNN
F 2 "" H 9950 6200 50  0001 C CNN
F 3 "" H 9950 6200 50  0001 C CNN
	1    9950 6200
	1    0    0    -1  
$EndComp
Wire Wire Line
	8350 6000 8250 6000
$Comp
L power:+2V5 #PWR037
U 1 1 5DAB4042
P 8250 5900
F 0 "#PWR037" H 8250 5750 50  0001 C CNN
F 1 "+2V5" H 8265 6073 50  0000 C CNN
F 2 "" H 8250 5900 50  0001 C CNN
F 3 "" H 8250 5900 50  0001 C CNN
	1    8250 5900
	1    0    0    -1  
$EndComp
$Comp
L power:+1V1 #PWR036
U 1 1 5DAB74FC
P 8250 3400
F 0 "#PWR036" H 8250 3250 50  0001 C CNN
F 1 "+1V1" H 8265 3573 50  0000 C CNN
F 2 "" H 8250 3400 50  0001 C CNN
F 3 "" H 8250 3400 50  0001 C CNN
	1    8250 3400
	1    0    0    -1  
$EndComp
Wire Notes Line
	500  3100 11200 3100
$Comp
L Device:C C7
U 1 1 5DB72418
P 1700 1000
F 0 "C7" H 1750 1100 50  0000 L CNN
F 1 "0.1uF" H 1700 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1738 850 50  0001 C CNN
F 3 "~" H 1700 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1700 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1700 1000 50  0001 C CNN "Substitution"
	1    1700 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C9
U 1 1 5DB775B8
P 1950 1000
F 0 "C9" H 2000 1100 50  0000 L CNN
F 1 "0.1uF" H 1950 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1988 850 50  0001 C CNN
F 3 "~" H 1950 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1950 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1950 1000 50  0001 C CNN "Substitution"
	1    1950 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C11
U 1 1 5DB78258
P 2200 1000
F 0 "C11" H 2250 1100 50  0000 L CNN
F 1 "0.1uF" H 2200 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2238 850 50  0001 C CNN
F 3 "~" H 2200 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2200 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2200 1000 50  0001 C CNN "Substitution"
	1    2200 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C13
U 1 1 5DB78863
P 2450 1000
F 0 "C13" H 2500 1100 50  0000 L CNN
F 1 "0.1uF" H 2450 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2488 850 50  0001 C CNN
F 3 "~" H 2450 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2450 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2450 1000 50  0001 C CNN "Substitution"
	1    2450 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C15
U 1 1 5DB78A7A
P 2700 1000
F 0 "C15" H 2750 1100 50  0000 L CNN
F 1 "0.1uF" H 2700 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2738 850 50  0001 C CNN
F 3 "~" H 2700 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2700 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2700 1000 50  0001 C CNN "Substitution"
	1    2700 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C17
U 1 1 5DB79057
P 2950 1000
F 0 "C17" H 3000 1100 50  0000 L CNN
F 1 "0.1uF" H 2950 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2988 850 50  0001 C CNN
F 3 "~" H 2950 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2950 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2950 1000 50  0001 C CNN "Substitution"
	1    2950 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C1
U 1 1 5DB79E95
P 1050 1000
F 0 "C1" H 1100 1100 50  0000 L CNN
F 1 "2.2uF" H 800 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1088 850 50  0001 C CNN
F 3 "~" H 1050 1000 50  0001 C CNN
F 4 "CAP CER 2.2UF 10V X5R 0603" H 1050 1000 50  0001 C CNN "Description"
F 5 "Samsung" H 1050 1000 50  0001 C CNN "Manufacturer"
F 6 "CL10A225KP8NNNC" H 1050 1000 50  0001 C CNN "Part Number"
	1    1050 1000
	1    0    0    -1  
$EndComp
$Comp
L power:+1V1 #PWR012
U 1 1 5DB7B3B9
P 850 850
F 0 "#PWR012" H 850 700 50  0001 C CNN
F 1 "+1V1" H 865 1023 50  0000 C CNN
F 2 "" H 850 850 50  0001 C CNN
F 3 "" H 850 850 50  0001 C CNN
	1    850  850 
	1    0    0    -1  
$EndComp
Wire Wire Line
	850  850  1050 850 
Connection ~ 1050 850 
Wire Wire Line
	1050 850  1250 850 
Connection ~ 1700 850 
Wire Wire Line
	1700 850  1950 850 
Connection ~ 1950 850 
Wire Wire Line
	1950 850  2200 850 
Connection ~ 2200 850 
Wire Wire Line
	2200 850  2450 850 
Connection ~ 2450 850 
Wire Wire Line
	2450 850  2700 850 
Connection ~ 2700 850 
Wire Wire Line
	2700 850  2950 850 
Wire Wire Line
	2950 1150 2700 1150
Wire Wire Line
	850  1150 850  1200
Connection ~ 1050 1150
Wire Wire Line
	1050 1150 850  1150
Wire Wire Line
	1250 1150 1050 1150
Connection ~ 1700 1150
Connection ~ 1950 1150
Wire Wire Line
	1950 1150 1700 1150
Connection ~ 2200 1150
Wire Wire Line
	2200 1150 1950 1150
Connection ~ 2450 1150
Wire Wire Line
	2450 1150 2200 1150
Connection ~ 2700 1150
Wire Wire Line
	2700 1150 2450 1150
$Comp
L power:GND #PWR013
U 1 1 5DB84E04
P 850 1200
F 0 "#PWR013" H 850 950 50  0001 C CNN
F 1 "GND" H 855 1027 50  0000 C CNN
F 2 "" H 850 1200 50  0001 C CNN
F 3 "" H 850 1200 50  0001 C CNN
	1    850  1200
	1    0    0    -1  
$EndComp
$Comp
L Device:C C3
U 1 1 5DB795D8
P 1250 1000
F 0 "C3" H 1300 1100 50  0000 L CNN
F 1 "2.2uF" H 1250 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1288 850 50  0001 C CNN
F 3 "~" H 1250 1000 50  0001 C CNN
F 4 "CAP CER 2.2UF 10V X5R 0603" H 1250 1000 50  0001 C CNN "Description"
F 5 "Samsung" H 1250 1000 50  0001 C CNN "Manufacturer"
F 6 "CL10A225KP8NNNC" H 1250 1000 50  0001 C CNN "Part Number"
	1    1250 1000
	1    0    0    -1  
$EndComp
Wire Wire Line
	1250 850  1700 850 
Connection ~ 1250 850 
Wire Wire Line
	1250 1150 1700 1150
Connection ~ 1250 1150
Text Notes 1050 1300 0    39   ~ 0
2 bulk decoupling; 6 local for each individual pair of VCC/GND pins
$Comp
L power:+3V3 #PWR014
U 1 1 5DBBF959
P 850 1850
F 0 "#PWR014" H 850 1700 50  0001 C CNN
F 1 "+3V3" H 865 2023 50  0000 C CNN
F 2 "" H 850 1850 50  0001 C CNN
F 3 "" H 850 1850 50  0001 C CNN
	1    850  1850
	1    0    0    -1  
$EndComp
Connection ~ 1250 2150
Wire Wire Line
	1250 2150 1700 2150
Connection ~ 1250 1850
Wire Wire Line
	1250 1850 1700 1850
$Comp
L Device:C C4
U 1 1 5DBA82F6
P 1250 2000
F 0 "C4" H 1300 2100 50  0000 L CNN
F 1 "2.2uF" H 1250 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1288 1850 50  0001 C CNN
F 3 "~" H 1250 2000 50  0001 C CNN
F 4 "CAP CER 2.2UF 10V X5R 0603" H 1250 2000 50  0001 C CNN "Description"
F 5 "Samsung" H 1250 2000 50  0001 C CNN "Manufacturer"
F 6 "CL10A225KP8NNNC" H 1250 2000 50  0001 C CNN "Part Number"
	1    1250 2000
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR015
U 1 1 5DBA82EC
P 850 2200
F 0 "#PWR015" H 850 1950 50  0001 C CNN
F 1 "GND" H 855 2027 50  0000 C CNN
F 2 "" H 850 2200 50  0001 C CNN
F 3 "" H 850 2200 50  0001 C CNN
	1    850  2200
	1    0    0    -1  
$EndComp
Connection ~ 1700 2150
Wire Wire Line
	1250 2150 1050 2150
Wire Wire Line
	1050 2150 850  2150
Connection ~ 1050 2150
Wire Wire Line
	850  2150 850  2200
Connection ~ 1700 1850
Wire Wire Line
	1050 1850 1250 1850
Connection ~ 1050 1850
Wire Wire Line
	850  1850 1050 1850
$Comp
L Device:C C2
U 1 1 5DBA82BD
P 1050 2000
F 0 "C2" H 1100 2100 50  0000 L CNN
F 1 "2.2uF" H 800 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1088 1850 50  0001 C CNN
F 3 "~" H 1050 2000 50  0001 C CNN
F 4 "CAP CER 2.2UF 10V X5R 0603" H 1050 2000 50  0001 C CNN "Description"
F 5 "Samsung" H 1050 2000 50  0001 C CNN "Manufacturer"
F 6 "CL10A225KP8NNNC" H 1050 2000 50  0001 C CNN "Part Number"
	1    1050 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C8
U 1 1 5DBA8281
P 1700 2000
F 0 "C8" H 1750 2100 50  0000 L CNN
F 1 "0.1uF" H 1700 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1738 1850 50  0001 C CNN
F 3 "~" H 1700 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1700 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1700 2000 50  0001 C CNN "Substitution"
	1    1700 2000
	1    0    0    -1  
$EndComp
Text Notes 4050 1300 0    39   ~ 0
VCCAUX decoupling, only
$Comp
L power:GND #PWR027
U 1 1 5DBD058B
P 3850 1200
F 0 "#PWR027" H 3850 950 50  0001 C CNN
F 1 "GND" H 3855 1027 50  0000 C CNN
F 2 "" H 3850 1200 50  0001 C CNN
F 3 "" H 3850 1200 50  0001 C CNN
	1    3850 1200
	1    0    0    -1  
$EndComp
Connection ~ 4400 1150
Wire Wire Line
	4050 1150 3850 1150
Connection ~ 4050 1150
Wire Wire Line
	3850 1150 3850 1200
Connection ~ 4400 850 
Connection ~ 4050 850 
Wire Wire Line
	3850 850  4050 850 
$Comp
L Device:C C22
U 1 1 5DBD05B0
P 4050 1000
F 0 "C22" H 4100 1100 50  0000 L CNN
F 1 "1uF" H 3800 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 4088 850 50  0001 C CNN
F 3 "~" H 4050 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 4050 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4050 1000 50  0001 C CNN "Substitution"
	1    4050 1000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C24
U 1 1 5DBD05EC
P 4400 1000
F 0 "C24" H 4450 1100 50  0000 L CNN
F 1 "0.1uF" H 4400 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4438 850 50  0001 C CNN
F 3 "~" H 4400 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 4400 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4400 1000 50  0001 C CNN "Substitution"
	1    4400 1000
	1    0    0    -1  
$EndComp
$Comp
L power:+2V5 #PWR026
U 1 1 5DBEB38D
P 3850 850
F 0 "#PWR026" H 3850 700 50  0001 C CNN
F 1 "+2V5" H 3865 1023 50  0000 C CNN
F 2 "" H 3850 850 50  0001 C CNN
F 3 "" H 3850 850 50  0001 C CNN
	1    3850 850 
	1    0    0    -1  
$EndComp
Wire Wire Line
	4650 1150 4400 1150
Wire Wire Line
	4400 850  4650 850 
$Comp
L Device:C C26
U 1 1 5DBD05E2
P 4650 1000
F 0 "C26" H 4700 1100 50  0000 L CNN
F 1 "0.1uF" H 4650 900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4688 850 50  0001 C CNN
F 3 "~" H 4650 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 4650 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4650 1000 50  0001 C CNN "Substitution"
	1    4650 1000
	1    0    0    -1  
$EndComp
Wire Wire Line
	4050 1150 4400 1150
Wire Wire Line
	4050 850  4400 850 
Text Notes 800  2850 0    134  ~ 0
FPGA Decoupling
$Comp
L Device:R R?
U 1 1 6025B23B
P 7200 1400
AR Path="/6025B23B" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/6025B23B" Ref="R1"  Part="1" 
F 0 "R1" V 7150 1200 50  0000 C CNN
F 1 "2.2K" V 7200 1400 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 7130 1400 50  0001 C CNN
F 3 "~" H 7200 1400 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 7200 1400 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 7200 1400 50  0001 C CNN "Substitution"
	1    7200 1400
	0    -1   1    0   
$EndComp
$Comp
L support_hardware:AP22804-SOT U?
U 1 1 6025B245
P 7900 1150
AR Path="/6025B245" Ref="U?"  Part="1" 
AR Path="/5DA7BAF4/6025B245" Ref="U1"  Part="1" 
F 0 "U1" H 8150 1322 50  0000 C CNN
F 1 "AP22811A" H 8150 1232 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 7900 1150 50  0001 C CNN
F 3 "" H 7900 1150 50  0001 C CNN
F 4 "IC PWR SWITCH P-CHAN 1:1 SOT25" H 7900 1150 50  0001 C CNN "Description"
F 5 "Diodes Inc." H 7900 1150 50  0001 C CNN "Manufacturer"
F 6 "AP22811AW5-7" H 7900 1150 50  0001 C CNN "Part Number"
F 7 "AP22804AW5-7, AP22814AW5-7" H 7900 1150 50  0001 C CNN "Substitution"
	1    7900 1150
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR?
U 1 1 6025B251
P 6850 1300
AR Path="/6025B251" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B251" Ref="#PWR042"  Part="1" 
F 0 "#PWR042" H 6850 1050 50  0001 C CNN
F 1 "GND" V 6854 1172 50  0000 R CNN
F 2 "" H 6850 1300 50  0001 C CNN
F 3 "" H 6850 1300 50  0001 C CNN
	1    6850 1300
	0    1    1    0   
$EndComp
Wire Wire Line
	7350 1400 7500 1400
Connection ~ 7500 1400
Wire Wire Line
	7500 1400 7800 1400
$Comp
L Device:C C?
U 1 1 6025B27A
P 5950 1100
AR Path="/6025B27A" Ref="C?"  Part="1" 
AR Path="/5DA7BAF4/6025B27A" Ref="C54"  Part="1" 
F 0 "C54" H 6065 1145 50  0000 L CNN
F 1 "1uF" H 6065 1055 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 5988 950 50  0001 C CNN
F 3 "~" H 5950 1100 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 5950 1100 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 5950 1100 50  0001 C CNN "Substitution"
	1    5950 1100
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR?
U 1 1 6025B280
P 5950 1350
AR Path="/6025B280" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B280" Ref="#PWR04"  Part="1" 
F 0 "#PWR04" H 5950 1100 50  0001 C CNN
F 1 "GND" H 5954 1178 50  0000 C CNN
F 2 "" H 5950 1350 50  0001 C CNN
F 3 "" H 5950 1350 50  0001 C CNN
	1    5950 1350
	1    0    0    -1  
$EndComp
Wire Wire Line
	5950 1350 5950 1250
$Comp
L power:+5V #PWR?
U 1 1 6025B287
P 5950 750
AR Path="/6025B287" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B287" Ref="#PWR03"  Part="1" 
F 0 "#PWR03" H 5950 600 50  0001 C CNN
F 1 "+5V" H 5964 923 50  0000 C CNN
F 2 "" H 5950 750 50  0001 C CNN
F 3 "" H 5950 750 50  0001 C CNN
	1    5950 750 
	1    0    0    -1  
$EndComp
$Comp
L Device:C C40
U 1 1 6025B2A6
P 9150 1550
AR Path="/5DA7BAF4/6025B2A6" Ref="C40"  Part="1" 
AR Path="/6025B2A6" Ref="C?"  Part="1" 
F 0 "C40" H 9200 1650 50  0000 L CNN
F 1 "0.1uF" H 9150 1450 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 9188 1400 50  0001 C CNN
F 3 "~" H 9150 1550 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 9150 1550 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 9150 1550 50  0001 C CNN "Substitution"
	1    9150 1550
	0    1    -1   0   
$EndComp
Wire Wire Line
	8900 1550 9000 1550
$Comp
L power:GND #PWR?
U 1 1 6025B2B4
P 9400 1550
AR Path="/6025B2B4" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B2B4" Ref="#PWR0114"  Part="1" 
F 0 "#PWR0114" H 9400 1300 50  0001 C CNN
F 1 "GND" H 9500 1400 50  0000 R CNN
F 2 "" H 9400 1550 50  0001 C CNN
F 3 "" H 9400 1550 50  0001 C CNN
	1    9400 1550
	0    -1   -1   0   
$EndComp
Wire Wire Line
	9300 1550 9400 1550
Wire Wire Line
	6850 1300 6950 1300
Wire Wire Line
	7050 1400 6950 1400
Wire Wire Line
	6950 1400 6950 1300
Connection ~ 6950 1300
Wire Wire Line
	6950 1300 7800 1300
Wire Wire Line
	8900 1550 8900 1300
Wire Wire Line
	8500 1400 8800 1400
Wire Wire Line
	6900 1850 7800 1850
$Comp
L Device:R R?
U 1 1 6025B21B
P 7250 1950
AR Path="/6025B21B" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/6025B21B" Ref="R2"  Part="1" 
F 0 "R2" V 7350 1950 50  0000 C CNN
F 1 "2.2K" V 7250 1950 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 7180 1950 50  0001 C CNN
F 3 "~" H 7250 1950 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 7250 1950 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 7250 1950 50  0001 C CNN "Substitution"
	1    7250 1950
	0    1    1    0   
$EndComp
$Comp
L support_hardware:AP22804-SOT U?
U 1 1 6025B224
P 7900 1700
AR Path="/6025B224" Ref="U?"  Part="1" 
AR Path="/5DA7BAF4/6025B224" Ref="U12"  Part="1" 
F 0 "U12" H 8150 1872 50  0000 C CNN
F 1 "AP22811A" H 8150 1782 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 7900 1700 50  0001 C CNN
F 3 "" H 7900 1700 50  0001 C CNN
F 4 "IC PWR SWITCH P-CHAN 1:1 SOT25" H 7900 1700 50  0001 C CNN "Description"
F 5 "Diodes Inc." H 7900 1700 50  0001 C CNN "Manufacturer"
F 6 "AP22811AW5-7" H 7900 1700 50  0001 C CNN "Part Number"
F 7 "AP22804AW5-7, AP22814AW5-7" H 7900 1700 50  0001 C CNN "Substitution"
	1    7900 1700
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR?
U 1 1 6025B22A
P 6900 1850
AR Path="/6025B22A" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B22A" Ref="#PWR083"  Part="1" 
F 0 "#PWR083" H 6900 1600 50  0001 C CNN
F 1 "GND" V 6904 1722 50  0000 R CNN
F 2 "" H 6900 1850 50  0001 C CNN
F 3 "" H 6900 1850 50  0001 C CNN
	1    6900 1850
	0    1    1    0   
$EndComp
Wire Wire Line
	8500 1850 9750 1850
Wire Wire Line
	7800 1950 7600 1950
Connection ~ 7600 1950
Wire Wire Line
	7600 1950 7400 1950
$Comp
L Device:C C?
U 1 1 6025B26C
P 10350 2100
AR Path="/6025B26C" Ref="C?"  Part="1" 
AR Path="/5DA7BAF4/6025B26C" Ref="C53"  Part="1" 
F 0 "C53" V 10100 2100 50  0000 C CNN
F 1 "10uF" V 10190 2100 50  0000 C CNN
F 2 "Capacitor_SMD:C_0805_2012Metric" H 10388 1950 50  0001 C CNN
F 3 "~" H 10350 2100 50  0001 C CNN
F 4 "CAP CER 10UF 10V X5R 0805" H 10350 2100 50  0001 C CNN "Description"
F 5 "Taiyo Yuden" H 10350 2100 50  0001 C CNN "Manufacturer"
F 6 "LMK212ABJ106KGHT" H 10350 2100 50  0001 C CNN "Part Number"
	1    10350 2100
	-1   0    0    1   
$EndComp
$Comp
L power:GND #PWR?
U 1 1 6025B273
P 10350 2350
AR Path="/6025B273" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B273" Ref="#PWR0117"  Part="1" 
F 0 "#PWR0117" H 10350 2100 50  0001 C CNN
F 1 "GND" H 10450 2200 50  0000 R CNN
F 2 "" H 10350 2350 50  0001 C CNN
F 3 "" H 10350 2350 50  0001 C CNN
	1    10350 2350
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR?
U 1 1 6025B297
P 6400 2250
AR Path="/6025B297" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/6025B297" Ref="#PWR07"  Part="1" 
F 0 "#PWR07" H 6400 2000 50  0001 C CNN
F 1 "GND" H 6404 2078 50  0000 C CNN
F 2 "" H 6400 2250 50  0001 C CNN
F 3 "" H 6400 2250 50  0001 C CNN
	1    6400 2250
	1    0    0    -1  
$EndComp
Wire Wire Line
	6400 2250 6400 2150
Connection ~ 9750 1850
Wire Wire Line
	1800 6950 1900 6950
Wire Wire Line
	7000 1750 7800 1750
$Comp
L Device:C C?
U 1 1 6025B28F
P 6400 2000
AR Path="/6025B28F" Ref="C?"  Part="1" 
AR Path="/5DA7BAF4/6025B28F" Ref="C55"  Part="1" 
F 0 "C55" H 6515 2045 50  0000 L CNN
F 1 "1uF" H 6515 1955 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 6438 1850 50  0001 C CNN
F 3 "~" H 6400 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 6400 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 6400 2000 50  0001 C CNN "Substitution"
	1    6400 2000
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR?
U 1 1 604A4965
P 9900 2350
AR Path="/604A4965" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/604A4965" Ref="#PWR0116"  Part="1" 
F 0 "#PWR0116" H 9900 2100 50  0001 C CNN
F 1 "GND" H 9904 2178 50  0000 C CNN
F 2 "" H 9900 2350 50  0001 C CNN
F 3 "" H 9900 2350 50  0001 C CNN
	1    9900 2350
	1    0    0    -1  
$EndComp
Wire Wire Line
	9900 2350 9900 2250
$Comp
L Device:C C?
U 1 1 604A496D
P 9900 2100
AR Path="/604A496D" Ref="C?"  Part="1" 
AR Path="/5DA7BAF4/604A496D" Ref="C45"  Part="1" 
F 0 "C45" H 10015 2145 50  0000 L CNN
F 1 "1uF" H 10015 2055 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 9938 1950 50  0001 C CNN
F 3 "~" H 9900 2100 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 9900 2100 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 9900 2100 50  0001 C CNN "Substitution"
	1    9900 2100
	1    0    0    -1  
$EndComp
Wire Wire Line
	10350 2250 10350 2350
Wire Wire Line
	9750 1850 9900 1850
Wire Wire Line
	9900 1950 9900 1850
Connection ~ 9900 1850
Wire Wire Line
	9900 1850 10000 1850
Wire Wire Line
	10000 1300 10000 1850
Wire Wire Line
	6400 1850 6400 1750
Wire Wire Line
	7100 1950 7000 1950
Wire Wire Line
	7000 1750 7000 1950
Connection ~ 7000 1950
Connection ~ 7000 1750
Wire Wire Line
	8500 1950 8700 1950
Text HLabel 1800 6950 0    50   BiDi ~ 0
TARGET_VBUS_C
Wire Wire Line
	7600 1950 7600 1000
Wire Wire Line
	7500 1400 7500 1100
$Comp
L support_hardware:AP22804-SOT U?
U 1 1 602B24C1
P 8400 2550
AR Path="/602B24C1" Ref="U?"  Part="1" 
AR Path="/5DA7BAF4/602B24C1" Ref="U13"  Part="1" 
F 0 "U13" H 8650 2722 50  0000 C CNN
F 1 "AP22811A" H 8650 2632 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 8400 2550 50  0001 C CNN
F 3 "" H 8400 2550 50  0001 C CNN
F 4 "IC PWR SWITCH P-CHAN 1:1 SOT25" H 8400 2550 50  0001 C CNN "Description"
F 5 "Diodes Inc." H 8400 2550 50  0001 C CNN "Manufacturer"
F 6 "AP22811AW5-7" H 8400 2550 50  0001 C CNN "Part Number"
F 7 "AP22804AW5-7, AP22814AW5-7" H 8400 2550 50  0001 C CNN "Substitution"
	1    8400 2550
	-1   0    0    1   
$EndComp
Wire Wire Line
	9750 2500 8500 2500
Wire Wire Line
	7400 1000 7600 1000
$Comp
L power:GND #PWR?
U 1 1 60372EEF
P 9400 2400
AR Path="/60372EEF" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/60372EEF" Ref="#PWR0115"  Part="1" 
F 0 "#PWR0115" H 9400 2150 50  0001 C CNN
F 1 "GND" V 9404 2272 50  0000 R CNN
F 2 "" H 9400 2400 50  0001 C CNN
F 3 "" H 9400 2400 50  0001 C CNN
	1    9400 2400
	0    -1   -1   0   
$EndComp
Wire Wire Line
	9400 2400 9300 2400
Wire Wire Line
	9750 1850 9750 2500
$Comp
L Device:R R?
U 1 1 60584829
P 9050 2300
AR Path="/60584829" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/60584829" Ref="R42"  Part="1" 
F 0 "R42" V 9150 2300 50  0000 C CNN
F 1 "2.2K" V 9050 2300 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8980 2300 50  0001 C CNN
F 3 "~" H 9050 2300 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 9050 2300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 9050 2300 50  0001 C CNN "Substitution"
	1    9050 2300
	0    1    -1   0   
$EndComp
Wire Wire Line
	9200 2300 9300 2300
Wire Wire Line
	9300 2300 9300 2400
Connection ~ 9300 2400
Wire Wire Line
	9300 2400 8500 2400
Wire Wire Line
	8500 2300 8600 2300
Connection ~ 8600 2300
Wire Wire Line
	8600 2300 8900 2300
Wire Wire Line
	7000 1950 7000 2400
Wire Wire Line
	7000 2400 7800 2400
Wire Wire Line
	7800 2300 7700 2300
Wire Wire Line
	7700 2300 7700 900 
Wire Wire Line
	7700 900  7400 900 
Text HLabel 7400 900  0    50   Output ~ 0
VBUS_C_TO_A_FAULT
Text HLabel 8900 1000 2    50   Input ~ 0
VBUS_A_TO_C_EN
Text HLabel 7400 1100 0    50   Input ~ 0
VBUS_5V_TO_A_EN
Wire Wire Line
	7400 1100 7500 1100
Text Notes 7100 2950 0    134  ~ 0
VBUS Load Switches
Text Notes 3850 4950 0    39   ~ 0
Operating the +1V1 rail at 1.15 V\nis a compromise between performance\nand power consumption. ECP5 core\nsupply voltage is specified as 1.1 V\nwhile the higher performing ECP5-5G\n(confirmed to be the same die) core\nsupply voltage is specified as 1.2 V.\n
$Comp
L Regulator_Linear:MIC5504-1.8YM5 U4
U 1 1 5FFE1C03
P 5350 4050
F 0 "U4" H 5350 4417 50  0000 C CNN
F 1 "TCR2EF115" H 5350 4326 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 5350 3650 50  0001 C CNN
F 3 "https://toshiba.semicon-storage.com/info/docget.jsp?did=13794&prodName=TCR2EF115" H 5100 4300 50  0001 C CNN
F 4 "IC REG LINEAR 1.15V 200MA SMV" H 5350 4050 50  0001 C CNN "Description"
F 5 "Toshiba" H 5350 4050 50  0001 C CNN "Manufacturer"
F 6 "TCR2EF115,LM(CT" H 5350 4050 50  0001 C CNN "Part Number"
	1    5350 4050
	1    0    0    -1  
$EndComp
Wire Wire Line
	2250 4500 2250 4600
Connection ~ 2250 4500
Wire Wire Line
	2950 4500 2250 4500
Wire Wire Line
	2250 4400 2250 4500
$Comp
L Regulator_Linear:MIC5504-1.8YM5 U3
U 1 1 5FE35315
P 2250 4100
F 0 "U3" H 2250 4467 50  0000 C CNN
F 1 "AP7366-33W5-7" H 2250 4376 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 2250 3700 50  0001 C CNN
F 3 "https://www.diodes.com/assets/Datasheets/AP7366.pdf" H 2000 4350 50  0001 C CNN
F 4 "Linear Voltage Regulator IC 1 Output 600mA SOT-25" H 2250 4100 50  0001 C CNN "Description"
F 5 "Diodes Inc." H 2250 4100 50  0001 C CNN "Manufacturer"
F 6 "AP7366-33W5-7" H 2250 4100 50  0001 C CNN "Part Number"
	1    2250 4100
	1    0    0    -1  
$EndComp
Wire Wire Line
	1600 3700 1600 3800
Connection ~ 1600 3800
Wire Wire Line
	1600 3800 1600 4000
$Comp
L power:+5V #PWR019
U 1 1 5DB57CF1
P 1600 3700
F 0 "#PWR019" H 1600 3550 50  0001 C CNN
F 1 "+5V" H 1615 3873 50  0000 C CNN
F 2 "" H 1600 3700 50  0001 C CNN
F 3 "" H 1600 3700 50  0001 C CNN
	1    1600 3700
	1    0    0    -1  
$EndComp
Connection ~ 1600 4000
Wire Wire Line
	5900 6050 5900 6150
Connection ~ 5900 6050
$Comp
L Connector:TestPoint TP5
U 1 1 5E218EBF
P 6000 6050
F 0 "TP5" V 5955 6237 50  0000 L CNN
F 1 "TestPoint" V 6045 6237 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 6200 6050 50  0001 C CNN
F 3 "~" H 6200 6050 50  0001 C CNN
F 4 "DNP" H 6000 6050 50  0001 C CNN "Note"
	1    6000 6050
	0    1    1    0   
$EndComp
Wire Wire Line
	5900 3850 5900 3950
Connection ~ 5900 3850
$Comp
L Connector:TestPoint TP4
U 1 1 5E218B73
P 6000 3850
F 0 "TP4" V 5955 4037 50  0000 L CNN
F 1 "TestPoint" V 6045 4037 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 6200 3850 50  0001 C CNN
F 3 "~" H 6200 3850 50  0001 C CNN
F 4 "DNP" H 6000 3850 50  0001 C CNN "Note"
	1    6000 3850
	0    1    1    0   
$EndComp
Wire Wire Line
	2950 3900 2950 4000
Connection ~ 2950 3900
$Comp
L Connector:TestPoint TP3
U 1 1 5E218736
P 3050 3900
F 0 "TP3" V 3005 4087 50  0000 L CNN
F 1 "TestPoint" V 3095 4087 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 3250 3900 50  0001 C CNN
F 3 "~" H 3250 3900 50  0001 C CNN
F 4 "DNP" H 3050 3900 50  0001 C CNN "Note"
	1    3050 3900
	0    1    1    0   
$EndComp
Wire Wire Line
	4600 3750 4800 3750
Wire Wire Line
	4700 5950 4800 5950
Connection ~ 4800 6150
Wire Wire Line
	4800 6350 4950 6350
Wire Wire Line
	4800 6150 4800 6350
Wire Wire Line
	4800 4150 4950 4150
Connection ~ 4800 3950
Wire Wire Line
	4800 3950 4800 4150
Wire Wire Line
	1600 4200 1600 4000
Wire Wire Line
	1850 4200 1600 4200
Wire Wire Line
	2650 4000 2950 4000
Wire Wire Line
	1600 4000 1850 4000
Wire Notes Line
	5250 3100 5250 500 
$Comp
L power:+1V1 #PWR034
U 1 1 5DB71356
P 5900 3750
F 0 "#PWR034" H 5900 3600 50  0001 C CNN
F 1 "+1V1" H 5915 3923 50  0000 C CNN
F 2 "" H 5900 3750 50  0001 C CNN
F 3 "" H 5900 3750 50  0001 C CNN
	1    5900 3750
	1    0    0    -1  
$EndComp
$Comp
L power:+2V5 #PWR030
U 1 1 5DB70700
P 4800 3650
F 0 "#PWR030" H 4800 3500 50  0001 C CNN
F 1 "+2V5" H 4815 3823 50  0000 C CNN
F 2 "" H 4800 3650 50  0001 C CNN
F 3 "" H 4800 3650 50  0001 C CNN
	1    4800 3650
	1    0    0    -1  
$EndComp
Wire Notes Line
	7000 3100 7000 6500
Wire Wire Line
	5900 3750 5900 3850
Text Notes 4650 5300 0    134  ~ 0
FPGA VCC CORE
Wire Wire Line
	5350 4450 5350 4550
Connection ~ 5350 4450
Wire Wire Line
	5900 4450 5350 4450
$Comp
L Device:C C29
U 1 1 5DB5AC8D
P 5900 4200
F 0 "C29" H 6015 4246 50  0000 L CNN
F 1 "1uF" H 6015 4155 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 5938 4050 50  0001 C CNN
F 3 "~" H 5900 4200 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 5900 4200 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 5900 4200 50  0001 C CNN "Substitution"
	1    5900 4200
	1    0    0    -1  
$EndComp
Wire Wire Line
	4800 3750 4800 3950
Connection ~ 4800 3750
$Comp
L power:GND #PWR028
U 1 1 5DB5AC7F
P 4250 3850
F 0 "#PWR028" H 4250 3600 50  0001 C CNN
F 1 "GND" H 4255 3677 50  0000 C CNN
F 2 "" H 4250 3850 50  0001 C CNN
F 3 "" H 4250 3850 50  0001 C CNN
	1    4250 3850
	1    0    0    -1  
$EndComp
Wire Wire Line
	4250 3850 4250 3750
Wire Wire Line
	4250 3750 4300 3750
$Comp
L Device:C C27
U 1 1 5DB5AC73
P 4450 3750
F 0 "C27" V 4198 3750 50  0000 C CNN
F 1 "0.1uF" V 4289 3750 50  0000 C CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 4488 3600 50  0001 C CNN
F 3 "~" H 4450 3750 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 4450 3750 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4450 3750 50  0001 C CNN "Substitution"
	1    4450 3750
	0    1    1    0   
$EndComp
Wire Wire Line
	4800 3650 4800 3750
$Comp
L power:GND #PWR032
U 1 1 5DB5AC68
P 5350 4550
F 0 "#PWR032" H 5350 4300 50  0001 C CNN
F 1 "GND" H 5355 4377 50  0000 C CNN
F 2 "" H 5350 4550 50  0001 C CNN
F 3 "" H 5350 4550 50  0001 C CNN
	1    5350 4550
	1    0    0    -1  
$EndComp
Wire Wire Line
	5350 4350 5350 4450
Wire Wire Line
	4950 3950 4800 3950
$Comp
L power:+3V3 #PWR023
U 1 1 5DB58DE3
P 2950 3800
F 0 "#PWR023" H 2950 3650 50  0001 C CNN
F 1 "+3V3" H 2965 3973 50  0000 C CNN
F 2 "" H 2950 3800 50  0001 C CNN
F 3 "" H 2950 3800 50  0001 C CNN
	1    2950 3800
	1    0    0    -1  
$EndComp
Wire Notes Line
	3700 3100 3700 7750
Text Notes 1350 5250 0    134  ~ 0
Main I/O Supply
$Comp
L Device:C C20
U 1 1 5DAFC9B0
P 2950 4250
F 0 "C20" H 3065 4296 50  0000 L CNN
F 1 "2.2uF" H 3065 4205 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 2988 4100 50  0001 C CNN
F 3 "~" H 2950 4250 50  0001 C CNN
F 4 "CAP CER 2.2UF 10V X5R 0603" H 2950 4250 50  0001 C CNN "Description"
F 5 "Samsung" H 2950 4250 50  0001 C CNN "Manufacturer"
F 6 "CL10A225KP8NNNC" H 2950 4250 50  0001 C CNN "Part Number"
	1    2950 4250
	1    0    0    -1  
$EndComp
Wire Wire Line
	2950 3800 2950 3900
$Comp
L power:GND #PWR021
U 1 1 5DAFC980
P 2250 4600
F 0 "#PWR021" H 2250 4350 50  0001 C CNN
F 1 "GND" H 2255 4427 50  0000 C CNN
F 2 "" H 2250 4600 50  0001 C CNN
F 3 "" H 2250 4600 50  0001 C CNN
	1    2250 4600
	1    0    0    -1  
$EndComp
Wire Wire Line
	5900 5950 5900 6050
$Comp
L power:+2V5 #PWR035
U 1 1 5DAF4ABE
P 5900 5950
F 0 "#PWR035" H 5900 5800 50  0001 C CNN
F 1 "+2V5" H 5915 6123 50  0000 C CNN
F 2 "" H 5900 5950 50  0001 C CNN
F 3 "" H 5900 5950 50  0001 C CNN
	1    5900 5950
	1    0    0    -1  
$EndComp
Wire Notes Line
	3750 5400 7000 5400
Wire Notes Line
	3700 5400 500  5400
$Comp
L Regulator_Linear:MIC5504-2.5YM5 U5
U 1 1 5DAEA302
P 5350 6250
F 0 "U5" H 5350 6617 50  0000 C CNN
F 1 "MIC5504-2.5YM5" H 5350 6526 50  0000 C CNN
F 2 "Package_TO_SOT_SMD:SOT-23-5" H 5350 5850 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/MIC550X.pdf" H 5100 6500 50  0001 C CNN
F 4 "IC REG LINEAR 2.5V 300MA SOT23-5" H 5350 6250 50  0001 C CNN "Description"
F 5 "Microchip" H 5350 6250 50  0001 C CNN "Manufacturer"
F 6 "MIC5504-2.5YM5-TR" H 5350 6250 50  0001 C CNN "Part Number"
	1    5350 6250
	1    0    0    -1  
$EndComp
Text Notes 4650 7550 0    134  ~ 0
FPGA VCCAUX
Wire Wire Line
	5350 6650 5350 6750
Connection ~ 5350 6650
Wire Wire Line
	5900 6650 5350 6650
$Comp
L Device:C C30
U 1 1 5DAE1BF3
P 5900 6400
F 0 "C30" H 6015 6446 50  0000 L CNN
F 1 "1uF" H 6015 6355 50  0000 L CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 5938 6250 50  0001 C CNN
F 3 "~" H 5900 6400 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 5900 6400 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 5900 6400 50  0001 C CNN "Substitution"
	1    5900 6400
	1    0    0    -1  
$EndComp
Wire Wire Line
	4800 5950 4800 6150
Connection ~ 4800 5950
$Comp
L power:GND #PWR029
U 1 1 5DAE1BDA
P 4300 6050
F 0 "#PWR029" H 4300 5800 50  0001 C CNN
F 1 "GND" H 4305 5877 50  0000 C CNN
F 2 "" H 4300 6050 50  0001 C CNN
F 3 "" H 4300 6050 50  0001 C CNN
	1    4300 6050
	1    0    0    -1  
$EndComp
Wire Wire Line
	4300 6050 4300 5950
Wire Wire Line
	4300 5950 4400 5950
$Comp
L Device:C C28
U 1 1 5DAE1BCE
P 4550 5950
F 0 "C28" V 4298 5950 50  0000 C CNN
F 1 "1uF" V 4389 5950 50  0000 C CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 4588 5800 50  0001 C CNN
F 3 "~" H 4550 5950 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 4550 5950 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4550 5950 50  0001 C CNN "Substitution"
	1    4550 5950
	0    1    1    0   
$EndComp
Wire Wire Line
	4800 5850 4800 5950
$Comp
L power:GND #PWR033
U 1 1 5DAE1BC3
P 5350 6750
F 0 "#PWR033" H 5350 6500 50  0001 C CNN
F 1 "GND" H 5355 6577 50  0000 C CNN
F 2 "" H 5350 6750 50  0001 C CNN
F 3 "" H 5350 6750 50  0001 C CNN
	1    5350 6750
	1    0    0    -1  
$EndComp
Wire Wire Line
	5350 6550 5350 6650
$Comp
L power:+3V3 #PWR031
U 1 1 5DAE1BB6
P 4800 5850
F 0 "#PWR031" H 4800 5700 50  0001 C CNN
F 1 "+3V3" H 4815 6023 50  0000 C CNN
F 2 "" H 4800 5850 50  0001 C CNN
F 3 "" H 4800 5850 50  0001 C CNN
	1    4800 5850
	1    0    0    -1  
$EndComp
Wire Wire Line
	4950 6150 4800 6150
Wire Wire Line
	8500 1300 8900 1300
Connection ~ 8900 1300
Wire Wire Line
	8900 1300 10000 1300
Wire Wire Line
	8800 1200 8900 1200
Wire Wire Line
	8800 1400 8800 1200
Text HLabel 8900 1200 2    50   Output ~ 0
VBUS_5V_TO_A_FAULT
Wire Wire Line
	8700 1100 8900 1100
Wire Wire Line
	8700 1950 8700 1100
Text HLabel 8900 1100 2    50   Output ~ 0
VBUS_A_TO_C_FAULT
Text HLabel 7400 1000 0    50   Input ~ 0
VBUS_C_TO_A_EN
Wire Wire Line
	8600 1000 8900 1000
Wire Wire Line
	8600 2300 8600 1000
Wire Wire Line
	9250 800  9200 800 
$Comp
L power:+3V3 #PWR?
U 1 1 60C90AE9
P 9250 800
AR Path="/60C90AE9" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/60C90AE9" Ref="#PWR0100"  Part="1" 
F 0 "#PWR0100" H 9250 650 50  0001 C CNN
F 1 "+3V3" V 9264 928 50  0000 L CNN
F 2 "" H 9250 800 50  0001 C CNN
F 3 "" H 9250 800 50  0001 C CNN
	1    9250 800 
	0    1    1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 60C90AE3
P 9050 800
AR Path="/60C90AE3" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/60C90AE3" Ref="R3"  Part="1" 
F 0 "R3" V 9150 800 50  0000 C CNN
F 1 "10K" V 9050 800 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8980 800 50  0001 C CNN
F 3 "~" H 9050 800 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 9050 800 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 9050 800 50  0001 C CNN "Substitution"
	1    9050 800 
	0    1    1    0   
$EndComp
Wire Wire Line
	9250 600  9200 600 
$Comp
L power:+3V3 #PWR?
U 1 1 60E90328
P 9250 600
AR Path="/60E90328" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/60E90328" Ref="#PWR099"  Part="1" 
F 0 "#PWR099" H 9250 450 50  0001 C CNN
F 1 "+3V3" V 9264 728 50  0000 L CNN
F 2 "" H 9250 600 50  0001 C CNN
F 3 "" H 9250 600 50  0001 C CNN
	1    9250 600 
	0    1    1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 60E90333
P 9050 600
AR Path="/60E90333" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/60E90333" Ref="R41"  Part="1" 
F 0 "R41" V 9150 600 50  0000 C CNN
F 1 "10K" V 9050 600 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8980 600 50  0001 C CNN
F 3 "~" H 9050 600 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 9050 600 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 9050 600 50  0001 C CNN "Substitution"
	1    9050 600 
	0    1    1    0   
$EndComp
Wire Wire Line
	8800 1200 8800 800 
Wire Wire Line
	8800 800  8900 800 
Connection ~ 8800 1200
Wire Wire Line
	8700 1100 8700 600 
Wire Wire Line
	8700 600  8900 600 
Connection ~ 8700 1100
Wire Wire Line
	7050 700  7100 700 
$Comp
L power:+3V3 #PWR?
U 1 1 60EC101A
P 7050 700
AR Path="/60EC101A" Ref="#PWR?"  Part="1" 
AR Path="/5DA7BAF4/60EC101A" Ref="#PWR082"  Part="1" 
F 0 "#PWR082" H 7050 550 50  0001 C CNN
F 1 "+3V3" V 7064 828 50  0000 L CNN
F 2 "" H 7050 700 50  0001 C CNN
F 3 "" H 7050 700 50  0001 C CNN
	1    7050 700 
	0    -1   1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 60EC1025
P 7250 700
AR Path="/60EC1025" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/60EC1025" Ref="R40"  Part="1" 
F 0 "R40" V 7350 700 50  0000 C CNN
F 1 "10K" V 7250 700 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 7180 700 50  0001 C CNN
F 3 "~" H 7250 700 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 7250 700 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 7250 700 50  0001 C CNN "Substitution"
	1    7250 700 
	0    -1   1    0   
$EndComp
Wire Wire Line
	7700 700  7400 700 
Wire Wire Line
	7700 700  7700 900 
Connection ~ 7700 900 
Wire Wire Line
	5950 750  5950 850 
Wire Wire Line
	5950 850  6400 850 
Wire Wire Line
	6400 850  6400 1200
Wire Wire Line
	6400 1200 7800 1200
Connection ~ 5950 850 
Wire Wire Line
	5950 850  5950 950 
Wire Wire Line
	1500 3800 1600 3800
$Comp
L power:GND #PWR017
U 1 1 5DAFC997
P 1100 3900
F 0 "#PWR017" H 1100 3650 50  0001 C CNN
F 1 "GND" H 1105 3727 50  0000 C CNN
F 2 "" H 1100 3900 50  0001 C CNN
F 3 "" H 1100 3900 50  0001 C CNN
	1    1100 3900
	1    0    0    -1  
$EndComp
Wire Wire Line
	1100 3800 1200 3800
Wire Wire Line
	1100 3800 1100 3900
$Comp
L Device:C C?
U 1 1 5FEAA520
P 1350 3800
AR Path="/5FEAA520" Ref="C?"  Part="1" 
AR Path="/5DA7BAF4/5FEAA520" Ref="C6"  Part="1" 
F 0 "C6" V 1600 3800 50  0000 C CNN
F 1 "1uF" V 1500 3800 50  0000 C CNN
F 2 "Capacitor_SMD:C_0603_1608Metric" H 1388 3650 50  0001 C CNN
F 3 "~" H 1350 3800 50  0001 C CNN
F 4 "GENERIC-CAP-0603-1uF" H 1350 3800 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1350 3800 50  0001 C CNN "Substitution"
	1    1350 3800
	0    1    -1   0   
$EndComp
$Comp
L power:PWR_FLAG #FLG0102
U 1 1 608139F5
P 2300 5800
F 0 "#FLG0102" H 2300 5875 50  0001 C CNN
F 1 "PWR_FLAG" H 2300 5973 50  0000 C CNN
F 2 "" H 2300 5800 50  0001 C CNN
F 3 "~" H 2300 5800 50  0001 C CNN
	1    2300 5800
	1    0    0    -1  
$EndComp
$Comp
L power:+5V #PWR0107
U 1 1 6082A530
P 2200 5900
F 0 "#PWR0107" H 2200 5750 50  0001 C CNN
F 1 "+5V" H 2215 6073 50  0000 C CNN
F 2 "" H 2200 5900 50  0001 C CNN
F 3 "" H 2200 5900 50  0001 C CNN
	1    2200 5900
	0    -1   -1   0   
$EndComp
Wire Wire Line
	2300 6000 2300 5900
$Comp
L power:GND #PWR0122
U 1 1 608D5363
P 1550 5900
F 0 "#PWR0122" H 1550 5650 50  0001 C CNN
F 1 "GND" H 1555 5727 50  0000 C CNN
F 2 "" H 1550 5900 50  0001 C CNN
F 3 "" H 1550 5900 50  0001 C CNN
	1    1550 5900
	0    1    1    0   
$EndComp
$Comp
L power:PWR_FLAG #FLG0101
U 1 1 608D5F95
P 1650 5800
F 0 "#FLG0101" H 1650 5875 50  0001 C CNN
F 1 "PWR_FLAG" H 1650 5973 50  0000 C CNN
F 2 "" H 1650 5800 50  0001 C CNN
F 3 "~" H 1650 5800 50  0001 C CNN
	1    1650 5800
	1    0    0    -1  
$EndComp
Wire Wire Line
	1650 6000 1650 5900
$Comp
L power:PWR_FLAG #FLG0104
U 1 1 6092C127
P 1900 6850
F 0 "#FLG0104" H 1900 6925 50  0001 C CNN
F 1 "PWR_FLAG" H 1900 7023 50  0000 C CNN
F 2 "" H 1900 6850 50  0001 C CNN
F 3 "~" H 1900 6850 50  0001 C CNN
	1    1900 6850
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP29
U 1 1 617D3114
P 1900 7200
F 0 "TP29" V 1855 7387 50  0000 L CNN
F 1 "TestPoint" V 1945 7387 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 2100 7200 50  0001 C CNN
F 3 "~" H 2100 7200 50  0001 C CNN
F 4 "DNP" H 1900 7200 50  0001 C CNN "Note"
	1    1900 7200
	-1   0    0    1   
$EndComp
Wire Wire Line
	1900 6950 1900 7100
$Comp
L Connector:TestPoint TP31
U 1 1 6176EDC9
P 2900 7200
F 0 "TP31" V 2855 7387 50  0000 L CNN
F 1 "TestPoint" V 2945 7387 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 3100 7200 50  0001 C CNN
F 3 "~" H 3100 7200 50  0001 C CNN
F 4 "DNP" H 2900 7200 50  0001 C CNN "Note"
	1    2900 7200
	-1   0    0    1   
$EndComp
Text HLabel 2800 6950 0    50   Output ~ 0
TARGET_VBUS_A
$Comp
L power:PWR_FLAG #FLG0103
U 1 1 608F2C2B
P 2900 6850
F 0 "#FLG0103" H 2900 6925 50  0001 C CNN
F 1 "PWR_FLAG" H 2900 7023 50  0000 C CNN
F 2 "" H 2900 6850 50  0001 C CNN
F 3 "~" H 2900 6850 50  0001 C CNN
	1    2900 6850
	1    0    0    -1  
$EndComp
Wire Wire Line
	10000 1850 10350 1850
Wire Wire Line
	10350 1850 10350 1950
Connection ~ 10000 1850
Wire Wire Line
	6400 1750 7000 1750
Text Label 10450 1850 0    50   ~ 0
TARGET_VBUS_A
Text Label 6300 1750 2    50   ~ 0
TARGET_VBUS_C
Wire Wire Line
	6300 1750 6400 1750
Connection ~ 6400 1750
Wire Wire Line
	10450 1850 10350 1850
Connection ~ 10350 1850
Text Label 1800 7100 2    50   ~ 0
TARGET_VBUS_C
Wire Wire Line
	1900 6950 1900 6850
Connection ~ 1900 6950
Wire Wire Line
	1800 7100 1900 7100
Connection ~ 1900 7100
Wire Wire Line
	1900 7100 1900 7200
Text Label 2800 7100 2    50   ~ 0
TARGET_VBUS_A
Wire Wire Line
	2800 6950 2900 6950
Wire Wire Line
	2900 6950 2900 6850
Wire Wire Line
	2900 6950 2900 7100
Connection ~ 2900 6950
Wire Wire Line
	2800 7100 2900 7100
Connection ~ 2900 7100
Wire Wire Line
	2900 7100 2900 7200
$Comp
L Connector:TestPoint TP28
U 1 1 618F9CB8
P 1650 6000
F 0 "TP28" V 1605 6187 50  0000 L CNN
F 1 "TestPoint" V 1695 6187 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 1850 6000 50  0001 C CNN
F 3 "~" H 1850 6000 50  0001 C CNN
F 4 "DNP" H 1650 6000 50  0001 C CNN "Note"
	1    1650 6000
	-1   0    0    1   
$EndComp
Wire Wire Line
	1550 5900 1650 5900
Connection ~ 1650 5900
Wire Wire Line
	1650 5900 1650 5800
$Comp
L Connector:TestPoint TP30
U 1 1 6192E92B
P 2300 6000
F 0 "TP30" V 2255 6187 50  0000 L CNN
F 1 "TestPoint" V 2345 6187 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 2500 6000 50  0001 C CNN
F 3 "~" H 2500 6000 50  0001 C CNN
F 4 "DNP" H 2300 6000 50  0001 C CNN "Note"
	1    2300 6000
	-1   0    0    1   
$EndComp
Wire Wire Line
	2200 5900 2300 5900
Connection ~ 2300 5900
Wire Wire Line
	2300 5900 2300 5800
$Comp
L Device:C C10
U 1 1 5DBA828B
P 1950 2000
F 0 "C10" H 2000 2100 50  0000 L CNN
F 1 "0.1uF" H 1950 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1988 1850 50  0001 C CNN
F 3 "~" H 1950 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1950 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1950 2000 50  0001 C CNN "Substitution"
	1    1950 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C12
U 1 1 5DBA8295
P 2200 2000
F 0 "C12" H 2250 2100 50  0000 L CNN
F 1 "0.1uF" H 2200 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2238 1850 50  0001 C CNN
F 3 "~" H 2200 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2200 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2200 2000 50  0001 C CNN "Substitution"
	1    2200 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C14
U 1 1 5DBA829F
P 2450 2000
F 0 "C14" H 2500 2100 50  0000 L CNN
F 1 "0.1uF" H 2450 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2488 1850 50  0001 C CNN
F 3 "~" H 2450 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2450 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2450 2000 50  0001 C CNN "Substitution"
	1    2450 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C16
U 1 1 5DBA82A9
P 2700 2000
F 0 "C16" H 2750 2100 50  0000 L CNN
F 1 "0.1uF" H 2700 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2738 1850 50  0001 C CNN
F 3 "~" H 2700 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2700 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2700 2000 50  0001 C CNN "Substitution"
	1    2700 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C18
U 1 1 5DBA82B3
P 2950 2000
F 0 "C18" H 3000 2100 50  0000 L CNN
F 1 "0.1uF" H 2950 1900 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2988 1850 50  0001 C CNN
F 3 "~" H 2950 2000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2950 2000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2950 2000 50  0001 C CNN "Substitution"
	1    2950 2000
	1    0    0    -1  
$EndComp
Wire Wire Line
	1700 1850 1950 1850
Connection ~ 1950 1850
Wire Wire Line
	1950 1850 2200 1850
Connection ~ 2200 1850
Wire Wire Line
	2200 1850 2450 1850
Connection ~ 2450 1850
Wire Wire Line
	2450 1850 2700 1850
Connection ~ 2700 1850
Wire Wire Line
	2700 1850 2950 1850
Wire Wire Line
	2950 2150 2700 2150
Connection ~ 1950 2150
Wire Wire Line
	1950 2150 1700 2150
Connection ~ 2200 2150
Wire Wire Line
	2200 2150 1950 2150
Connection ~ 2450 2150
Wire Wire Line
	2450 2150 2200 2150
Connection ~ 2700 2150
Wire Wire Line
	2700 2150 2450 2150
Text Notes 1050 2350 0    39   ~ 0
2 bulk decoupling; 6 local for the various 3V3 VCCIO pins\n(microcontroller / flash / etc decoupling is included locally)
Wire Wire Line
	5750 6150 5900 6150
Wire Wire Line
	5900 6550 5900 6650
Wire Wire Line
	5900 6250 5900 6150
Wire Wire Line
	6000 6050 5900 6050
Wire Wire Line
	2950 4000 2950 4100
Wire Wire Line
	2950 4400 2950 4500
Connection ~ 2950 4000
Wire Wire Line
	3050 3900 2950 3900
Connection ~ 5900 6150
Wire Wire Line
	5900 4350 5900 4450
Wire Wire Line
	5750 3950 5900 3950
Wire Wire Line
	5900 3950 5900 4050
Connection ~ 5900 3950
Wire Wire Line
	5900 3850 6000 3850
Wire Wire Line
	8350 6100 8250 6100
Wire Wire Line
	8250 6100 8250 6000
Connection ~ 8250 6000
Wire Wire Line
	8350 3500 8250 3500
Wire Wire Line
	8250 3500 8250 3600
Wire Wire Line
	8250 4000 8350 4000
Wire Wire Line
	8350 3900 8250 3900
Connection ~ 8250 3900
Wire Wire Line
	8250 3900 8250 4000
Wire Wire Line
	8350 3800 8250 3800
Connection ~ 8250 3800
Wire Wire Line
	8250 3800 8250 3900
Wire Wire Line
	8350 3700 8250 3700
Connection ~ 8250 3700
Wire Wire Line
	8250 3700 8250 3800
Wire Wire Line
	8350 3600 8250 3600
Connection ~ 8250 3600
Wire Wire Line
	8250 3600 8250 3700
Connection ~ 8250 3500
Connection ~ 9950 6100
Wire Wire Line
	9950 3500 9950 3600
Wire Wire Line
	9850 3500 9950 3500
Wire Wire Line
	9850 3600 9950 3600
Connection ~ 9950 3600
Wire Wire Line
	9950 3600 9950 3700
Wire Wire Line
	9850 3700 9950 3700
Connection ~ 9950 3700
Wire Wire Line
	9950 3700 9950 3800
Wire Wire Line
	9850 3800 9950 3800
Connection ~ 9950 3800
Wire Wire Line
	9950 3800 9950 3900
Wire Wire Line
	9850 3900 9950 3900
Connection ~ 9950 3900
Wire Wire Line
	9950 3900 9950 4000
Wire Wire Line
	9850 4000 9950 4000
Connection ~ 9950 4000
Wire Wire Line
	9950 4000 9950 4100
Wire Wire Line
	9850 4100 9950 4100
Connection ~ 9950 4100
Wire Wire Line
	9950 4100 9950 4200
Wire Wire Line
	9850 4200 9950 4200
Connection ~ 9950 4200
Wire Wire Line
	9950 4200 9950 4300
Wire Wire Line
	9850 4300 9950 4300
Connection ~ 9950 4300
Wire Wire Line
	9950 4300 9950 4400
Wire Wire Line
	9850 4400 9950 4400
Connection ~ 9950 4400
Wire Wire Line
	9850 4500 9950 4500
Wire Wire Line
	9950 4400 9950 4500
Connection ~ 9950 4500
Wire Wire Line
	9950 4500 9950 4600
Wire Wire Line
	9850 4600 9950 4600
Connection ~ 9950 4600
Wire Wire Line
	9950 4600 9950 4700
Wire Wire Line
	9850 4700 9950 4700
Connection ~ 9950 4700
Wire Wire Line
	9950 4700 9950 4800
Wire Wire Line
	9850 4800 9950 4800
Connection ~ 9950 4800
Wire Wire Line
	9950 4800 9950 4900
Wire Wire Line
	9850 4900 9950 4900
Connection ~ 9950 4900
Wire Wire Line
	9850 5000 9950 5000
Wire Wire Line
	9950 4900 9950 5000
Connection ~ 9950 5000
Wire Wire Line
	9950 5000 9950 5100
Wire Wire Line
	9850 5100 9950 5100
Connection ~ 9950 5100
Wire Wire Line
	9950 5100 9950 5200
Wire Wire Line
	9850 5200 9950 5200
Connection ~ 9950 5200
Wire Wire Line
	9950 5200 9950 5300
Wire Wire Line
	9850 5300 9950 5300
Connection ~ 9950 5300
Wire Wire Line
	9950 5300 9950 5400
Wire Wire Line
	9850 5400 9950 5400
Connection ~ 9950 5400
Wire Wire Line
	9950 5400 9950 5500
Wire Wire Line
	9850 5500 9950 5500
Connection ~ 9950 5500
Wire Wire Line
	9950 5500 9950 5600
Wire Wire Line
	9850 5600 9950 5600
Connection ~ 9950 5600
Wire Wire Line
	9950 5600 9950 5700
Wire Wire Line
	9850 5700 9950 5700
Connection ~ 9950 5700
Wire Wire Line
	9950 5700 9950 5800
Wire Wire Line
	9850 5800 9950 5800
Connection ~ 9950 5800
Wire Wire Line
	9950 5800 9950 5900
Wire Wire Line
	9850 5900 9950 5900
Connection ~ 9950 5900
Wire Wire Line
	9950 5900 9950 6000
Wire Wire Line
	9850 6000 9950 6000
Connection ~ 9950 6000
Wire Wire Line
	9950 6000 9950 6100
Wire Wire Line
	8250 3400 8250 3500
Wire Wire Line
	8250 5900 8250 6000
$EndSCHEMATC
