EESchema Schematic File Version 4
EELAYER 30 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 4 9
Title "LUNA: Configuration / Dev / Debug Section"
Date "2021-03-10"
Rev "r0"
Comp "Copyright 2019-2021 Great Scott Gadgets"
Comment1 "Katherine J. Temkin"
Comment2 ""
Comment3 "Licensed under the CERN-OHL-P v2"
Comment4 ""
$EndDescr
$Comp
L fpgas_and_processors:ECP5-BGA256 IC1
U 8 1 5DCABD39
P 10500 2250
F 0 "IC1" H 11350 2400 50  0000 R CNN
F 1 "ECP5-BGA256" H 11350 2300 50  0000 R CNN
F 2 "luna:lattice_cabga256" H 7300 5700 50  0001 L CNN
F 3 "" H 6850 6650 50  0001 L CNN
F 4 "FPGA - Field Programmable Gate Array ECP5; 12k LUTs; 1.1V" H 6850 6550 50  0001 L CNN "Description"
F 5 "Lattice" H 6900 7500 50  0001 L CNN "Manufacturer"
F 6 "LFE5U-12F-6BG256C" H 6900 7400 50  0001 L CNN "Part Number"
F 7 "LFE5U-12F-*BG256*" H 10500 2250 50  0001 C CNN "Substitution"
	8    10500 2250
	-1   0    0    -1  
$EndComp
Wire Wire Line
	10300 2050 10300 1950
$Comp
L power:+3V3 #PWR056
U 1 1 5DCDEED8
P 10300 1950
F 0 "#PWR056" H 10300 1800 50  0001 C CNN
F 1 "+3V3" H 10315 2123 50  0000 C CNN
F 2 "" H 10300 1950 50  0001 C CNN
F 3 "" H 10300 1950 50  0001 C CNN
	1    10300 1950
	1    0    0    -1  
$EndComp
$Comp
L Device:C C32
U 1 1 5DCEC8F9
P 1850 1300
F 0 "C32" H 1900 1400 50  0000 L CNN
F 1 "0.1uF" H 1900 1200 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1888 1150 50  0001 C CNN
F 3 "~" H 1850 1300 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1850 1300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1850 1300 50  0001 C CNN "Substitution"
	1    1850 1300
	1    0    0    -1  
$EndComp
Connection ~ 1850 1100
Wire Wire Line
	1850 1150 1850 1100
$Comp
L Device:C C33
U 1 1 5DCEDCE6
P 2150 1300
F 0 "C33" H 2200 1400 50  0000 L CNN
F 1 "0.1uF" H 2200 1200 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2188 1150 50  0001 C CNN
F 3 "~" H 2150 1300 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2150 1300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2150 1300 50  0001 C CNN "Substitution"
	1    2150 1300
	1    0    0    -1  
$EndComp
$Comp
L Device:C C34
U 1 1 5DCEE41C
P 2450 1300
F 0 "C34" H 2500 1400 50  0000 L CNN
F 1 "0.1uF" H 2500 1200 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 2488 1150 50  0001 C CNN
F 3 "~" H 2450 1300 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 2450 1300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2450 1300 50  0001 C CNN "Substitution"
	1    2450 1300
	1    0    0    -1  
$EndComp
$Comp
L Device:C C31
U 1 1 5DCEE96F
P 1550 1300
F 0 "C31" H 1600 1400 50  0000 L CNN
F 1 "0.1uF" H 1600 1200 50  0000 L CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 1588 1150 50  0001 C CNN
F 3 "~" H 1550 1300 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 1550 1300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 1550 1300 50  0001 C CNN "Substitution"
	1    1550 1300
	1    0    0    -1  
$EndComp
Wire Wire Line
	1550 1450 1850 1450
Connection ~ 1850 1450
Connection ~ 2150 1450
Wire Wire Line
	2150 1450 2450 1450
Wire Wire Line
	2800 1450 2800 1550
$Comp
L power:GND #PWR041
U 1 1 5DCEFFC7
P 2800 1550
F 0 "#PWR041" H 2800 1300 50  0001 C CNN
F 1 "GND" H 2805 1377 50  0000 C CNN
F 2 "" H 2800 1550 50  0001 C CNN
F 3 "" H 2800 1550 50  0001 C CNN
	1    2800 1550
	1    0    0    -1  
$EndComp
Wire Wire Line
	2150 1150 2150 1100
Connection ~ 2150 1100
Wire Wire Line
	2150 1100 1850 1100
Wire Wire Line
	2450 1150 2450 1100
Connection ~ 2450 1100
Wire Wire Line
	2450 1100 2150 1100
Wire Wire Line
	1550 1150 1550 1100
Wire Wire Line
	1550 1100 1850 1100
Text Notes 3050 4700 0    138  ~ 0
Development / Debug uC
Text Label 2600 2550 0    50   ~ 0
~UC_RESET
$Comp
L power:+3V3 #PWR051
U 1 1 5DD1D655
P 8300 900
F 0 "#PWR051" H 8300 750 50  0001 C CNN
F 1 "+3V3" H 8315 1073 50  0000 C CNN
F 2 "" H 8300 900 50  0001 C CNN
F 3 "" H 8300 900 50  0001 C CNN
	1    8300 900 
	1    0    0    -1  
$EndComp
$Comp
L power:GND #PWR052
U 1 1 5DD1E101
P 8300 2000
F 0 "#PWR052" H 8300 1750 50  0001 C CNN
F 1 "GND" H 8305 1827 50  0000 C CNN
F 2 "" H 8300 2000 50  0001 C CNN
F 3 "" H 8300 2000 50  0001 C CNN
	1    8300 2000
	1    0    0    -1  
$EndComp
$Comp
L Device:C C35
U 1 1 5DD1E9FF
P 7650 1000
F 0 "C35" V 7750 850 50  0000 C CNN
F 1 "0.1uF" V 7700 1250 50  0000 C CNN
F 2 "Capacitor_SMD:C_0402_1005Metric" H 7688 850 50  0001 C CNN
F 3 "~" H 7650 1000 50  0001 C CNN
F 4 "GENERIC-CAP-0402-0.1uF" H 7650 1000 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 7650 1000 50  0001 C CNN "Substitution"
	1    7650 1000
	0    1    1    0   
$EndComp
Wire Wire Line
	7800 1000 8300 1000
Wire Wire Line
	8300 1100 8300 1000
Connection ~ 8300 1000
$Comp
L power:GND #PWR050
U 1 1 5DD21DA8
P 7500 1000
F 0 "#PWR050" H 7500 750 50  0001 C CNN
F 1 "GND" V 7505 872 50  0000 R CNN
F 2 "" H 7500 1000 50  0001 C CNN
F 3 "" H 7500 1000 50  0001 C CNN
	1    7500 1000
	0    1    1    0   
$EndComp
$Comp
L Device:R R12
U 1 1 5DD22BB5
P 8750 4950
F 0 "R12" V 8700 4750 50  0000 C CNN
F 1 "10K" V 8750 4950 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8680 4950 50  0001 C CNN
F 3 "~" H 8750 4950 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 8750 4950 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 8750 4950 50  0001 C CNN "Substitution"
	1    8750 4950
	0    1    1    0   
$EndComp
$Comp
L Device:R R13
U 1 1 5DD23434
P 8750 5050
F 0 "R13" V 8700 4850 50  0000 C CNN
F 1 "10K" V 8750 5050 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8680 5050 50  0001 C CNN
F 3 "~" H 8750 5050 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 8750 5050 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 8750 5050 50  0001 C CNN "Substitution"
	1    8750 5050
	0    1    1    0   
$EndComp
$Comp
L Device:R R14
U 1 1 5DD23797
P 8750 5150
F 0 "R14" V 8700 4950 50  0000 C CNN
F 1 "10K" V 8750 5150 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 8680 5150 50  0001 C CNN
F 3 "~" H 8750 5150 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 8750 5150 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 8750 5150 50  0001 C CNN "Substitution"
	1    8750 5150
	0    1    1    0   
$EndComp
$Comp
L power:+3V3 #PWR055
U 1 1 5DD27B73
P 8450 5050
F 0 "#PWR055" H 8450 4900 50  0001 C CNN
F 1 "+3V3" V 8465 5178 50  0000 L CNN
F 2 "" H 8450 5050 50  0001 C CNN
F 3 "" H 8450 5050 50  0001 C CNN
	1    8450 5050
	0    -1   -1   0   
$EndComp
Wire Wire Line
	8450 5050 8600 5050
Wire Wire Line
	8900 4950 9450 4950
Wire Wire Line
	8900 5050 9450 5050
Wire Wire Line
	8900 5150 9450 5150
$Comp
L power:GND #PWR053
U 1 1 5DD2CC69
P 8400 4950
F 0 "#PWR053" H 8400 4700 50  0001 C CNN
F 1 "GND" V 8405 4822 50  0000 R CNN
F 2 "" H 8400 4950 50  0001 C CNN
F 3 "" H 8400 4950 50  0001 C CNN
	1    8400 4950
	0    1    1    0   
$EndComp
Wire Wire Line
	8400 4950 8600 4950
$Comp
L power:GND #PWR054
U 1 1 5DD2DED3
P 8400 5150
F 0 "#PWR054" H 8400 4900 50  0001 C CNN
F 1 "GND" V 8405 5022 50  0000 R CNN
F 2 "" H 8400 5150 50  0001 C CNN
F 3 "" H 8400 5150 50  0001 C CNN
	1    8400 5150
	0    1    1    0   
$EndComp
Wire Wire Line
	8400 5150 8600 5150
Text Notes 7200 5150 0    44   ~ 0
By default, select MSPI \nmode, so the ECP5 will \nself-configure from flash.
Wire Wire Line
	9450 4750 7600 4750
Wire Wire Line
	7600 4750 7600 1600
Wire Wire Line
	7600 1600 7800 1600
Wire Wire Line
	8800 1300 9200 1300
Wire Wire Line
	9200 1300 9200 3400
Wire Wire Line
	9100 3300 9100 1400
Wire Wire Line
	9100 1400 8800 1400
Wire Wire Line
	8800 1600 9000 1600
Wire Wire Line
	9000 1600 9000 3200
Wire Wire Line
	9450 3100 8900 3100
Wire Wire Line
	8900 3100 8900 1700
Wire Wire Line
	8900 1700 8800 1700
Wire Wire Line
	9450 3700 7700 3700
Wire Wire Line
	7700 3700 7700 1400
Wire Wire Line
	7700 1400 7800 1400
Text Label 9200 3700 0    44   ~ 0
~CS_DI
Text Label 9250 3400 0    44   ~ 0
D0
Text Label 9250 3300 0    44   ~ 0
D1
Text Label 9250 3200 0    44   ~ 0
D2
Text Label 9250 3100 0    44   ~ 0
D3
Text Label 9050 4750 2    50   ~ 0
FPGA_CONFIG_CLK
Text Label 9050 4200 2    50   ~ 0
TMS
Text Label 9050 4300 2    50   ~ 0
FPGA_TCK
Text Label 9050 4400 2    50   ~ 0
FPGA_TDI
Text Label 9050 4500 2    50   ~ 0
FPGA_TDO
Text Label 9000 4950 0    50   ~ 0
FPGA_CFG0
Text Label 9000 5050 0    50   ~ 0
FPGA_CFG1
Text Label 9000 5150 0    50   ~ 0
FPGA_CFG2
Text Label 8900 5400 0    50   ~ 0
FPGA_DONE
Text Label 8900 5500 0    50   ~ 0
~FPGA_INIT
Text Label 8900 5600 0    50   ~ 0
~FPGA_PROGRAM
Text Label 5650 3150 0    50   ~ 0
FPGA_TDI
Text Label 5650 3250 0    50   ~ 0
FPGA_TCK
Text Label 5650 2950 0    50   ~ 0
FPGA_TDO
Text Label 5650 3050 0    50   ~ 0
FPGA_TMS
Text Label 9050 4200 2    50   ~ 0
FPGA_TMS
Wire Wire Line
	6500 4300 9450 4300
Wire Wire Line
	1800 6450 2000 6450
$Comp
L Connector:Conn_ARM_JTAG_SWD_10 J6
U 1 1 5DB28143
P 2500 6750
F 0 "J6" H 2250 7450 50  0000 R CNN
F 1 "Conn_ARM_JTAG_SWD_10" H 2250 7350 50  0000 R CNN
F 2 "luna:SWD_CONNECTOR_LARGE_BOX" H 2500 6750 50  0001 C CNN
F 3 "http://infocenter.arm.com/help/topic/com.arm.doc.ddi0314h/DDI0314H_coresight_components_trm.pdf" V 2150 5500 50  0001 C CNN
F 4 "CONN HEADER VERT 10POS 1.27MM" H 2500 6750 50  0001 C CNN "Description"
F 5 "Samtec" H 2500 6750 50  0001 C CNN "Manufacturer"
F 6 "FTSH-105-01-F-D-K" H 2500 6750 50  0001 C CNN "Part Number"
	1    2500 6750
	-1   0    0    -1  
$EndComp
NoConn ~ 2000 6850
NoConn ~ 2000 6950
$Comp
L power:GND #PWR049
U 1 1 5DB45414
P 2600 7500
F 0 "#PWR049" H 2600 7250 50  0001 C CNN
F 1 "GND" H 2604 7328 50  0000 C CNN
F 2 "" H 2600 7500 50  0001 C CNN
F 3 "" H 2600 7500 50  0001 C CNN
	1    2600 7500
	1    0    0    -1  
$EndComp
Wire Wire Line
	2600 7400 2600 7500
Wire Wire Line
	2500 7350 2500 7400
Wire Wire Line
	2600 7350 2600 7400
$Comp
L power:+3V3 #PWR048
U 1 1 5DB4C59C
P 2500 6050
F 0 "#PWR048" H 2500 5900 50  0001 C CNN
F 1 "+3V3" H 2514 6223 50  0000 C CNN
F 2 "" H 2500 6050 50  0001 C CNN
F 3 "" H 2500 6050 50  0001 C CNN
	1    2500 6050
	1    0    0    -1  
$EndComp
Wire Wire Line
	2500 6050 2500 6150
Text Label 2600 2750 0    50   ~ 0
UC_SWDCLK
Wire Wire Line
	1400 6650 2000 6650
Wire Wire Line
	1300 6750 2000 6750
Text Label 2600 2850 0    50   ~ 0
UC_SWDIO
Wire Wire Line
	6500 4300 6500 3250
Wire Wire Line
	6700 3150 6700 4400
Wire Wire Line
	6700 4400 9450 4400
Wire Wire Line
	6600 2950 6600 4500
Wire Wire Line
	6600 4500 9450 4500
Wire Wire Line
	6400 3050 6400 4200
NoConn ~ 9450 2900
NoConn ~ 9450 3000
NoConn ~ 9450 3500
NoConn ~ 9450 3600
NoConn ~ 9450 3800
NoConn ~ 9450 3900
Wire Wire Line
	4850 6600 4100 6600
Wire Wire Line
	4850 6700 4300 6700
Wire Wire Line
	4850 6800 4500 6800
Wire Wire Line
	4850 6900 4700 6900
Text Label 3550 6600 0    50   ~ 0
FPGA_TCK
Text Label 3550 6700 0    50   ~ 0
FPGA_TMS
Text Label 3550 6800 0    50   ~ 0
FPGA_TDO
Text Label 3550 6900 0    50   ~ 0
FPGA_TDI
NoConn ~ 4850 6400
Wire Wire Line
	6400 4200 9450 4200
$Comp
L Device:R R25
U 1 1 5E28BD64
P 2500 2300
F 0 "R25" H 2570 2345 50  0000 L CNN
F 1 "10K" V 2500 2250 50  0000 L CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 2430 2300 50  0001 C CNN
F 3 "~" H 2500 2300 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 2500 2300 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 2500 2300 50  0001 C CNN "Substitution"
	1    2500 2300
	1    0    0    -1  
$EndComp
$Comp
L power:+3V3 #PWR0103
U 1 1 5E29AB77
P 2500 2150
F 0 "#PWR0103" H 2500 2000 50  0001 C CNN
F 1 "+3V3" H 2514 2323 50  0000 C CNN
F 2 "" H 2500 2150 50  0001 C CNN
F 3 "" H 2500 2150 50  0001 C CNN
	1    2500 2150
	1    0    0    -1  
$EndComp
Text HLabel 1300 2450 1    50   Input ~ 0
~UC_RESET
Text HLabel 6800 3150 2    50   Output ~ 0
UC_TX_FPGA_RX
Text HLabel 6800 3050 2    50   Input ~ 0
UC_RX_FPGA_TX
NoConn ~ 9450 2700
NoConn ~ 9450 2800
Text Label 1500 6750 0    50   ~ 0
UC_SWDIO
Text Label 1500 6650 0    50   ~ 0
UC_SWDCLK
Wire Wire Line
	6400 3050 6800 3050
Connection ~ 6400 3050
Wire Wire Line
	6700 3150 6800 3150
Connection ~ 6700 3150
Text Notes 6650 2850 0    50   ~ 0
JTAG pins may be\nused for UART when\nJTAG is not in use
Wire Wire Line
	6700 3150 4150 3150
Wire Wire Line
	4250 4150 4450 4150
Wire Wire Line
	4150 3850 5750 3850
Wire Wire Line
	5750 3750 4150 3750
Text HLabel 5750 3750 2    50   BiDi ~ 0
SIDEBAND_D-
Text HLabel 5750 3850 2    50   BiDi ~ 0
SIDEBAND_D+
Connection ~ 5650 3650
Wire Wire Line
	5650 3950 5650 3650
Wire Wire Line
	5650 3650 5650 3550
Wire Wire Line
	3050 3150 3150 3150
Wire Wire Line
	3050 3050 3150 3050
Wire Wire Line
	4150 2850 4250 2850
Wire Wire Line
	5700 2650 4150 2650
Wire Wire Line
	4250 2550 4150 2550
Wire Wire Line
	4150 2450 4250 2450
Wire Wire Line
	4150 2350 4250 2350
Wire Wire Line
	3650 2050 3650 2150
$Comp
L power:+3V3 #PWR0112
U 1 1 5FAF747F
P 3650 2050
F 0 "#PWR0112" H 3650 1900 50  0001 C CNN
F 1 "+3V3" H 3665 2223 50  0000 C CNN
F 2 "" H 3650 2050 50  0001 C CNN
F 3 "" H 3650 2050 50  0001 C CNN
	1    3650 2050
	1    0    0    -1  
$EndComp
Wire Wire Line
	3650 4150 3650 4250
$Comp
L MCU_Microchip_SAMD:ATSAMD11D14A-M U6
U 1 1 5FAD0234
P 3650 3150
F 0 "U6" H 3850 4250 50  0000 L CNN
F 1 "ATSAMD11D14A-MUT" H 3850 4150 50  0000 L CNN
F 2 "Package_DFN_QFN:QFN-24-1EP_4x4mm_P0.5mm_EP2.6x2.6mm" H 3650 1800 50  0001 C CNN
F 3 "http://ww1.microchip.com/downloads/en/DeviceDoc/Atmel-42363-SAM-D11_Datasheet.pdf" H 3650 2150 50  0001 C CNN
F 4 "IC MCU 32BIT 16KB FLASH 24QFN" H 3650 3150 50  0001 C CNN "Description"
F 5 "Microchip" H 3650 3150 50  0001 C CNN "Manufacturer"
F 6 "ATSAMD11D14A-MUT" H 3650 3150 50  0001 C CNN "Part Number"
	1    3650 3150
	1    0    0    -1  
$EndComp
Text Label 3050 3050 2    50   ~ 0
~FPGA_PROGRAM
Wire Wire Line
	4150 3350 4250 3350
Wire Wire Line
	4150 3450 4450 3450
Wire Wire Line
	4150 3550 4450 3550
Wire Wire Line
	4150 3650 4450 3650
$Comp
L Device:LED D10
U 1 1 5DB78DC3
P 5350 3350
F 0 "D10" H 5500 3400 50  0000 C CNN
F 1 "ICE BLUE" H 4950 3400 50  0000 C CNN
F 2 "LED_SMD:LED_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5350 3350 50  0001 C CNN
F 3 "~" H 5350 3350 50  0001 C CNN
F 4 "MHT192WDT-ICE" H 5350 3350 50  0001 C CNN "Part Number"
F 5 "MEIHUA" H 5350 3350 50  0001 C CNN "Manufacturer"
F 6 "LED SMD 0603 ICE BLUE" H 5350 3350 50  0001 C CNN "Description"
	1    5350 3350
	1    0    0    1   
$EndComp
Text HLabel 3050 3150 0    50   BiDi ~ 0
~SIDEBAND_RESET
Text Notes 1950 4000 0    50   ~ 0
pull this signal high from the\nFPGA to tristate the uC’s \nUSB connections and activate\nthe sideband PHY\n\nor pull this signal low from\nthe UC to prevent the FPGA\nfrom driving the USB (used in\nrecovery modes)
Text HLabel 4450 4150 2    50   Input ~ 0
~FORCE_DFU
Text HLabel 4250 2750 2    50   Input ~ 0
TARGET_PHY_1V8
Text HLabel 4250 2450 2    50   Input ~ 0
HOST_PHY_1V8
Text HLabel 4250 2350 2    50   Input ~ 0
SIDEBAND_PHY_1V8
$Comp
L power:+2V5 #PWR046
U 1 1 5DC1FF9A
P 4250 2850
F 0 "#PWR046" H 4250 2700 50  0001 C CNN
F 1 "+2V5" V 4250 3000 50  0000 L CNN
F 2 "" H 4250 2850 50  0001 C CNN
F 3 "" H 4250 2850 50  0001 C CNN
	1    4250 2850
	0    1    1    0   
$EndComp
Wire Wire Line
	4750 3950 5200 3950
Wire Wire Line
	4750 3650 5200 3650
Wire Wire Line
	5200 3550 4750 3550
Wire Wire Line
	5200 3450 4750 3450
Wire Wire Line
	4750 3350 5200 3350
Wire Wire Line
	5750 3550 5650 3550
$Comp
L power:+3V3 #PWR047
U 1 1 5DB8CD6C
P 5750 3550
F 0 "#PWR047" H 5750 3400 50  0001 C CNN
F 1 "+3V3" V 5764 3678 50  0000 L CNN
F 2 "" H 5750 3550 50  0001 C CNN
F 3 "" H 5750 3550 50  0001 C CNN
	1    5750 3550
	0    1    1    0   
$EndComp
Wire Wire Line
	5500 3950 5650 3950
Wire Wire Line
	5500 3650 5650 3650
Connection ~ 5650 3550
Wire Wire Line
	5650 3550 5500 3550
Wire Wire Line
	5650 3450 5650 3350
Connection ~ 5650 3450
Wire Wire Line
	5500 3450 5650 3450
Wire Wire Line
	5650 3350 5500 3350
Wire Wire Line
	5650 3550 5650 3450
$Comp
L Device:LED D14
U 1 1 5DB7B4CC
P 5350 3950
F 0 "D14" H 5500 4000 50  0000 C CNN
F 1 "ICE BLUE" H 4950 4000 50  0000 C CNN
F 2 "LED_SMD:LED_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5350 3950 50  0001 C CNN
F 3 "~" H 5350 3950 50  0001 C CNN
F 4 "MHT192WDT-ICE" H 5350 3950 50  0001 C CNN "Part Number"
F 5 "MEIHUA" H 5350 3950 50  0001 C CNN "Manufacturer"
F 6 "LED SMD 0603 ICE BLUE" H 5350 3950 50  0001 C CNN "Description"
	1    5350 3950
	1    0    0    1   
$EndComp
$Comp
L Device:LED D13
U 1 1 5DB7B14B
P 5350 3650
F 0 "D13" H 5500 3700 50  0000 C CNN
F 1 "PINK" H 4950 3700 50  0000 C CNN
F 2 "LED_SMD:LED_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5350 3650 50  0001 C CNN
F 3 "~" H 5350 3650 50  0001 C CNN
F 4 "OSK40603C1E" H 5350 3650 50  0001 C CNN "Part Number"
F 5 "OptoSupply" H 5350 3650 50  0001 C CNN "Manufacturer"
F 6 "LED SMD 0603 PINK" H 5350 3650 50  0001 C CNN "Description"
	1    5350 3650
	1    0    0    1   
$EndComp
$Comp
L Device:LED D12
U 1 1 5DB7AE70
P 5350 3550
F 0 "D12" H 5500 3600 50  0000 C CNN
F 1 "WHITE" H 4950 3600 50  0000 C CNN
F 2 "LED_SMD:LED_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5350 3550 50  0001 C CNN
F 3 "~" H 5350 3550 50  0001 C CNN
F 4 "ORH-W46G" H 5350 3550 50  0001 C CNN "Part Number"
F 5 "Orient" H 5350 3550 50  0001 C CNN "Manufacturer"
F 6 "LED SMD 0603 WHITE" H 5350 3550 50  0001 C CNN "Description"
	1    5350 3550
	1    0    0    1   
$EndComp
$Comp
L Device:LED D11
U 1 1 5DB7AB4E
P 5350 3450
F 0 "D11" H 5500 3500 50  0000 C CNN
F 1 "PINK" H 4950 3500 50  0000 C CNN
F 2 "LED_SMD:LED_0603_1608Metric_Pad1.05x0.95mm_HandSolder" H 5350 3450 50  0001 C CNN
F 3 "~" H 5350 3450 50  0001 C CNN
F 4 "OSK40603C1E" H 5350 3450 50  0001 C CNN "Part Number"
F 5 "OptoSupply" H 5350 3450 50  0001 C CNN "Manufacturer"
F 6 "LED SMD 0603 PINK" H 5350 3450 50  0001 C CNN "Description"
	1    5350 3450
	1    0    0    1   
$EndComp
Wire Wire Line
	4150 2950 6600 2950
Wire Wire Line
	4150 3250 6500 3250
Wire Wire Line
	4150 3050 6400 3050
$Comp
L power:GND #PWR044
U 1 1 5DD0C578
P 3650 4250
F 0 "#PWR044" H 3650 4000 50  0001 C CNN
F 1 "GND" H 3655 4077 50  0000 C CNN
F 2 "" H 3650 4250 50  0001 C CNN
F 3 "" H 3650 4250 50  0001 C CNN
	1    3650 4250
	1    0    0    -1  
$EndComp
Wire Wire Line
	1400 2750 3150 2750
Wire Wire Line
	1300 2850 3150 2850
Wire Wire Line
	1800 2550 2500 2550
Wire Wire Line
	2500 2450 2500 2550
Connection ~ 2500 2550
Wire Wire Line
	2500 2550 3150 2550
Wire Wire Line
	1200 2550 1300 2550
Connection ~ 1800 2550
$Comp
L Connector:TestPoint TP?
U 1 1 6001FEDC
P 6900 1300
AR Path="/6001FEDC" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/6001FEDC" Ref="TP11"  Part="1" 
F 0 "TP11" H 6958 1418 50  0000 L CNN
F 1 "TestPoint" H 6958 1328 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 7100 1300 50  0001 C CNN
F 3 "~" H 7100 1300 50  0001 C CNN
F 4 "DNP" H 6900 1300 50  0001 C CNN "Note"
	1    6900 1300
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 60027FAC
P 6400 1300
AR Path="/60027FAC" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/60027FAC" Ref="TP10"  Part="1" 
F 0 "TP10" H 6458 1418 50  0000 L CNN
F 1 "TestPoint" H 6458 1328 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 6600 1300 50  0001 C CNN
F 3 "~" H 6600 1300 50  0001 C CNN
F 4 "DNP" H 6400 1300 50  0001 C CNN "Note"
	1    6400 1300
	1    0    0    -1  
$EndComp
Wire Wire Line
	7700 1400 6900 1400
Wire Wire Line
	6900 1400 6900 1300
Connection ~ 7700 1400
Wire Wire Line
	6400 1300 6400 1600
Wire Wire Line
	6400 1600 7600 1600
Connection ~ 7600 1600
Text Notes 5100 2450 0    50   ~ 0
rail monitors\nfor test
Wire Wire Line
	2450 1100 2800 1100
$Comp
L power:+3V3 #PWR045
U 1 1 5DD07968
P 2800 1000
F 0 "#PWR045" H 2800 850 50  0001 C CNN
F 1 "+3V3" H 2815 1173 50  0000 C CNN
F 2 "" H 2800 1000 50  0001 C CNN
F 3 "" H 2800 1000 50  0001 C CNN
	1    2800 1000
	1    0    0    -1  
$EndComp
Wire Wire Line
	2800 1100 2800 1000
Wire Wire Line
	9450 5400 7750 5400
Wire Wire Line
	9450 5500 8250 5500
Wire Wire Line
	9450 5600 8750 5600
Wire Wire Line
	8750 5600 8750 5700
$Comp
L Connector:TestPoint TP?
U 1 1 6003B95B
P 8750 5700
AR Path="/6003B95B" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/6003B95B" Ref="TP14"  Part="1" 
F 0 "TP14" H 8808 5818 50  0000 L CNN
F 1 "TestPoint" H 8808 5728 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 8950 5700 50  0001 C CNN
F 3 "~" H 8950 5700 50  0001 C CNN
F 4 "DNP" H 8750 5700 50  0001 C CNN "Note"
	1    8750 5700
	-1   0    0    1   
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 6007F34F
P 8250 5700
AR Path="/6007F34F" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/6007F34F" Ref="TP13"  Part="1" 
F 0 "TP13" H 8308 5818 50  0000 L CNN
F 1 "TestPoint" H 8308 5728 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 8450 5700 50  0001 C CNN
F 3 "~" H 8450 5700 50  0001 C CNN
F 4 "DNP" H 8250 5700 50  0001 C CNN "Note"
	1    8250 5700
	-1   0    0    1   
$EndComp
Wire Wire Line
	8250 5500 8250 5700
$Comp
L Connector:TestPoint TP?
U 1 1 60089159
P 7750 5700
AR Path="/60089159" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/60089159" Ref="TP12"  Part="1" 
F 0 "TP12" H 7808 5818 50  0000 L CNN
F 1 "TestPoint" H 7808 5728 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 7950 5700 50  0001 C CNN
F 3 "~" H 7950 5700 50  0001 C CNN
F 4 "DNP" H 7750 5700 50  0001 C CNN "Note"
	1    7750 5700
	-1   0    0    1   
$EndComp
Wire Wire Line
	7750 5400 7750 5700
$Comp
L power:+3V3 #PWR02
U 1 1 5FC94008
P 6950 5100
F 0 "#PWR02" H 6950 4950 50  0001 C CNN
F 1 "+3V3" H 6964 5273 50  0000 C CNN
F 2 "" H 6950 5100 50  0001 C CNN
F 3 "" H 6950 5100 50  0001 C CNN
	1    6950 5100
	1    0    0    -1  
$EndComp
Wire Wire Line
	8750 5600 6950 5600
Wire Wire Line
	6950 5600 6950 5500
Connection ~ 8750 5600
Wire Wire Line
	6950 5100 6950 5200
Wire Wire Line
	6450 5600 6550 5600
Wire Wire Line
	6850 5600 6950 5600
Connection ~ 6950 5600
$Comp
L Device:R R?
U 1 1 5FD294F6
P 6950 5350
AR Path="/5FD294F6" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/5FD294F6" Ref="R6"  Part="1" 
F 0 "R6" V 7050 5350 50  0000 C CNN
F 1 "10K" V 6950 5350 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 6880 5350 50  0001 C CNN
F 3 "~" H 6950 5350 50  0001 C CNN
F 4 "GENERIC-RES-0402-10K" H 6950 5350 50  0001 C CNN "Part Number"
F 5 "DNP" V 6850 5350 50  0000 C CNN "Note"
F 6 "any equivalent" H 6950 5350 50  0001 C CNN "Substitution"
	1    6950 5350
	1    0    0    -1  
$EndComp
$Comp
L Device:R R?
U 1 1 5FD39CA8
P 6700 5600
AR Path="/5FD39CA8" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/5FD39CA8" Ref="R5"  Part="1" 
F 0 "R5" V 6800 5600 50  0000 C CNN
F 1 "2.2K" V 6700 5600 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 6630 5600 50  0001 C CNN
F 3 "~" H 6700 5600 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 6700 5600 50  0001 C CNN "Part Number"
F 5 "DNP" V 6600 5600 50  0000 C CNN "Note"
F 6 "any equivalent" H 6700 5600 50  0001 C CNN "Substitution"
	1    6700 5600
	0    1    1    0   
$EndComp
Text Notes 5900 5450 0    44   ~ 0
Populate R5 and R6 to\nallow FPGA to trigger its\nown programming\n(not required unless U6\nis unpopulated).
Text HLabel 6450 5600 0    50   Input ~ 0
~FPGA_SELF_PROGRAM
$Comp
L power:+1V1 #PWR040
U 1 1 5DC0CC5E
P 4250 2550
F 0 "#PWR040" H 4250 2400 50  0001 C CNN
F 1 "+1V1" V 4265 2678 50  0000 L CNN
F 2 "" H 4250 2550 50  0001 C CNN
F 3 "" H 4250 2550 50  0001 C CNN
	1    4250 2550
	0    1    1    0   
$EndComp
$Comp
L power:+3V3 #PWR0124
U 1 1 5FF9BDE5
P 5350 6000
F 0 "#PWR0124" H 5350 5850 50  0001 C CNN
F 1 "+3V3" H 5364 6173 50  0000 C CNN
F 2 "" H 5350 6000 50  0001 C CNN
F 3 "" H 5350 6000 50  0001 C CNN
	1    5350 6000
	1    0    0    -1  
$EndComp
Wire Wire Line
	5350 6000 5350 6100
Wire Wire Line
	5450 7400 5450 7300
Wire Wire Line
	5350 7300 5350 7400
$Comp
L Connector:Conn_ARM_JTAG_SWD_10 J5
U 1 1 5DC7E70D
P 5350 6700
F 0 "J5" H 5050 7400 50  0000 R CNN
F 1 "Conn_FPGA_JTAG_10" H 5050 7300 50  0000 R CNN
F 2 "luna:SWD_CONNECTOR_LARGE_BOX" H 5350 6700 50  0001 C CNN
F 3 "http://infocenter.arm.com/help/topic/com.arm.doc.ddi0314h/DDI0314H_coresight_components_trm.pdf" V 5000 5450 50  0001 C CNN
F 4 "CONN HEADER VERT 10POS 1.27MM" H 5350 6700 50  0001 C CNN "Description"
F 5 "Samtec" H 5350 6700 50  0001 C CNN "Manufacturer"
F 6 "FTSH-105-01-F-D-K" H 5350 6700 50  0001 C CNN "Part Number"
	1    5350 6700
	-1   0    0    -1  
$EndComp
$Comp
L power:GND #PWR0131
U 1 1 60198439
P 2550 5450
F 0 "#PWR0131" H 2550 5200 50  0001 C CNN
F 1 "GND" H 2554 5278 50  0000 C CNN
F 2 "" H 2550 5450 50  0001 C CNN
F 3 "" H 2550 5450 50  0001 C CNN
	1    2550 5450
	1    0    0    -1  
$EndComp
Wire Wire Line
	2450 4550 1400 4550
Wire Wire Line
	2450 4750 2450 4550
Wire Wire Line
	2450 5350 1800 5350
Wire Wire Line
	2450 5250 2450 5350
Wire Wire Line
	2350 4650 1300 4650
Wire Wire Line
	2350 4750 2350 4650
$Comp
L power:+3V3 #PWR0133
U 1 1 60164576
P 2350 5450
F 0 "#PWR0133" H 2350 5300 50  0001 C CNN
F 1 "+3V3" H 2364 5623 50  0000 C CNN
F 2 "" H 2350 5450 50  0001 C CNN
F 3 "" H 2350 5450 50  0001 C CNN
	1    2350 5450
	-1   0    0    1   
$EndComp
$Comp
L Connector_Generic:Conn_02x03_Odd_Even J10
U 1 1 60114D15
P 2450 5050
F 0 "J10" V 2546 4862 50  0000 R CNN
F 1 "TC_SWD" V 2455 4862 50  0000 R CNN
F 2 "Connector:Tag-Connect_TC2030-IDC-FP_2x03_P1.27mm_Vertical" H 2450 5050 50  0001 C CNN
F 3 "~" H 2450 5050 50  0001 C CNN
F 4 "Tag-Connect" H 2450 5050 50  0001 C CNN "Manufacturer"
F 5 "DNP" H 2450 5050 50  0001 C CNN "Note"
F 6 "TC2030-IDC" H 2450 5050 50  0001 C CNN "Part Number"
F 7 "TC2030-CTX" H 2450 5050 50  0001 C CNN "Substitution"
	1    2450 5050
	0    -1   -1   0   
$EndComp
Wire Wire Line
	1400 2750 1400 4550
Wire Wire Line
	1300 2850 1300 2950
Wire Wire Line
	1800 2550 1800 5350
Connection ~ 1300 4650
Wire Wire Line
	1300 4650 1300 6750
Connection ~ 1400 4550
Wire Wire Line
	1400 4550 1400 6650
Connection ~ 1800 5350
Wire Wire Line
	1800 5350 1800 6450
Wire Wire Line
	2350 5250 2350 5450
Wire Wire Line
	2550 5250 2550 5450
Text HLabel 5800 1450 0    50   Input ~ 0
TARGET_VBUS_C
$Comp
L Device:R R?
U 1 1 5FE432BE
P 5900 2200
AR Path="/5DCD9772/5FE432BE" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/5FE432BE" Ref="R43"  Part="1" 
F 0 "R43" H 5650 2100 50  0000 C CNN
F 1 "8.06k±1%" H 5650 2200 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 5830 2200 50  0001 C CNN
F 3 "~" H 5900 2200 50  0001 C CNN
F 4 "RES SMD 8.06K OHM 1% 1/10W 0402" H 5900 2200 50  0001 C CNN "Description"
F 5 "Panasonic" H 5900 2200 50  0001 C CNN "Manufacturer"
F 6 "ERJ-2RKF8061X" H 5900 2200 50  0001 C CNN "Part Number"
F 7 "any equivalent" H 5900 2200 50  0001 C CNN "Substitution"
	1    5900 2200
	-1   0    0    1   
$EndComp
$Comp
L Device:R R?
U 1 1 5FE510BF
P 5900 1700
AR Path="/5DCD9772/5FE510BF" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/5FE510BF" Ref="R4"  Part="1" 
F 0 "R4" H 5650 1600 50  0000 C CNN
F 1 "8.06k±1%" H 5650 1700 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 5830 1700 50  0001 C CNN
F 3 "~" H 5900 1700 50  0001 C CNN
F 4 "RES SMD 8.06K OHM 1% 1/10W 0402" H 5900 1700 50  0001 C CNN "Description"
F 5 "Panasonic" H 5900 1700 50  0001 C CNN "Manufacturer"
F 6 "ERJ-2RKF8061X" H 5900 1700 50  0001 C CNN "Part Number"
F 7 "any equivalent" H 5900 1700 50  0001 C CNN "Substitution"
	1    5900 1700
	-1   0    0    1   
$EndComp
Wire Wire Line
	5700 1950 5700 2650
Wire Wire Line
	5700 1950 5900 1950
Wire Wire Line
	5900 1950 5900 2050
Wire Wire Line
	5900 1950 5900 1850
Connection ~ 5900 1950
$Comp
L power:GND #PWR016
U 1 1 5FE88B44
P 5900 2450
F 0 "#PWR016" H 5900 2200 50  0001 C CNN
F 1 "GND" H 5905 2277 50  0000 C CNN
F 2 "" H 5900 2450 50  0001 C CNN
F 3 "" H 5900 2450 50  0001 C CNN
	1    5900 2450
	1    0    0    -1  
$EndComp
Wire Wire Line
	5900 2450 5900 2350
Wire Wire Line
	5800 1450 5900 1450
Wire Wire Line
	5900 1450 5900 1550
Wire Wire Line
	4150 2750 4250 2750
Text Label 4800 2650 0    50   ~ 0
HALF_TARGET_VBUS_C
Wire Wire Line
	4150 3950 4450 3950
Wire Wire Line
	4250 4150 4250 3350
Connection ~ 4250 3350
Wire Wire Line
	4250 3350 4450 3350
$Comp
L Connector:TestPoint TP?
U 1 1 619DDE5D
P 1200 2950
AR Path="/5DA7BAF4/619DDE5D" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/619DDE5D" Ref="TP20"  Part="1" 
F 0 "TP20" V 1155 3137 50  0000 L CNN
F 1 "TestPoint" V 1245 3137 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 1400 2950 50  0001 C CNN
F 3 "~" H 1400 2950 50  0001 C CNN
F 4 "DNP" H 1200 2950 50  0001 C CNN "Note"
	1    1200 2950
	0    -1   -1   0   
$EndComp
$Comp
L Memory_Flash:W25Q32JVSS U7
U 1 1 5DD128B2
P 8300 1500
F 0 "U7" H 8000 1100 50  0000 C CNN
F 1 "W25Q32JVSS" H 8600 1100 50  0000 C CNN
F 2 "Package_SO:SOIC-8_5.23x5.23mm_P1.27mm" H 8300 1500 50  0001 C CNN
F 3 "http://www.winbond.com/resource-files/w25q32jv%20revg%2003272018%20plus.pdf" H 8300 1500 50  0001 C CNN
F 4 "IC FLASH 32M SPI 133MHZ 8SOIC" H 8300 1500 50  0001 C CNN "Description"
F 5 "Winbond" H 8300 1500 50  0001 C CNN "Manufacturer"
F 6 "W25Q32JVSSIQ" H 8300 1500 50  0001 C CNN "Part Number"
	1    8300 1500
	1    0    0    -1  
$EndComp
Wire Wire Line
	9000 3200 9450 3200
Wire Wire Line
	9200 3400 9450 3400
Wire Wire Line
	9450 3300 9100 3300
$Comp
L Connector:TestPoint TP?
U 1 1 61B1944B
P 1200 2750
AR Path="/5DA7BAF4/61B1944B" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B1944B" Ref="TP19"  Part="1" 
F 0 "TP19" V 1155 2937 50  0000 L CNN
F 1 "TestPoint" V 1245 2937 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 1400 2750 50  0001 C CNN
F 3 "~" H 1400 2750 50  0001 C CNN
F 4 "DNP" H 1200 2750 50  0001 C CNN "Note"
	1    1200 2750
	0    -1   -1   0   
$EndComp
Wire Wire Line
	1200 2750 1400 2750
Connection ~ 1400 2750
Wire Wire Line
	1200 2950 1300 2950
Connection ~ 1300 2950
Wire Wire Line
	1300 2950 1300 4650
$Comp
L Connector:TestPoint TP?
U 1 1 61B320FB
P 1200 2550
AR Path="/5DA7BAF4/61B320FB" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B320FB" Ref="TP18"  Part="1" 
F 0 "TP18" V 1155 2737 50  0000 L CNN
F 1 "TestPoint" V 1245 2737 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 1400 2550 50  0001 C CNN
F 3 "~" H 1400 2550 50  0001 C CNN
F 4 "DNP" H 1200 2550 50  0001 C CNN "Note"
	1    1200 2550
	0    -1   -1   0   
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 61B6474F
P 4100 6500
AR Path="/5DA7BAF4/61B6474F" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B6474F" Ref="TP21"  Part="1" 
F 0 "TP21" V 4055 6687 50  0000 L CNN
F 1 "TestPoint" V 4145 6687 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 4300 6500 50  0001 C CNN
F 3 "~" H 4300 6500 50  0001 C CNN
F 4 "DNP" H 4100 6500 50  0001 C CNN "Note"
	1    4100 6500
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 61B669E5
P 4300 6500
AR Path="/5DA7BAF4/61B669E5" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B669E5" Ref="TP22"  Part="1" 
F 0 "TP22" V 4255 6687 50  0000 L CNN
F 1 "TestPoint" V 4345 6687 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 4500 6500 50  0001 C CNN
F 3 "~" H 4500 6500 50  0001 C CNN
F 4 "DNP" H 4300 6500 50  0001 C CNN "Note"
	1    4300 6500
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 61B66CEE
P 4500 6500
AR Path="/5DA7BAF4/61B66CEE" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B66CEE" Ref="TP23"  Part="1" 
F 0 "TP23" V 4455 6687 50  0000 L CNN
F 1 "TestPoint" V 4545 6687 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 4700 6500 50  0001 C CNN
F 3 "~" H 4700 6500 50  0001 C CNN
F 4 "DNP" H 4500 6500 50  0001 C CNN "Note"
	1    4500 6500
	1    0    0    -1  
$EndComp
$Comp
L Connector:TestPoint TP?
U 1 1 61B66FE5
P 4700 6500
AR Path="/5DA7BAF4/61B66FE5" Ref="TP?"  Part="1" 
AR Path="/5DCAA6D2/61B66FE5" Ref="TP24"  Part="1" 
F 0 "TP24" V 4655 6687 50  0000 L CNN
F 1 "TestPoint" V 4745 6687 50  0000 L CNN
F 2 "TestPoint:TestPoint_Pad_D1.0mm" H 4900 6500 50  0001 C CNN
F 3 "~" H 4900 6500 50  0001 C CNN
F 4 "DNP" H 4700 6500 50  0001 C CNN "Note"
	1    4700 6500
	1    0    0    -1  
$EndComp
Wire Wire Line
	4700 6500 4700 6900
Connection ~ 4700 6900
Wire Wire Line
	4700 6900 3550 6900
Wire Wire Line
	4500 6500 4500 6800
Connection ~ 4500 6800
Wire Wire Line
	4500 6800 3550 6800
Wire Wire Line
	4300 6500 4300 6700
Connection ~ 4300 6700
Wire Wire Line
	4300 6700 3550 6700
Wire Wire Line
	4100 6500 4100 6600
Connection ~ 4100 6600
Wire Wire Line
	4100 6600 3550 6600
Wire Wire Line
	8300 900  8300 1000
Connection ~ 2600 7400
Wire Wire Line
	2500 7400 2600 7400
Wire Wire Line
	5350 7400 5450 7400
$Comp
L power:GND #PWR020
U 1 1 61F76864
P 5450 7500
F 0 "#PWR020" H 5450 7250 50  0001 C CNN
F 1 "GND" H 5454 7328 50  0000 C CNN
F 2 "" H 5450 7500 50  0001 C CNN
F 3 "" H 5450 7500 50  0001 C CNN
	1    5450 7500
	1    0    0    -1  
$EndComp
Wire Wire Line
	5450 7400 5450 7500
Connection ~ 5450 7400
Wire Wire Line
	1850 1450 2150 1450
Wire Wire Line
	2450 1450 2800 1450
Connection ~ 2450 1450
Wire Wire Line
	8300 1900 8300 2000
Wire Wire Line
	1300 2450 1300 2550
Connection ~ 1300 2550
Wire Wire Line
	1300 2550 1800 2550
$Comp
L Device:R R?
U 1 1 5FFED8BB
P 4600 3450
AR Path="/5DCD9772/5FFED8BB" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/5FFED8BB" Ref="R8"  Part="1" 
F 0 "R8" V 4550 3250 50  0000 C CNN
F 1 "2.2K" V 4600 3450 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4530 3450 50  0001 C CNN
F 3 "~" H 4600 3450 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 4600 3450 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4600 3450 50  0001 C CNN "Substitution"
	1    4600 3450
	0    1    1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 60003542
P 4600 3550
AR Path="/5DCD9772/60003542" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/60003542" Ref="R9"  Part="1" 
F 0 "R9" V 4550 3350 50  0000 C CNN
F 1 "2.2K" V 4600 3550 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4530 3550 50  0001 C CNN
F 3 "~" H 4600 3550 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 4600 3550 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4600 3550 50  0001 C CNN "Substitution"
	1    4600 3550
	0    1    1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 60003831
P 4600 3650
AR Path="/5DCD9772/60003831" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/60003831" Ref="R10"  Part="1" 
F 0 "R10" V 4550 3450 50  0000 C CNN
F 1 "2.2K" V 4600 3650 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4530 3650 50  0001 C CNN
F 3 "~" H 4600 3650 50  0001 C CNN
F 4 "GENERIC-RES-0402-2.2K" H 4600 3650 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4600 3650 50  0001 C CNN "Substitution"
	1    4600 3650
	0    1    1    0   
$EndComp
$Comp
L Device:R R?
U 1 1 6001DCF6
P 4600 3350
AR Path="/6001DCF6" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/6001DCF6" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/6001DCF6" Ref="R7"  Part="1" 
F 0 "R7" V 4650 3150 50  0000 C CNN
F 1 "5.5K" V 4600 3350 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4530 3350 50  0001 C CNN
F 3 "~" H 4600 3350 50  0001 C CNN
F 4 "ERJ-2RKF5491X" H 4600 3350 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4600 3350 50  0001 C CNN "Substitution"
F 6 "RES SMD 5.49K OHM 1% 1/10W 0402" H 4600 3350 50  0001 C CNN "Description"
F 7 "Panasonic" H 4600 3350 50  0001 C CNN "Manufacturer"
	1    4600 3350
	0    1    -1   0   
$EndComp
$Comp
L Device:R R?
U 1 1 6002A83C
P 4600 3950
AR Path="/6002A83C" Ref="R?"  Part="1" 
AR Path="/5DA7BAF4/6002A83C" Ref="R?"  Part="1" 
AR Path="/5DCAA6D2/6002A83C" Ref="R11"  Part="1" 
F 0 "R11" V 4650 3750 50  0000 C CNN
F 1 "5.5K" V 4600 3950 50  0000 C CNN
F 2 "Resistor_SMD:R_0402_1005Metric" V 4530 3950 50  0001 C CNN
F 3 "~" H 4600 3950 50  0001 C CNN
F 4 "ERJ-2RKF5491X" H 4600 3950 50  0001 C CNN "Part Number"
F 5 "any equivalent" H 4600 3950 50  0001 C CNN "Substitution"
F 6 "RES SMD 5.49K OHM 1% 1/10W 0402" H 4600 3950 50  0001 C CNN "Description"
F 7 "Panasonic" H 4600 3950 50  0001 C CNN "Manufacturer"
	1    4600 3950
	0    1    -1   0   
$EndComp
$Comp
L power:+5V #PWR?
U 1 1 604E0BAD
P 2550 4250
AR Path="/604E0BAD" Ref="#PWR?"  Part="1" 
AR Path="/5DCAA6D2/604E0BAD" Ref="#PWR0136"  Part="1" 
F 0 "#PWR0136" H 2550 4100 50  0001 C CNN
F 1 "+5V" V 2450 4200 50  0000 L CNN
F 2 "" H 2550 4250 50  0001 C CNN
F 3 "" H 2550 4250 50  0001 C CNN
	1    2550 4250
	1    0    0    -1  
$EndComp
$Comp
L Device:D_Schottky D?
U 1 1 604E0BB6
P 2550 4500
AR Path="/604E0BB6" Ref="D?"  Part="1" 
AR Path="/5DCAA6D2/604E0BB6" Ref="D9"  Part="1" 
F 0 "D9" H 2550 4600 50  0000 C CNN
F 1 "PMEG4010ESBYL" H 2450 4650 50  0001 C CNN
F 2 "Diode_SMD:D_0402_1005Metric" H 2550 4500 50  0001 C CNN
F 3 "~" H 2550 4500 50  0001 C CNN
F 4 "Nexperia" H 2550 4500 50  0001 C CNN "Manufacturer"
F 5 "PMEG4010ESBYL" H 2550 4500 50  0001 C CNN "Part Number"
F 6 "DIODE SCHOTTKY 40V 1A DSN1006-2" H 2550 4500 50  0001 C CNN "Description"
	1    2550 4500
	0    1    1    0   
$EndComp
Wire Wire Line
	2550 4250 2550 4350
Wire Wire Line
	2550 4750 2550 4650
$EndSCHEMATC
