/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.http.auth.AuthStringTokenizer;
import org.apache.jena.http.auth.RFC2617;

public class AuthChallenge {
    public static String SCHEME = "SCHEME";
    public final AuthScheme authScheme;
    public final String realm;
    public final String nonce;
    public final String opaque;
    public final String qop;
    public final Map<String, String> parsed;

    public static AuthChallenge parse(String authHeaderStr) {
        Map<String, String> authHeader = null;
        try {
            authHeader = AuthStringTokenizer.parse(authHeaderStr);
        }
        catch (Throwable ex) {
            return null;
        }
        try {
            if (!authHeader.containsKey(SCHEME)) {
                return null;
            }
            AuthScheme authScheme = AuthScheme.scheme(authHeader.get(SCHEME));
            switch (authScheme) {
                case DIGEST: {
                    AuthChallenge.nonNull(RFC2617.strNonce, authHeader.get(RFC2617.strNonce));
                    AuthChallenge.nonNull(RFC2617.strRealm, authHeader.get(RFC2617.strRealm));
                    break;
                }
                case BASIC: {
                    AuthChallenge.nonNull(RFC2617.strRealm, authHeader.get(RFC2617.strRealm));
                }
            }
            return new AuthChallenge(authScheme, authHeader.get(RFC2617.strRealm), authHeader.get(RFC2617.strNonce), authHeader.get(RFC2617.strOpaque), authHeader.get(RFC2617.strQop), authHeader);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private AuthChallenge(AuthScheme authScheme, String realm, String nonce, String opaque, String qop, Map<String, String> parsed) {
        this.authScheme = authScheme;
        this.realm = realm;
        this.nonce = nonce;
        this.opaque = opaque;
        this.qop = qop;
        this.parsed = parsed;
    }

    private static String nonNull(String field, String s) {
        return Objects.requireNonNull(s, "Field=" + field);
    }
}

