/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJson {
    private static Logger xlog = LoggerFactory.getLogger(ResponseJson.class);

    public static void doResponseJson(HttpAction action, Iterator<JsonObject> jsonItem) {
        if (jsonItem == null) {
            xlog.warn("doResponseJson: Result set is null");
            throw new FusekiException("Result set is null");
        }
        ResponseJson.jsonOutput(action, jsonItem);
    }

    private static void jsonOutput(HttpAction action, Iterator<JsonObject> jsonItems) {
        ResponseResultSet.OutputContent proc = out -> {
            if (jsonItems != null) {
                ResultSetFormatter.output(out, jsonItems);
            }
        };
        try {
            String callback = ResponseOps.paramCallback(action.getRequest());
            ServletOutputStream out2 = action.getResponseOutputStream();
            if (callback != null) {
                callback = StringUtils.replaceChars(callback, "\r", "");
                callback = StringUtils.replaceChars(callback, "\n", "");
                out2.write(StrUtils.asUTF8bytes(callback));
                out2.write(40);
                out2.write(10);
            }
            ResponseJson.output(action, "application/json", "utf-8", proc);
            if (callback != null) {
                out2.write(41);
                out2.write(10);
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    private static void output(HttpAction action, String contentType, String charset, ResponseResultSet.OutputContent proc) {
        try {
            ResponseJson.setHttpResponse(action, contentType, charset);
            action.setResponseStatus(200);
            ServletOutputStream out = action.getResponseOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                xlog.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                PrintStream ps = new PrintStream(out);
                ps.println();
                ps.println("##  Query cancelled due to timeout during execution   ##");
                ps.println("##  ****          Incomplete results           ****   ##");
                ps.flush();
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpAction action, String contentType, String charset) {
        ServletOps.setNoCache(action);
        if (contentType != null) {
            if (charset != null) {
                contentType = (String)contentType + "; charset=" + charset;
            }
            xlog.trace("Content-Type for response: " + (String)contentType);
            action.setResponseContentType((String)contentType);
        }
    }
}

