/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.servlets.GSPLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;

public class GraphTarget {
    private final boolean isDefault;
    private final boolean isUnion;
    private final DatasetGraph dsg;
    private final Node graphName;

    public static final GraphTarget determineTarget(DatasetGraph dsg, HttpAction action) {
        return GraphTarget.determineTarget(dsg, action, false);
    }

    public static final GraphTarget determineTargetGSP(DatasetGraph dsg, HttpAction action) {
        return GraphTarget.determineTarget(dsg, action, false);
    }

    private static final GraphTarget determineTarget(DatasetGraph dsg, HttpAction action, boolean allowDirectNaming) {
        if (dsg == null) {
            ServletOps.errorOccurred("Internal error : No action graph (not in a transaction?)");
        }
        boolean dftGraph = GSPLib.getOneOnly(action.getRequest(), "default") != null;
        String uri = GSPLib.getOneOnly(action.getRequest(), "graph");
        if (!dftGraph && uri == null) {
            if (!allowDirectNaming) {
                ServletOps.errorBadRequest("Neither default graph nor named graph specified");
            }
            String directName = action.getRequestRequestURL().toString();
            if (action.getRequestRequestURI().equals(action.getDatasetName())) {
                ServletOps.errorBadRequest("Neither default graph nor named graph specified and no direct name");
            }
            Node gn = NodeFactory.createURI(directName);
            return GraphTarget.createNamed(dsg, gn);
        }
        if (dftGraph) {
            return GraphTarget.createDefault(dsg);
        }
        if (uri.equals("default")) {
            return GraphTarget.createDefault(dsg);
        }
        if (uri.equals("union")) {
            return GraphTarget.createUnion(dsg);
        }
        String absUri = GraphTarget.resolve0(uri, action);
        return GraphTarget.createNamed(dsg, absUri);
    }

    private static String resolve0(String uri, HttpAction action) {
        try {
            IRIx iri2 = IRIx.create(uri);
            if (!iri2.isReference()) {
                action.log.warn(String.format("[%d] URI is relative: <%s>", action.id, uri));
            }
            return uri;
        }
        catch (IRIException ex) {
            action.log.warn(String.format("[%d] Bad URI <%s> : %s", action.id, uri, ex.getMessage()));
            return uri;
        }
    }

    private static String xresolve(String uriStr, HttpAction action) {
        IRIx uri;
        try {
            uri = IRIx.create(uriStr);
            if (uri.isReference()) {
                return uri.str();
            }
        }
        catch (IRIException ex) {
            FmtLog.warn(Fuseki.actionLog, "Bad URI: '" + uriStr, new Object[0]);
            ServletOps.errorBadRequest("Bad IRI: " + uriStr + " : " + ex.getMessage());
            return null;
        }
        Object baseStr = action.getRequestRequestURL().toString();
        Endpoint ep = action.getEndpoint();
        if (!ep.isUnnamed() && ((String)baseStr).endsWith(ep.getName())) {
            baseStr = ((String)baseStr).substring(0, ((String)baseStr).length() - ep.getName().length());
        }
        if (!((String)baseStr).endsWith("/")) {
            baseStr = (String)baseStr + "/";
        }
        try {
            IRIx base = IRIx.create((String)baseStr);
            IRIx uri2 = base.resolve(uri);
            if (!uri2.isReference()) {
                FmtLog.warn(Fuseki.actionLog, "Bad URI (after resolving): '" + uriStr, new Object[0]);
                ServletOps.errorBadRequest("Bad IRI: " + uriStr);
            }
            return uri2.str();
        }
        catch (IRIException ex) {
            ServletOps.errorBadRequest("Bad IRI: " + uriStr + " : " + ex.getMessage());
            return null;
        }
    }

    static GraphTarget createNamed(DatasetGraph dsg, String graphName) {
        return GraphTarget.createNamed(dsg, NodeFactory.createURI(graphName));
    }

    static GraphTarget createNamed(DatasetGraph dsg, Node graphName) {
        return new GraphTarget(false, false, dsg, graphName);
    }

    static GraphTarget createDefault(DatasetGraph dsg) {
        return new GraphTarget(true, false, dsg, null);
    }

    static GraphTarget createUnion(DatasetGraph dsg) {
        return new GraphTarget(false, true, dsg, null);
    }

    static GraphTarget retarget(GraphTarget target, DatasetGraph dsg) {
        GraphTarget target2 = new GraphTarget(target, dsg);
        return target2;
    }

    private GraphTarget(boolean isDefault, boolean isUnion, DatasetGraph dsg, Node graphName) {
        if (!isUnion && !isDefault && graphName == null) {
            throw new IllegalArgumentException("Inconsistent: not default, union nor graph name");
        }
        if (isDefault && graphName != null) {
            throw new IllegalArgumentException("Inconsistent: default and a graph name");
        }
        if (isUnion && graphName != null) {
            throw new IllegalArgumentException("Inconsistent: union and a graph name");
        }
        if (isDefault && isUnion) {
            throw new IllegalArgumentException("Inconsistent: default and union graph");
        }
        this.isDefault = isDefault;
        this.isUnion = isUnion;
        this.dsg = dsg;
        this.graphName = graphName;
    }

    private GraphTarget(GraphTarget other, DatasetGraph dsg) {
        this.dsg = dsg;
        this.isDefault = other.isDefault;
        this.isUnion = other.isUnion;
        this.graphName = other.graphName;
    }

    public DatasetGraph dataset() {
        return this.dsg;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public Node graphName() {
        return this.graphName;
    }

    public Graph graph() {
        if (this.isDefault) {
            return this.dsg.getDefaultGraph();
        }
        if (this.isUnion) {
            return this.dsg.getUnionGraph();
        }
        return this.dsg.getGraph(this.graphName);
    }

    public boolean exists() {
        if (this.isDefault || this.isUnion) {
            return true;
        }
        Graph g = this.graph();
        return g != null && !g.isEmpty();
    }

    public String label() {
        if (this.isDefault) {
            return "default";
        }
        if (this.isUnion) {
            return "union";
        }
        return NodeFmtLib.str(this.graphName);
    }

    public String toString() {
        return "target:" + this.label();
    }
}

