/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Locale;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

public abstract class ActionREST
extends ActionService {
    @Override
    public void execute(HttpAction action) {
        String method = action.getRequestMethod().toUpperCase(Locale.ROOT);
        if (method.equals("GET")) {
            this.doGet$(action);
        } else if (method.equals("HEAD")) {
            this.doHead$(action);
        } else if (method.equals("POST")) {
            this.doPost$(action);
        } else if (method.equals("PATCH")) {
            this.doPatch$(action);
        } else if (method.equals("OPTIONS")) {
            this.doOptions$(action);
        } else if (method.equals("TRACE")) {
            ServletOps.errorMethodNotAllowed("TRACE");
        } else if (method.equals("PUT")) {
            this.doPut$(action);
        } else if (method.equals("DELETE")) {
            this.doDelete$(action);
        } else {
            ServletOps.errorNotImplemented("Unknown method: " + method);
        }
    }

    protected DatasetGraph decideDataset(HttpAction action) {
        return action.getActiveDSG();
    }

    private final void doGet$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPget);
        try {
            this.doGet(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPgetGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPgetBad);
            throw ex;
        }
    }

    private final void doHead$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPhead);
        try {
            this.doHead(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPheadGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPheadBad);
            throw ex;
        }
    }

    private final void doPost$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpost);
        try {
            this.doPost(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpostGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpostBad);
            throw ex;
        }
    }

    private final void doPatch$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatch);
        try {
            this.doPatch(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatchGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPpatchBad);
            throw ex;
        }
    }

    private final void doDelete$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdelete);
        try {
            this.doDelete(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdeleteGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPdeleteBad);
            throw ex;
        }
    }

    private final void doPut$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPput);
        try {
            this.doPut(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPputGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPputBad);
            throw ex;
        }
    }

    private final void doOptions$(HttpAction action) {
        ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptions);
        try {
            this.doOptions(action);
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptionsGood);
        }
        catch (ActionErrorException ex) {
            ActionExecLib.incCounter(action.getEndpoint(), CounterName.HTTPoptionsBad);
            throw ex;
        }
    }

    protected abstract void doGet(HttpAction var1);

    protected abstract void doHead(HttpAction var1);

    protected abstract void doPost(HttpAction var1);

    protected abstract void doPut(HttpAction var1);

    protected abstract void doDelete(HttpAction var1);

    protected abstract void doPatch(HttpAction var1);

    protected abstract void doOptions(HttpAction var1);

    @Override
    public void execAny(String methodName, HttpAction action) {
        this.executeLifecycle(action);
    }
}

