/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.GraphObject;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriRelativizer;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonArray;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class UriCompaction {
    private final ActiveContext activeContext;
    private JsonValue value;
    private boolean vocab;
    private boolean reverse;

    private UriCompaction(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.value = null;
        this.vocab = false;
        this.reverse = false;
    }

    public static UriCompaction with(ActiveContext activeContext) {
        return new UriCompaction(activeContext);
    }

    public UriCompaction value(JsonValue value) {
        this.value = value;
        return this;
    }

    public UriCompaction vocab(boolean vocab) {
        this.vocab = vocab;
        return this;
    }

    public UriCompaction reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public String compact(String variable) throws JsonLdError {
        URI uri;
        String suffix;
        if (variable == null) {
            return null;
        }
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        InverseContext inverseContext = this.activeContext.getInverseContext();
        if (this.vocab && inverseContext.contains(variable)) {
            JsonValue preserve;
            Object defaultLanguage = "@none";
            if (this.activeContext.getDefaultLanguage() != null) {
                defaultLanguage = this.activeContext.getDefaultLanguage().toLowerCase();
                if (this.activeContext.getDefaultBaseDirection() != null) {
                    defaultLanguage = (String)defaultLanguage + "_".concat(this.activeContext.getDefaultBaseDirection().name().toLowerCase());
                }
            } else if (this.activeContext.getDefaultBaseDirection() != null) {
                defaultLanguage = "_".concat(this.activeContext.getDefaultBaseDirection().name().toLowerCase());
            }
            if (JsonUtils.isObject(this.value) && this.value.asJsonObject().containsKey("@preserve") && JsonUtils.isNotNull(preserve = (JsonValue)this.value.asJsonObject().get("@preserve"))) {
                this.value = (JsonValue)JsonUtils.toJsonArray(preserve).get(0);
            }
            ArrayList containers = new ArrayList();
            String typeLanguage = "@language";
            Object typeLanguageValue = "@null";
            if (JsonUtils.isObject(this.value) && this.value.asJsonObject().containsKey("@index") && !GraphObject.isGraphObject(this.value)) {
                containers.add("@index");
                containers.add("@index".concat("@set"));
            }
            if (this.reverse) {
                typeLanguage = "@type";
                typeLanguageValue = "@reverse";
                containers.add("@set");
            } else if (ListObject.isListObject(this.value)) {
                if (!this.value.asJsonObject().containsKey("@index")) {
                    containers.add("@list");
                }
                JsonArray list = ((JsonValue)this.value.asJsonObject().get("@list")).asJsonArray();
                String commonType = null;
                Object commonLanguage = list.isEmpty() ? defaultLanguage : null;
                for (JsonValue item : list) {
                    Object itemLanguage = "@none";
                    String itemType = "@none";
                    if (JsonUtils.isObject(item) && item.asJsonObject().containsKey("@value")) {
                        if (item.asJsonObject().containsKey("@direction")) {
                            itemLanguage = "";
                            if (item.asJsonObject().containsKey("@language")) {
                                itemLanguage = item.asJsonObject().getString("@language").toLowerCase();
                            }
                            itemLanguage = (String)itemLanguage + "_".concat(item.asJsonObject().getString("@direction").toLowerCase());
                        } else if (item.asJsonObject().containsKey("@language")) {
                            itemLanguage = item.asJsonObject().getString("@language").toLowerCase();
                        } else if (item.asJsonObject().containsKey("@type")) {
                            itemType = item.asJsonObject().getString("@type");
                        } else {
                            itemLanguage = "@null";
                        }
                    } else {
                        itemType = "@id";
                    }
                    if (commonLanguage == null) {
                        commonLanguage = itemLanguage;
                    } else if (!Objects.equals(itemLanguage, commonLanguage) && JsonUtils.isObject(item) && item.asJsonObject().containsKey("@value")) {
                        commonLanguage = "@none";
                    }
                    if (commonType == null) {
                        commonType = itemType;
                    } else if (!Objects.equals(itemType, commonType)) {
                        commonType = "@none";
                    }
                    if (!"@none".equals(commonLanguage) || !"@none".equals(commonType)) continue;
                    break;
                }
                if (commonLanguage == null) {
                    commonLanguage = "@none";
                }
                if (commonType == null) {
                    commonType = "@none";
                }
                if (!"@none".equals(commonType)) {
                    typeLanguage = "@type";
                    typeLanguageValue = commonType;
                } else {
                    typeLanguageValue = commonLanguage;
                }
            } else if (GraphObject.isGraphObject(this.value)) {
                if (this.value.asJsonObject().containsKey("@index")) {
                    containers.add("@graph".concat("@index"));
                    containers.add("@graph".concat("@index").concat("@set"));
                }
                if (this.value.asJsonObject().containsKey("@id")) {
                    containers.add("@graph".concat("@id"));
                    containers.add("@graph".concat("@id").concat("@set"));
                }
                containers.add("@graph");
                containers.add("@graph".concat("@set"));
                containers.add("@set");
                if (!this.value.asJsonObject().containsKey("@index")) {
                    containers.add("@graph".concat("@index"));
                    containers.add("@graph".concat("@index").concat("@set"));
                }
                if (!this.value.asJsonObject().containsKey("@id")) {
                    containers.add("@graph".concat("@id"));
                    containers.add("@graph".concat("@id").concat("@set"));
                }
                containers.add("@index");
                containers.add("@index".concat("@set"));
                typeLanguage = "@type";
                typeLanguageValue = "@id";
            } else {
                if (ValueObject.isValueObject(this.value)) {
                    JsonValue language;
                    if (JsonUtils.contains("@direction", this.value) && !JsonUtils.contains("@index", this.value)) {
                        JsonValue direction;
                        typeLanguageValue = "";
                        if (JsonUtils.contains("@language", this.value) && JsonUtils.isString(language = (JsonValue)this.value.asJsonObject().get("@language"))) {
                            typeLanguageValue = ((JsonString)language).getString().toLowerCase();
                        }
                        if (JsonUtils.isString(direction = (JsonValue)this.value.asJsonObject().get("@direction"))) {
                            typeLanguageValue = (String)typeLanguageValue + "_".concat(((JsonString)direction).getString().toLowerCase());
                        }
                        containers.add("@language");
                        containers.add("@language".concat("@set"));
                    } else if (JsonUtils.contains("@language", this.value) && !JsonUtils.contains("@index", this.value)) {
                        if (JsonUtils.contains("@language", this.value) && JsonUtils.isString(language = (JsonValue)this.value.asJsonObject().get("@language"))) {
                            typeLanguageValue = ((JsonString)language).getString().toLowerCase();
                        }
                        containers.add("@language");
                        containers.add("@language".concat("@set"));
                    } else if (JsonUtils.contains("@type", this.value)) {
                        typeLanguage = "@type";
                        typeLanguageValue = this.value.asJsonObject().getString("@type");
                    }
                } else {
                    typeLanguage = "@type";
                    typeLanguageValue = "@id";
                    containers.add("@id");
                    containers.add("@id".concat("@set"));
                    containers.add("@type");
                    containers.add("@set".concat("@type"));
                }
                containers.add("@set");
            }
            containers.add("@none");
            if (!(this.activeContext.inMode(JsonLdVersion.V1_0) || !JsonUtils.isNotObject(this.value) && this.value.asJsonObject().containsKey("@index"))) {
                containers.add("@index");
                containers.add("@index".concat("@set"));
            }
            if (!this.activeContext.inMode(JsonLdVersion.V1_0) && JsonUtils.isObject(this.value) && this.value.asJsonObject().containsKey("@value") && this.value.asJsonObject().size() == 1) {
                containers.add("@language");
                containers.add("@language".concat("@set"));
            }
            if (typeLanguageValue == null) {
                typeLanguageValue = "@null";
            }
            ArrayList<String> preferredValues = new ArrayList<String>();
            if ("@reverse".equals(typeLanguageValue)) {
                preferredValues.add("@reverse");
            }
            if (("@reverse".equals(typeLanguageValue) || "@id".equals(typeLanguageValue)) && JsonUtils.isObject(this.value) && this.value.asJsonObject().containsKey("@id")) {
                JsonValue idValue = (JsonValue)this.value.asJsonObject().get("@id");
                if (this.activeContext.getOptions().isRdfStar() && NodeObject.isEmbeddedNode(idValue)) {
                    preferredValues.add("@id");
                    preferredValues.add("@vocab");
                } else if (JsonUtils.isString(idValue)) {
                    String idString = ((JsonString)idValue).getString();
                    String compactedIdValue = this.activeContext.uriCompaction().vocab(true).compact(idString);
                    Optional<TermDefinition> compactedIdValueTermDefinition = this.activeContext.getTerm(compactedIdValue);
                    if (compactedIdValueTermDefinition.map(TermDefinition::getUriMapping).filter(idString::equals).isPresent()) {
                        preferredValues.add("@vocab");
                        preferredValues.add("@id");
                    } else {
                        preferredValues.add("@id");
                        preferredValues.add("@vocab");
                    }
                } else {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_ID_VALUE, "An @id entry was encountered whose value was not a string but [" + (JsonValue)idValue + "].");
                }
                preferredValues.add("@none");
            } else {
                preferredValues.add((String)typeLanguageValue);
                preferredValues.add("@none");
                if (ListObject.isListObject(this.value) && JsonUtils.isEmptyArray((JsonValue)this.value.asJsonObject().get("@list"))) {
                    typeLanguage = "@any";
                }
            }
            preferredValues.add("@any");
            for (String preferredValue : new ArrayList(preferredValues)) {
                int index = preferredValue.indexOf(95);
                if (index == -1) continue;
                preferredValues.add(preferredValue.substring(index));
            }
            Optional<String> term = this.activeContext.termSelector(variable, containers, typeLanguage).match(preferredValues);
            if (term.isPresent()) {
                return term.get();
            }
        }
        if (this.vocab && this.activeContext.getVocabularyMapping() != null && variable.startsWith(this.activeContext.getVocabularyMapping()) && variable.length() > this.activeContext.getVocabularyMapping().length() && !this.activeContext.containsTerm(suffix = variable.substring(this.activeContext.getVocabularyMapping().length()))) {
            return suffix;
        }
        String compactUri = null;
        for (Map.Entry<String, TermDefinition> termEntry : this.activeContext.getTermsMapping().entrySet()) {
            TermDefinition termDefinition = termEntry.getValue();
            if (termDefinition.getUriMapping() == null || variable.equals(termDefinition.getUriMapping()) || !variable.startsWith(termDefinition.getUriMapping()) || termDefinition.isNotPrefix()) continue;
            String compactUriCandidate = termEntry.getKey().concat(":").concat(variable.substring(termDefinition.getUriMapping().length()));
            if ((compactUri != null && compactUriCandidate.compareTo(compactUri) >= 0 || this.activeContext.containsTerm(compactUriCandidate)) && (!this.activeContext.getTerm(compactUriCandidate).map(TermDefinition::getUriMapping).filter(u -> u.equals(variable)).isPresent() || !JsonUtils.isNull(this.value))) continue;
            compactUri = compactUriCandidate;
        }
        if (compactUri != null) {
            return compactUri;
        }
        if (UriUtils.isAbsoluteUri(variable) && (uri = URI.create(variable)).getScheme() != null && this.activeContext.getTerm(uri.getScheme()).filter(TermDefinition::isPrefix).isPresent() && uri.getAuthority() == null) {
            throw new JsonLdError(JsonLdErrorCode.IRI_CONFUSED_WITH_PREFIX);
        }
        if (!this.vocab && this.activeContext.getBaseUri() != null && !BlankNode.hasPrefix(variable)) {
            String relativeUri = UriRelativizer.relativize(this.activeContext.getBaseUri(), variable);
            return Keywords.matchForm(relativeUri) ? "./".concat(relativeUri) : relativeUri;
        }
        return variable;
    }
}

