## Motivation

What was the reasoning behind this change? Please explain the changes briefly.

## How to test the behavior?
```
Show how to reproduce the new behavior (can be a bug fix or a new feature)
```

## Checklist

- [ ] Did you update CHANGELOG.md with your changes?
- [ ] Have you checked our [Contributing](https://github.com/hdmf-dev/hdmf-zarr/blob/dev/docs/CONTRIBUTING.rst) document?
- [ ] Have you ensured the PR clearly describes the problem and the solution?
- [ ] Is your contribution compliant with our coding style? This can be checked running `ruff` from the source directory.
- [ ] Have you checked to ensure that there aren't other open [Pull Requests](https://github.com/hdmf-dev/hdmf-zarr/pulls) for the same change?
- [ ] Have you included the relevant issue number using "Fix #XXX" notation where XXX is the issue number? By including "Fix #XXX" you allow GitHub to close issue #XXX when the PR is merged.
