from langchain_core.prompts import ChatPromptTemplate


class Prompts():
    def __init__(self):
        pass

    # 寻找哪些表是相关的
    get_relate_table_system = """你的任务通过理解业务分类以及业务包括的表名,思考用户所要查询的内容属于哪个业务,需要哪些表。
                    首先,判断用户所要查询的内容属于哪个业务,
                    然后找到业务包括的表中,哪些是用户也需要的,
                    接下来你需要思考并总结,用户想要查询的问题应该在哪些表名中,务必保证用户的问题和你返回的表名的业务逻辑或者其他逻辑是相关联的。
                    你可以多找一些表,以此保证用户想查的内容在你选定的范围内。
                    我需要在你总结的表中去查询用户想要查询的内容,但这与你无关,你只需要帮我找出使用哪些表就行了。
                    最后,你需要判断并且把用户想要查询的内容所在的表的表名返回给我。
                    只返回表名给我,表名之间用","分割,禁止返回任何其他描述思考内容。
    """
    get_relate_table_prompt = ChatPromptTemplate.from_messages(
        [("system", get_relate_table_system), ("placeholder", "{messages}")]
    )

    summary_question_system = """
                    你需要对用户的问题进行分析,判断用户到底是想要查询什么内容,
                    并且判断用户是想要查询的你内容在哪一张表或者哪几张表中的哪些字段和数据。
                    首先,你需要分析之前给你的所有的表的别名,表的字段和别名,分析用户想要查询的内容在哪些表和表的字段中。
                    千万不要假设或者虚构不存在的表和字段!一切思考基于你已知的表结构和信息!
                    你需要思考:如果要生成sql查询用户的内容的话,需要考虑使用什么样的sql功能去查询内容。
                    例如:需要把哪些表按照哪些字段相互连接,需要添加什么样的条件查询,是否需要集合操作等.....
                    在详细了解表结构的情况下,一定要保证你的操作在这些表中是可以实现的。
                    然后你需要思考要把哪些字段给查询出来,一定要保证想要查询的内容是在表中的,并且一定要保证你的方法能够查询到内容。

                    针对你需要查询的内容有以下的额外要求:
                    1,尽可能不要返回id和编码,而是返回id和编码对应名称和类型名称。
                    2,如果用户没有指定项目,或者需要查询多个项目中的内容,你需要对项目进行分组
                    3,如果用户未指定排序,你可以自己思考排序方式,例如按照时间排序,数量排序。

                    最后,你需要把你的思考过程和结果告诉我,不用返回sql语句,我将根据你的思考来自己完成sql代码。
                    切记,只返回你的思考过程,不要返回sql代码!
    """
    summary_question_prompt = ChatPromptTemplate.from_messages(
        [("system", summary_question_system), ("placeholder", "{messages}")]
    )

    generate_sql_system = """
                    你需要对用户的问题进行分析,判断用户到底是想要查询什么内容,
                    并且判断用户是想要查询的你内容在哪一张表或者哪几张表中的哪些字段和数据。
                    首先,你需要分析之前给你的所有的表的别名,
                    千万不要假设或者虚构不存在的表和字段!一切思考基于你已知的表结构和信息!
                    然后思考并生成一个完全正确的sql,
                    需要思考以下内容:
                    1,需要把哪些表按照哪些字段相互连接
                    2,需要查询哪些字段
                    3,需要添加什么样的条件查询
                    4,是否需要group操作等,该怎么group
                    5,生成的sql需要在postgres中运行


                    在详细了解表结构的情况下,一定要保证你使用的字段是在表结构中的。

                    针对你思考的内容有以下的额外要求:
                    1,尽可能不要返回id和编码,而是返回id和编码对应名称和类型名称。
                    2,如果用户没有指定项目,或者需要查询多个项目中的内容,你需要对项目进行分组
                    3,如果用户未指定排序,你可以自己思考排序方式,例如按照时间排序,数量排序。
                    4,使用中文别名,使用户更容易理解每一列的信息。
                    
                    根据你的思考生成sql,
                    最后你需要检查sql中的字段是不是在表结构中都存在。                  
                    只返回sql语句代码,禁止返回任何其他描述文本内容！
                
    """

    generate_sql_prompt = ChatPromptTemplate.from_messages(
        [("system", generate_sql_system), ("placeholder", "{messages}")]
    )

    check_error_system = """
                    你的任务是根据查询数据库的报错信息修改sql:
                    1,检查生成的sql中的字段是否存在于表结构中,禁止大模型生成虚构的字段,如果上一个sql使用了虚构字段,那就把它修改或删除。
                    2,检查where语句中是不是存在虚构数据!即使取值是合理的,但是如果取值在表中不存在,就可能查不到任何信息,你要避免这种情况。
                    3,在此基础上检查sql语法是否有问题。   
 
                    你只需要返回给我绝对正确的sql语句,不要让我帮你去检查字段是否存在。

    """
    check_error_prompt = ChatPromptTemplate.from_messages(
        [("system", check_error_system), ("placeholder", "{messages}")]
    )

    judge_question_system = """
                    你的任务是判断在案例查询中,有没有和用户的提问语义完全一致的案例查询。
                    判断完全一致的标准如下:
                    1,用户查询的信息与案例查询的时间范围可以不同
                    2,用户查询的信息与案例查询的排序方式可以不同
                    3,用户查询的信息与案例查询的项目id可以不同
                    4,其他方面在语义上必须完全一致

                    如果你找到了这样一个案例查询,你就返回这个案例查询,否则在任何情况下都只返回 "没有"
                    如果你找到多个相似的案例查询,那就只返回最相似那个!不要全部返回!
                    只返回案例查询,不要返回任何其他内容!

    """
    judge_question_prompt = ChatPromptTemplate.from_messages(
        [("system", judge_question_system), ("placeholder", "{messages}")]
    )

    generate_sql_only_example_system = """
                    你的任务是学习给你的sql案例,理解sql案例中的字段和查询的内容。
                    针对用户的查询需求对sql案例进行修改。
                    修改sql案例需要满足的关键点:
                        1,禁止修改join,from,group by等sql语句,以及这些语句内包含的字段!即使你认为应该修改,但也别修改!
                        2,严格参照sql案例进行修改,如果用户是查询所有项目,那就需要把匹配某个项目的where字段删掉,如果查询指定项目,就需要添加where project_info.id = "项目id"
                        3,禁止修改查询的字段!不要用另一张表的相同字段去替换原字段!
                        4,除非特殊需要,否则不要随意去使用未出现在sql中的字段,因为你不知道这些字段是否有效!!!!!!
                        5,如果用户查询的时间和案例sql的时间不一致,那就修改时间,或者添加时间限制
                        6,如果用户需要排序,就添加排序,或者按照用户需求排序
                        7,如果用户查询的项目不一样,那就替换project_id的值
                        8,查询材料类型时需要按照material_info表中的id字段分组,同时查询name和type字段
                        

                
                    生成sql的要求如下:
                    1,首先你需要再次确认所有表结构信息中的字段和字段类型,
                    2,千万不要假设或者虚构不存在的表和字段!
                    3,根据之前的表结构信息,保证你生成的sql中的表和表的字段都存在于表结构中!
                    4,在用户没有添加条件限制时,禁止使用where语法!
                    5,不要使用where去匹配你不知道的表中数据信息!如果一个数据你不知道在表中是否存在,也没有在案例sql中出现,不要使用这个数据！
                    6,保证你的sql在语法上没有任何错误!需要满足在PostgreSQL 中运行。 
                    

    """

    generate_sql_only_example_prompt = ChatPromptTemplate.from_messages(
        [("system", generate_sql_only_example_system),
         ("placeholder", "{messages}")]
    )
    get_relate_aspects_system = """你的任务通过理解业务分类以及相关信息,思考用户所要查询的内容属于哪个业务。
                    返回给我你选择的业务的名称。只返回业务名称。
    """
    get_relate_aspects_prompt = ChatPromptTemplate.from_messages(
        [("system", get_relate_aspects_system), ("placeholder", "{messages}")]
    )
