# Generated by Django 3.1.1 on 2020-10-04 09:36

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import imicusfat.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("eveonline", "0012_index_additions"),
        ("imicusfat", "0010_ifatlinktype_is_enabled"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="clickifatduration",
            options={
                "verbose_name": "FAT Duration",
                "verbose_name_plural": "FAT Durations",
            },
        ),
        migrations.AlterModelOptions(
            name="dellog",
            options={
                "verbose_name": "Delete Log",
                "verbose_name_plural": "Delete Logs",
            },
        ),
        migrations.AlterModelOptions(
            name="ifatlinktype",
            options={
                "verbose_name": "FAT Link Type",
                "verbose_name_plural": "FAT Link Types",
            },
        ),
        migrations.AlterModelOptions(
            name="manualifat",
            options={
                "verbose_name": "Manual FAT Log",
                "verbose_name_plural": "Manual FAT Logs",
            },
        ),
        migrations.AddField(
            model_name="manualifat",
            name="created_at",
            field=models.DateTimeField(
                blank=True, help_text="Time this FAT has been added manually", null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifat",
            name="character",
            field=models.ForeignKey(
                help_text="Character who registered this fat",
                on_delete=django.db.models.deletion.CASCADE,
                to="eveonline.evecharacter",
            ),
        ),
        migrations.AlterField(
            model_name="ifat",
            name="deleted_at",
            field=models.DateTimeField(
                blank=True, help_text="Has been deleted or not", null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifat",
            name="ifatlink",
            field=models.ForeignKey(
                help_text="The fatlink the character registered with",
                on_delete=django.db.models.deletion.CASCADE,
                to="imicusfat.ifatlink",
            ),
        ),
        migrations.AlterField(
            model_name="ifat",
            name="shiptype",
            field=models.CharField(
                help_text="The ship the character was flying", max_length=100, null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifat",
            name="system",
            field=models.CharField(
                help_text="The system the character is in", max_length=100, null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="creator",
            field=models.ForeignKey(
                help_text="Who created the fatlink?",
                on_delete=models.SET(imicusfat.models.get_sentinel_user),
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="deleted_at",
            field=models.DateTimeField(
                blank=True, help_text="Has been deleted or not", null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="fleet",
            field=models.CharField(
                help_text="The fatlinks fleet name", max_length=254, null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="hash",
            field=models.CharField(help_text="The fatlinks hash", max_length=254),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="ifattime",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="When was this fatlink created",
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="is_esilink",
            field=models.BooleanField(
                default=False,
                help_text="Whether this fatlink was created via ESI or not",
            ),
        ),
        migrations.AlterField(
            model_name="ifatlink",
            name="link_type",
            field=models.ForeignKey(
                help_text="The fatlinks fleet type, if it's set",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="imicusfat.ifatlinktype",
            ),
        ),
        migrations.AlterField(
            model_name="ifatlinktype",
            name="deleted_at",
            field=models.DateTimeField(
                blank=True, help_text="Has this been deleted?", null=True
            ),
        ),
        migrations.AlterField(
            model_name="ifatlinktype",
            name="name",
            field=models.CharField(
                help_text="Descriptive name of your fleet type", max_length=254
            ),
        ),
    ]
