"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const waf = require("@aws-cdk/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
/**
 * @summary The WafwebaclToApiGateway class.
 */
class WafwebaclToApiGateway extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the WafwebaclToApiGateway class.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'REGIONAL', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        const resourceArn = `arn:aws:apigateway:${core_1.Stack.of(scope).region}::/restapis/${props.existingApiGatewayInterface.restApiId}/stages/${props.existingApiGatewayInterface.deploymentStage.stageName}`;
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn
        });
        this.apiGateway = props.existingApiGatewayInterface;
    }
}
exports.WafwebaclToApiGateway = WafwebaclToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-apigateway.WafwebaclToApiGateway", version: "1.130.0" };
//# sourceMappingURL=data:application/json;base64,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