from howler import odm


@odm.model(
    index=True,
    store=True,
    description="The user_agent fields normally come from a browser request.",
)
class Vulnerability(odm.Model):
    category = odm.Optional(
        odm.List(
            odm.Keyword(),
            description="The type of system or architecture that the vulnerability affects. These may be "
            "platform-specific (for example, Debian or SUSE) or general (for example, Database or Firewall).",
        )
    )
    classification = odm.Optional(
        odm.Keyword(
            description="The classification of the vulnerability scoring system. "
            "For example (https://www.first.org/cvss/)"
        )
    )
    description = odm.Optional(
        odm.Keyword(
            description="The description of the vulnerability that provides additional context of the vulnerability."
        )
    )
    enumeration = odm.Optional(odm.Keyword(description="The type of identifier used for this vulnerability."))
    id = odm.Optional(
        odm.Keyword(
            description="The identification (ID) is the number portion of a vulnerability entry. It includes a "
            "unique identification number for the vulnerability."
        )
    )
    reference = odm.Optional(
        odm.Keyword(
            description="A resource that provides additional information, context, and mitigations for the "
            "identified vulnerability."
        )
    )
    report_id = odm.Optional(odm.Keyword(description="The report or scan identification number."))
