import json
import pytest

from pathlib import Path
from cve_driller.driller import CVEDriller

data_folder = Path(__file__).absolute().parent.parent / "data"

inputs_folder = data_folder / "inputs"
outputs_folder = data_folder / "outputs"
driller = CVEDriller()


def get_test_cases():
    test_cases = []

    for cwe_dir in inputs_folder.iterdir():
        if not cwe_dir.is_dir():
            continue

        for starting_detail_dir in cwe_dir.iterdir():
            for filename in starting_detail_dir.iterdir():
                output_path = Path(outputs_folder, cwe_dir.name, starting_detail_dir.name, filename.stem + ".json")

                if output_path.exists():
                    test_cases.append((filename, output_path))

    return test_cases


@pytest.mark.parametrize("input_file, expected_output_file", get_test_cases())
def test_extraction(input_file, expected_output_file):
    with open(input_file, "r", encoding="utf-8") as f:
        input_text = f.read()

    with open(expected_output_file, "r", encoding="utf-8") as f:
        expected_details = json.load(f)

    starting_detail, extracted_data = driller(input_text)

    assert starting_detail is not None, f"Starting detail not found in {input_file}"
    assert starting_detail.value == expected_output_file.parent.name, f"Starting detail mismatch in {input_file}"
    assert extracted_data == expected_details, f"Pattern mismatch in {input_file}"
