import json

from cve_driller.driller import CVEDriller


if __name__ == "__main__":
    driller = CVEDriller(verbose=True)
    cve_id = "CVE-2018-7187"

    input_path = f"data/inputs/CWE-78/comp_config_condition/{cve_id}.txt"
    #description = open(input_path, 'r').read()
    description = "Directory traversal vulnerability in post-edit.php in MiniCMS V1.10 allows remote attackers to include and execute arbitrary files via the state parameter."
    detail_type, details = driller(description)
    # CVE-2023-26922

    if details:
        print(json.dumps(details, indent=4))

    #if details:
    #    output_path = f"data/outputs/{detail_type.value}/{cve_id}.json"

    #    with open(output_path, 'w') as f:
    #        json.dump(details, f, indent=4)
