from ..common.enums import DetailType

from .weakness.configuration.attacker import WEAKNESS_CONFIG_ATTACKER_PATTERN, WEAKNESS_CONFIG_ATTACKER_PATTERNS
from .weakness.configuration.component import WEAKNESS_CONFIG_COMP_PATTERN, WEAKNESS_CONFIG_COMP_PATTERNS
from .weakness.configuration.vector import WEAKNESS_CONFIG_VECTOR_PATTERN, WEAKNESS_CONFIG_VECTOR_PATTERNS
from .weakness.component.configuration import WEAKNESS_COMP_CONFIG_PATTERN, WEAKNESS_COMP_CONFIG_PATTERNS
from .weakness.configuration.cause import WEAKNESS_CONFIG_CAUSE_PATTERN, WEAKNESS_CONFIG_CAUSE_PATTERNS
from .weakness.configuration.condition import WEAKNESS_CONFIG_CONDITION_PATTERN, WEAKNESS_CONFIG_CONDITION_PATTERNS

from .configuration.weakness.component import CONFIG_WEAKNESS_COMP_PATTERN, CONFIG_WEAKNESS_COMP_PATTERNS
from .configuration.weakness.attacker import CONFIG_WEAKNESS_ATTACKER_PATTERN, CONFIG_WEAKNESS_ATTACKER_PATTERNS
from .configuration.weakness.condition import CONFIG_WEAKNESS_CONDITION_PATTERN, CONFIG_WEAKNESS_CONDITION_PATTERNS
from .configuration.attacker.impact import CONFIG_ATTACKER_IMPACT_PATTERN, CONFIG_ATTACKER_IMPACT_PATTERNS
from .configuration.cause.attacker import CONFIG_CAUSE_ATTACKER_PATTERN, CONFIG_CAUSE_ATTACKER_PATTERNS
from .configuration.cause.weakness import CONFIG_CAUSE_WEAKNESS_PATTERN, CONFIG_CAUSE_WEAKNESS_PATTERNS
from .configuration.condition.cause import CONFIG_CONDITION_CAUSE_PATTERN, CONFIG_CONDITION_CAUSE_PATTERNS

from .component.configuration.weakness import COMPONENT_CONFIG_WEAKNESS_PATTERN, COMPONENT_CONFIG_WEAKNESS_PATTERNS
from .component.configuration.attacker import COMPONENT_CONFIG_ATTACKER_PATTERN, COMPONENT_CONFIG_ATTACKER_PATTERNS
from .component.configuration.cause import COMPONENT_CONFIG_CAUSE_PATTERN, COMPONENT_CONFIG_CAUSE_PATTERNS
from .component.configuration.condition import COMPONENT_CONFIG_CONDITION_PATTERN, COMPONENT_CONFIG_CONDITION_PATTERNS


STARTING_DETAILS_MAPPING = {
    DetailType.COMPONENT_CONFIG_WEAKNESS: COMPONENT_CONFIG_WEAKNESS_PATTERN,
    DetailType.CONFIG_WEAKNESS_COMP: CONFIG_WEAKNESS_COMP_PATTERN,
    DetailType.CONFIG_WEAKNESS_ATTACKER: CONFIG_WEAKNESS_ATTACKER_PATTERN,
    DetailType.CONFIG_WEAKNESS_CONDITION: CONFIG_WEAKNESS_CONDITION_PATTERN,
    DetailType.WEAKNESS_COMP_CONFIG: WEAKNESS_COMP_CONFIG_PATTERN,
    DetailType.WEAKNESS_CONFIG_COMP: WEAKNESS_CONFIG_COMP_PATTERN,
    DetailType.COMPONENT_CONFIG_CAUSE: COMPONENT_CONFIG_CAUSE_PATTERN,
    DetailType.COMPONENT_CONFIG_CONDITION: COMPONENT_CONFIG_CONDITION_PATTERN,
    DetailType.COMPONENT_CONFIG_ATTACKER: COMPONENT_CONFIG_ATTACKER_PATTERN,
    DetailType.WEAKNESS_CONFIG_ATTACKER: WEAKNESS_CONFIG_ATTACKER_PATTERN,
    DetailType.WEAKNESS_CONFIG_VECTOR: WEAKNESS_CONFIG_VECTOR_PATTERN,
    DetailType.WEAKNESS_CONFIG_CAUSE: WEAKNESS_CONFIG_CAUSE_PATTERN,
    DetailType.WEAKNESS_CONFIG_CONDITION: WEAKNESS_CONFIG_CONDITION_PATTERN,
    DetailType.CONFIG_ATTACKER_IMPACT: CONFIG_ATTACKER_IMPACT_PATTERN,
    DetailType.CONFIG_CAUSE_ATTACKER: CONFIG_CAUSE_ATTACKER_PATTERN,
    DetailType.CONFIG_CAUSE_WEAKNESS: CONFIG_CAUSE_WEAKNESS_PATTERN,
    DetailType.CONFIG_CONDITION_CAUSE: CONFIG_CONDITION_CAUSE_PATTERN,
}

DETAILS_PATTERNS_MAPPING = {
    DetailType.COMPONENT_CONFIG_WEAKNESS: COMPONENT_CONFIG_WEAKNESS_PATTERNS,
    DetailType.CONFIG_WEAKNESS_COMP: CONFIG_WEAKNESS_COMP_PATTERNS,
    DetailType.CONFIG_WEAKNESS_ATTACKER: CONFIG_WEAKNESS_ATTACKER_PATTERNS,
    DetailType.CONFIG_WEAKNESS_CONDITION: CONFIG_WEAKNESS_CONDITION_PATTERNS,
    DetailType.WEAKNESS_COMP_CONFIG: WEAKNESS_COMP_CONFIG_PATTERNS,
    DetailType.WEAKNESS_CONFIG_COMP: WEAKNESS_CONFIG_COMP_PATTERNS,
    DetailType.COMPONENT_CONFIG_CAUSE: COMPONENT_CONFIG_CAUSE_PATTERNS,
    DetailType.COMPONENT_CONFIG_CONDITION: COMPONENT_CONFIG_CONDITION_PATTERNS,
    DetailType.COMPONENT_CONFIG_ATTACKER: COMPONENT_CONFIG_ATTACKER_PATTERNS,
    DetailType.WEAKNESS_CONFIG_ATTACKER: WEAKNESS_CONFIG_ATTACKER_PATTERNS,
    DetailType.WEAKNESS_CONFIG_VECTOR: WEAKNESS_CONFIG_VECTOR_PATTERNS,
    DetailType.WEAKNESS_CONFIG_CAUSE: WEAKNESS_CONFIG_CAUSE_PATTERNS,
    DetailType.WEAKNESS_CONFIG_CONDITION: WEAKNESS_CONFIG_CONDITION_PATTERNS,
    DetailType.CONFIG_ATTACKER_IMPACT: CONFIG_ATTACKER_IMPACT_PATTERNS,
    DetailType.CONFIG_CAUSE_ATTACKER: CONFIG_CAUSE_ATTACKER_PATTERNS,
    DetailType.CONFIG_CAUSE_WEAKNESS: CONFIG_CAUSE_WEAKNESS_PATTERNS,
    DetailType.CONFIG_CONDITION_CAUSE: CONFIG_CONDITION_CAUSE_PATTERNS
}
