# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
import pulumi_aws

__all__ = ['ReplicatedBucketArgs', 'ReplicatedBucket']

@pulumi.input_type
class ReplicatedBucketArgs:
    def __init__(__self__, *,
                 destination_region: pulumi.Input[str]):
        """
        The set of arguments for constructing a ReplicatedBucket resource.
        :param pulumi.Input[str] destination_region: Region to which data should be replicated.
        """
        pulumi.set(__self__, "destination_region", destination_region)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Input[str]:
        """
        Region to which data should be replicated.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region", value)


class ReplicatedBucket(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ReplicatedBucket resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_region: Region to which data should be replicated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicatedBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ReplicatedBucket resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ReplicatedBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicatedBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicatedBucketArgs.__new__(ReplicatedBucketArgs)

            if destination_region is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region'")
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["destination_bucket"] = None
            __props__.__dict__["source_bucket"] = None
        super(ReplicatedBucket, __self__).__init__(
            'aws-s3-replicated-bucket:index:ReplicatedBucket',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="destinationBucket")
    def destination_bucket(self) -> pulumi.Output['pulumi_aws.s3.Bucket']:
        """
        Bucket to which data should be replicated.
        """
        return pulumi.get(self, "destination_bucket")

    @property
    @pulumi.getter(name="sourceBucket")
    def source_bucket(self) -> pulumi.Output['pulumi_aws.s3.Bucket']:
        """
        Bucket to which objects are written.
        """
        return pulumi.get(self, "source_bucket")

