__copyright__ = "Copyright (c) 2021"
__author__ = "Rakha Asyrofi"
__date__ = "2021-10-08:18:07:39"

# -*- coding: utf-8 -*-
"""modul_relasi.ipynb
Author Rakha Asyrofi / 05111950010038

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1h6HKNeALV8bXjrxWB0Jn0ztHtLv2cXz8
"""

"""# Modul1: xmlparser"""

# function
import xml.etree.ElementTree as ET
import pandas as pd
from tabulate import tabulate
from time import time

# template class xmlparser
class xmlParser:

    # inisialisasi
    def __init__(self, filename= 'IRCI_Researcher.xmi', 
                 tipe_xmi= '{http://schema.omg.org/spec/XMI/2.1}type',
                 id_xmi= '{http://schema.omg.org/spec/XMI/2.1}id'):
    	self.namaFile = filename
    	self.xmi_type = tipe_xmi
    	self.xmi_id = id_xmi

    #fungsi parse tree elemen
    def elemenTreeParse(self):
      tree = ET.parse(self.namaFile)
      root = tree.getroot()
      try: 
        elemenTag = [elem.tag for elem in root.iter()]
        elemenAtribut = [elem.attrib for elem in root.iter()]
        tabelElemen = pd.DataFrame([elemenTag, elemenAtribut], index=['Berdasarkan Tag', 'Berdsarkan Atribut']).T
        return tabelElemen

      except OSError as err:
        print("OS error: {0}".format(err))

    # fungsi pencarian elemen
    def cariTreeElemen(self, elemen):
      try:
        tree1 = ET.parse(self.namaFile)
        root1 = tree1.getroot()
        pencarian = [num.findall(elemen) for num in root1.iter()]
        return pencarian

      except OSError as err:
        print("OS error: {0}".format(err))

    #fungsi list elemen
    def listElemen(self, elemen):
      try:
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        listElemen = [berdasarkanOwnEnd.attrib for berdasarkanOwnEnd in root.iter(elemen)]
        tabelElement = pd.DataFrame(listElemen)
        return tabelElement

      except OSError as err:
        print("OS error: {0}".format(err))

    # fungsi mencari table spesifik
    def tableElemenSpesifik(self, elemen= 'packagedElement', kolom1= 'name'):
      try:
        hasil = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        berdasarkanPackagedELement = [packagedElement.attrib for packagedElement in root.iter(elemen)]
        for num in berdasarkanPackagedELement:
          a1 = num[kolom1]
          c1 = num[self.xmi_type]
          d1 = num[self.xmi_id]
          hasil.append([a1, c1, d1])
        cleanPackagedELement = pd.DataFrame(hasil, columns=[kolom1, self.xmi_type, self.xmi_id])
        return cleanPackagedELement
        
      except OSError as err:
        print("OS error: {0}".format(err))


    # fungsi mencari string
    def doString(self):
      try:
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        print(ET.tostring(root, encoding='utf8').decode('utf8'))
      except OSError as err:
        print("OS error: {0}".format(err))


    def dataPaketElemen(self, category = 'packagedElement'):
      try:
        hasil = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        berdasarkanPackagedELement = [packagedElement.attrib for packagedElement in root.iter(category)]
        for num in berdasarkanPackagedELement:
          a1 = num[self.xmi_id]
          b1 = num['name']
          d1 = num[self.xmi_type]
          hasil.append([a1, b1, d1])

        paketElemen = pd.DataFrame(hasil, columns=['id', 'name', 'type'])
        return paketElemen

      except OSError as err:
        print("OS error: {0}".format(err))

    def dataExtend(self, category = 'extend'):
      try:
        hasil = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        berdasarkanExtend = [packagedElement.attrib for packagedElement in root.iter(category)]
        for num in berdasarkanExtend:
          a1 = num[self.xmi_id]
          b1 = num[self.xmi_type]
          c1 = num['extendedCase']
          d1 = paketElemen[paketElemen['id'] == c1].iloc[0]['name']
          e1 = num['extension']
          f1 = paketElemen[paketElemen['id'] == e1].iloc[0]['name']
          hasil.append([a1, b1, c1, d1, e1, f1])
          
        extendTable = pd.DataFrame(hasil, columns=['id', 'type', 'source', 'sourceName', 'destination', 'destinationName'])
        return extendTable
      except OSError as err:
        print("OS error: {0}".format(err))

    def dataInclude(self, category = 'include'):
      try:
        hasil = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        byinclude = [packagedElement.attrib for packagedElement in root.iter(category)]
        for num in byinclude:
          a1 = num['{http://schema.omg.org/spec/XMI/2.1}id']
          b1 = num['{http://schema.omg.org/spec/XMI/2.1}type']
          c1 = num['includingCase']
          d1 = paketElemen[paketElemen['id'] == c1].iloc[0]['name']
          e1 = num['addition']
          f1 = paketElemen[paketElemen['id'] == e1].iloc[0]['name']
          hasil.append([a1, b1, c1, d1, e1, f1])
        includeTable = pd.DataFrame(hasil, columns= ['id', 'tipe', 'include', 'includeName', 'addition', 'additionName'])
        return includeTable        
      except OSError as err:
        print("OS error: {0}".format(err))

    def dataOwnedEnd(self, category = 'ownedEnd'):
      try:
        # berdasarkan ownedEnd
        hasil = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        berdasarkanOwnedEnd = [packagedElement.attrib for packagedElement in root.iter(category)]
        berdasarkanOwnedEnd
        for num in berdasarkanOwnedEnd:
          a1 = num['type']
          b1 = num[self.xmi_id]
          c1 = num[self.xmi_type]
          d1 = paketElemen[paketElemen['id'] == a1].iloc[0]['name']
          hasil.append([a1, b1, c1, d1])
          
        ownedEndTable = pd.DataFrame(hasil, columns=['id_data', 'id_property', 'type_property', 'id_name'])
        return ownedEndTable
      except OSError as err:
        print("OS error: {0}".format(err))


    def dataOwnedMember(self, category = 'ownedMember'):
      try:
        # berdasarkan UML Model
        hasilNum = []
        tree1 = ET.parse(self.namaFile)
        root = tree1.getroot()
        berdasarkanOwnedMember = [packagedElement for packagedElement in root.iter(category)]
        for num in berdasarkanOwnedMember:
          a = num.attrib[self.xmi_id]
          b = num.attrib[self.xmi_type]
          for index, angka in enumerate(num.iter('ownedEnd')):
            if index == 0:
              c = paketElemen[paketElemen['id'] == angka.attrib['type']].iloc[0]['name']
            else:
              d = paketElemen[paketElemen['id'] == angka.attrib['type']].iloc[0]['name']
          hasilNum.append([a, b, c, d])

        ownedMemberTable = pd.DataFrame(hasilNum, columns=['id', 'type_property', 'actor', 'usecase'])
        return ownedMemberTable  
      except OSError as err:
        print("OS error: {0}".format(err))

    def __del__(self):
        print ('Destructor called.')    

if __name__ == "__main__":
  try:
      t0 = time()
      # myXmlParser = xmlParser(filename= 'IRCI_Topic.xmi')
      # myXmlParser = xmlParser(filename= 'IRCI_Researcher.xmi')
      # myXmlParser = xmlParser(filename= 'rAnalyzerUC.xmi')
      myXmlParser = xmlParser()
      paketElemen = myXmlParser.dataPaketElemen()
      extendTable = myXmlParser.dataExtend()
      ownedEndTable = myXmlParser.dataOwnedEnd()
      ownedMemberTable = myXmlParser.dataOwnedMember()
  
      """# Modul 1
      Parsing file xmi menjadi tabel2 (daftar aktor, daftar use case, dan relasi antara actor use case dan antar use case)
      """
      print("actorTable")
      actorTable = paketElemen[paketElemen['type'] == 'uml:Actor']
      print(tabulate(actorTable, headers = 'keys', tablefmt = 'psql'))

      print("\nuseCaseTable")
      useCaseTable = paketElemen[paketElemen['type'] == 'uml:UseCase']
      print(tabulate(useCaseTable, headers = 'keys', tablefmt = 'psql'))

      print("\nextendTable")
      print(tabulate(extendTable, headers = 'keys', tablefmt = 'psql'))


      print("\nassociationTable")
      print(tabulate(ownedMemberTable, headers = 'keys', tablefmt = 'psql'))

      print("\npropertyTable")
      print(tabulate(ownedEndTable, headers = 'keys', tablefmt = 'psql'))

      #untuk extend - data researcher dan topic
      hasilAktor = []
      hasilDestinasi = []

      for idx, num in enumerate(extendTable.sourceName):
        c = ownedMemberTable[ownedMemberTable['usecase'] == extendTable.sourceName[idx]]
        if len(c) > 0:
          for aktor in c.actor:
            hasilAktor.append(aktor)
            hasilDestinasi.append(extendTable.destinationName[idx])
        else:
          temp = 2
          d = ownedMemberTable[ownedMemberTable['usecase'] == extendTable.sourceName[idx-temp]]
          for dAktor in d.actor:
            hasilAktor.append(dAktor)
            hasilDestinasi.append(extendTable.destinationName[idx])

      df_a = pd.DataFrame([hasilAktor, hasilDestinasi], index= ['actor', 'action']).T
      df_a['actor'] = df_a.groupby(['action'])['actor'].transform(lambda x: ';'.join(x))
      df_a = df_a[['action','actor']].drop_duplicates()
      df_a['actor'][0] = set(df_a['actor'][0].split(";")) # fungsi ini digunakan untuk menyempurnakan format
      df_a['actor'][0] = ";".join(df_a['actor'][0])
      ownedMemberTable.rename(columns = {'usecase':'action'}, inplace = True)
      dt_b = pd.concat([df_a, ownedMemberTable])
      dt_actor_action = dt_b.drop(['id', 'type_property'], axis= 1)
      dt_actor_action['actor'] = dt_actor_action.groupby(['action'])['actor'].transform(lambda x: ';'.join(x))
      dt_actor_action = dt_actor_action[['action','actor']].drop_duplicates()
      print("\nactorActionTable")
      print(tabulate(dt_actor_action, headers = 'keys', tablefmt = 'psql'))

      # print("\nincludeTable")
      # print(tabulate(includeTable, headers = 'keys', tablefmt = 'psql'))

      # # untuk include  data ranalyzer
      # hasilAktor = []
      # hasilDestinasi = []
      # for idy, angka in enumerate(includeTable.includeName):
      #   f = ownedMemberTable[ownedMemberTable.usecase == includeTable.includeName[idy]]
      #   if len(f) > 0:
      #     for aktor in f.actor:
      #       hasilAktor.append(aktor)
      #       hasilDestinasi.append(includeTable.additionName[idy])
      #   else:
      #     tempY = 2
      #     g = ownedMemberTable[ownedMemberTable.usecase == includeTable.includeName[idy-tempY]]
      #     for dAktor in g.actor:
      #       hasilAktor.append(dAktor)
      #       hasilDestinasi.append(includeTable.additionName[idy])

      # df_a = pd.DataFrame([hasilAktor, hasilDestinasi], index= ['actor', 'action']).T
      # df_a['actor'] = df_a.groupby(['action'])['actor'].transform(lambda x: ';'.join(x))
      # df_a = df_a[['action','actor']].drop_duplicates()
      # df_a['actor'][0] = set(df_a['actor'][0].split(";")) # fungsi ini digunakan untuk menyempurnakan format
      # df_a['actor'][0] = ";".join(df_a['actor'][0])
      # ownedMemberTable.rename(columns = {'usecase':'action'}, inplace = True)
      # dt_b = pd.concat([df_a, ownedMemberTable])
      # dt_actor_action = dt_b.drop(['id', 'type_property'], axis= 1)
      # print("\nactorActionTable")
      # print(tabulate(dt_actor_action, headers = 'keys', tablefmt = 'psql'))      
      print("done in %0.3fs." % (time() - t0))
      input('Press ENTER to exit') 

      myXmlParser.__del__()

  except OSError as err:
      print("OS error: {0}".format(err))


