"use strict";
// Copyright (c) Binh Vu
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
class SlowTunnelModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SlowTunnelModel.model_name, _model_module: SlowTunnelModel.model_module, _model_module_version: SlowTunnelModel.model_module_version, _view_name: SlowTunnelModel.view_name, _view_module: SlowTunnelModel.view_module, _view_module_version: SlowTunnelModel.view_module_version, py_endpoint: [0, ''], js_endpoint: [0, ''] });
    }
}
exports.SlowTunnelModel = SlowTunnelModel;
SlowTunnelModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
SlowTunnelModel.model_name = 'SlowTunnelModel';
SlowTunnelModel.model_module = version_1.MODULE_NAME;
SlowTunnelModel.model_module_version = version_1.MODULE_VERSION;
SlowTunnelModel.view_name = 'SlowTunnelView'; // Set to null if no view
SlowTunnelModel.view_module = version_1.MODULE_NAME; // Set to null if no view
SlowTunnelModel.view_module_version = version_1.MODULE_VERSION;
class SlowTunnelView extends base_1.DOMWidgetView {
    constructor() {
        super(...arguments);
        this.onReceiveHandler = defaultCallbackHandler;
    }
    render() {
        // do not display this in the dom
        this.el.classList.add('ipycallback');
        // listen to the change from the server for this variable
        this.model.on('change:js_endpoint', this.receive_msg, this);
        // register this view to the global variable.
        if (window.IPyCallback === undefined) {
            window.IPyCallback = new Map();
        }
        window.IPyCallback.set(this.model.model_id, this);
    }
    send_msg(msg) {
        let py_endpoint = this.model.get('py_endpoint');
        let version = py_endpoint[0] + 1;
        this.model.set('py_endpoint', [version, msg]);
        this.model.save_changes();
        return version;
    }
    send_msg_with_version(version, msg) {
        let py_endpoint = this.model.get('py_endpoint');
        if (version > py_endpoint[0]) {
            this.model.set('py_endpoint', [version, msg]);
            this.model.save_changes();
        }
    }
    receive_msg() {
        var value = this.model.get('js_endpoint');
        this.onReceiveHandler(value[0], value[1]);
    }
    on_receive(callback) {
        this.onReceiveHandler = callback;
    }
}
exports.SlowTunnelView = SlowTunnelView;
function defaultCallbackHandler(version, msg) {
}
//# sourceMappingURL=widget.js.map