import logging
import socket
from collections import defaultdict
from xml.etree import cElementTree as ET

# these utils were taken from ovos_utils


LOG = logging.getLogger("HiveMind-presence")
LOG.setLevel("DEBUG")


def get_ip():
    # taken from https://stackoverflow.com/a/28950776/13703283
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        # doesn't even have to be reachable
        s.connect(('10.255.255.255', 1))
        IP = s.getsockname()[0]
    except Exception:
        IP = '127.0.0.1'
    finally:
        s.close()
    return IP


def etree2dict(t):
    d = {t.tag: {} if t.attrib else None}
    children = list(t)
    if children:
        dd = defaultdict(list)
        for dc in map(etree2dict, children):
            for k, v in dc.items():
                dd[k].append(v)
        d = {t.tag: {k: v[0] if len(v) == 1 else v for k, v in dd.items()}}
    if t.attrib:
        d[t.tag].update((k, v) for k, v in t.attrib.items())
    if t.text:
        text = t.text.strip()
        if children or t.attrib:
            if text:
                d[t.tag]['text'] = text
        else:
            d[t.tag] = text
    return d


def xml2dict(xml_string):
    try:
        xml_string = xml_string.replace('xmlns="http://www.w3.org/1999/xhtml"',
                                        "")
        e = ET.XML(xml_string)
        d = etree2dict(e)
        return d
    except:
        return {}
