"""
    local-api

    local api for linksaas desktop  # noqa: E501

    The version of the OpenAPI document: 0.1.2
    Contact: panleiming@linksaas.pro
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from linksaas_local_api.api_client import ApiClient, Endpoint as _Endpoint
from linksaas_local_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from linksaas_local_api.model.err_info import ErrInfo
from linksaas_local_api.model.event_info import EventInfo
from linksaas_local_api.model.project_project_id_task_all_get200_response import ProjectProjectIdTaskAllGet200Response
from linksaas_local_api.model.task_info import TaskInfo


class ProjectTaskApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.project_project_id_task_all_get_endpoint = _Endpoint(
            settings={
                'response_type': (ProjectProjectIdTaskAllGet200Response,),
                'auth': [],
                'endpoint_path': '/project/{projectId}/task/all',
                'operation_id': 'project_project_id_task_all_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'access_token',
                    'offset',
                    'limit',
                ],
                'required': [
                    'project_id',
                    'access_token',
                    'offset',
                    'limit',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'offset',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('offset',): {

                        'inclusive_minimum': 0,
                    },
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'access_token':
                        (str,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'access_token': 'accessToken',
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'project_id': 'path',
                    'access_token': 'query',
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_task_my_get_endpoint = _Endpoint(
            settings={
                'response_type': ([TaskInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/task/my',
                'operation_id': 'project_project_id_task_my_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'access_token',
                    'state',
                ],
                'required': [
                    'project_id',
                    'access_token',
                    'state',
                ],
                'nullable': [
                ],
                'enum': [
                    'state',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('state',): {

                        "ALL": "all",
                        "CLOSED": "closed",
                        "UNCLOSE": "unclose"
                    },
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'access_token':
                        (str,),
                    'state':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'access_token': 'accessToken',
                    'state': 'state',
                },
                'location_map': {
                    'project_id': 'path',
                    'access_token': 'query',
                    'state': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_task_record_task_id_events_get_endpoint = _Endpoint(
            settings={
                'response_type': ([EventInfo],),
                'auth': [],
                'endpoint_path': '/project/{projectId}/task/record/{taskId}/events',
                'operation_id': 'project_project_id_task_record_task_id_events_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'task_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'task_id': 'taskId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'task_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_task_record_task_id_short_note_get_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/project/{projectId}/task/record/{taskId}/shortNote',
                'operation_id': 'project_project_id_task_record_task_id_short_note_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'task_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'task_id': 'taskId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'task_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.project_project_id_task_record_task_id_show_get_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/project/{projectId}/task/record/{taskId}/show',
                'operation_id': 'project_project_id_task_record_task_id_show_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'required': [
                    'project_id',
                    'task_id',
                    'access_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'task_id':
                        (str,),
                    'access_token':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'task_id': 'taskId',
                    'access_token': 'accessToken',
                },
                'location_map': {
                    'project_id': 'path',
                    'task_id': 'path',
                    'access_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def project_project_id_task_all_get(
        self,
        project_id,
        access_token,
        offset,
        limit,
        **kwargs
    ):
        """所有任务  # noqa: E501

        列出所有任务  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_task_all_get(project_id, access_token, offset, limit, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            access_token (str): 访问令牌
            offset (int): 列表偏移
            limit (int): 列表大小

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProjectProjectIdTaskAllGet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['access_token'] = \
            access_token
        kwargs['offset'] = \
            offset
        kwargs['limit'] = \
            limit
        return self.project_project_id_task_all_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_task_my_get(
        self,
        project_id,
        access_token,
        state="all",
        **kwargs
    ):
        """指派给我的任务  # noqa: E501

        列出指派给我的任务  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_task_my_get(project_id, access_token, state="all", async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            access_token (str): 访问令牌
            state (str): defaults to "all", must be one of ["all"]

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TaskInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['access_token'] = \
            access_token
        kwargs['state'] = \
            state
        return self.project_project_id_task_my_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_task_record_task_id_events_get(
        self,
        project_id,
        task_id,
        access_token,
        **kwargs
    ):
        """任务相关事件  # noqa: E501

        列出任务相关事件  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_task_record_task_id_events_get(project_id, task_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            task_id (str): 任务ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [EventInfo]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['task_id'] = \
            task_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_task_record_task_id_events_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_task_record_task_id_short_note_get(
        self,
        project_id,
        task_id,
        access_token,
        **kwargs
    ):
        """便签方式显示任务  # noqa: E501

        便签方式显示任务  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_task_record_task_id_short_note_get(project_id, task_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            task_id (str): 任务ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['task_id'] = \
            task_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_task_record_task_id_short_note_get_endpoint.call_with_http_info(**kwargs)

    def project_project_id_task_record_task_id_show_get(
        self,
        project_id,
        task_id,
        access_token,
        **kwargs
    ):
        """显示任务  # noqa: E501

        显示任务  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.project_project_id_task_record_task_id_show_get(project_id, task_id, access_token, async_req=True)
        >>> result = thread.get()

        Args:
            project_id (str): 项目ID
            task_id (str): 任务ID
            access_token (str): 访问令牌

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['project_id'] = \
            project_id
        kwargs['task_id'] = \
            task_id
        kwargs['access_token'] = \
            access_token
        return self.project_project_id_task_record_task_id_show_get_endpoint.call_with_http_info(**kwargs)

