from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, ArrayType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DataRequirementSchema:
    """
    Describes a required data item for evaluation in terms of the type of data,
    and optional code or date-based filters of the data.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Describes a required data item for evaluation in terms of the type of data,
        and optional code or date-based filters of the data.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        type: The type of the required data, specified as the type name of a resource. For
            profiles, this value is set to the type of the base resource of the profile.

        profile: The profile of the required data, specified as the uri of the profile
            definition.

        mustSupport: Indicates that specific elements of the type are referenced by the knowledge
            module and must be supported by the consumer in order to obtain an effective
            evaluation. This does not mean that a value is required for this element, only
            that the consuming system must understand the element and be able to provide
            values for it if they are available. Note that the value for this element can
            be a path to allow references to nested elements. In that case, all the
            elements along the path must be supported.

        codeFilter: Code filters specify additional constraints on the data, specifying the value
            set of interest for a particular element of the data.

        dateFilter: Date filters specify additional constraints on the data in terms of the
            applicable date range for specific elements.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.datarequirement_codefilter import (
            DataRequirement_CodeFilterSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.datarequirement_datefilter import (
            DataRequirement_DateFilterSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("DataRequirement") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DataRequirement"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The type of the required data, specified as the type name of a resource. For
                # profiles, this value is set to the type of the base resource of the profile.
                StructField("type", StringType(), True),
                # The profile of the required data, specified as the uri of the profile
                # definition.
                # Indicates that specific elements of the type are referenced by the knowledge
                # module and must be supported by the consumer in order to obtain an effective
                # evaluation. This does not mean that a value is required for this element, only
                # that the consuming system must understand the element and be able to provide
                # values for it if they are available. Note that the value for this element can
                # be a path to allow references to nested elements. In that case, all the
                # elements along the path must be supported.
                # Code filters specify additional constraints on the data, specifying the value
                # set of interest for a particular element of the data.
                StructField(
                    "codeFilter",
                    ArrayType(
                        DataRequirement_CodeFilterSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Date filters specify additional constraints on the data in terms of the
                # applicable date range for specific elements.
                StructField(
                    "dateFilter",
                    ArrayType(
                        DataRequirement_DateFilterSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
