[![](https://img.shields.io/pypi/v/foliantcontrib.dbmldoc.svg)](https://pypi.org/project/foliantcontrib.dbmldoc/)  [![](https://img.shields.io/github/v/tag/foliant-docs/foliantcontrib.dbmldoc.svg?label=GitHub)](https://github.com/foliant-docs/foliantcontrib.dbmldoc)

# DBML Docs Generator for Foliant

This preprocessor generates Markdown documentation from [DBML](https://www.dbml.org/) specification files . It uses [PyDBML](https://github.com/Vanderhoof/PyDBML) for parsing DBML syntax and [Jinja2](http://jinja.pocoo.org/) templating engine for generating Markdown.

## Installation

```bash
$ pip install foliantcontrib.dbmldoc
```

## Config

To enable the preprocessor, add `dbmldoc` to `preprocessors` section in the project config:

```yaml
preprocessors:
    - dbmldoc
```

The preprocessor has a number of options:

```yaml
preprocessors:
    - dbmldoc:
        spec_url: http://localhost/scheme.dbml
        spec_path: scheme.dbml
        doc: true
        chart: true
        template: dbml.j2
        scheme_template: scheme.j2

```

`spec_url`
:    URL to DBML spec file. If it is a list — preprocessor uses the first url which works.

`spec_path`
:    Local path to DBML spec file (relative to project dir).

> If both url and path params are specified — preprocessor first tries to fetch spec from url, and only if that fails looks for the file on the local path.

`doc`
:   If `true` — documentation will be generated. Set to `false` if you only want to draw a scheme of the database. Default `true`

`scheme`
:   If `true` — the platuml code for database scheme will be generated. Default `true`

`template`
:   Path to jinja-template for rendering the generated documentation. Path is relative to the project directory. If no template is specified preprocessor will use default template (and put it into project dir if it was missing). Default: `dbml.j2`

`scheme_template`
:   Path to jinja-template for generating planuml code for the database scheme. Path is relative to the project directory. If no template is specified preprocessor will use default template (and put it into project dir if it was missing). Default: `scheme.j2`

## Usage

Add a `<dbmldoc></dbmldoc>` tag at the position in the document where the generated documentation should be inserted:

```html
# Introduction

This document contains the automatically generated documentation of our Database schema.

<dbmldoc></dbmldoc>
```

Each time the preprocessor encounters the tag `<dbmldoc></dbmldoc>` it inserts the whole generated documentation text instead of it. The path or url to DBML spec file is taken from foliant.yml.

You can also override some parameters (or all of them) in the tag options:

```markdown
# Introduction

Introduction text for API documentation.

<dbmldoc spec_url="http://localhost/schema.dbml"
         template="dbml.j2"
         scheme="false">
</dbmldoc>

# Database scheme

And here goes a visual diagram of our database:

<dbmldoc doc="false" scheme="true">
</dbmldoc>
```

> Note that template path in tag is stated **relative to the markdown file**.

Tag parameters have the highest priority.

This way you can put your database description in one place and its diagram in the other (like in the example above). Or you can even have documentation from several different DBML spec files in one Foliant project.

## Customizing output

The output markdown is generated by the [Jinja2](http://jinja.pocoo.org/) template. Inside the template all data from the parsed DBML file is available under the `data` variable. It is in fact a `PyDBMLParseResults` object, as returned by [PyDBML](https://github.com/Vanderhoof/PyDBML) (see the docs to find out which attributes are available).

To customize the output create a template which suits your needs. Then supply the path to it in the `template` parameter. Same goes for the scheme template, which is defined in the `scheme_template` parameter.

If you wish to use the default template as a starting point, build the foliant project with `dbmldoc` preprocessor turned on. After the first build the default templates will appear in your foliant project dir under the names `dbml.j2` and `scheme.j2`.
