import { ReactWidget } from '@jupyterlab/apputils';
import React, { useState, useEffect } from 'react';
/**
 * React component for a settings widget.
 *
 * @returns The React component
 */
const SettingsComponent = props => {
    const { settings, idSettings } = props;
    const [properties, setProperties] = useState(new Array());
    useEffect(() => {
        settings.load(idSettings)
            .then(setting => {
            const aux = setting.schema.properties;
            const values = new Array();
            Object.keys(aux).map(k => {
                const prop = {
                    key: k,
                    title: aux[k].title,
                    description: aux[k].description,
                    type: aux[k].type.toString(),
                    default: aux[k].default,
                    value: setting.get(k).composite,
                    save: (value) => { setting.set(k, value); },
                };
                values.push(prop);
            });
            setProperties(values);
        }).catch(err => console.log(err));
    }, []);
    const submit = (e) => {
        e.preventDefault();
        properties.forEach((prop, i) => {
            let value = "";
            switch (prop.type) {
                case "string": { }
                case "number": {
                    value = e.target[i].value;
                    break;
                }
                case "null": {
                    if (e.target[i].value == "null")
                        value = null;
                    else
                        value = e.target[i].value;
                    break;
                }
                case "boolean": {
                    value = e.target[i].checked;
                    break;
                }
                case "array": {
                    value = e.target[i].value.substring(1, e.target[i].value.length - 1).split(", ");
                    break;
                }
                case "object": {
                    value = JSON.parse(e.target[i].value);
                    break;
                }
                default: {
                    value = e.target[i].value.toString();
                    break;
                }
            }
            if (prop.value != value) {
                prop.value = value;
                prop.save(prop.value);
            }
        });
    };
    const typeInput = (prop) => {
        switch (prop.type) {
            case "string": { }
            case "null": {
                return (React.createElement("input", { className: "lm-CommandPalette-input p-CommandPalette-input", name: "text", type: prop.type, defaultValue: prop.value.toString() }));
            }
            case "boolean": {
                return (React.createElement("input", { className: "lm-CommandPalette-input p-CommandPalette-input", name: "checkbox", type: prop.type, defaultValue: prop.value.toString(), value: prop.title }));
            }
            case "number": {
                return (React.createElement("input", { className: "lm-CommandPalette-input p-CommandPalette-input", name: "number", type: prop.type, defaultValue: prop.value.toString() }));
            }
            case "array": { }
            case "object": { }
            default: {
                return (React.createElement("input", { className: "lm-CommandPalette-input p-CommandPalette-input", name: "textarea", type: prop.type, defaultValue: prop.value.toString() }));
            }
        }
    };
    return (React.createElement("form", { className: "jp-Launcher-content", onSubmit: submit },
        properties.map(prop => (React.createElement("div", { key: prop.key, className: "jp-Launcher-section" },
            React.createElement("div", { className: "jp-Launcher-sectionHeader" },
                React.createElement("span", { className: "jp-Launcher-sectionTitle" }, prop.title)),
            React.createElement("pre", { className: "jp-About-body" }, prop.description),
            React.createElement("div", { className: "jp-Launcher-cardContainer" },
                React.createElement("div", { className: "bp3-input-group jp-extensionmanager-search-wrapper jp-InputGroup", style: { width: "100%" } }, typeInput(prop)))))),
        React.createElement("button", { className: "bp3-button jp-Button", type: "submit" }, "Save")));
};
/**
 * A SettingsWidget Lumino Widget that wraps a SettingsComponent.
 */
export default class SettingsWidget extends ReactWidget {
    /**
     * Constructs a new Settings.
     */
    constructor(settings, idSettings) {
        super();
        this.settings = settings;
        this.idSettings = idSettings;
        this.addClass('jp-ReactWidget');
    }
    render() {
        return React.createElement(SettingsComponent, { settings: this.settings, idSettings: this.idSettings });
    }
}
