import { IStatusBar } from '@jupyterlab/statusbar';
import StatusMaster from './status';
export const master = {
    id: 'jupyterlab-ros/master',
    autoStart: true,
    requires: [IStatusBar],
    optional: [],
    activate: (app, statusBar) => {
        if (!statusBar) {
            console.log("No status bar!");
            return;
        }
        statusBar.registerStatusItem('jupyterlab-ros/master:status', {
            item: new StatusMaster(),
            align: 'left',
            rank: 4,
            isActive: () => true
        });
    }
};
