import { ReactWidget } from '@jupyterlab/apputils';
import * as React from 'react';
export class LogStatus extends ReactWidget {
    constructor(ros, url) {
        super();
        this.connected = false;
        this.ros = null;
        this.connect = () => { var _a; return (_a = this.ros) === null || _a === void 0 ? void 0 : _a.connect(this.url); };
        this.disconnect = () => { var _a; return (_a = this.ros) === null || _a === void 0 ? void 0 : _a.close(); };
        this.setConnected = (connected) => {
            this.connected = connected;
            this.update();
        };
        this.addClass('jp-LogConsole-toolbarLogLevel');
        this.ros = ros;
        this.url = url;
    }
    render() {
        return (React.createElement("div", { className: "main" }, this.connected ?
            React.createElement("div", { onClick: this.disconnect, className: "ok" }) :
            React.createElement("div", { onClick: this.connect, className: "ko" })));
    }
}
