import { ReactWidget } from '@jupyterlab/apputils';
import { HTMLSelect } from '@jupyterlab/ui-components';
import * as React from 'react';
export class LogNodeSwitcher extends ReactWidget {
    constructor(logConsolePanel) {
        super();
        this.logConsolePanel = null;
        this.handleChange = (event) => {
            this.topic = event.target.value;
            this.logConsolePanel.setTopic(this.topic);
            this.update();
        };
        this.handleKeyDown = (event) => {
            if (event.keyCode === 13)
                this.logConsolePanel.activate();
        };
        this.refreshNodes = (nodes) => {
            this.topics = nodes;
            this.topics.unshift('/all');
            this.update();
        };
        this.setNode = (node) => {
            if (!this.topics.includes(node))
                this.topics.push(node);
            this.update();
        };
        this.addClass('jp-LogConsole-toolbarLogLevel');
        this.logConsolePanel = logConsolePanel;
        this.topic = '/all';
        this.topics = ['/all'];
    }
    render() {
        const topics = this.topics.map(value => { return { label: value.substring(1), value }; });
        return (React.createElement(React.Fragment, null,
            React.createElement("label", null, "Node:"),
            React.createElement(HTMLSelect, { className: "jp-LogConsole-toolbarLogLevelDropdown", onChange: this.handleChange, onKeyDown: this.handleKeyDown, value: this.topic, "aria-label": "Log level", options: topics })));
    }
}
