import { defaultSanitizer } from '@jupyterlab/apputils';
import { renderText } from '@jupyterlab/rendermime';
import React, { useState } from 'react';
export const Log = (props) => {
    const { log } = props;
    const [toggled, setToggled] = useState(log.toggled);
    let level = 'debug';
    switch (log.level) {
        case 1:
            level = 'debug';
            break;
        case 2:
            level = 'info';
            break;
        case 4:
            level = 'warning';
            break;
        case 8:
            level = 'error';
            break;
        case 16:
            level = 'critical';
            break;
        default:
            level = 'info';
    }
    const open = () => {
        log.toggled = !log.toggled;
        setToggled(log.toggled);
    };
    const title = log.date.toLocaleDateString() + " " + log.date.toLocaleTimeString() + "; " + level + " level";
    const msg = document.createElement('div');
    renderText({ host: msg, sanitizer: defaultSanitizer, source: log.msg });
    return (React.createElement("a", { href: "#", onClick: open, className: "lm-Widget p-Widget lm-Panel p-Panel jp-OutputArea-child" },
        React.createElement("div", { title: title, "data-log-level": level, className: "jp-OutputArea-prompt", style: { width: "55px" } }, !toggled ?
            React.createElement("div", { style: { width: "55px" } }, log.date.toLocaleTimeString())
            :
                React.createElement("div", { style: { width: "55px" } }, log.date.toLocaleTimeString())),
        !toggled ?
            React.createElement("div", { className: "jp-RenderedText jp-OutputArea-output" },
                React.createElement("pre", null,
                    React.createElement("span", null,
                        log.name,
                        "; ",
                        log.file.split('/').pop(),
                        ":ln ",
                        log.line)),
                React.createElement("pre", null, log.msg.length < 50 ?
                    React.createElement("div", { dangerouslySetInnerHTML: { __html: msg.innerHTML } })
                    :
                        React.createElement("span", null,
                            log.msg.substr(0, 50),
                            "...")))
            :
                React.createElement("div", { className: "jp-RenderedText jp-OutputArea-output" },
                    React.createElement("table", null,
                        React.createElement("tbody", null,
                            React.createElement("tr", null,
                                React.createElement("th", null, "Node:"),
                                React.createElement("td", null, log.name)),
                            React.createElement("tr", null,
                                React.createElement("th", null, "File:"),
                                React.createElement("td", null,
                                    log.file,
                                    ":ln ",
                                    log.line)),
                            React.createElement("tr", null,
                                React.createElement("th", null, "Function:"),
                                React.createElement("td", null, log.function)),
                            React.createElement("tr", null,
                                React.createElement("th", null, "Topics:"),
                                React.createElement("td", null, log.topics)),
                            React.createElement("tr", null,
                                React.createElement("th", null, "Message:"),
                                React.createElement("td", null,
                                    React.createElement("div", { dangerouslySetInnerHTML: { __html: msg.innerHTML } }))))))));
};
export const Checkpoint = (props) => {
    const { log } = props;
    const title = log.date.toLocaleDateString() + " " + log.date.toLocaleTimeString() + "; debug level";
    return (React.createElement("div", { className: "lm-Widget p-Widget lm-Panel p-Panel jp-OutputArea-child" },
        React.createElement("div", { title: title, "data-log-level": 'debug', style: { width: "80px" }, className: "lm-Widget p-Widget jp-OutputArea-prompt" },
            React.createElement("div", null, log.date.toLocaleTimeString())),
        React.createElement("div", { className: "lm-Widget p-Widget jp-RenderedText jp-OutputArea-output" },
            React.createElement("pre", null,
                React.createElement("hr", null)))));
};
