"""
    Pinterest REST API

    Pinterest's REST API  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: pinterest-api@pinterest.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pinterestsdk.api_client import ApiClient, Endpoint as _Endpoint
from pinterestsdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pinterestsdk.model.analytics_response import AnalyticsResponse
from pinterestsdk.model.error import Error
from pinterestsdk.model.pin import Pin


class PinsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.pins_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (AnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/pins/{pin_id}/analytics',
                'operation_id': 'pins_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pin_id',
                    'start_date',
                    'end_date',
                    'metric_types',
                    'app_types',
                    'split_field',
                    'ad_account_id',
                ],
                'required': [
                    'pin_id',
                    'start_date',
                    'end_date',
                    'metric_types',
                ],
                'nullable': [
                ],
                'enum': [
                    'metric_types',
                    'app_types',
                    'split_field',
                ],
                'validation': [
                    'ad_account_id',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('metric_types',): {

                        "IMPRESSION": "IMPRESSION",
                        "SAVE": "SAVE",
                        "PIN_CLICK": "PIN_CLICK",
                        "OUTBOUND_CLICK": "OUTBOUND_CLICK",
                        "VIDEO_MRC_VIEW": "VIDEO_MRC_VIEW",
                        "VIDEO_AVG_WATCH_TIME": "VIDEO_AVG_WATCH_TIME",
                        "VIDEO_V50_WATCH_TIME": "VIDEO_V50_WATCH_TIME",
                        "QUARTILE_95_PERCENT_VIEW": "QUARTILE_95_PERCENT_VIEW"
                    },
                    ('app_types',): {

                        "ALL": "ALL",
                        "MOBILE": "MOBILE",
                        "TABLET": "TABLET",
                        "WEB": "WEB"
                    },
                    ('split_field',): {

                        "NO_SPLIT": "NO_SPLIT",
                        "APP_TYPE": "APP_TYPE"
                    },
                },
                'openapi_types': {
                    'pin_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'metric_types':
                        ([str],),
                    'app_types':
                        (str,),
                    'split_field':
                        (str,),
                    'ad_account_id':
                        (str,),
                },
                'attribute_map': {
                    'pin_id': 'pin_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'metric_types': 'metric_types',
                    'app_types': 'app_types',
                    'split_field': 'split_field',
                    'ad_account_id': 'ad_account_id',
                },
                'location_map': {
                    'pin_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'metric_types': 'query',
                    'app_types': 'query',
                    'split_field': 'query',
                    'ad_account_id': 'query',
                },
                'collection_format_map': {
                    'metric_types': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.pins_create_endpoint = _Endpoint(
            settings={
                'response_type': (Pin,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/pins',
                'operation_id': 'pins_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'pin',
                ],
                'required': [
                    'pin',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'pin':
                        (Pin,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'pin': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.pins_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/pins/{pin_id}',
                'operation_id': 'pins_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'pin_id',
                ],
                'required': [
                    'pin_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'pin_id':
                        (str,),
                },
                'attribute_map': {
                    'pin_id': 'pin_id',
                },
                'location_map': {
                    'pin_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.pins_get_endpoint = _Endpoint(
            settings={
                'response_type': (Pin,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/pins/{pin_id}',
                'operation_id': 'pins_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'pin_id',
                    'ad_account_id',
                ],
                'required': [
                    'pin_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'ad_account_id',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'pin_id':
                        (str,),
                    'ad_account_id':
                        (str,),
                },
                'attribute_map': {
                    'pin_id': 'pin_id',
                    'ad_account_id': 'ad_account_id',
                },
                'location_map': {
                    'pin_id': 'path',
                    'ad_account_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def pins_analytics(
        self,
        pin_id,
        start_date,
        end_date,
        metric_types,
        **kwargs
    ):
        """Get Pin analytics  # noqa: E501

        Get analytics for a Pin owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href=\"https://developers.pinterest.com/docs/api/v5/#operation/ad_accounts/list\">List ad accounts</a>) to use the owner of that ad_account as the \"operation user_account\". In order to do this, the token user_account must have one of the following <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a> roles on the ad_account:  - For Pins on public or protected boards: Admin, Analyst. - For Pins on secret boards: Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pins_analytics(pin_id, start_date, end_date, metric_types, async_req=True)
        >>> result = thread.get()

        Args:
            pin_id (str): Unique identifier of a Pin.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            metric_types ([str]): Pin metric types to get data for, default is all.

        Keyword Args:
            app_types (str): Apps or devices to get data for, default is all.. [optional] if omitted the server will use the default value of "ALL"
            split_field (str): How to split the data into groups. Not including this param means data won't be split.. [optional] if omitted the server will use the default value of "NO_SPLIT"
            ad_account_id (str): Unique identifier of an ad account.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['pin_id'] = \
            pin_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['metric_types'] = \
            metric_types
        return self.pins_analytics_endpoint.call_with_http_info(**kwargs)

    def pins_create(
        self,
        pin,
        **kwargs
    ):
        """Create Pin  # noqa: E501

        Create a Pin on a board or board section owned by the \"operation user_account\".  Note: If the current \"operation user_account\" (defined by the access token) has access to another user's Ad Accounts via Pinterest Business Access, you can modify your request to make use of the current operation_user_account's permissions to those Ad Accounts by including the ad_account_id in the path parameters for the request (e.g. .../?ad_account_id=12345&...).  - This function is intended solely for publishing new content created by the user. If you are interested in saving content created by others to your Pinterest boards, sometimes called 'curated content', please use our <a href='/docs/add-ons/save-button'>Save button</a> instead. For more tips on creating fresh content for Pinterest, review our <a href='/docs/solutions/content-apps'>Content App Solutions Guide</a>.  <strong><a href='/docs/solutions/content-apps/#creatingvideopins'>Learn more</a></strong> about video Pin creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pins_create(pin, async_req=True)
        >>> result = thread.get()

        Args:
            pin (Pin): Create a new Pin.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Pin
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['pin'] = \
            pin
        return self.pins_create_endpoint.call_with_http_info(**kwargs)

    def pins_delete(
        self,
        pin_id,
        **kwargs
    ):
        """Delete Pin  # noqa: E501

        Delete a Pins owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pins_delete(pin_id, async_req=True)
        >>> result = thread.get()

        Args:
            pin_id (str): Unique identifier of a Pin.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['pin_id'] = \
            pin_id
        return self.pins_delete_endpoint.call_with_http_info(**kwargs)

    def pins_get(
        self,
        pin_id,
        **kwargs
    ):
        """Get Pin  # noqa: E501

        Get a Pin owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the \"operation user_account\". In order to do this, the token user_account must have one of the following <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a> roles on the ad_account:  - For Pins on public or protected boards: Owner, Admin, Analyst, Campaign Manager. - For Pins on secret boards: Owner, Admin.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pins_get(pin_id, async_req=True)
        >>> result = thread.get()

        Args:
            pin_id (str): Unique identifier of a Pin.

        Keyword Args:
            ad_account_id (str): Unique identifier of an ad account.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Pin
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['pin_id'] = \
            pin_id
        return self.pins_get_endpoint.call_with_http_info(**kwargs)

