"""
    Pinterest REST API

    Pinterest's REST API  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: pinterest-api@pinterest.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pinterestsdk.api_client import ApiClient, Endpoint as _Endpoint
from pinterestsdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pinterestsdk.model.catalogs_feed import CatalogsFeed
from pinterestsdk.model.catalogs_feeds_create_request import CatalogsFeedsCreateRequest
from pinterestsdk.model.catalogs_feeds_update_request import CatalogsFeedsUpdateRequest
from pinterestsdk.model.catalogs_items import CatalogsItems
from pinterestsdk.model.catalogs_items_batch import CatalogsItemsBatch
from pinterestsdk.model.catalogs_items_batch_request import CatalogsItemsBatchRequest
from pinterestsdk.model.catalogs_product_group import CatalogsProductGroup
from pinterestsdk.model.catalogs_product_group_create_request import CatalogsProductGroupCreateRequest
from pinterestsdk.model.catalogs_product_group_update_request import CatalogsProductGroupUpdateRequest
from pinterestsdk.model.error import Error
from pinterestsdk.model.paginated import Paginated


class CatalogsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.catalogs_product_groups_create_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/product_groups',
                'operation_id': 'catalogs_product_groups_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalogs_product_group_create_request',
                ],
                'required': [
                    'catalogs_product_group_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalogs_product_group_create_request':
                        (CatalogsProductGroupCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'catalogs_product_group_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.catalogs_product_groups_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/product_groups/{product_group_id}',
                'operation_id': 'catalogs_product_groups_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'product_group_id',
                ],
                'required': [
                    'product_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'product_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('product_group_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'product_group_id':
                        (str,),
                },
                'attribute_map': {
                    'product_group_id': 'product_group_id',
                },
                'location_map': {
                    'product_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.catalogs_product_groups_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/product_groups',
                'operation_id': 'catalogs_product_groups_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'feed_id',
                    'bookmark',
                    'page_size',
                ],
                'required': [
                    'feed_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'feed_id',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('feed_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'feed_id':
                        (str,),
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'feed_id': 'feed_id',
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'feed_id': 'query',
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.catalogs_product_groups_update_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsProductGroup,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/product_groups/{product_group_id}',
                'operation_id': 'catalogs_product_groups_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'product_group_id',
                    'catalogs_product_group_update_request',
                ],
                'required': [
                    'product_group_id',
                    'catalogs_product_group_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'product_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('product_group_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'product_group_id':
                        (str,),
                    'catalogs_product_group_update_request':
                        (CatalogsProductGroupUpdateRequest,),
                },
                'attribute_map': {
                    'product_group_id': 'product_group_id',
                },
                'location_map': {
                    'product_group_id': 'path',
                    'catalogs_product_group_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.feed_processing_results_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds/{feed_id}/processing_results',
                'operation_id': 'feed_processing_results_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'feed_id',
                    'bookmark',
                    'page_size',
                ],
                'required': [
                    'feed_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'feed_id',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('feed_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'feed_id':
                        (str,),
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'feed_id': 'feed_id',
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'feed_id': 'path',
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.feeds_create_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsFeed,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds',
                'operation_id': 'feeds_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalogs_feeds_create_request',
                ],
                'required': [
                    'catalogs_feeds_create_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalogs_feeds_create_request':
                        (CatalogsFeedsCreateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'catalogs_feeds_create_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.feeds_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds/{feed_id}',
                'operation_id': 'feeds_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'feed_id',
                ],
                'required': [
                    'feed_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'feed_id',
                ]
            },
            root_map={
                'validations': {
                    ('feed_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'feed_id':
                        (str,),
                },
                'attribute_map': {
                    'feed_id': 'feed_id',
                },
                'location_map': {
                    'feed_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.feeds_get_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsFeed,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds/{feed_id}',
                'operation_id': 'feeds_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'feed_id',
                ],
                'required': [
                    'feed_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'feed_id',
                ]
            },
            root_map={
                'validations': {
                    ('feed_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'feed_id':
                        (str,),
                },
                'attribute_map': {
                    'feed_id': 'feed_id',
                },
                'location_map': {
                    'feed_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.feeds_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds',
                'operation_id': 'feeds_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.feeds_update_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsFeed,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/feeds/{feed_id}',
                'operation_id': 'feeds_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'feed_id',
                    'catalogs_feeds_update_request',
                ],
                'required': [
                    'feed_id',
                    'catalogs_feeds_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'feed_id',
                ]
            },
            root_map={
                'validations': {
                    ('feed_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'feed_id':
                        (str,),
                    'catalogs_feeds_update_request':
                        (CatalogsFeedsUpdateRequest,),
                },
                'attribute_map': {
                    'feed_id': 'feed_id',
                },
                'location_map': {
                    'feed_id': 'path',
                    'catalogs_feeds_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.items_batch_get_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsItemsBatch,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/items/batch/{batch_id}',
                'operation_id': 'items_batch_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'batch_id',
                ],
                'required': [
                    'batch_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'batch_id':
                        (str,),
                },
                'attribute_map': {
                    'batch_id': 'batch_id',
                },
                'location_map': {
                    'batch_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.items_batch_post_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsItemsBatch,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/items/batch',
                'operation_id': 'items_batch_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalogs_items_batch_request',
                ],
                'required': [
                    'catalogs_items_batch_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalogs_items_batch_request':
                        (CatalogsItemsBatchRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'catalogs_items_batch_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.items_get_endpoint = _Endpoint(
            settings={
                'response_type': (CatalogsItems,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/catalogs/items',
                'operation_id': 'items_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'country',
                    'item_ids',
                    'language',
                ],
                'required': [
                    'country',
                    'item_ids',
                    'language',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'country':
                        (str,),
                    'item_ids':
                        ([str],),
                    'language':
                        (str,),
                },
                'attribute_map': {
                    'country': 'country',
                    'item_ids': 'item_ids',
                    'language': 'language',
                },
                'location_map': {
                    'country': 'query',
                    'item_ids': 'query',
                    'language': 'query',
                },
                'collection_format_map': {
                    'item_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def catalogs_product_groups_create(
        self,
        catalogs_product_group_create_request,
        **kwargs
    ):
        """Create product group  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Create product group to use in Catalogs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.catalogs_product_groups_create(catalogs_product_group_create_request, async_req=True)
        >>> result = thread.get()

        Args:
            catalogs_product_group_create_request (CatalogsProductGroupCreateRequest): Request object used to created a catalogs product group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['catalogs_product_group_create_request'] = \
            catalogs_product_group_create_request
        return self.catalogs_product_groups_create_endpoint.call_with_http_info(**kwargs)

    def catalogs_product_groups_delete(
        self,
        product_group_id,
        **kwargs
    ):
        """Delete product group  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Delete a product group from being in use in Catalogs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.catalogs_product_groups_delete(product_group_id, async_req=True)
        >>> result = thread.get()

        Args:
            product_group_id (str): Unique identifier of a product group

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['product_group_id'] = \
            product_group_id
        return self.catalogs_product_groups_delete_endpoint.call_with_http_info(**kwargs)

    def catalogs_product_groups_list(
        self,
        feed_id,
        **kwargs
    ):
        """Get product groups list  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Get a list of product groups for a given Catalogs Feed Id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.catalogs_product_groups_list(feed_id, async_req=True)
        >>> result = thread.get()

        Args:
            feed_id (str): Unique identifier of a feed

        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['feed_id'] = \
            feed_id
        return self.catalogs_product_groups_list_endpoint.call_with_http_info(**kwargs)

    def catalogs_product_groups_update(
        self,
        product_group_id,
        catalogs_product_group_update_request,
        **kwargs
    ):
        """Update product group  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Update product group to use in Catalogs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.catalogs_product_groups_update(product_group_id, catalogs_product_group_update_request, async_req=True)
        >>> result = thread.get()

        Args:
            product_group_id (str): Unique identifier of a product group
            catalogs_product_group_update_request (CatalogsProductGroupUpdateRequest): Request object used to Update a catalogs product group.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsProductGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['product_group_id'] = \
            product_group_id
        kwargs['catalogs_product_group_update_request'] = \
            catalogs_product_group_update_request
        return self.catalogs_product_groups_update_endpoint.call_with_http_info(**kwargs)

    def feed_processing_results_list(
        self,
        feed_id,
        **kwargs
    ):
        """List processing results for a given feed  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Fetch a feed processing results owned by the owner user account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feed_processing_results_list(feed_id, async_req=True)
        >>> result = thread.get()

        Args:
            feed_id (str): Unique identifier of a feed

        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['feed_id'] = \
            feed_id
        return self.feed_processing_results_list_endpoint.call_with_http_info(**kwargs)

    def feeds_create(
        self,
        catalogs_feeds_create_request,
        **kwargs
    ):
        """Create feed  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Create a new feed owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_create(catalogs_feeds_create_request, async_req=True)
        >>> result = thread.get()

        Args:
            catalogs_feeds_create_request (CatalogsFeedsCreateRequest): Request object used to created a feed.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsFeed
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['catalogs_feeds_create_request'] = \
            catalogs_feeds_create_request
        return self.feeds_create_endpoint.call_with_http_info(**kwargs)

    def feeds_delete(
        self,
        feed_id,
        **kwargs
    ):
        """Delete feed  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Delete a feed owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_delete(feed_id, async_req=True)
        >>> result = thread.get()

        Args:
            feed_id (str): Unique identifier of a feed

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['feed_id'] = \
            feed_id
        return self.feeds_delete_endpoint.call_with_http_info(**kwargs)

    def feeds_get(
        self,
        feed_id,
        **kwargs
    ):
        """Get feed  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Get a single feed owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_get(feed_id, async_req=True)
        >>> result = thread.get()

        Args:
            feed_id (str): Unique identifier of a feed

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsFeed
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['feed_id'] = \
            feed_id
        return self.feeds_get_endpoint.call_with_http_info(**kwargs)

    def feeds_list(
        self,
        **kwargs
    ):
        """List feeds  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Fetch feeds owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.feeds_list_endpoint.call_with_http_info(**kwargs)

    def feeds_update(
        self,
        feed_id,
        catalogs_feeds_update_request,
        **kwargs
    ):
        """Update feed  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Update a feed owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_update(feed_id, catalogs_feeds_update_request, async_req=True)
        >>> result = thread.get()

        Args:
            feed_id (str): Unique identifier of a feed
            catalogs_feeds_update_request (CatalogsFeedsUpdateRequest): Request object used to update a feed.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsFeed
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['feed_id'] = \
            feed_id
        kwargs['catalogs_feeds_update_request'] = \
            catalogs_feeds_update_request
        return self.feeds_update_endpoint.call_with_http_info(**kwargs)

    def items_batch_get(
        self,
        batch_id,
        **kwargs
    ):
        """Get catalogs items batch  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  Get a single catalogs items batch created by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.items_batch_get(batch_id, async_req=True)
        >>> result = thread.get()

        Args:
            batch_id (str): Id of a catalogs items batch to fetch

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsItemsBatch
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['batch_id'] = \
            batch_id
        return self.items_batch_get_endpoint.call_with_http_info(**kwargs)

    def items_batch_post(
        self,
        catalogs_items_batch_request,
        **kwargs
    ):
        """Perform an operation on an item batch  # noqa: E501

        <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/api/v5/#tag/Understanding-catalog-management'>Learn more</a>.</strong>  This endpoint supports multiple operations on a set of one or more catalog items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.items_batch_post(catalogs_items_batch_request, async_req=True)
        >>> result = thread.get()

        Args:
            catalogs_items_batch_request (CatalogsItemsBatchRequest): Request object used to create catalogs items in a batch

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsItemsBatch
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['catalogs_items_batch_request'] = \
            catalogs_items_batch_request
        return self.items_batch_post_endpoint.call_with_http_info(**kwargs)

    def items_get(
        self,
        country,
        item_ids,
        language,
        **kwargs
    ):
        """Get catalogs items  # noqa: E501

        Get the items of the catalog created by the \"operating user_account\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.items_get(country, item_ids, language, async_req=True)
        >>> result = thread.get()

        Args:
            country (str): Country for the Catalogs Items
            item_ids ([str]): Catalos Item ids
            language (str): Language for the Catalogs Items

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CatalogsItems
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['country'] = \
            country
        kwargs['item_ids'] = \
            item_ids
        kwargs['language'] = \
            language
        return self.items_get_endpoint.call_with_http_info(**kwargs)

