# pinterestsdk
Pinterest's REST API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 5.3.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://developers.pinterest.com/](https://developers.pinterest.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/cliffano/pinterest-sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/cliffano/pinterest-sdk.git`)

Then import the package:
```python
import pinterestsdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pinterestsdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pinterestsdk
from pprint import pprint
from pinterestsdk.api import ad_accounts_api
from pinterestsdk.model.ad_account_analytics_response import AdAccountAnalyticsResponse
from pinterestsdk.model.ad_groups_analytics_response import AdGroupsAnalyticsResponse
from pinterestsdk.model.ads_analytics_create_async_request import AdsAnalyticsCreateAsyncRequest
from pinterestsdk.model.ads_analytics_create_async_response import AdsAnalyticsCreateAsyncResponse
from pinterestsdk.model.ads_analytics_get_async_response import AdsAnalyticsGetAsyncResponse
from pinterestsdk.model.ads_analytics_response import AdsAnalyticsResponse
from pinterestsdk.model.campaigns_analytics_response import CampaignsAnalyticsResponse
from pinterestsdk.model.error import Error
from pinterestsdk.model.granularity import Granularity
from pinterestsdk.model.paginated import Paginated
from pinterestsdk.model.product_group_analytics_response import ProductGroupAnalyticsResponse
# Defining the host is optional and defaults to https://api.pinterest.com/v5
# See configuration.py for a list of all supported configuration parameters.
configuration = pinterestsdk.Configuration(
    host = "https://api.pinterest.com/v5"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: pinterest_oauth2
configuration = pinterestsdk.Configuration(
    host = "https://api.pinterest.com/v5"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pinterestsdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ad_accounts_api.AdAccountsApi(api_client)
    ad_account_id = "4" # str | Unique identifier of an ad account.
start_date = dateutil_parser('1970-01-01').date() # date | Metric report start date (UTC). Format: YYYY-MM-DD
end_date = dateutil_parser('1970-01-01').date() # date | Metric report end date (UTC). Format: YYYY-MM-DD
columns = [
        "SPEND_IN_DOLLAR",
    ] # [str] | Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
granularity = Granularity("DAY") # Granularity | Granularity
click_window_days = 1 # int | Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days. (optional) (default to 30)
engagement_window_days = 30 # int | Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days. (optional) (default to 30)
view_window_days = 1 # int | Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day. (optional) (default to 1)
conversion_report_time = "TIME_OF_AD_ACTION" # str | The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event. (optional) (default to "TIME_OF_AD_ACTION")

    try:
        # Get ad account analytics
        api_response = api_instance.ad_account_analytics(ad_account_id, start_date, end_date, columns, granularity, click_window_days=click_window_days, engagement_window_days=engagement_window_days, view_window_days=view_window_days, conversion_report_time=conversion_report_time)
        pprint(api_response)
    except pinterestsdk.ApiException as e:
        print("Exception when calling AdAccountsApi->ad_account_analytics: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.pinterest.com/v5*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdAccountsApi* | [**ad_account_analytics**](docs/AdAccountsApi.md#ad_account_analytics) | **GET** /ad_accounts/{ad_account_id}/analytics | Get ad account analytics
*AdAccountsApi* | [**ad_accounts_list**](docs/AdAccountsApi.md#ad_accounts_list) | **GET** /ad_accounts | List ad accounts
*AdAccountsApi* | [**ad_groups_analytics**](docs/AdAccountsApi.md#ad_groups_analytics) | **GET** /ad_accounts/{ad_account_id}/ad_groups/analytics | Get ad group analytics
*AdAccountsApi* | [**ad_groups_list**](docs/AdAccountsApi.md#ad_groups_list) | **GET** /ad_accounts/{ad_account_id}/ad_groups | List ad groups
*AdAccountsApi* | [**ads_analytics**](docs/AdAccountsApi.md#ads_analytics) | **GET** /ad_accounts/{ad_account_id}/ads/analytics | Get ad analytics
*AdAccountsApi* | [**ads_list**](docs/AdAccountsApi.md#ads_list) | **GET** /ad_accounts/{ad_account_id}/ads | List ads
*AdAccountsApi* | [**analytics_create_report**](docs/AdAccountsApi.md#analytics_create_report) | **POST** /ad_accounts/{ad_account_id}/reports | Create async request for an account analytics report
*AdAccountsApi* | [**analytics_get_report**](docs/AdAccountsApi.md#analytics_get_report) | **GET** /ad_accounts/{ad_account_id}/reports | Get the account analytics report created by the async call
*AdAccountsApi* | [**campaigns_analytics**](docs/AdAccountsApi.md#campaigns_analytics) | **GET** /ad_accounts/{ad_account_id}/campaigns/analytics | Get campaign analytics
*AdAccountsApi* | [**campaigns_list**](docs/AdAccountsApi.md#campaigns_list) | **GET** /ad_accounts/{ad_account_id}/campaigns | List campaigns
*AdAccountsApi* | [**product_groups_analytics**](docs/AdAccountsApi.md#product_groups_analytics) | **GET** /ad_accounts/{ad_account_id}/product_groups/analytics | Get product group analytics
*BoardsApi* | [**board_sections_create**](docs/BoardsApi.md#board_sections_create) | **POST** /boards/{board_id}/sections | Create board section
*BoardsApi* | [**board_sections_delete**](docs/BoardsApi.md#board_sections_delete) | **DELETE** /boards/{board_id}/sections/{section_id} | Delete board section
*BoardsApi* | [**board_sections_list**](docs/BoardsApi.md#board_sections_list) | **GET** /boards/{board_id}/sections | List board sections
*BoardsApi* | [**board_sections_list_pins**](docs/BoardsApi.md#board_sections_list_pins) | **GET** /boards/{board_id}/sections/{section_id}/pins | List Pins on board section
*BoardsApi* | [**board_sections_update**](docs/BoardsApi.md#board_sections_update) | **PATCH** /boards/{board_id}/sections/{section_id} | Update board section
*BoardsApi* | [**boards_create**](docs/BoardsApi.md#boards_create) | **POST** /boards | Create board
*BoardsApi* | [**boards_delete**](docs/BoardsApi.md#boards_delete) | **DELETE** /boards/{board_id} | Delete board
*BoardsApi* | [**boards_get**](docs/BoardsApi.md#boards_get) | **GET** /boards/{board_id} | Get board
*BoardsApi* | [**boards_list**](docs/BoardsApi.md#boards_list) | **GET** /boards | List boards
*BoardsApi* | [**boards_list_pins**](docs/BoardsApi.md#boards_list_pins) | **GET** /boards/{board_id}/pins | List Pins on board
*BoardsApi* | [**boards_update**](docs/BoardsApi.md#boards_update) | **PATCH** /boards/{board_id} | Update board
*CatalogsApi* | [**catalogs_product_groups_create**](docs/CatalogsApi.md#catalogs_product_groups_create) | **POST** /catalogs/product_groups | Create product group
*CatalogsApi* | [**catalogs_product_groups_delete**](docs/CatalogsApi.md#catalogs_product_groups_delete) | **DELETE** /catalogs/product_groups/{product_group_id} | Delete product group
*CatalogsApi* | [**catalogs_product_groups_list**](docs/CatalogsApi.md#catalogs_product_groups_list) | **GET** /catalogs/product_groups | Get product groups list
*CatalogsApi* | [**catalogs_product_groups_update**](docs/CatalogsApi.md#catalogs_product_groups_update) | **PATCH** /catalogs/product_groups/{product_group_id} | Update product group
*CatalogsApi* | [**feed_processing_results_list**](docs/CatalogsApi.md#feed_processing_results_list) | **GET** /catalogs/feeds/{feed_id}/processing_results | List processing results for a given feed
*CatalogsApi* | [**feeds_create**](docs/CatalogsApi.md#feeds_create) | **POST** /catalogs/feeds | Create feed
*CatalogsApi* | [**feeds_delete**](docs/CatalogsApi.md#feeds_delete) | **DELETE** /catalogs/feeds/{feed_id} | Delete feed
*CatalogsApi* | [**feeds_get**](docs/CatalogsApi.md#feeds_get) | **GET** /catalogs/feeds/{feed_id} | Get feed
*CatalogsApi* | [**feeds_list**](docs/CatalogsApi.md#feeds_list) | **GET** /catalogs/feeds | List feeds
*CatalogsApi* | [**feeds_update**](docs/CatalogsApi.md#feeds_update) | **PATCH** /catalogs/feeds/{feed_id} | Update feed
*CatalogsApi* | [**items_batch_get**](docs/CatalogsApi.md#items_batch_get) | **GET** /catalogs/items/batch/{batch_id} | Get catalogs items batch
*CatalogsApi* | [**items_batch_post**](docs/CatalogsApi.md#items_batch_post) | **POST** /catalogs/items/batch | Perform an operation on an item batch
*CatalogsApi* | [**items_get**](docs/CatalogsApi.md#items_get) | **GET** /catalogs/items | Get catalogs items
*MediaApi* | [**media_create**](docs/MediaApi.md#media_create) | **POST** /media | Register media upload
*MediaApi* | [**media_get**](docs/MediaApi.md#media_get) | **GET** /media/{media_id} | Get media upload details
*MediaApi* | [**media_list**](docs/MediaApi.md#media_list) | **GET** /media | List media uploads
*OauthApi* | [**oauth_token**](docs/OauthApi.md#oauth_token) | **POST** /oauth/token | Generate OAuth access token
*PinsApi* | [**pins_analytics**](docs/PinsApi.md#pins_analytics) | **GET** /pins/{pin_id}/analytics | Get Pin analytics
*PinsApi* | [**pins_create**](docs/PinsApi.md#pins_create) | **POST** /pins | Create Pin
*PinsApi* | [**pins_delete**](docs/PinsApi.md#pins_delete) | **DELETE** /pins/{pin_id} | Delete Pin
*PinsApi* | [**pins_get**](docs/PinsApi.md#pins_get) | **GET** /pins/{pin_id} | Get Pin
*UserAccountApi* | [**user_account_analytics**](docs/UserAccountApi.md#user_account_analytics) | **GET** /user_account/analytics | Get user account analytics
*UserAccountApi* | [**user_account_get**](docs/UserAccountApi.md#user_account_get) | **GET** /user_account | Get user account


## Documentation For Models

 - [Account](docs/Account.md)
 - [ActionType](docs/ActionType.md)
 - [AdAccount](docs/AdAccount.md)
 - [AdAccountAnalyticsResponse](docs/AdAccountAnalyticsResponse.md)
 - [AdAccountOwner](docs/AdAccountOwner.md)
 - [AdGroupResponse](docs/AdGroupResponse.md)
 - [AdGroupResponseAllOf](docs/AdGroupResponseAllOf.md)
 - [AdGroupResponseAllOf1](docs/AdGroupResponseAllOf1.md)
 - [AdGroupSummaryStatus](docs/AdGroupSummaryStatus.md)
 - [AdGroupsAnalyticsResponse](docs/AdGroupsAnalyticsResponse.md)
 - [AdResponse](docs/AdResponse.md)
 - [AdResponseAllOf](docs/AdResponseAllOf.md)
 - [AdResponseAllOf1](docs/AdResponseAllOf1.md)
 - [AdsAnalyticsCreateAsyncRequest](docs/AdsAnalyticsCreateAsyncRequest.md)
 - [AdsAnalyticsCreateAsyncRequestAllOf](docs/AdsAnalyticsCreateAsyncRequestAllOf.md)
 - [AdsAnalyticsCreateAsyncRequestAllOf1](docs/AdsAnalyticsCreateAsyncRequestAllOf1.md)
 - [AdsAnalyticsCreateAsyncResponse](docs/AdsAnalyticsCreateAsyncResponse.md)
 - [AdsAnalyticsFilterColumn](docs/AdsAnalyticsFilterColumn.md)
 - [AdsAnalyticsFilterOperator](docs/AdsAnalyticsFilterOperator.md)
 - [AdsAnalyticsGetAsyncResponse](docs/AdsAnalyticsGetAsyncResponse.md)
 - [AdsAnalyticsMetricsFilter](docs/AdsAnalyticsMetricsFilter.md)
 - [AdsAnalyticsResponse](docs/AdsAnalyticsResponse.md)
 - [AdsAnalyticsTargetingType](docs/AdsAnalyticsTargetingType.md)
 - [AnalyticsMetricsResponse](docs/AnalyticsMetricsResponse.md)
 - [AnalyticsMetricsResponseDailyMetrics](docs/AnalyticsMetricsResponseDailyMetrics.md)
 - [AnalyticsResponse](docs/AnalyticsResponse.md)
 - [AvailabilityFilter](docs/AvailabilityFilter.md)
 - [BatchOperation](docs/BatchOperation.md)
 - [BatchOperationStatus](docs/BatchOperationStatus.md)
 - [Board](docs/Board.md)
 - [BoardOwner](docs/BoardOwner.md)
 - [BoardSection](docs/BoardSection.md)
 - [BoardUpdate](docs/BoardUpdate.md)
 - [BrandFilter](docs/BrandFilter.md)
 - [CampaignCommon](docs/CampaignCommon.md)
 - [CampaignResponse](docs/CampaignResponse.md)
 - [CampaignResponseAllOf](docs/CampaignResponseAllOf.md)
 - [CampaignResponseAllOf1](docs/CampaignResponseAllOf1.md)
 - [CampaignSummaryStatus](docs/CampaignSummaryStatus.md)
 - [CampaignsAnalyticsResponse](docs/CampaignsAnalyticsResponse.md)
 - [CatalogsDbItem](docs/CatalogsDbItem.md)
 - [CatalogsFeed](docs/CatalogsFeed.md)
 - [CatalogsFeedCredentials](docs/CatalogsFeedCredentials.md)
 - [CatalogsFeedIngestionDetails](docs/CatalogsFeedIngestionDetails.md)
 - [CatalogsFeedIngestionErrors](docs/CatalogsFeedIngestionErrors.md)
 - [CatalogsFeedIngestionInfo](docs/CatalogsFeedIngestionInfo.md)
 - [CatalogsFeedProcessingResult](docs/CatalogsFeedProcessingResult.md)
 - [CatalogsFeedProcessingResultFields](docs/CatalogsFeedProcessingResultFields.md)
 - [CatalogsFeedProcessingSchedule](docs/CatalogsFeedProcessingSchedule.md)
 - [CatalogsFeedProcessingStatus](docs/CatalogsFeedProcessingStatus.md)
 - [CatalogsFeedProductCounts](docs/CatalogsFeedProductCounts.md)
 - [CatalogsFeedValidationDetails](docs/CatalogsFeedValidationDetails.md)
 - [CatalogsFeedValidationErrors](docs/CatalogsFeedValidationErrors.md)
 - [CatalogsFeedValidationWarnings](docs/CatalogsFeedValidationWarnings.md)
 - [CatalogsFeedsCreateRequest](docs/CatalogsFeedsCreateRequest.md)
 - [CatalogsFeedsUpdateRequest](docs/CatalogsFeedsUpdateRequest.md)
 - [CatalogsFormat](docs/CatalogsFormat.md)
 - [CatalogsItems](docs/CatalogsItems.md)
 - [CatalogsItemsBatch](docs/CatalogsItemsBatch.md)
 - [CatalogsItemsBatchRequest](docs/CatalogsItemsBatchRequest.md)
 - [CatalogsProductGroup](docs/CatalogsProductGroup.md)
 - [CatalogsProductGroupCreateRequest](docs/CatalogsProductGroupCreateRequest.md)
 - [CatalogsProductGroupCurrencyCriteria](docs/CatalogsProductGroupCurrencyCriteria.md)
 - [CatalogsProductGroupFilterKeys](docs/CatalogsProductGroupFilterKeys.md)
 - [CatalogsProductGroupFilters](docs/CatalogsProductGroupFilters.md)
 - [CatalogsProductGroupFiltersAllOf](docs/CatalogsProductGroupFiltersAllOf.md)
 - [CatalogsProductGroupFiltersAnyOf](docs/CatalogsProductGroupFiltersAnyOf.md)
 - [CatalogsProductGroupMultipleStringCriteria](docs/CatalogsProductGroupMultipleStringCriteria.md)
 - [CatalogsProductGroupMultipleStringListCriteria](docs/CatalogsProductGroupMultipleStringListCriteria.md)
 - [CatalogsProductGroupPricingCriteria](docs/CatalogsProductGroupPricingCriteria.md)
 - [CatalogsProductGroupStatus](docs/CatalogsProductGroupStatus.md)
 - [CatalogsProductGroupType](docs/CatalogsProductGroupType.md)
 - [CatalogsProductGroupUpdateRequest](docs/CatalogsProductGroupUpdateRequest.md)
 - [CatalogsStatus](docs/CatalogsStatus.md)
 - [ConditionFilter](docs/ConditionFilter.md)
 - [ConversionAttributionWindowDays](docs/ConversionAttributionWindowDays.md)
 - [ConversionReportAttributionType](docs/ConversionReportAttributionType.md)
 - [ConversionReportTimeType](docs/ConversionReportTimeType.md)
 - [Country](docs/Country.md)
 - [Currency](docs/Currency.md)
 - [CurrencyFilter](docs/CurrencyFilter.md)
 - [CustomLabel0Filter](docs/CustomLabel0Filter.md)
 - [CustomLabel1Filter](docs/CustomLabel1Filter.md)
 - [CustomLabel2Filter](docs/CustomLabel2Filter.md)
 - [CustomLabel3Filter](docs/CustomLabel3Filter.md)
 - [CustomLabel4Filter](docs/CustomLabel4Filter.md)
 - [DataOutputFormat](docs/DataOutputFormat.md)
 - [EntityStatus](docs/EntityStatus.md)
 - [Error](docs/Error.md)
 - [FeedFields](docs/FeedFields.md)
 - [GenderFilter](docs/GenderFilter.md)
 - [GoogleProductCategory0Filter](docs/GoogleProductCategory0Filter.md)
 - [GoogleProductCategory1Filter](docs/GoogleProductCategory1Filter.md)
 - [GoogleProductCategory2Filter](docs/GoogleProductCategory2Filter.md)
 - [GoogleProductCategory3Filter](docs/GoogleProductCategory3Filter.md)
 - [GoogleProductCategory4Filter](docs/GoogleProductCategory4Filter.md)
 - [GoogleProductCategory5Filter](docs/GoogleProductCategory5Filter.md)
 - [GoogleProductCategory6Filter](docs/GoogleProductCategory6Filter.md)
 - [Granularity](docs/Granularity.md)
 - [ImageDetails](docs/ImageDetails.md)
 - [ItemAttributes](docs/ItemAttributes.md)
 - [ItemBatchRecord](docs/ItemBatchRecord.md)
 - [ItemGroupIdFilter](docs/ItemGroupIdFilter.md)
 - [ItemIdFilter](docs/ItemIdFilter.md)
 - [ItemProcessingRecord](docs/ItemProcessingRecord.md)
 - [ItemProcessingStatus](docs/ItemProcessingStatus.md)
 - [ItemValidationEvent](docs/ItemValidationEvent.md)
 - [Language](docs/Language.md)
 - [MaxPriceFilter](docs/MaxPriceFilter.md)
 - [MediaUpload](docs/MediaUpload.md)
 - [MediaUploadAllOf](docs/MediaUploadAllOf.md)
 - [MediaUploadAllOfUploadParameters](docs/MediaUploadAllOfUploadParameters.md)
 - [MediaUploadDetails](docs/MediaUploadDetails.md)
 - [MediaUploadRequest](docs/MediaUploadRequest.md)
 - [MediaUploadStatus](docs/MediaUploadStatus.md)
 - [MediaUploadType](docs/MediaUploadType.md)
 - [MetricsReportingLevel](docs/MetricsReportingLevel.md)
 - [MinPriceFilter](docs/MinPriceFilter.md)
 - [NonNullableCatalogsCurrency](docs/NonNullableCatalogsCurrency.md)
 - [NullableCurrency](docs/NullableCurrency.md)
 - [OauthAccessTokenRequestCode](docs/OauthAccessTokenRequestCode.md)
 - [OauthAccessTokenRequestCodeAllOf](docs/OauthAccessTokenRequestCodeAllOf.md)
 - [OauthAccessTokenRequestRefresh](docs/OauthAccessTokenRequestRefresh.md)
 - [OauthAccessTokenRequestRefreshAllOf](docs/OauthAccessTokenRequestRefreshAllOf.md)
 - [OauthAccessTokenResponse](docs/OauthAccessTokenResponse.md)
 - [OauthAccessTokenResponseCode](docs/OauthAccessTokenResponseCode.md)
 - [OauthAccessTokenResponseCodeAllOf](docs/OauthAccessTokenResponseCodeAllOf.md)
 - [OauthAccessTokenResponseRefresh](docs/OauthAccessTokenResponseRefresh.md)
 - [ObjectiveType](docs/ObjectiveType.md)
 - [PacingDeliveryType](docs/PacingDeliveryType.md)
 - [Paginated](docs/Paginated.md)
 - [Pin](docs/Pin.md)
 - [PinMedia](docs/PinMedia.md)
 - [PinMediaSource](docs/PinMediaSource.md)
 - [PinMediaSourceImageBase64](docs/PinMediaSourceImageBase64.md)
 - [PinMediaSourceImageURL](docs/PinMediaSourceImageURL.md)
 - [PinMediaSourceVideoID](docs/PinMediaSourceVideoID.md)
 - [PinMediaWithImage](docs/PinMediaWithImage.md)
 - [PinMediaWithImageAllOf](docs/PinMediaWithImageAllOf.md)
 - [PinPromotionSummaryStatus](docs/PinPromotionSummaryStatus.md)
 - [PlacementGroupType](docs/PlacementGroupType.md)
 - [ProductAvailabilityType](docs/ProductAvailabilityType.md)
 - [ProductGroupAnalyticsResponse](docs/ProductGroupAnalyticsResponse.md)
 - [ProductGroupSummaryStatus](docs/ProductGroupSummaryStatus.md)
 - [ProductType0Filter](docs/ProductType0Filter.md)
 - [ProductType1Filter](docs/ProductType1Filter.md)
 - [ProductType2Filter](docs/ProductType2Filter.md)
 - [ProductType3Filter](docs/ProductType3Filter.md)
 - [ProductType4Filter](docs/ProductType4Filter.md)
 - [ReportingColumnAsync](docs/ReportingColumnAsync.md)
 - [TargetingTypeFilter](docs/TargetingTypeFilter.md)
 - [TrackingUrls](docs/TrackingUrls.md)


## Documentation For Authorization


## basic

- **Type**: HTTP basic authentication


## pinterest_oauth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://www.pinterest.com/oauth/
- **Scopes**: 
 - **ads:read**: See all of your advertising data, including ads, ad groups, campaigns etc.
 - **ads:write**: Create, update, or delete ads, ad groups, campaigns etc.
 - **boards:read**: See your public boards, including group boards you join
 - **boards:read_secret**: See your secret boards
 - **boards:write**: Create, update, or delete your public boards
 - **boards:write_secret**: Create, update, or delete your secret boards
 - **catalogs:read**: See all of your catalogs data
 - **catalogs:write**: Create, update, or delete your catalogs data
 - **pins:read**: See your public Pins
 - **pins:read_secret**: See your secret Pins
 - **pins:write**: Create, update, or delete your public Pins
 - **pins:write_secret**: Create, update, or delete your secret Pins
 - **user_accounts:read**: See your user accounts


## Author

pinterest-api@pinterest.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pinterestsdk.apis and pinterestsdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pinterestsdk.api.default_api import DefaultApi`
- `from pinterestsdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pinterestsdk
from pinterestsdk.apis import *
from pinterestsdk.models import *
```

