import torch

import torch_bsf as tb


def test_indices():
    for i in tb.bezier_simplex.indices(1, 1):
        assert i == (1,)


def test_fit():
    ts = torch.tensor(  # parameters on a simplex
        [
            [3/3, 0/3, 0/3],
            [2/3, 1/3, 0/3],
            [2/3, 0/3, 1/3],
            [1/3, 2/3, 0/3],
            [1/3, 1/3, 1/3],
            [1/3, 0/3, 2/3],
            [0/3, 3/3, 0/3],
            [0/3, 2/3, 1/3],
            [0/3, 1/3, 2/3],
            [0/3, 0/3, 3/3],
        ]
    )
    xs = 1 - ts * ts  # values corresponding to the parameters

    # Train a model
    bs = tb.fit(params=ts, values=xs, degree=3)

    # Predict by the trained model
    t = [[0.2, 0.3, 0.5]]
    x = bs(t)
    print(f"{t} -> {x}")
