# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'HoursOfOperationConfigArgs',
    'HoursOfOperationTagArgs',
    'HoursOfOperationTimeSliceArgs',
    'QuickConnectConfigArgs',
    'QuickConnectPhoneNumberQuickConnectConfigArgs',
    'QuickConnectQueueQuickConnectConfigArgs',
    'QuickConnectTagArgs',
    'QuickConnectUserQuickConnectConfigArgs',
    'UserIdentityInfoArgs',
    'UserPhoneConfigArgs',
    'UserTagArgs',
]

@pulumi.input_type
class HoursOfOperationConfigArgs:
    def __init__(__self__, *,
                 day: pulumi.Input['HoursOfOperationConfigDay'],
                 end_time: pulumi.Input['HoursOfOperationTimeSliceArgs'],
                 start_time: pulumi.Input['HoursOfOperationTimeSliceArgs']):
        """
        Contains information about the hours of operation.
        :param pulumi.Input['HoursOfOperationConfigDay'] day: The day that the hours of operation applies to.
        :param pulumi.Input['HoursOfOperationTimeSliceArgs'] end_time: The end time that your contact center closes.
        :param pulumi.Input['HoursOfOperationTimeSliceArgs'] start_time: The start time that your contact center opens.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input['HoursOfOperationConfigDay']:
        """
        The day that the hours of operation applies to.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input['HoursOfOperationConfigDay']):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input['HoursOfOperationTimeSliceArgs']:
        """
        The end time that your contact center closes.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input['HoursOfOperationTimeSliceArgs']):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['HoursOfOperationTimeSliceArgs']:
        """
        The start time that your contact center opens.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['HoursOfOperationTimeSliceArgs']):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class HoursOfOperationTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HoursOfOperationTimeSliceArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[int],
                 minutes: pulumi.Input[int]):
        """
        The start time or end time for an hours of operation.
        :param pulumi.Input[int] hours: The hours.
        :param pulumi.Input[int] minutes: The minutes.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[int]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[int]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "minutes", value)


@pulumi.input_type
class QuickConnectConfigArgs:
    def __init__(__self__, *,
                 quick_connect_type: pulumi.Input['QuickConnectType'],
                 phone_config: Optional[pulumi.Input['QuickConnectPhoneNumberQuickConnectConfigArgs']] = None,
                 queue_config: Optional[pulumi.Input['QuickConnectQueueQuickConnectConfigArgs']] = None,
                 user_config: Optional[pulumi.Input['QuickConnectUserQuickConnectConfigArgs']] = None):
        """
        Configuration settings for the quick connect.
        """
        pulumi.set(__self__, "quick_connect_type", quick_connect_type)
        if phone_config is not None:
            pulumi.set(__self__, "phone_config", phone_config)
        if queue_config is not None:
            pulumi.set(__self__, "queue_config", queue_config)
        if user_config is not None:
            pulumi.set(__self__, "user_config", user_config)

    @property
    @pulumi.getter(name="quickConnectType")
    def quick_connect_type(self) -> pulumi.Input['QuickConnectType']:
        return pulumi.get(self, "quick_connect_type")

    @quick_connect_type.setter
    def quick_connect_type(self, value: pulumi.Input['QuickConnectType']):
        pulumi.set(self, "quick_connect_type", value)

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> Optional[pulumi.Input['QuickConnectPhoneNumberQuickConnectConfigArgs']]:
        return pulumi.get(self, "phone_config")

    @phone_config.setter
    def phone_config(self, value: Optional[pulumi.Input['QuickConnectPhoneNumberQuickConnectConfigArgs']]):
        pulumi.set(self, "phone_config", value)

    @property
    @pulumi.getter(name="queueConfig")
    def queue_config(self) -> Optional[pulumi.Input['QuickConnectQueueQuickConnectConfigArgs']]:
        return pulumi.get(self, "queue_config")

    @queue_config.setter
    def queue_config(self, value: Optional[pulumi.Input['QuickConnectQueueQuickConnectConfigArgs']]):
        pulumi.set(self, "queue_config", value)

    @property
    @pulumi.getter(name="userConfig")
    def user_config(self) -> Optional[pulumi.Input['QuickConnectUserQuickConnectConfigArgs']]:
        return pulumi.get(self, "user_config")

    @user_config.setter
    def user_config(self, value: Optional[pulumi.Input['QuickConnectUserQuickConnectConfigArgs']]):
        pulumi.set(self, "user_config", value)


@pulumi.input_type
class QuickConnectPhoneNumberQuickConnectConfigArgs:
    def __init__(__self__, *,
                 phone_number: pulumi.Input[str]):
        """
        The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.
        """
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class QuickConnectQueueQuickConnectConfigArgs:
    def __init__(__self__, *,
                 contact_flow_arn: pulumi.Input[str],
                 queue_arn: pulumi.Input[str]):
        """
        The queue configuration. This is required only if QuickConnectType is QUEUE.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "queue_arn", queue_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "contact_flow_arn")

    @contact_flow_arn.setter
    def contact_flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_flow_arn", value)

    @property
    @pulumi.getter(name="queueArn")
    def queue_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "queue_arn")

    @queue_arn.setter
    def queue_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_arn", value)


@pulumi.input_type
class QuickConnectTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class QuickConnectUserQuickConnectConfigArgs:
    def __init__(__self__, *,
                 contact_flow_arn: pulumi.Input[str],
                 user_arn: pulumi.Input[str]):
        """
        The user configuration. This is required only if QuickConnectType is USER.
        """
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        pulumi.set(__self__, "user_arn", user_arn)

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "contact_flow_arn")

    @contact_flow_arn.setter
    def contact_flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_flow_arn", value)

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "user_arn")

    @user_arn.setter
    def user_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_arn", value)


@pulumi.input_type
class UserIdentityInfoArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None):
        """
        Contains information about the identity of a user.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)


@pulumi.input_type
class UserPhoneConfigArgs:
    def __init__(__self__, *,
                 phone_type: pulumi.Input['UserPhoneType'],
                 after_contact_work_time_limit: Optional[pulumi.Input[int]] = None,
                 auto_accept: Optional[pulumi.Input[bool]] = None,
                 desk_phone_number: Optional[pulumi.Input[str]] = None):
        """
        Contains information about the phone configuration settings for a user.
        """
        pulumi.set(__self__, "phone_type", phone_type)
        if after_contact_work_time_limit is not None:
            pulumi.set(__self__, "after_contact_work_time_limit", after_contact_work_time_limit)
        if auto_accept is not None:
            pulumi.set(__self__, "auto_accept", auto_accept)
        if desk_phone_number is not None:
            pulumi.set(__self__, "desk_phone_number", desk_phone_number)

    @property
    @pulumi.getter(name="phoneType")
    def phone_type(self) -> pulumi.Input['UserPhoneType']:
        return pulumi.get(self, "phone_type")

    @phone_type.setter
    def phone_type(self, value: pulumi.Input['UserPhoneType']):
        pulumi.set(self, "phone_type", value)

    @property
    @pulumi.getter(name="afterContactWorkTimeLimit")
    def after_contact_work_time_limit(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "after_contact_work_time_limit")

    @after_contact_work_time_limit.setter
    def after_contact_work_time_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "after_contact_work_time_limit", value)

    @property
    @pulumi.getter(name="autoAccept")
    def auto_accept(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_accept")

    @auto_accept.setter
    def auto_accept(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_accept", value)

    @property
    @pulumi.getter(name="deskPhoneNumber")
    def desk_phone_number(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "desk_phone_number")

    @desk_phone_number.setter
    def desk_phone_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desk_phone_number", value)


@pulumi.input_type
class UserTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is maximum of 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


