# -*- coding:utf-8 -*-

# This file is a part of IoT-LAB cli-tools
# Copyright (C) 2015 INRIA (Contact: admin@iot-lab.info)
# Contributor(s) : see AUTHORS file
#
# This software is governed by the CeCILL license under French law
# and abiding by the rules of distribution of free software.  You can  use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# http://www.cecill.info.
#
# As a counterpart to the access to the source code and  rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty  and the software's author,  the holder of the
# economic rights,  and the successive licensors  have only  limited
# liability.
#
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.

"""Help parser messages"""

import os

CUR_DIR = os.path.dirname(__file__)
HELP_DIR = os.path.join(CUR_DIR, 'help')


def _read_help_file(name):
    """Read help file."""
    help_file = os.path.join(HELP_DIR, name)

    with open(help_file) as help_fd:
        return help_fd.read()


PARSER_EPILOG = """

Authentication :
    * Only username: Ask password on command line
        $ iotlab-{cli} -u login {option} ...
    * Username and password: use given credentials
        $ iotlab-{cli} -u login -p password  {option} ...
    * Nothing provided: Use credentials file generated by 'iotlab-auth'
        $ iotlab-{cli} {option} ...
"""

SUBMIT_EPILOG = """

Examples:
    Note: All the lists must be of the same type: Alias or Physical

    $ iotlab-experiment submit -d 20 -l <experiment_list> \
        -l <experiment_list_2>

    * Physical experiment list:
        + <site_name,archi,nodes_id_list,firmware_path,profile_name>
        + grenoble,m3,1-20,bin/tutorial.elf -l rocquencourt,a8,1-5,,battery
        + grenoble,wsn430,1-5+8+9-11,cc1101.hex,battery
        + grenoble,m3,1-20

    * Alias experiment list:
        + <nodes_number,properties,firmware_path,profile_name>
        + 9,archi=wsn430:cc1101+site=grenoble,tp.hex,battery
        + 9,archi=m3:at86rf231+site=grenoble,gre.elf
        + 5,archi=m3:at86rf231+site=strasbourg,stras.elf
"""

SUBMIT_LIST_HELP = _read_help_file('submit_list_help.md')
SUBMIT_SITE_ASSOC_HELP = _read_help_file('submit_site_association_help.md')

SCRIPT_EPILOG = """
Examples:
    * Run script 'experiment.sh' on grenoble:
        $ iotlab-experiment script --run grenoble,script=experiment.sh
    * Run many scripts scripts on different site
        $ iotlab-experiment script --run grenoble,lille,script=exp.sh \\
            strasbourg,script=exp2.sh
    * Run script with a configuration file on grenoble:
        $ iotlab-experiment script --run \
            grenoble,script=exp.sh,scriptconfig=conf
    * Check and control script
        $ iotlab-experiment script --status
        $ iotlab-experiment script --kill
"""

WAIT_EPILOG = """
Examples:
    * wait that currently starting experiment becomes 'Running':
        $ iotlab-experiment wait

    * wait that given experiment gets in state Launching or Running by checking
      every second and timeout after 60 seconds
        $ iotlab-experiment -i 1234 --state Launching,Running --step 1 \
--timeout 60
"""

LOAD_EPILOG = """

Examples:
    * load experiment :
        $ iotlab-experiment load -f 192.json
        Note : by default firmwares are searched in the current directory
    * load experiment with firmware list and explicit path:
        $ iotlab-experiment load -f 192.json -l /home/cc2420.hex \
            -l ../cc1101.hex
    * reload an experiment using load:
        $ iotlab-experiment get -i 192 -a
        $ tar -xzvf 192.tar.gz
        $ cd 192
        $ iotlab-experiment load -f 192.json
"""

RELOAD_EPILOG = """

Examples:
    * Reload experiment for same duration as soon as possible:
        $ iotlab-experiment reload --id 12345
    * Reload experiment with duration set to two hours (120 minutes):
        $ iotlab-experiment reload -i 12345 --duration 120
    * Reload experiment with duration and a schedule timestamp:
        $ iotlab-experiment reload -i 12345 -d 60 --reservation 1474984085
"""

GET_EPILOG = """

Examples:
    * Get an experiment submission
        $ iotlab-experiment get -p
        Note : with one experiment in the state Running
    * Get an experiment archive with id 1637
        $ iotlab-experiment get -i 1637 -a
    * Get experiment nodes list with id 1637
        $ iotlab-experiment get -i 1637 -n
    * Get user's experiment list with filter by state and number
        $ iotlab-experiment get -l --state Running,Terminated \\
            --offset 10 --limit 20
"""


INFO_EPILOG = """

Examples:
    * Get nodes description list with filter by site
        $ iotlab-experiment info -l --site grenoble
    * Get nodes id list (e.g. 1-34+72)
        $ iotlab-experiment info -li

"""


ADD_EPILOG_WSN430 = """

Examples :
    # Add a profile with consumption measure configuration
    $ iotlab-profile addwsn430 -n consum -current -voltage -power -cfreq 5000

    # Add a profile with radio rssi measures
    $ iotlab-profile addwsn430 -n rssi_profile -rfreq 500

    # Add a profile with sensor measures
    $ iotlab-profile addwsn430 -n sensors -sfreq 1000 -temperature -luminosity
"""

ADD_EPILOG_M3_A8 = """

Examples :
    # Add a profile for {archi} nodes with battery power supply and only
      voltage measure configuration
    $ iotlab-profile {cmd} -n profile -p battery -voltage -period 8244 \
        -avg 1024

    # Add a profile for {archi} nodes with multi-channel radio rssi measures
    $ iotlab-profile {cmd} -n prof_rssi -rssi -channels 11 12 -num 10 \
        -rperiod 100

    # Add a profile for {archi} nodes with radio sniffer
    $ iotlab-profile {cmd} -n sniff_11 -sniffer -channels 11

"""
