/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core.references;

import com.adobe.epubcheck.opf.OPFItem;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.mola.galimatias.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.Resource;

public final class ResourceRegistry {
    private Map<URL, Resource> resources = new HashMap<URL, Resource>();
    private Map<URL, List<String>> ids = new HashMap<URL, List<String>>();
    private Table<URL, String, Reference.Type> idTypes = HashBasedTable.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerID(String id, Reference.Type type, URL resourceURL) {
        if (id == null) {
            return;
        }
        Preconditions.checkArgument((resourceURL != null && this.resources.containsKey(resourceURL) ? 1 : 0) != 0, (Object)"resource not registered");
        Map<URL, List<String>> map = this.ids;
        synchronized (map) {
            this.ids.putIfAbsent(resourceURL, new LinkedList());
            List<String> resourceIDs = this.ids.get(resourceURL);
            if (!resourceIDs.contains(id)) {
                resourceIDs.add(id);
                this.idTypes.put((Object)resourceURL, (Object)id, (Object)type);
            }
        }
    }

    public int getIDPosition(String id, Resource resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0);
        if (id == null || id.trim().isEmpty()) {
            return 0;
        }
        int position = this.ids.get(resource.getURL()).indexOf(id);
        return position == -1 ? -1 : position + 1;
    }

    public Reference.Type getIDType(String id, Resource resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0);
        return (Reference.Type)((Object)this.idTypes.get((Object)resource.getURL(), (Object)id));
    }

    public void registerResource(OPFItem item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0);
        if (!this.resources.containsKey(item.getURL())) {
            this.resources.put(item.getURL(), Resource.fromItem(item));
        }
    }

    public void registerResource(URL url, String mimetype) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0);
        if (!this.resources.containsKey(url)) {
            this.resources.put(url, Resource.fromURL(url, mimetype));
        }
    }

    public String getMimeType(URL resource) {
        return this.resources.containsKey(resource) ? this.resources.get(resource).getMimeType() : null;
    }

    public Optional<OPFItem> getOPFItem(URL url) {
        return Optional.ofNullable(this.resources.get(url)).map(r -> r.getItem());
    }

    public Optional<Resource> getResource(URL url) {
        return Optional.ofNullable(this.resources.get(url));
    }
}

