/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.OCFResource;
import com.adobe.epubcheck.util.FeatureEnum;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.mola.galimatias.URL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFZipResources
implements Iterable<OCFResource> {
    private final ZipFile zip;

    public OCFZipResources(URL url) throws IOException {
        File file = null;
        try {
            file = new File(url.toJavaURI());
        }
        catch (URISyntaxException e) {
            new IllegalArgumentException("Not a file URL: " + url);
        }
        this.zip = new ZipFile(file, StandardCharsets.UTF_8);
    }

    @Override
    public Iterator<OCFResource> iterator() {
        return new Iterator<OCFResource>(){
            private final Enumeration<? extends ZipEntry> entries;
            {
                this.entries = OCFZipResources.this.zip.entries();
            }

            @Override
            public boolean hasNext() {
                return this.entries.hasMoreElements();
            }

            @Override
            public OCFResource next() throws NoSuchElementException {
                final ZipEntry entry = this.entries.nextElement();
                ImmutableMap properties = ImmutableMap.builder().put((Object)FeatureEnum.SIZE, (Object)String.valueOf(entry.getSize())).put((Object)FeatureEnum.COMPRESSED_SIZE, (Object)String.valueOf(entry.getCompressedSize())).put((Object)FeatureEnum.COMPRESSION_METHOD, (Object)OCFZipResources.getCompressionMethod(entry)).put((Object)FeatureEnum.SHA_256, (Object)OCFZipResources.getSHAHash(entry, OCFZipResources.this.zip)).build();
                return new OCFResource(){
                    final /* synthetic */ Map val$properties;
                    {
                        this.val$properties = map;
                    }

                    @Override
                    public InputStream openStream() throws IOException {
                        return OCFZipResources.this.zip.getInputStream(entry);
                    }

                    @Override
                    public boolean isFile() {
                        return !entry.isDirectory();
                    }

                    @Override
                    public boolean isDirectory() {
                        return entry.isDirectory();
                    }

                    @Override
                    public Map<FeatureEnum, String> getProperties() {
                        return this.val$properties;
                    }

                    @Override
                    public String getPath() {
                        return entry.getName();
                    }

                    public String toString() {
                        return this.getPath();
                    }
                };
            }
        };
    }

    private static String getSHAHash(ZipEntry entry, ZipFile zip) {
        String string;
        block10: {
            InputStream inputStream = zip.getInputStream(entry);
            try {
                int nread;
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] dataBytes = new byte[1024];
                while ((nread = inputStream.read(dataBytes)) != -1) {
                    md.update(dataBytes, 0, nread);
                }
                byte[] bytes = md.digest();
                StringBuilder hexString = new StringBuilder();
                for (byte aByte : bytes) {
                    hexString.append(Integer.toHexString(0xFF & aByte));
                }
                string = hexString.toString();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String getCompressionMethod(ZipEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        switch (entry.getMethod()) {
            case 8: {
                return "Deflated";
            }
            case 0: {
                return "Stored";
            }
        }
        return "Unsupported";
    }
}

