"""add number_of_targets and remove other fields from experiments

Revision ID: 0a8fb7826e9b
Revises: 033e0f7eca4f
Create Date: 2025-10-28 20:06:54.792631

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from lecrapaud.config import LECRAPAUD_TABLE_PREFIX

# revision identifiers, used by Alembic.
revision: str = "0a8fb7826e9b"
down_revision: Union[str, None] = "033e0f7eca4f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_experiments",
        sa.Column("number_of_targets", sa.Integer(), nullable=True),
    )
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_experiments", "corr_threshold")
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_experiments", "max_features")
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_experiments", "percentile")
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_experiments", "type")
    op.drop_index(
        op.f("ix_model_selection_scores_id"),
        table_name=f"{LECRAPAUD_TABLE_PREFIX}_model_selection_scores",
    )
    op.create_index(
        op.f("ix_model_selection_scores_id"),
        f"{LECRAPAUD_TABLE_PREFIX}_model_selection_scores",
        ["id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_lecrapaud_model_selection_scores_id"),
        table_name=f"{LECRAPAUD_TABLE_PREFIX}_model_selection_scores",
    )
    op.create_index(
        op.f("ix_model_selection_scores_id"),
        f"{LECRAPAUD_TABLE_PREFIX}_model_selection_scores",
        ["id"],
        unique=False,
    )
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_experiments",
        sa.Column("type", mysql.VARCHAR(length=50), nullable=False),
    )
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_experiments",
        sa.Column("percentile", mysql.FLOAT(), nullable=False),
    )
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_experiments",
        sa.Column("max_features", mysql.INTEGER(), autoincrement=False, nullable=False),
    )
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_experiments",
        sa.Column("corr_threshold", mysql.FLOAT(), nullable=False),
    )
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_experiments", "number_of_targets")
    # ### end Alembic commands ###
