"""add unique constraint to score

Revision ID: 07e303521594
Revises: 8b11c1ba982e
Create Date: 2025-10-25 06:35:57.950929

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from lecrapaud.config import LECRAPAUD_TABLE_PREFIX

# revision identifiers, used by Alembic.
revision: str = "07e303521594"
down_revision: Union[str, None] = "8b11c1ba982e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint(
        "unique_score_per_model_training",
        f"{LECRAPAUD_TABLE_PREFIX}_scores",
        ["model_training_id"],
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "unique_score_per_model_training",
        f"{LECRAPAUD_TABLE_PREFIX}_scores",
        type_="unique",
    )
    # ### end Alembic commands ###
