"""

Revision ID: 86457e2f333f
Revises: c62251b129ed
Create Date: 2025-06-24 17:11:25.187876

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from lecrapaud.config import LECRAPAUD_TABLE_PREFIX

# revision identifiers, used by Alembic.
revision: str = "86457e2f333f"
down_revision: Union[str, None] = "c62251b129ed"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_scores",
        sa.Column("thresholds", sa.JSON(), nullable=True),
    )
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_scores",
        sa.Column("f1_at_threshold", sa.Float(), nullable=True),
    )
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_scores", "threshold")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        f"{LECRAPAUD_TABLE_PREFIX}_scores",
        sa.Column("threshold", mysql.FLOAT(), nullable=True),
    )
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_scores", "f1_at_threshold")
    op.drop_column(f"{LECRAPAUD_TABLE_PREFIX}_scores", "thresholds")
    # ### end Alembic commands ###
