"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtXml, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtXml

bytes = str


class QDomCDATASection(PySide6.QtXml.QDomText):
    """
    https://doc.qt.io/qt-6/qdomcdatasection.html

    **Detailed Description**

    CDATA sections are used to escape blocks of text containing characters that
    would otherwise be regarded as markup. The only delimiter that is recognized
    in a CDATA section is the "]]&gt;" string that terminates the CDATA section.
    CDATA sections cannot be nested. Their primary purpose is for including
    material such as XML fragments, without needing to escape all the
    delimiters.

    Adjacent QDomCDATASection nodes are not merged by the
    **QDomNode::normalize** () function.

    For further information about the Document Object Model see
    <http://www.w3.org/TR/REC-DOM-Level-1/> and <http://www.w3.org/TR/DOM-
    Level-2-Core/>. For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdomcdatasection.html#QDomCDATASection

        **QDomCDATASection::QDomCDATASection()**

        Constructs an empty CDATA section. To create a CDATA section with
        content, use the **QDomDocument::createCDATASection** () function.
        """
        ...

    @overload
    def __init__(self, x: PySide6.QtXml.QDomCDATASection) -> None:
        """
        https://doc.qt.io/qt-6/qdomcdatasection.html#QDomCDATASection-1

        **QDomCDATASection::QDomCDATASection(const QDomCDATASection & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def nodeType(self) -> PySide6.QtXml.QDomNode.NodeType:
        """
        https://doc.qt.io/qt-6/qdomcdatasection.html#nodeType

        **QDomNode::NodeType QDomCDATASection::nodeType() const**

        Returns `CDATASection`.
        """
        ...
