"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QToolBar(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qtoolbar.html

    **Detailed Description**

    Toolbar buttons are added by adding **actions** , using **addAction** () or
    **insertAction** (). Groups of buttons can be separated using
    **addSeparator** () or **insertSeparator** (). If a toolbar button is not
    appropriate, a widget can be inserted instead using **addWidget** () or
    **insertWidget** (). Examples of suitable widgets are **QSpinBox** ,
    **QDoubleSpinBox** , and **QComboBox** . When a toolbar button is pressed,
    it emits the **actionTriggered** () signal.

    A toolbar can be fixed in place in a particular area (e.g., at the top of
    the window), or it can be movable between toolbar areas; see **setMovable**
    (), **isMovable** (), **allowedAreas** () and **isAreaAllowed** ().

    When a toolbar is resized in such a way that it is too small to show all the
    items it contains, an extension button will appear as the last item in the
    toolbar. Pressing the extension button will pop up a menu containing the
    items that do not currently fit in the toolbar.

    When a QToolBar is not a child of a **QMainWindow** , it loses the ability
    to populate the extension pop up with widgets added to the toolbar using
    **addWidget** (). Please use widget actions created by inheriting
    **QWidgetAction**  and implementing **QWidgetAction::createWidget** ()
    instead.

    **See also** **QToolButton** , **QMenu** , **QAction** , and **Qt Widgets -
    Application Example** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#QToolBar

        **QToolBar::QToolBar(const QString & title , QWidget * parent =
        nullptr)**

        Constructs a QToolBar with the given **parent**.

        The given window **title** identifies the toolbar and is shown in the
        context menu provided by **QMainWindow** .

        **See also** **setWindowTitle** ().
        """
        ...

    @overload
    def __init__(
        self, title: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#QToolBar-1

        **QToolBar::QToolBar(QWidget * parent = nullptr)**

        Constructs a QToolBar with the given **parent**.
        """
        ...

    @overload
    def actionAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionAt

        **QAction *QToolBar::actionAt(const QPoint & p ) const**

        Returns the action at point **p**. This function returns zero if no
        action was found.

        **See also** **QWidget::childAt** ().
        """
        ...

    @overload
    def actionAt(self, x: int, y: int) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionAt-1

        **QAction *QToolBar::actionAt(int x , int y ) const**

        This is an overloaded function.

        Returns the action at the point **x** , **y**. This function returns
        zero if no action was found.
        """
        ...

    def actionEvent(self, event: PySide6.QtGui.QActionEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionEvent

        **[override virtual protected] void QToolBar::actionEvent(QActionEvent *
        event )**

        Reimplements: **QWidget::actionEvent** (QActionEvent *event).
        """
        ...

    def actionGeometry(self, action: PySide6.QtGui.QAction) -> PySide6.QtCore.QRect:
        ...

    @overload
    def addAction(self, arg__1: PySide6.QtGui.QAction) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction

        **QAction *QToolBar::addAction(const QString & text )**

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar.
        """
        ...

    @overload
    def addAction(
        self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-1

        **QAction *QToolBar::addAction(const QIcon & icon , const QString & text
        )**

        This is an overloaded function.

        Creates a new action with the given **icon** and **text**. This action
        is added to the end of the toolbar.
        """
        ...

    @overload
    def addAction(
        self,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        text: str,
        receiver: object,
        member: bytes,
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-2

        **QAction *QToolBar::addAction(const QString & text , const QObject *
        receiver , const char * member )**

        This is an overloaded function.

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar. The action's **triggered** () signal is
        connected to **member** in **receiver**.
        """
        ...

    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-3

        **QAction *QToolBar::addAction(const QIcon & icon , const QString & text
        , const QObject * receiver , const char * member )**

        This is an overloaded function.

        Creates a new action with the given **icon** and **text**. This action
        is added to the end of the toolbar. The action's **triggered** () signal
        is connected to **member** in **receiver**.
        """
        ...

    @overload
    def addAction(
        self, text: str, receiver: object, member: bytes
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addAction-4

        **[since 5.6] template <typename Functor> QAction
        *QToolBar::addAction(const QString & text , Functor functor )**

        This is an overloaded function.

        Creates a new action with the given **text**. This action is added to
        the end of the toolbar. The action's **triggered** () signal is
        connected to the **functor**.

        This function was introduced in Qt 5.6.
        """
        ...

    def addSeparator(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addSeparator

        **QAction *QToolBar::addSeparator()**

        Adds a separator to the end of the toolbar.

        **See also** **insertSeparator** ().
        """
        ...

    def addWidget(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#addWidget

        **QAction *QToolBar::addWidget(QWidget * widget )**

        Adds the given **widget** to the toolbar as the toolbar's last item.

        The toolbar takes ownership of **widget**.

        If you add a **QToolButton**  with this method, the toolbar's
        **Qt::ToolButtonStyle**  will not be respected.

        **Note:** You should use **QAction::setVisible** () to change the
        visibility of the widget. Using **QWidget::setVisible** (),
        **QWidget::show** () and **QWidget::hide** () does not work.

        **See also** **insertWidget** ().
        """
        ...

    def allowedAreas(self) -> PySide6.QtCore.Qt.ToolBarAreas:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreas-prop

        **allowedAreas : Qt::ToolBarAreas**

        areas where the toolbar may be placed

        The default is **Qt::AllToolBarAreas** .

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        Qt::ToolBarAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::ToolBarAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::ToolBarAreas **allowedAreas** )

        **See also** **movable** .
        """
        ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#changeEvent

        **[override virtual protected] void QToolBar::changeEvent(QEvent * event
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#clear

        **void QToolBar::clear()**

        Removes all actions from the toolbar.

        **See also** **removeAction** ().
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#event

        **[override virtual protected] bool QToolBar::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSize-prop

        **iconSize : QSize**

        size of icons in the toolbar.

        The default size is determined by the application's style and is derived
        from the **QStyle::PM_ToolBarIconSize**  pixel metric. It is the maximum
        size an icon can have. Icons of smaller size will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )

        **Notifier signal:**

        void ****iconSizeChanged** ** (const QSize & **iconSize** )
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolBar) -> None:
        ...

    def insertSeparator(self, before: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#insertSeparator

        **QAction *QToolBar::insertSeparator(QAction * before )**

        Inserts a separator into the toolbar in front of the toolbar item
        associated with the **before** action.

        **See also** **addSeparator** ().
        """
        ...

    def insertWidget(
        self, before: PySide6.QtGui.QAction, widget: PySide6.QtWidgets.QWidget
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#insertWidget

        **QAction *QToolBar::insertWidget(QAction * before , QWidget * widget
        )**

        Inserts the given **widget** in front of the toolbar item associated
        with the **before** action.

        Note: You should use **QAction::setVisible** () to change the visibility
        of the widget. Using **QWidget::setVisible** (), **QWidget::show** ()
        and **QWidget::hide** () does not work.

        **See also** **addWidget** ().
        """
        ...

    def isAreaAllowed(self, area: PySide6.QtCore.Qt.ToolBarArea) -> bool:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#isAreaAllowed

        **bool QToolBar::isAreaAllowed(Qt::ToolBarArea area ) const**

        Returns `true` if this toolbar is dockable in the given **area** ;
        otherwise returns `false`.
        """
        ...

    def isFloatable(self) -> bool:
        ...

    def isFloating(self) -> bool:
        ...

    def isMovable(self) -> bool:
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientation-prop

        **orientation : Qt::Orientation**

        orientation of the toolbar

        The default is **Qt::Horizontal** .

        This function should not be used when the toolbar is managed by
        **QMainWindow** . You can use **QMainWindow::addToolBar** () or
        **QMainWindow::insertToolBar** () if you wish to move a toolbar that is
        already added to a main window to another **Qt::ToolBarArea** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **orientation** )

        **Notifier signal:**

        void ****orientationChanged** ** (Qt::Orientation **orientation** )
        """
        ...

    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#paintEvent

        **[override virtual protected] void QToolBar::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.ToolBarAreas) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreas-prop

        **allowedAreas : Qt::ToolBarAreas**

        areas where the toolbar may be placed

        The default is **Qt::AllToolBarAreas** .

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        Qt::ToolBarAreas **allowedAreas** () const
        void **setAllowedAreas**
        (Qt::ToolBarAreas **areas** )

        **Notifier signal:**

        void ****allowedAreasChanged** ** (Qt::ToolBarAreas **allowedAreas** )

        **See also** **movable** .
        """
        ...

    def setFloatable(self, floatable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#floatable-prop

        **floatable : bool**

        This property holds whether the toolbar can be dragged and dropped as an
        independent window.

        The default is true.

        **Access functions:**

        bool **isFloatable** () const
        void **setFloatable** (bool
        **floatable** )
        """
        ...

    def setIconSize(self, iconSize: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSize-prop

        **iconSize : QSize**

        size of icons in the toolbar.

        The default size is determined by the application's style and is derived
        from the **QStyle::PM_ToolBarIconSize**  pixel metric. It is the maximum
        size an icon can have. Icons of smaller size will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **iconSize** )

        **Notifier signal:**

        void ****iconSizeChanged** ** (const QSize & **iconSize** )
        """
        ...

    def setMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#movable-prop

        **movable : bool**

        This property holds whether the user can move the toolbar within the
        toolbar area, or between toolbar areas.

        By default, this property is `true`.

        This property only makes sense if the toolbar is in a **QMainWindow** .

        **Access functions:**

        bool **isMovable** () const
        void **setMovable** (bool **movable** )

        **Notifier signal:**

        void ****movableChanged** ** (bool **movable** )

        **See also** **allowedAreas** .
        """
        ...

    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientation-prop

        **orientation : Qt::Orientation**

        orientation of the toolbar

        The default is **Qt::Horizontal** .

        This function should not be used when the toolbar is managed by
        **QMainWindow** . You can use **QMainWindow::addToolBar** () or
        **QMainWindow::insertToolBar** () if you wish to move a toolbar that is
        already added to a main window to another **Qt::ToolBarArea** .

        **Access functions:**

        Qt::Orientation **orientation** () const
        void **setOrientation**
        (Qt::Orientation **orientation** )

        **Notifier signal:**

        void ****orientationChanged** ** (Qt::Orientation **orientation** )
        """
        ...

    def setToolButtonStyle(
        self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds the style of toolbar buttons

        This property defines the style of all tool buttons that are added as
        **QAction** s. Note that if you add a **QToolButton**  with the
        **addWidget** () method, it will not get this button style.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )

        **Notifier signal:**

        void ****toolButtonStyleChanged** ** (Qt::ToolButtonStyle
        **toolButtonStyle** )

        **Member Function Documentation**
        """
        ...

    def toggleViewAction(self) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toggleViewAction

        **QAction *QToolBar::toggleViewAction() const**

        Returns a checkable action that can be used to show or hide this
        toolbar.

        The action's text is set to the toolbar's window title.

        **See also** **QAction::text**  and **QWidget::windowTitle** .
        """
        ...

    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyle-prop

        **toolButtonStyle : Qt::ToolButtonStyle**

        This property holds the style of toolbar buttons

        This property defines the style of all tool buttons that are added as
        **QAction** s. Note that if you add a **QToolButton**  with the
        **addWidget** () method, it will not get this button style.

        To have the style of toolbuttons follow the system settings, set this
        property to **Qt::ToolButtonFollowStyle** . On Unix, the user settings
        from the desktop environment will be used. On other platforms,
        **Qt::ToolButtonFollowStyle**  means icon only.

        The default is **Qt::ToolButtonIconOnly** .

        **Access functions:**

        Qt::ToolButtonStyle **toolButtonStyle** () const
        void
        **setToolButtonStyle** (Qt::ToolButtonStyle **toolButtonStyle** )

        **Notifier signal:**

        void ****toolButtonStyleChanged** ** (Qt::ToolButtonStyle
        **toolButtonStyle** )

        **Member Function Documentation**
        """
        ...

    def widgetForAction(
        self, action: PySide6.QtGui.QAction
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#widgetForAction

        **QWidget *QToolBar::widgetForAction(QAction * action ) const**

        Returns the widget associated with the specified **action**.

        **See also** **addWidget** ().
        """
        ...

    @property
    def actionTriggered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#actionTriggered

        **[signal] void QToolBar::actionTriggered(QAction * action )**

        This signal is emitted when an action in this toolbar is triggered. This
        happens when the action's tool button is pressed, or when the action is
        triggered in some other way outside the toolbar. The parameter holds the
        triggered **action**.
        """
        ...

    @property
    def allowedAreasChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#allowedAreasChanged

        **[signal] void QToolBar::allowedAreasChanged(Qt::ToolBarAreas
        allowedAreas )**

        This signal is emitted when the collection of allowed areas for the
        toolbar is changed. The new areas in which the toolbar can be positioned
        are specified by **allowedAreas**.

        **Note:** Notifier signal for property **allowedAreas** .

        **See also** **allowedAreas** .
        """
        ...

    @property
    def iconSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#iconSizeChanged

        **[signal] void QToolBar::iconSizeChanged(const QSize & iconSize )**

        This signal is emitted when the icon size is changed. The **iconSize**
        parameter holds the toolbar's new icon size.

        **Note:** Notifier signal for property **iconSize** .

        **See also** **iconSize**  and **QMainWindow::iconSize** .
        """
        ...

    @property
    def movableChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#movableChanged

        **[signal] void QToolBar::movableChanged(bool movable )**

        This signal is emitted when the toolbar becomes movable or fixed. If the
        toolbar can be moved, **movable** is true; otherwise it is false.

        **Note:** Notifier signal for property **movable** .

        **See also** **movable** .
        """
        ...

    @property
    def orientationChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#orientationChanged

        **[signal] void QToolBar::orientationChanged(Qt::Orientation orientation
        )**

        This signal is emitted when the orientation of the toolbar changes. The
        **orientation** parameter holds the toolbar's new orientation.

        **Note:** Notifier signal for property **orientation** .

        **See also** **orientation** .
        """
        ...

    @property
    def toolButtonStyleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#toolButtonStyleChanged

        **[signal] void QToolBar::toolButtonStyleChanged(Qt::ToolButtonStyle
        toolButtonStyle )**

        This signal is emitted when the tool button style is changed. The
        **toolButtonStyle** parameter holds the toolbar's new tool button style.

        **Note:** Notifier signal for property **toolButtonStyle** .

        **See also** **toolButtonStyle**  and **QMainWindow::toolButtonStyle** .
        """
        ...

    @property
    def topLevelChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#topLevelChanged

        **[signal] void QToolBar::topLevelChanged(bool topLevel )**

        This signal is emitted when the **floating**  property changes. The
        **topLevel** parameter is true if the toolbar is now floating; otherwise
        it is false.

        **See also** **isWindow** ().
        """
        ...

    @property
    def visibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtoolbar.html#visibilityChanged

        **[signal] void QToolBar::visibilityChanged(bool visible )**

        This signal is emitted when the toolbar becomes **visible** (or
        invisible). This happens when the widget is hidden or shown.
        """
        ...
