"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTableView(PySide6.QtWidgets.QAbstractItemView):
    """
    https://doc.qt.io/qt-6/qtableview.html

    **Detailed Description**

    ![](images/windows-tableview.png)

    A QTableView implements a table view that displays items from a model. This
    class is used to provide standard tables that were previously provided by
    the QTable class, but using the more flexible approach provided by Qt's
    model/view architecture.

    The QTableView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    QTableView implements the interfaces defined by the **QAbstractItemView**
    class to allow it to display data provided by models derived from the
    **QAbstractItemModel**  class.

    **Navigation**

    You can navigate the cells in the table by clicking on a cell with the
    mouse, or by using the arrow keys. Because QTableView enables
    **tabKeyNavigation**  by default, you can also hit Tab and Backtab to move
    from cell to cell.

    **Visual Appearance**

    The table has a vertical header that can be obtained using the
    **verticalHeader** () function, and a horizontal header that is available
    through the **horizontalHeader** () function. The height of each row in the
    table can be found by using **rowHeight** (); similarly, the width of
    columns can be found using **columnWidth** (). Since both of these are plain
    widgets, you can hide either of them using their **hide** () functions.

    Rows and columns can be hidden and shown with **hideRow** (), **hideColumn**
    (), **showRow** (), and **showColumn** (). They can be selected with
    **selectRow** () and **selectColumn** (). The table will show a grid
    depending on the **showGrid**  property.

    The items shown in a table view, like those in the other item views, are
    rendered and edited using standard **delegates** . However, for some tasks
    it is sometimes useful to be able to insert widgets in a table instead.
    Widgets are set for particular indexes with the **setIndexWidget** ()
    function, and later retrieved with **indexWidget** ().

    ![](images/qtableview-resized.png)By default, the cells in a table do not
    expand to fill the available space.

    You can make the cells fill the
    available space by stretching the last header section. Access the relevant
    header using **horizontalHeader** () or **verticalHeader** () and set the
    header's **stretchLastSection**  property.

    To distribute the available
    space according to the space requirement of each column or row, call the
    view's **resizeColumnsToContents** () or **resizeRowsToContents** ()
    functions.

    **Coordinate Systems**

    For some specialized forms of tables it is useful to be able to convert
    between row and column indexes and widget coordinates. The **rowAt** ()
    function provides the y-coordinate within the view of the specified row; the
    row index can be used to obtain a corresponding y-coordinate with
    **rowViewportPosition** (). The **columnAt** () and
    **columnViewportPosition** () functions provide the equivalent conversion
    operations between x-coordinates and column indexes.

    **See also** **QTableWidget** , **View Classes** , **QAbstractItemModel** ,
    **QAbstractItemView** , **Chart Example** , **Pixelator Example** , and
    **Table Model Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#QTableView

        **QTableView::QTableView(QWidget * parent = nullptr)**

        Constructs a table view with a **parent** to represent the data.

        **See also** **QAbstractItemModel** .
        """
        ...

    def clearSpans(self) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#clearSpans

        **void QTableView::clearSpans()**

        Removes all row and column spans in the table view.

        **See also** **setSpan** ().
        """
        ...

    def columnAt(self, x: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnAt

        **int QTableView::columnAt(int x ) const**

        Returns the column in which the given x-coordinate, **x** , in contents
        coordinates is located.

        **Note:** This function returns -1 if the given coordinate is not valid
        (has no column).

        **See also** **rowAt** ().
        """
        ...

    def columnCountChanged(self, oldCount: int, newCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnCountChanged

        **[protected slot] void QTableView::columnCountChanged(int oldCount ,
        int newCount )**

        This slot is called whenever columns are added or deleted. The previous
        number of columns is specified by **oldCount** , and the new number of
        columns is specified by **newCount**.
        """
        ...

    def columnMoved(self, column: int, oldIndex: int, newIndex: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnMoved

        **[protected slot] void QTableView::columnMoved(int column , int
        oldIndex , int newIndex )**

        This slot is called to change the index of the given **column** in the
        table view. The old index is specified by **oldIndex** , and the new
        index by **newIndex**.

        **See also** **rowMoved** ().
        """
        ...

    def columnResized(self, column: int, oldWidth: int, newWidth: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnResized

        **[protected slot] void QTableView::columnResized(int column , int
        oldWidth , int newWidth )**

        This slot is called to change the width of the given **column**. The old
        width is specified by **oldWidth** , and the new width by **newWidth**.

        **See also** **rowResized** ().
        """
        ...

    def columnSpan(self, row: int, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnSpan

        **int QTableView::columnSpan(int row , int column ) const**

        Returns the column span of the table element at ( **row** , **column**
        ). The default is 1.

        **See also** **setSpan** () and **rowSpan** ().
        """
        ...

    def columnViewportPosition(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnViewportPosition

        **int QTableView::columnViewportPosition(int column ) const**

        Returns the x-coordinate in contents coordinates of the given
        **column**.
        """
        ...

    def columnWidth(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#columnWidth

        **int QTableView::columnWidth(int column ) const**

        Returns the width of the given **column**.

        **See also** **setColumnWidth** (), **resizeColumnToContents** (), and
        **rowHeight** ().
        """
        ...

    def currentChanged(
        self,
        current: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        previous: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#currentChanged

        **[override virtual protected] void QTableView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    def doItemsLayout(self) -> None:
        ...

    def gridStyle(self) -> PySide6.QtCore.Qt.PenStyle:
        """
        https://doc.qt.io/qt-6/qtableview.html#gridStyle-prop

        **gridStyle : Qt::PenStyle**

        This property holds the pen style used to draw the grid.

        This property holds the style used when drawing the grid (see
        **showGrid** ).

        **Access functions:**

        Qt::PenStyle **gridStyle** () const
        void **setGridStyle**
        (Qt::PenStyle **style** )
        """
        ...

    def hideColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#hideColumn

        **[slot] void QTableView::hideColumn(int column )**

        Hide the given **column**.

        **See also** **showColumn** () and **hideRow** ().
        """
        ...

    def hideRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#hideRow

        **[slot] void QTableView::hideRow(int row )**

        Hide the given **row**.

        **See also** **showRow** () and **hideColumn** ().
        """
        ...

    def horizontalHeader(self) -> PySide6.QtWidgets.QHeaderView:
        """
        https://doc.qt.io/qt-6/qtableview.html#horizontalHeader

        **QHeaderView *QTableView::horizontalHeader() const**

        Returns the table view's horizontal header.

        **See also** **setHorizontalHeader** (), **verticalHeader** (), and
        **QAbstractItemModel::headerData** ().
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#horizontalOffset

        **[override virtual protected] int QTableView::horizontalOffset()
        const**

        Reimplements: **QAbstractItemView::horizontalOffset() const** .

        Returns the horizontal offset of the items in the table view.

        Note that the table view uses the horizontal header section positions to
        determine the positions of columns in the view.

        **See also** **verticalOffset** ().
        """
        ...

    def horizontalScrollbarAction(self, action: int) -> None:
        ...

    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtableview.html#indexAt

        **[override virtual] QModelIndex QTableView::indexAt(const QPoint & pos
        ) const**

        Reimplements: **QAbstractItemView::indexAt(const QPoint &point) const**
        .

        Returns the index position of the model item corresponding to the table
        item at position **pos** in contents coordinates.
        """
        ...

    def initViewItemOption(
        self, option: PySide6.QtWidgets.QStyleOptionViewItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#initViewItemOption

        **[override virtual protected] void
        QTableView::initViewItemOption(QStyleOptionViewItem * option ) const**

        Reimplements:
        **QAbstractItemView::initViewItemOption(QStyleOptionViewItem *option)
        const** .
        """
        ...

    def isColumnHidden(self, column: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtableview.html#isColumnHidden

        **bool QTableView::isColumnHidden(int column ) const**

        Returns `true` if the given **column** is hidden; otherwise returns
        `false`.

        **See also** **isRowHidden** ().
        """
        ...

    def isCornerButtonEnabled(self) -> bool:
        ...

    def isIndexHidden(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtableview.html#isIndexHidden

        **[override virtual protected] bool QTableView::isIndexHidden(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemView::isIndexHidden(const QModelIndex
        &index) const** .
        """
        ...

    def isRowHidden(self, row: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtableview.html#isRowHidden

        **bool QTableView::isRowHidden(int row ) const**

        Returns `true` if the given **row** is hidden; otherwise returns
        `false`.

        **See also** **isColumnHidden** ().
        """
        ...

    def isSortingEnabled(self) -> bool:
        ...

    def moveCursor(
        self,
        cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qtableview.html#moveCursor

        **[override virtual protected] QModelIndex
        QTableView::moveCursor(QAbstractItemView::CursorAction cursorAction ,
        Qt::KeyboardModifiers modifiers )**

        Reimplements: **QAbstractItemView::moveCursor**
        (QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers
        modifiers).

        Moves the cursor in accordance with the given **cursorAction** , using
        the information provided by the **modifiers**.

        **See also** **QAbstractItemView::CursorAction** .
        """
        ...

    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#paintEvent

        **[override virtual protected] void QTableView::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).

        Paints the table on receipt of the given paint event **event**.
        """
        ...

    def resizeColumnToContents(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#resizeColumnToContents

        **[slot] void QTableView::resizeColumnToContents(int column )**

        Resizes the given **column** based on the size hints of the delegate
        used to render each item in the column.

        **Note:** Only visible columns will be resized. Reimplement
        **sizeHintForColumn** () to resize hidden columns as well.

        **See also** **resizeColumnsToContents** (), **sizeHintForColumn** (),
        and **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def resizeColumnsToContents(self) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#resizeColumnsToContents

        **[slot] void QTableView::resizeColumnsToContents()**

        Resizes all columns based on the size hints of the delegate used to
        render each item in the columns.

        **See also** **resizeColumnToContents** (), **sizeHintForColumn** (),
        and **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def resizeRowToContents(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#resizeRowToContents

        **[slot] void QTableView::resizeRowToContents(int row )**

        Resizes the given **row** based on the size hints of the delegate used
        to render each item in the row.

        **See also** **resizeRowsToContents** (), **sizeHintForRow** (), and
        **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def resizeRowsToContents(self) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#resizeRowsToContents

        **[slot] void QTableView::resizeRowsToContents()**

        Resizes all rows based on the size hints of the delegate used to render
        each item in the rows.

        **See also** **resizeRowToContents** (), **sizeHintForRow** (), and
        **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def rowAt(self, y: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowAt

        **int QTableView::rowAt(int y ) const**

        Returns the row in which the given y-coordinate, **y** , in contents
        coordinates is located.

        **Note:** This function returns -1 if the given coordinate is not valid
        (has no row).

        **See also** **columnAt** ().
        """
        ...

    def rowCountChanged(self, oldCount: int, newCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowCountChanged

        **[protected slot] void QTableView::rowCountChanged(int oldCount , int
        newCount )**

        This slot is called whenever rows are added or deleted. The previous
        number of rows is specified by **oldCount** , and the new number of rows
        is specified by **newCount**.
        """
        ...

    def rowHeight(self, row: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowHeight

        **int QTableView::rowHeight(int row ) const**

        Returns the height of the given **row**.

        **See also** **setRowHeight** (), **resizeRowToContents** (), and
        **columnWidth** ().
        """
        ...

    def rowMoved(self, row: int, oldIndex: int, newIndex: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowMoved

        **[protected slot] void QTableView::rowMoved(int row , int oldIndex ,
        int newIndex )**

        This slot is called to change the index of the given **row** in the
        table view. The old index is specified by **oldIndex** , and the new
        index by **newIndex**.

        **See also** **columnMoved** ().
        """
        ...

    def rowResized(self, row: int, oldHeight: int, newHeight: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowResized

        **[protected slot] void QTableView::rowResized(int row , int oldHeight ,
        int newHeight )**

        This slot is called to change the height of the given **row**. The old
        height is specified by **oldHeight** , and the new height by
        **newHeight**.

        **See also** **columnResized** ().
        """
        ...

    def rowSpan(self, row: int, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowSpan

        **int QTableView::rowSpan(int row , int column ) const**

        Returns the row span of the table element at ( **row** , **column** ).
        The default is 1.

        **See also** **setSpan** () and **columnSpan** ().
        """
        ...

    def rowViewportPosition(self, row: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#rowViewportPosition

        **int QTableView::rowViewportPosition(int row ) const**

        Returns the y-coordinate in contents coordinates of the given **row**.
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#scrollContentsBy

        **[override virtual protected] void QTableView::scrollContentsBy(int dx
        , int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).

        Scroll the contents of the table view by ( **dx** , **dy** ).
        """
        ...

    def scrollTo(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#scrollTo

        **[override virtual] void QTableView::scrollTo(const QModelIndex & index
        , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Reimplements: **QAbstractItemView::scrollTo** (const QModelIndex &index,
        QAbstractItemView::ScrollHint hint).

        Makes sure that the given **index** is visible in the table view,
        scrolling if necessary.
        """
        ...

    def selectColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#selectColumn

        **[slot] void QTableView::selectColumn(int column )**

        Selects the given **column** in the table view if the current
        SelectionMode and SelectionBehavior allows columns to be selected.

        **See also** **selectRow** ().
        """
        ...

    def selectRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#selectRow

        **[slot] void QTableView::selectRow(int row )**

        Selects the given **row** in the table view if the current SelectionMode
        and SelectionBehavior allows rows to be selected.

        **See also** **selectColumn** ().
        """
        ...

    def selectedIndexes(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qtableview.html#selectedIndexes

        **[override virtual protected] QModelIndexList
        QTableView::selectedIndexes() const**

        Reimplements: **QAbstractItemView::selectedIndexes() const** .
        """
        ...

    def selectionChanged(
        self,
        selected: PySide6.QtCore.QItemSelection,
        deselected: PySide6.QtCore.QItemSelection,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#selectionChanged

        **[override virtual protected] void QTableView::selectionChanged(const
        QItemSelection & selected , const QItemSelection & deselected )**

        Reimplements: **QAbstractItemView::selectionChanged** (const
        QItemSelection &selected, const QItemSelection &deselected).
        """
        ...

    def setColumnHidden(self, column: int, hide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setColumnHidden

        **void QTableView::setColumnHidden(int column , bool hide )**

        If **hide** is true the given **column** will be hidden; otherwise it
        will be shown.

        **See also** **isColumnHidden** () and **setRowHidden** ().
        """
        ...

    def setColumnWidth(self, column: int, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setColumnWidth

        **void QTableView::setColumnWidth(int column , int width )**

        Sets the width of the given **column** to be **width**.

        **See also** **columnWidth** ().
        """
        ...

    def setCornerButtonEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#cornerButtonEnabled-prop

        **cornerButtonEnabled : bool**

        This property holds whether the button in the top-left corner is enabled

        If this property is `true` then button in the top-left corner of the
        table view is enabled. Clicking on this button will select all the cells
        in the table view.

        This property is `true` by default.

        **Access functions:**

        bool **isCornerButtonEnabled** () const
        void
        **setCornerButtonEnabled** (bool **enable** )
        """
        ...

    def setGridStyle(self, style: PySide6.QtCore.Qt.PenStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#gridStyle-prop

        **gridStyle : Qt::PenStyle**

        This property holds the pen style used to draw the grid.

        This property holds the style used when drawing the grid (see
        **showGrid** ).

        **Access functions:**

        Qt::PenStyle **gridStyle** () const
        void **setGridStyle**
        (Qt::PenStyle **style** )
        """
        ...

    def setHorizontalHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setHorizontalHeader

        **void QTableView::setHorizontalHeader(QHeaderView * header )**

        Sets the widget to use for the horizontal header to **header**.

        **See also** **horizontalHeader** () and **setVerticalHeader** ().
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setModel

        **[override virtual] void QTableView::setModel(QAbstractItemModel *
        model )**

        Reimplements: **QAbstractItemView::setModel** (QAbstractItemModel
        *model).
        """
        ...

    def setRootIndex(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setRootIndex

        **[override virtual] void QTableView::setRootIndex(const QModelIndex &
        index )**

        Reimplements: **QAbstractItemView::setRootIndex** (const QModelIndex
        &index).
        """
        ...

    def setRowHeight(self, row: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setRowHeight

        **void QTableView::setRowHeight(int row , int height )**

        Sets the height of the given **row** to be **height**.

        **See also** **rowHeight** ().
        """
        ...

    def setRowHidden(self, row: int, hide: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setRowHidden

        **void QTableView::setRowHidden(int row , bool hide )**

        If **hide** is true **row** will be hidden, otherwise it will be shown.

        **See also** **isRowHidden** () and **setColumnHidden** ().
        """
        ...

    def setSelection(
        self,
        rect: PySide6.QtCore.QRect,
        command: PySide6.QtCore.QItemSelectionModel.SelectionFlags,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setSelection

        **[override virtual protected] void QTableView::setSelection(const QRect
        & rect , QItemSelectionModel::SelectionFlags flags )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).

        Selects the items within the given **rect** and in accordance with the
        specified selection **flags**.
        """
        ...

    def setSelectionModel(
        self, selectionModel: PySide6.QtCore.QItemSelectionModel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setSelectionModel

        **[override virtual] void
        QTableView::setSelectionModel(QItemSelectionModel * selectionModel )**

        Reimplements: **QAbstractItemView::setSelectionModel**
        (QItemSelectionModel *selectionModel).
        """
        ...

    def setShowGrid(self, show: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#showGrid-prop

        **showGrid : bool**

        This property holds whether the grid is shown

        If this property is `true` a grid is drawn for the table; if the
        property is `false`, no grid is drawn. The default value is true.

        **Access functions:**

        bool **showGrid** () const
        void **setShowGrid** (bool **show** )
        """
        ...

    def setSortingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setSortingEnabled

        **void QTableView::setSortingEnabled(bool enable )**

        If **enable** is true, enables sorting for the table and immediately
        trigger a call to **sortByColumn** () with the current sort section and
        order

        **Note:** Setter function for property **sortingEnabled** .

        **See also** **isSortingEnabled** ().
        """
        ...

    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setSpan

        **void QTableView::setSpan(int row , int column , int rowSpanCount , int
        columnSpanCount )**

        Sets the span of the table element at ( **row** , **column** ) to the
        number of rows and columns specified by ( **rowSpanCount** ,
        **columnSpanCount** ).

        **See also** **rowSpan** () and **columnSpan** ().
        """
        ...

    def setVerticalHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#setVerticalHeader

        **void QTableView::setVerticalHeader(QHeaderView * header )**

        Sets the widget to use for the vertical header to **header**.

        **See also** **verticalHeader** () and **setHorizontalHeader** ().
        """
        ...

    def setWordWrap(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `true` by default.

        Note that even of wrapping is enabled, the cell will not be expanded to
        fit all text. Ellipsis will be inserted according to the current
        **textElideMode** .

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...

    def showColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#showColumn

        **[slot] void QTableView::showColumn(int column )**

        Show the given **column**.

        **See also** **hideColumn** () and **showRow** ().
        """
        ...

    def showGrid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtableview.html#showGrid-prop

        **showGrid : bool**

        This property holds whether the grid is shown

        If this property is `true` a grid is drawn for the table; if the
        property is `false`, no grid is drawn. The default value is true.

        **Access functions:**

        bool **showGrid** () const
        void **setShowGrid** (bool **show** )
        """
        ...

    def showRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#showRow

        **[slot] void QTableView::showRow(int row )**

        Show the given **row**.

        **See also** **hideRow** () and **showColumn** ().
        """
        ...

    def sizeHintForColumn(self, column: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#sizeHintForColumn

        **[override virtual protected] int QTableView::sizeHintForColumn(int
        column ) const**

        Reimplements: **QAbstractItemView::sizeHintForColumn(int column) const**
        .

        Returns the size hint for the given **column** 's width or -1 if there
        is no model.

        If you need to set the width of a given column to a fixed value, call
        **QHeaderView::resizeSection** () on the table's horizontal header.

        If you reimplement this function in a subclass, note that the value you
        return will be used when **resizeColumnToContents** () or
        **QHeaderView::resizeSections** () is called. If a larger column width
        is required by either the horizontal header or the item delegate, the
        larger width will be used instead.

        **See also** **QWidget::sizeHint** , **horizontalHeader** (), and
        **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def sizeHintForRow(self, row: int) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#sizeHintForRow

        **[override virtual protected] int QTableView::sizeHintForRow(int row )
        const**

        Reimplements: **QAbstractItemView::sizeHintForRow(int row) const** .

        Returns the size hint for the given **row** 's height or -1 if there is
        no model.

        If you need to set the height of a given row to a fixed value, call
        **QHeaderView::resizeSection** () on the table's vertical header.

        If you reimplement this function in a subclass, note that the value you
        return is only used when **resizeRowToContents** () is called. In that
        case, if a larger row height is required by either the vertical header
        or the item delegate, that width will be used instead.

        **See also** **QWidget::sizeHint** , **verticalHeader** (), and
        **QHeaderView::resizeContentsPrecision** ().
        """
        ...

    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#sortByColumn

        **[slot] void QTableView::sortByColumn(int column , Qt::SortOrder order
        )**

        Sorts the model by the values in the given **column** and **order**.

        **column** may be -1, in which case no sort indicator will be shown and
        the model will return to its natural, unsorted order. Note that not all
        models support this and may even crash in this case.

        **See also** **sortingEnabled** .
        """
        ...

    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#timerEvent

        **[override virtual protected] void QTableView::timerEvent(QTimerEvent *
        event )**

        Reimplements: **QAbstractItemView::timerEvent** (QTimerEvent *event).
        """
        ...

    def updateGeometries(self) -> None:
        """
        https://doc.qt.io/qt-6/qtableview.html#updateGeometries

        **[override virtual protected] void QTableView::updateGeometries()**

        Reimplements: **QAbstractItemView::updateGeometries** ().
        """
        ...

    def verticalHeader(self) -> PySide6.QtWidgets.QHeaderView:
        """
        https://doc.qt.io/qt-6/qtableview.html#verticalHeader

        **QHeaderView *QTableView::verticalHeader() const**

        Returns the table view's vertical header.

        **See also** **setVerticalHeader** (), **horizontalHeader** (), and
        **QAbstractItemModel::headerData** ().
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qtableview.html#verticalOffset

        **[override virtual protected] int QTableView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset() const** .

        Returns the vertical offset of the items in the table view.

        Note that the table view uses the vertical header section positions to
        determine the positions of rows in the view.

        **See also** **horizontalOffset** ().
        """
        ...

    def verticalScrollbarAction(self, action: int) -> None:
        ...

    def viewportSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtableview.html#viewportSizeHint

        **[override virtual protected] QSize QTableView::viewportSizeHint()
        const**

        Reimplements: **QAbstractItemView::viewportSizeHint() const** .
        """
        ...

    def visualRect(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qtableview.html#visualRect

        **[override virtual] QRect QTableView::visualRect(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemView::visualRect(const QModelIndex &index)
        const** .

        Returns the rectangle on the viewport occupied by the given **index**.
        If the index is hidden in the view it will return a null **QRect** .
        """
        ...

    def visualRegionForSelection(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtGui.QRegion:
        """
        https://doc.qt.io/qt-6/qtableview.html#visualRegionForSelection

        **[override virtual protected] QRegion
        QTableView::visualRegionForSelection(const QItemSelection & selection )
        const**

        Reimplements: **QAbstractItemView::visualRegionForSelection(const
        QItemSelection &selection) const** .

        Returns the rectangle from the viewport of the items in the given
        **selection**.

        Since 4.7, the returned region only contains rectangles intersecting (or
        included in) the viewport.
        """
        ...

    def wordWrap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtableview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `true` by default.

        Note that even of wrapping is enabled, the cell will not be expanded to
        fit all text. Ellipsis will be inserted according to the current
        **textElideMode** .

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...
