"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QTabWidget(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qtabwidget.html

    **Detailed Description**

    ![](images/windows-tabwidget.png)

    A tab widget provides a tab bar (see **QTabBar** ) and a "page area" that is
    used to display pages related to each tab. By default, the tab bar is shown
    above the page area, but different configurations are available (see
    **TabPosition** ). Each tab is associated with a different widget (called a
    page). Only the current page is shown in the page area; all the other pages
    are hidden. The user can show a different page by clicking on its tab or by
    pressing its Alt+ **letter** shortcut if it has one.

    The normal way to use QTabWidget is to do the following:

    1. Create a QTabWidget.
      2. Create a **QWidget**  for each of the pages in
    the tab dialog, but do not specify parent widgets for them.
      3. Insert
    child widgets into the page widget, using layouts to position them as
    normal.
      4. Call **addTab** () or **insertTab** () to put the page widgets
    into the tab widget, giving each tab a suitable label with an optional
    keyboard shortcut.

    The position of the tabs is defined by **tabPosition** , their shape by
    **tabShape** .

    The signal **currentChanged** () is emitted when the user selects a page.

    The current page index is available as **currentIndex** (), the current page
    widget with **currentWidget** (). You can retrieve a pointer to a page
    widget with a given index using **widget** (), and can find the index
    position of a widget with **indexOf** (). Use **setCurrentWidget** () or
    **setCurrentIndex** () to show a particular page.

    You can change a tab's text and icon using **setTabText** () or
    **setTabIcon** (). A tab and its associated page can be removed with
    **removeTab** ().

    Each tab is either enabled or disabled at any given time (see
    **setTabEnabled** ()). If a tab is enabled, the tab text is drawn normally
    and the user can select that tab. If it is disabled, the tab is drawn in a
    different way and the user cannot select that tab. Note that even if a tab
    is disabled, the page can still be visible, for example if all of the tabs
    happen to be disabled.

    Tab widgets can be a very good way to split up a complex dialog. An
    alternative is to use a **QStackedWidget**  for which you provide some means
    of navigating between pages, for example, a **QToolBar**  or a
    **QListWidget** .

    Most of the functionality in QTabWidget is provided by a **QTabBar**  (at
    the top, providing the tabs) and a **QStackedWidget**  (most of the area,
    organizing the individual pages).

    **See also** **QTabBar** , **QStackedWidget** , **QToolBox** , and **Tab
    Dialog Example** .
    """

    North: QTabWidget.TabPosition = ...
    South: QTabWidget.TabPosition = ...
    West: QTabWidget.TabPosition = ...
    East: QTabWidget.TabPosition = ...
    Rounded: QTabWidget.TabShape = ...
    Triangular: QTabWidget.TabShape = ...

    class TabPosition(Enum):
        North: QTabWidget.TabPosition = ...
        South: QTabWidget.TabPosition = ...
        West: QTabWidget.TabPosition = ...
        East: QTabWidget.TabPosition = ...

    class TabShape(Enum):
        Rounded: QTabWidget.TabShape = ...
        Triangular: QTabWidget.TabShape = ...

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#QTabWidget

        **QTabWidget::QTabWidget(QWidget * parent = nullptr)**

        Constructs a tabbed widget with parent **parent**.
        """
        ...

    @overload
    def addTab(self, widget: PySide6.QtWidgets.QWidget, arg__2: str) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#addTab

        **int QTabWidget::addTab(QWidget * page , const QString & label )**

        Adds a tab with the given **page** and **label** to the tab widget, and
        returns the index of the tab in the tab bar. Ownership of **page** is
        passed on to the **QTabWidget** .

        If the tab's **label** contains an ampersand, the letter following the
        ampersand is used as a shortcut for the tab, e.g. if the label is
        "Bro&wse" then Alt+W becomes a shortcut which will move the focus to
        this tab.

        **Note:** If you call addTab() after **show** (), the layout system will
        try to adjust to the changes in its widgets hierarchy and may cause
        flicker. To prevent this, you can set the **QWidget::updatesEnabled**
        property to false prior to changes; remember to set the property to true
        when the changes are done, making the widget receive paint events again.

        **See also** **insertTab** ().
        """
        ...

    @overload
    def addTab(
        self,
        widget: PySide6.QtWidgets.QWidget,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        label: str,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#addTab-1

        **int QTabWidget::addTab(QWidget * page , const QIcon & icon , const
        QString & label )**

        This is an overloaded function.

        Adds a tab with the given **page** , **icon** , and **label** to the tab
        widget, and returns the index of the tab in the tab bar. Ownership of
        **page** is passed on to the **QTabWidget** .

        This function is the same as addTab(), but with an additional **icon**.
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#changeEvent

        **[override virtual protected] void QTabWidget::changeEvent(QEvent * ev
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#clear

        **void QTabWidget::clear()**

        Removes all the pages, but does not delete them. Calling this function
        is equivalent to calling **removeTab** () until the tab widget is empty.
        """
        ...

    def cornerWidget(
        self, corner: PySide6.QtCore.Qt.Corner = ...
    ) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#cornerWidget

        **QWidget *QTabWidget::cornerWidget(Qt::Corner corner =
        Qt::TopRightCorner) const**

        Returns the widget shown in the **corner** of the tab widget or
        `nullptr`.

        **See also** **setCornerWidget** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#count-prop

        **[read-only] count : const int**

        This property holds the number of tabs in the tab bar

        By default, this property contains a value of 0.

        **Access functions:**

        int **count** () const
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the current tab page

        The current index is -1 if there is no current widget.

        By default, this property contains a value of -1 because there are
        initially no tabs in the widget.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def currentWidget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#currentWidget

        **QWidget *QTabWidget::currentWidget() const**

        Returns a pointer to the page currently being displayed by the tab
        dialog. The tab dialog does its best to make sure that this value is
        never 0 (but if you try hard enough, it can be).

        **See also** **currentIndex** () and **setCurrentWidget** ().
        """
        ...

    def documentMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab widget is rendered in a mode
        suitable for document pages. This is the same as document mode on macOS.

        When this property is set the tab widget frame is not rendered. This
        mode is useful for showing document-type pages where the page covers
        most of the tab widget area.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **elideMode** , **QTabBar::documentMode** ,
        **QTabBar::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .
        """
        ...

    def elideMode(self) -> PySide6.QtCore.Qt.TextElideMode:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style dependent.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabBar::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#event

        **[override virtual protected] bool QTabWidget::event(QEvent * ev )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def hasHeightForWidth(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#hasHeightForWidth

        **[override virtual] bool QTabWidget::hasHeightForWidth() const**

        Reimplements: **QWidget::hasHeightForWidth() const** .
        """
        ...

    def heightForWidth(self, width: int) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#heightForWidth

        **[override virtual] int QTabWidget::heightForWidth(int width ) const**

        Reimplements: **QWidget::heightForWidth(int w) const** .
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. This is the maximum size that the
        icons will have. Icons are not scaled up if they are of smaller size.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabBar::iconSize** .
        """
        ...

    def indexOf(self, widget: PySide6.QtWidgets.QWidget) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#indexOf

        **int QTabWidget::indexOf(const QWidget * w ) const**

        Returns the index position of the page occupied by the widget **w** , or
        -1 if the widget cannot be found.
        """
        ...

    def initStyleOption(
        self, option: PySide6.QtWidgets.QStyleOptionTabWidgetFrame
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#initStyleOption

        **[virtual protected] void
        QTabWidget::initStyleOption(QStyleOptionTabWidgetFrame * option )
        const**

        Initialize **option** with the values from this **QTabWidget** . This
        method is useful for subclasses when they need a
        **QStyleOptionTabWidgetFrame** , but don't want to fill in all the
        information themselves.

        **See also** **QStyleOption::initFrom** () and
        **QTabBar::initStyleOption** ().
        """
        ...

    @overload
    def insertTab(
        self, index: int, widget: PySide6.QtWidgets.QWidget, arg__3: str
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#insertTab

        **int QTabWidget::insertTab(int index , QWidget * page , const QString &
        label )**

        Inserts a tab with the given **label** and **page** into the tab widget
        at the specified **index** , and returns the index of the inserted tab
        in the tab bar. Ownership of **page** is passed on to the **QTabWidget**
        .

        The label is displayed in the tab and may vary in appearance depending
        on the configuration of the tab widget.

        If the tab's **label** contains an ampersand, the letter following the
        ampersand is used as a shortcut for the tab, e.g. if the label is
        "Bro&wse" then Alt+W becomes a shortcut which will move the focus to
        this tab.

        If **index** is out of range, the tab is simply appended. Otherwise it
        is inserted at the specified position.

        If the **QTabWidget**  was empty before this function is called, the new
        page becomes the current page. Inserting a new tab at an index less than
        or equal to the current index will increment the current index, but keep
        the current page.

        **Note:** If you call insertTab() after **show** (), the layout system
        will try to adjust to the changes in its widgets hierarchy and may cause
        flicker. To prevent this, you can set the **QWidget::updatesEnabled**
        property to false prior to changes; remember to set the property to true
        when the changes are done, making the widget receive paint events again.

        **See also** **addTab** ().
        """
        ...

    @overload
    def insertTab(
        self,
        index: int,
        widget: PySide6.QtWidgets.QWidget,
        icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],
        label: str,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#insertTab-1

        **int QTabWidget::insertTab(int index , QWidget * page , const QIcon &
        icon , const QString & label )**

        This is an overloaded function.

        Inserts a tab with the given **label** , **page** , and **icon** into
        the tab widget at the specified **index** , and returns the index of the
        inserted tab in the tab bar. Ownership of **page** is passed on to the
        **QTabWidget** .

        This function is the same as insertTab(), but with an additional
        **icon**.
        """
        ...

    def isMovable(self) -> bool:
        ...

    def isTabEnabled(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#isTabEnabled

        **bool QTabWidget::isTabEnabled(int index ) const**

        Returns `true` if the page at position **index** is enabled; otherwise
        returns `false`.

        **See also** **setTabEnabled** () and **QWidget::isEnabled** ().
        """
        ...

    def isTabVisible(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#isTabVisible

        **[since 5.15] bool QTabWidget::isTabVisible(int index ) const**

        Returns true if the page at position **index** is visible; otherwise
        returns false.

        This function was introduced in Qt 5.15.

        **See also** **setTabVisible** ().
        """
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#keyPressEvent

        **[override virtual protected] void QTabWidget::keyPressEvent(QKeyEvent
        * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#minimumSizeHint

        **[override virtual] QSize QTabWidget::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .

        Returns a suitable minimum size for the tab widget.
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#paintEvent

        **[override virtual protected] void QTabWidget::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).

        Paints the tab widget's tab bar in response to the paint **event**.
        """
        ...

    def removeTab(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#removeTab

        **void QTabWidget::removeTab(int index )**

        Removes the tab at position **index** from this stack of widgets. The
        page widget itself is not deleted.

        **See also** **addTab** () and **insertTab** ().
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#resizeEvent

        **[override virtual protected] void QTabWidget::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def setCornerWidget(
        self, w: PySide6.QtWidgets.QWidget, corner: PySide6.QtCore.Qt.Corner = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setCornerWidget

        **void QTabWidget::setCornerWidget(QWidget * widget , Qt::Corner corner
        = Qt::TopRightCorner)**

        Sets the given **widget** to be shown in the specified **corner** of the
        tab widget. The geometry of the widget is determined based on the
        widget's **sizeHint** () and the **style** ().

        Only the horizontal element of the **corner** will be used.

        Passing `nullptr` shows no widget in the corner.

        Any previously set corner widget is hidden.

        All widgets set here will be deleted by the tab widget when it is
        destroyed unless you separately reparent the widget after setting some
        other corner widget (or `nullptr`).

        Note: Corner widgets are designed for **North**  and **South**  tab
        positions; other orientations are known to not work properly.

        **See also** **cornerWidget** () and **setTabPosition** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index position of the current tab page

        The current index is -1 if there is no current widget.

        By default, this property contains a value of -1 because there are
        initially no tabs in the widget.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentChanged** ** (int **index** )
        """
        ...

    def setCurrentWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setCurrentWidget

        **[slot] void QTabWidget::setCurrentWidget(QWidget * widget )**

        Makes **widget** the current widget. The **widget** used must be a page
        in this tab widget.

        **See also** **addTab** (), **setCurrentIndex** (), and
        **currentWidget** ().
        """
        ...

    def setDocumentMode(self, set: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#documentMode-prop

        **documentMode : bool**

        This property holds whether or not the tab widget is rendered in a mode
        suitable for document pages. This is the same as document mode on macOS.

        When this property is set the tab widget frame is not rendered. This
        mode is useful for showing document-type pages where the page covers
        most of the tab widget area.

        **Access functions:**

        bool **documentMode** () const
        void **setDocumentMode** (bool **set**
        )

        **See also** **elideMode** , **QTabBar::documentMode** ,
        **QTabBar::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .
        """
        ...

    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#elideMode-prop

        **elideMode : Qt::TextElideMode**

        how to elide text in the tab bar

        This property controls how items are elided when there is not enough
        space to show them for a given tab bar size.

        By default the value is style dependent.

        **Access functions:**

        Qt::TextElideMode **elideMode** () const
        void **setElideMode**
        (Qt::TextElideMode **mode** )

        **See also** **QTabBar::elideMode** , **usesScrollButtons** , and
        **QStyle::SH_TabBar_ElideMode** .
        """
        ...

    def setIconSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size for icons in the tab bar

        The default value is style-dependent. This is the maximum size that the
        icons will have. Icons are not scaled up if they are of smaller size.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )

        **See also** **QTabBar::iconSize** .
        """
        ...

    def setMovable(self, movable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#movable-prop

        **movable : bool**

        This property holds whether the user can move the tabs within the tabbar
        area.

        By default, this property is `false`;

        **Access functions:**

        bool **isMovable** () const
        void **setMovable** (bool **movable** )
        """
        ...

    def setTabBar(self, arg__1: PySide6.QtWidgets.QTabBar) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabBar

        **[protected] void QTabWidget::setTabBar(QTabBar * tb )**

        Replaces the dialog's **QTabBar**  heading with the tab bar **tb**. Note
        that this must be called **before** any tabs have been added, or the
        behavior is undefined.

        **See also** **tabBar** ().
        """
        ...

    def setTabBarAutoHide(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabBarAutoHide-prop

        **[since 5.4] tabBarAutoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **tabBarAutoHide** () const
        void **setTabBarAutoHide** (bool
        **enabled** )

        **See also** **QWidget::visible** .
        """
        ...

    def setTabEnabled(self, index: int, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabEnabled

        **void QTabWidget::setTabEnabled(int index , bool enable )**

        If **enable** is true, the page at position **index** is enabled;
        otherwise the page at position **index** is disabled. The page's tab is
        redrawn appropriately.

        **QTabWidget**  uses **QWidget::setEnabled** () internally, rather than
        keeping a separate flag.

        Note that even a disabled tab/page may be visible. If the page is
        visible already, **QTabWidget**  will not hide it; if all the pages are
        disabled, **QTabWidget**  will show one of them.

        **See also** **isTabEnabled** () and **QWidget::setEnabled** ().
        """
        ...

    def setTabIcon(
        self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabIcon

        **void QTabWidget::setTabIcon(int index , const QIcon & icon )**

        Sets the **icon** for the tab at position **index**.

        **See also** **tabIcon** ().
        """
        ...

    def setTabPosition(
        self, position: PySide6.QtWidgets.QTabWidget.TabPosition
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabPosition-prop

        **tabPosition : TabPosition**

        This property holds the position of the tabs in this tab widget

        Possible values for this property are described by the **TabPosition**
        enum.

        By default, this property is set to **North** .

        **Access functions:**

        QTabWidget::TabPosition **tabPosition** () const
        void
        **setTabPosition** (QTabWidget::TabPosition **position** )

        **See also** **TabPosition** .
        """
        ...

    def setTabShape(self, s: PySide6.QtWidgets.QTabWidget.TabShape) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabShape-prop

        **tabShape : TabShape**

        This property holds the shape of the tabs in this tab widget

        Possible values for this property are **QTabWidget::Rounded**  (default)
        or **QTabWidget::Triangular** .

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **s** )

        **See also** **TabShape** .
        """
        ...

    def setTabText(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabText

        **void QTabWidget::setTabText(int index , const QString & label )**

        Defines a new **label** for the page at position **index** 's tab.

        If the provided text contains an ampersand character ('&'), a shortcut
        is automatically created for it. The character that follows the '&' will
        be used as the shortcut key. Any previous shortcut will be overwritten,
        or cleared if no shortcut is defined by the text. See the **QShortcut**
        documentation for details (to display an actual ampersand, use '&&').

        **See also** **tabText** ().
        """
        ...

    def setTabToolTip(self, index: int, tip: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabToolTip

        **void QTabWidget::setTabToolTip(int index , const QString & tip )**

        Sets the tab tool tip for the page at position **index** to **tip**.

        **See also** **tabToolTip** ().
        """
        ...

    def setTabVisible(self, index: int, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabVisible

        **[since 5.15] void QTabWidget::setTabVisible(int index , bool visible
        )**

        If **visible** is true, the page at position **index** is visible;
        otherwise the page at position **index** is hidden. The page's tab is
        redrawn appropriately.

        This function was introduced in Qt 5.15.

        **See also** **isTabVisible** ().
        """
        ...

    def setTabWhatsThis(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#setTabWhatsThis

        **void QTabWidget::setTabWhatsThis(int index , const QString & text )**

        Sets the What's This help text for the page at position **index** to
        **text**.

        **See also** **tabWhatsThis** ().
        """
        ...

    def setTabsClosable(self, closeable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether close buttons are automatically added to
        each tab.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closeable** )

        **See also** **QTabBar::tabsClosable** ().
        """
        ...

    def setUsesScrollButtons(self, useButtons: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style dependent.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabBar::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#showEvent

        **[override virtual protected] void QTabWidget::showEvent(QShowEvent
        *)**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#sizeHint

        **[override virtual] QSize QTabWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def tabBar(self) -> PySide6.QtWidgets.QTabBar:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabBar

        **QTabBar *QTabWidget::tabBar() const**

        Returns the current **QTabBar** .

        **See also** **setTabBar** ().
        """
        ...

    def tabBarAutoHide(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabBarAutoHide-prop

        **[since 5.4] tabBarAutoHide : bool**

        If true, the tab bar is automatically hidden when it contains less than
        2 tabs.

        By default, this property is false.

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **tabBarAutoHide** () const
        void **setTabBarAutoHide** (bool
        **enabled** )

        **See also** **QWidget::visible** .
        """
        ...

    def tabIcon(self, index: int) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabIcon

        **QIcon QTabWidget::tabIcon(int index ) const**

        Returns the icon for the tab on the page at position **index**.

        **See also** **setTabIcon** ().
        """
        ...

    def tabInserted(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabInserted

        **[virtual protected] void QTabWidget::tabInserted(int index )**

        This virtual handler is called after a new tab was added or inserted at
        position **index**.

        **See also** **tabRemoved** ().
        """
        ...

    def tabPosition(self) -> PySide6.QtWidgets.QTabWidget.TabPosition:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabPosition-prop

        **tabPosition : TabPosition**

        This property holds the position of the tabs in this tab widget

        Possible values for this property are described by the **TabPosition**
        enum.

        By default, this property is set to **North** .

        **Access functions:**

        QTabWidget::TabPosition **tabPosition** () const
        void
        **setTabPosition** (QTabWidget::TabPosition **position** )

        **See also** **TabPosition** .
        """
        ...

    def tabRemoved(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabRemoved

        **[virtual protected] void QTabWidget::tabRemoved(int index )**

        This virtual handler is called after a tab was removed from position
        **index**.

        **See also** **tabInserted** ().
        """
        ...

    def tabShape(self) -> PySide6.QtWidgets.QTabWidget.TabShape:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabShape-prop

        **tabShape : TabShape**

        This property holds the shape of the tabs in this tab widget

        Possible values for this property are **QTabWidget::Rounded**  (default)
        or **QTabWidget::Triangular** .

        **Access functions:**

        QTabWidget::TabShape **tabShape** () const
        void **setTabShape**
        (QTabWidget::TabShape **s** )

        **See also** **TabShape** .
        """
        ...

    def tabText(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabText

        **QString QTabWidget::tabText(int index ) const**

        Returns the label text for the tab on the page at position **index**.

        **See also** **setTabText** ().
        """
        ...

    def tabToolTip(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabToolTip

        **QString QTabWidget::tabToolTip(int index ) const**

        Returns the tab tool tip for the page at position **index** or an empty
        string if no tool tip has been set.

        **See also** **setTabToolTip** ().
        """
        ...

    def tabWhatsThis(self, index: int) -> str:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabWhatsThis

        **QString QTabWidget::tabWhatsThis(int index ) const**

        Returns the What's This help text for the page at position **index** ,
        or an empty string if no help text has been set.

        **See also** **setTabWhatsThis** ().
        """
        ...

    def tabsClosable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabsClosable-prop

        **tabsClosable : bool**

        This property holds whether close buttons are automatically added to
        each tab.

        **Access functions:**

        bool **tabsClosable** () const
        void **setTabsClosable** (bool
        **closeable** )

        **See also** **QTabBar::tabsClosable** ().
        """
        ...

    def usesScrollButtons(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#usesScrollButtons-prop

        **usesScrollButtons : bool**

        This property holds whether or not a tab bar should use buttons to
        scroll tabs when it has many tabs.

        When there are too many tabs in a tab bar for its size, the tab bar can
        either choose to expand its size or to add buttons that allow you to
        scroll through the tabs.

        By default the value is style dependent.

        **Access functions:**

        bool **usesScrollButtons** () const
        void **setUsesScrollButtons**
        (bool **useButtons** )

        **See also** **elideMode** , **QTabBar::usesScrollButtons** , and
        **QStyle::SH_TabBar_PreferNoArrows** .

        **Member Function Documentation**
        """
        ...

    def widget(self, index: int) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#widget

        **QWidget *QTabWidget::widget(int index ) const**

        Returns the tab page at index position **index** or `nullptr` if the
        **index** is out of range.
        """
        ...

    @property
    def currentChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#currentChanged

        **[signal] void QTabWidget::currentChanged(int index )**

        This signal is emitted whenever the current page index changes. The
        parameter is the new current page **index** position, or -1 if there
        isn't a new one (for example, if there are no widgets in the
        **QTabWidget** )

        **Note:** Notifier signal for property **currentIndex** .

        **See also** **currentWidget** () and **currentIndex** .
        """
        ...

    @property
    def tabBarClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabBarClicked

        **[signal, since 5.2] void QTabWidget::tabBarClicked(int index )**

        This signal is emitted when user clicks on a tab at an **index**.

        **index** refers to the tab clicked, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabBarDoubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabBarDoubleClicked

        **[signal, since 5.2] void QTabWidget::tabBarDoubleClicked(int index )**

        This signal is emitted when the user double clicks on a tab at an
        **index**.

        **index** is the index of a clicked tab, or -1 if no tab is under the
        cursor.

        This function was introduced in Qt 5.2.
        """
        ...

    @property
    def tabCloseRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtabwidget.html#tabCloseRequested

        **[signal] void QTabWidget::tabCloseRequested(int index )**

        This signal is emitted when the close button on a tab is clicked. The
        **index** is the index that should be removed.

        **See also** **setTabsClosable** ().
        """
        ...
