"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStyle(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qstyle.html

    **Detailed Description**

    Qt contains a set of QStyle subclasses that emulate the styles of the
    different platforms supported by Qt (QWindowsStyle, QMacStyle etc.). By
    default, these styles are built into the Qt GUI module. Styles can also be
    made available as plugins.

    Qt's built-in widgets use QStyle to perform nearly all of their drawing,
    ensuring that they look exactly like the equivalent native widgets. The
    diagram below shows a **QComboBox**  in nine different styles.

    ![Nine combo boxes](images/qstyle-comboboxes.png)

    Topics:

    **Setting a Style**

    The style of the entire application can be set using the
    **QApplication::setStyle** () function. It can also be specified by the user
    of the application, using the `-style` command-line option:

    ./myapplication -style windows

    If no style is specified, Qt will choose the most appropriate style for the
    user's platform or desktop environment.

    A style can also be set on an individual widget using the
    **QWidget::setStyle** () function.

    **Developing Style-Aware Custom Widgets**

    If you are developing custom widgets and want them to look good on all
    platforms, you can use QStyle functions to perform parts of the widget
    drawing, such as **drawItemText** (), **drawItemPixmap** (),
    **drawPrimitive** (), **drawControl** (), and **drawComplexControl** ().

    Most QStyle draw functions take four arguments:

    * an enum value specifying which graphical element to draw
      * a
    **QStyleOption**  specifying how and where to render that element
      * a
    **QPainter**  that should be used to draw the element
      * a **QWidget**  on
    which the drawing is performed (optional)

    For example, if you want to draw a focus rectangle on your widget, you can
    write:

    void MyWidget::paintEvent(**QPaintEvent**  * /* event */)
        {
    **QPainter**  painter(this);

            **QStyleOptionFocusRect**  option;
    option.initFrom(this);
            option.backgroundColor =
    palette().color(**QPalette** ::Background);
    style()->drawPrimitive(QStyle::PE_FrameFocusRect, &option, &painter, this);
    }

    QStyle gets all the information it needs to render the graphical element
    from **QStyleOption** . The widget is passed as the last argument in case
    the style needs it to perform special effects (such as animated default
    buttons on macOS), but it isn't mandatory. In fact, you can use QStyle to
    draw on any paint device, not just widgets, by setting the **QPainter**
    properly.

    **QStyleOption**  has various subclasses for the various types of graphical
    elements that can be drawn. For example, **PE_FrameFocusRect**  expects a
    **QStyleOptionFocusRect**  argument.

    To ensure that drawing operations are as fast as possible, **QStyleOption**
    and its subclasses have public data members. See the **QStyleOption**  class
    documentation for details on how to use it.

    For convenience, Qt provides the **QStylePainter**  class, which combines a
    QStyle, a **QPainter** , and a **QWidget** . This makes it possible to write

    **QStylePainter**  painter(this);
            ...
    painter.drawPrimitive(QStyle::PE_FrameFocusRect, option);

    instead of

    **QPainter**  painter(this);
            ...
    style()->drawPrimitive(QStyle::PE_FrameFocusRect, &option, &painter, this);

    **Creating a Custom Style**

    You can create a custom look and feel for your application by creating a
    custom style. There are two approaches to creating a custom style. In the
    static approach, you either choose an existing QStyle class, subclass it,
    and reimplement virtual functions to provide the custom behavior, or you
    create an entire QStyle class from scratch. In the dynamic approach, you
    modify the behavior of your system style at runtime. The static approach is
    described below. The dynamic approach is described in **QProxyStyle** .

    The first step in the static approach is to pick one of the styles provided
    by Qt from which you will build your custom style. Your choice of QStyle
    class will depend on which style resembles your desired style the most. The
    most general class that you can use as a base is **QCommonStyle**  (not
    QStyle). This is because Qt requires its styles to be **QCommonStyle** s.

    Depending on which parts of the base style you want to change, you must
    reimplement the functions that are used to draw those parts of the
    interface. To illustrate this, we will modify the look of the spin box
    arrows drawn by QWindowsStyle. The arrows are **primitive elements** that
    are drawn by the **drawPrimitive** () function, so we need to reimplement
    that function. We need the following class declaration:

    class CustomStyle : public **QProxyStyle**
        {
            Q_OBJECT
    public:
            CustomStyle(const **QWidget**  *widget);
    ~CustomStyle() {}

            void drawPrimitive(PrimitiveElement element,
    const **QStyleOption**  *option,
                               **QPainter**
    *painter, const **QWidget**  *widget) const override;
        };

    To draw its up and down arrows, **QSpinBox**  uses the
    **PE_IndicatorSpinUp**  and **PE_IndicatorSpinDown**  primitive elements.
    Here's how to reimplement the **drawPrimitive** () function to draw them
    differently:

    void CustomStyle::drawPrimitive(PrimitiveElement element, const
    **QStyleOption**  *option,
                                        **QPainter**
    *painter, const **QWidget**  *widget) const
        {
            if (element ==
    PE_IndicatorSpinUp || element == PE_IndicatorSpinDown) {
    **QPolygon**  points(3);
                int x = option->rect.x();
    int y = option->rect.y();
                int w = option->rect.width() / 2;
    int h = option->rect.height() / 2;
                x += (option->rect.width() -
    w) / 2;
                y += (option->rect.height() - h) / 2;
    if (element == PE_IndicatorSpinUp) {
                    points[0] = **QPoint**
    (x, y + h);
                    points[1] = **QPoint** (x + w, y + h);
    points[2] = **QPoint** (x + w / 2, y);
                } else { //
    PE_SpinBoxDown
                    points[0] = **QPoint** (x, y);
    points[1] = **QPoint** (x + w, y);
                    points[2] = **QPoint** (x
    + w / 2, y + h);
                }

                if (option->state &
    State_Enabled) {
    painter->setPen(option->palette.mid().color());
    painter->setBrush(option->palette.buttonText());
                } else {
    painter->setPen(option->palette.buttonText().color());
    painter->setBrush(option->palette.mid());
                }
    painter->drawPolygon(points);
            } else {
            **QProxyStyle**
    ::drawPrimitive(element, option, painter, widget);
            }
        }

    Notice that we don't use the `widget` argument, except to pass it on to the
    QWindowStyle::drawPrimitive() function. As mentioned earlier, the
    information about what is to be drawn and how it should be drawn is
    specified by a **QStyleOption**  object, so there is no need to ask the
    widget.

    If you need to use the `widget` argument to obtain additional information,
    be careful to ensure that it isn't 0 and that it is of the correct type
    before using it. For example:

    const **QSpinBox**  *spinBox = qobject_cast<const **QSpinBox**  *>(widget);
    if (spinBox) {
            ...
            }

    When implementing a custom style, you cannot assume that the widget is a
    **QSpinBox**  just because the enum value is called **PE_IndicatorSpinUp**
    or **PE_IndicatorSpinDown** .

    The documentation for the **Styles**  example covers this topic in more
    detail.

    **Warning:** Qt style sheets are currently not supported for custom QStyle
    subclasses. We plan to address this in some future release.

    **Using a Custom Style**

    There are several ways of using a custom style in a Qt application. The
    simplest way is to pass the custom style to the **QApplication::setStyle**
    () static function before creating the **QApplication**  object:

    #include <QtWidgets>

        #include "customstyle.h"

        int main(int
    argc, char *argv[])
        {
            **QApplication** ::setStyle(new
    CustomStyle);
            **QApplication**  app(argc, argv);
    **QSpinBox**  spinBox;
            spinBox.show();
            return app.exec();
    }

    You can call **QApplication::setStyle** () at any time, but by calling it
    before the constructor, you ensure that the user's preference, set using the
    `-style` command-line option, is respected.

    You may want to make your custom style available for use in other
    applications, which may not be yours and hence not available for you to
    recompile. The Qt Plugin system makes it possible to create styles as
    plugins. Styles created as plugins are loaded as shared objects at runtime
    by Qt itself. Please refer to the **Qt Plugin**  documentation for more
    information on how to go about creating a style plugin.

    Compile your plugin and put it into Qt's `plugins/styles` directory. We now
    have a pluggable style that Qt can load automatically. To use your new style
    with existing applications, simply start the application with the following
    argument:

    ./myapplication -style custom

    The application will use the look and feel from the custom style you
    implemented.

    **Right-to-Left Desktops**

    Languages written from right to left (such as Arabic and Hebrew) usually
    also mirror the whole layout of widgets, and require the light to come from
    the screen's top-right corner instead of top-left.

    If you create a custom style, you should take special care when drawing
    asymmetric elements to make sure that they also look correct in a mirrored
    layout. An easy way to test your styles is to run applications with the
    `-reverse` command-line option or to call
    **QApplication::setLayoutDirection** () in your `main()` function.

    Here are some things to keep in mind when making a style work well in a
    right-to-left environment:

    * **subControlRect** () and **subElementRect** () return rectangles in
    screen coordinates
      * **QStyleOption::direction**  indicates in which
    direction the item should be drawn in
      * If a style is not right-to-left
    aware it will display items as if it were left-to-right
      * **visualRect**
    (), **visualPos** (), and **visualAlignment** () are helpful functions that
    will translate from logical to screen representations.
      * **alignedRect**
    () will return a logical rect aligned for the current direction

    **Styles in Item Views**

    The painting of items in views is performed by a delegate. Qt's default
    delegate, **QStyledItemDelegate** , is also used for calculating bounding
    rectangles of items, and their sub-elements for the various kind of item
    **data roles**  **QStyledItemDelegate**  supports. See the
    **QStyledItemDelegate**  class description to find out which datatypes and
    roles are supported. You can read more about item data roles in **Model/View
    Programming** .

    When **QStyledItemDelegate**  paints its items, it draws **CE_ItemViewItem**
    , and calculates their size with **CT_ItemViewItem** . Note also that it
    uses **SE_ItemViewItemText**  to set the size of editors. When implementing
    a style to customize drawing of item views, you need to check the
    implementation of **QCommonStyle**  (and any other subclasses from which
    your style inherits). This way, you find out which and how other style
    elements are painted, and you can then reimplement the painting of elements
    that should be drawn differently.

    We include a small example where we customize the drawing of item
    backgrounds.

    switch (element) {
                case (PE_PanelItemViewItem): {
    painter->save();

                    **QPoint**  topLeft =
    option->rect.topLeft();
                    **QPoint**  bottomRight =
    option->rect.topRight();
                    **QLinearGradient**
    backgroundGradient(topLeft, bottomRight);
    backgroundGradient.setColorAt(0.0, **QColor** (Qt::yellow).lighter(190));
    backgroundGradient.setColorAt(1.0, Qt::white);
    painter->fillRect(option->rect, **QBrush** (backgroundGradient));
    painter->restore();
                break;
                }
                default:
    **QProxyStyle** ::drawPrimitive(element, option, painter, widget);
            }

    The primitive element **PE_PanelItemViewItem**  is responsible for painting
    the background of items, and is called from **QCommonStyle** 's
    implementation of **CE_ItemViewItem** .

    To add support for drawing of new datatypes and item data roles, it is
    necessary to create a custom delegate. But if you only need to support the
    datatypes implemented by the default delegate, a custom style does not need
    an accompanying delegate. The **QStyledItemDelegate**  class description
    gives more information on custom delegates.

    The drawing of item view headers is also done by the style, giving control
    over size of header items and row and column sizes.

    **See also** **QStyleOption** , **QStylePainter** , **Styles Example** ,
    **Styles and Style Aware Widgets** , **QStyledItemDelegate** , and
    **Styling** .
    """

    CC_CustomBase: QStyle.ComplexControl = ...
    CC_SpinBox: QStyle.ComplexControl = ...
    CC_ComboBox: QStyle.ComplexControl = ...
    CC_ScrollBar: QStyle.ComplexControl = ...
    CC_Slider: QStyle.ComplexControl = ...
    CC_ToolButton: QStyle.ComplexControl = ...
    CC_TitleBar: QStyle.ComplexControl = ...
    CC_Dial: QStyle.ComplexControl = ...
    CC_GroupBox: QStyle.ComplexControl = ...
    CC_MdiControls: QStyle.ComplexControl = ...
    CT_CustomBase: QStyle.ContentsType = ...
    CT_PushButton: QStyle.ContentsType = ...
    CT_CheckBox: QStyle.ContentsType = ...
    CT_RadioButton: QStyle.ContentsType = ...
    CT_ToolButton: QStyle.ContentsType = ...
    CT_ComboBox: QStyle.ContentsType = ...
    CT_Splitter: QStyle.ContentsType = ...
    CT_ProgressBar: QStyle.ContentsType = ...
    CT_MenuItem: QStyle.ContentsType = ...
    CT_MenuBarItem: QStyle.ContentsType = ...
    CT_MenuBar: QStyle.ContentsType = ...
    CT_Menu: QStyle.ContentsType = ...
    CT_TabBarTab: QStyle.ContentsType = ...
    CT_Slider: QStyle.ContentsType = ...
    CT_ScrollBar: QStyle.ContentsType = ...
    CT_LineEdit: QStyle.ContentsType = ...
    CT_SpinBox: QStyle.ContentsType = ...
    CT_SizeGrip: QStyle.ContentsType = ...
    CT_TabWidget: QStyle.ContentsType = ...
    CT_DialogButtons: QStyle.ContentsType = ...
    CT_HeaderSection: QStyle.ContentsType = ...
    CT_GroupBox: QStyle.ContentsType = ...
    CT_MdiControls: QStyle.ContentsType = ...
    CT_ItemViewItem: QStyle.ContentsType = ...
    CE_CustomBase: QStyle.ControlElement = ...
    CE_PushButton: QStyle.ControlElement = ...
    CE_PushButtonBevel: QStyle.ControlElement = ...
    CE_PushButtonLabel: QStyle.ControlElement = ...
    CE_CheckBox: QStyle.ControlElement = ...
    CE_CheckBoxLabel: QStyle.ControlElement = ...
    CE_RadioButton: QStyle.ControlElement = ...
    CE_RadioButtonLabel: QStyle.ControlElement = ...
    CE_TabBarTab: QStyle.ControlElement = ...
    CE_TabBarTabShape: QStyle.ControlElement = ...
    CE_TabBarTabLabel: QStyle.ControlElement = ...
    CE_ProgressBar: QStyle.ControlElement = ...
    CE_ProgressBarGroove: QStyle.ControlElement = ...
    CE_ProgressBarContents: QStyle.ControlElement = ...
    CE_ProgressBarLabel: QStyle.ControlElement = ...
    CE_MenuItem: QStyle.ControlElement = ...
    CE_MenuScroller: QStyle.ControlElement = ...
    CE_MenuVMargin: QStyle.ControlElement = ...
    CE_MenuHMargin: QStyle.ControlElement = ...
    CE_MenuTearoff: QStyle.ControlElement = ...
    CE_MenuEmptyArea: QStyle.ControlElement = ...
    CE_MenuBarItem: QStyle.ControlElement = ...
    CE_MenuBarEmptyArea: QStyle.ControlElement = ...
    CE_ToolButtonLabel: QStyle.ControlElement = ...
    CE_Header: QStyle.ControlElement = ...
    CE_HeaderSection: QStyle.ControlElement = ...
    CE_HeaderLabel: QStyle.ControlElement = ...
    CE_ToolBoxTab: QStyle.ControlElement = ...
    CE_SizeGrip: QStyle.ControlElement = ...
    CE_Splitter: QStyle.ControlElement = ...
    CE_RubberBand: QStyle.ControlElement = ...
    CE_DockWidgetTitle: QStyle.ControlElement = ...
    CE_ScrollBarAddLine: QStyle.ControlElement = ...
    CE_ScrollBarSubLine: QStyle.ControlElement = ...
    CE_ScrollBarAddPage: QStyle.ControlElement = ...
    CE_ScrollBarSubPage: QStyle.ControlElement = ...
    CE_ScrollBarSlider: QStyle.ControlElement = ...
    CE_ScrollBarFirst: QStyle.ControlElement = ...
    CE_ScrollBarLast: QStyle.ControlElement = ...
    CE_FocusFrame: QStyle.ControlElement = ...
    CE_ComboBoxLabel: QStyle.ControlElement = ...
    CE_ToolBar: QStyle.ControlElement = ...
    CE_ToolBoxTabShape: QStyle.ControlElement = ...
    CE_ToolBoxTabLabel: QStyle.ControlElement = ...
    CE_HeaderEmptyArea: QStyle.ControlElement = ...
    CE_ColumnViewGrip: QStyle.ControlElement = ...
    CE_ItemViewItem: QStyle.ControlElement = ...
    CE_ShapedFrame: QStyle.ControlElement = ...
    PM_CustomBase: QStyle.PixelMetric = ...
    PM_ButtonMargin: QStyle.PixelMetric = ...
    PM_ButtonDefaultIndicator: QStyle.PixelMetric = ...
    PM_MenuButtonIndicator: QStyle.PixelMetric = ...
    PM_ButtonShiftHorizontal: QStyle.PixelMetric = ...
    PM_ButtonShiftVertical: QStyle.PixelMetric = ...
    PM_DefaultFrameWidth: QStyle.PixelMetric = ...
    PM_SpinBoxFrameWidth: QStyle.PixelMetric = ...
    PM_ComboBoxFrameWidth: QStyle.PixelMetric = ...
    PM_MaximumDragDistance: QStyle.PixelMetric = ...
    PM_ScrollBarExtent: QStyle.PixelMetric = ...
    PM_ScrollBarSliderMin: QStyle.PixelMetric = ...
    PM_SliderThickness: QStyle.PixelMetric = ...
    PM_SliderControlThickness: QStyle.PixelMetric = ...
    PM_SliderLength: QStyle.PixelMetric = ...
    PM_SliderTickmarkOffset: QStyle.PixelMetric = ...
    PM_SliderSpaceAvailable: QStyle.PixelMetric = ...
    PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ...
    PM_DockWidgetHandleExtent: QStyle.PixelMetric = ...
    PM_DockWidgetFrameWidth: QStyle.PixelMetric = ...
    PM_TabBarTabOverlap: QStyle.PixelMetric = ...
    PM_TabBarTabHSpace: QStyle.PixelMetric = ...
    PM_TabBarTabVSpace: QStyle.PixelMetric = ...
    PM_TabBarBaseHeight: QStyle.PixelMetric = ...
    PM_TabBarBaseOverlap: QStyle.PixelMetric = ...
    PM_ProgressBarChunkWidth: QStyle.PixelMetric = ...
    PM_SplitterWidth: QStyle.PixelMetric = ...
    PM_TitleBarHeight: QStyle.PixelMetric = ...
    PM_MenuScrollerHeight: QStyle.PixelMetric = ...
    PM_MenuHMargin: QStyle.PixelMetric = ...
    PM_MenuVMargin: QStyle.PixelMetric = ...
    PM_MenuPanelWidth: QStyle.PixelMetric = ...
    PM_MenuTearoffHeight: QStyle.PixelMetric = ...
    PM_MenuDesktopFrameWidth: QStyle.PixelMetric = ...
    PM_MenuBarPanelWidth: QStyle.PixelMetric = ...
    PM_MenuBarItemSpacing: QStyle.PixelMetric = ...
    PM_MenuBarVMargin: QStyle.PixelMetric = ...
    PM_MenuBarHMargin: QStyle.PixelMetric = ...
    PM_IndicatorWidth: QStyle.PixelMetric = ...
    PM_IndicatorHeight: QStyle.PixelMetric = ...
    PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ...
    PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ...
    PM_DialogButtonsSeparator: QStyle.PixelMetric = ...
    PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ...
    PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ...
    PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ...
    PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ...
    PM_HeaderMargin: QStyle.PixelMetric = ...
    PM_HeaderMarkSize: QStyle.PixelMetric = ...
    PM_HeaderGripMargin: QStyle.PixelMetric = ...
    PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ...
    PM_TabBarTabShiftVertical: QStyle.PixelMetric = ...
    PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ...
    PM_ToolBarFrameWidth: QStyle.PixelMetric = ...
    PM_ToolBarHandleExtent: QStyle.PixelMetric = ...
    PM_ToolBarItemSpacing: QStyle.PixelMetric = ...
    PM_ToolBarItemMargin: QStyle.PixelMetric = ...
    PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ...
    PM_ToolBarExtensionExtent: QStyle.PixelMetric = ...
    PM_SpinBoxSliderHeight: QStyle.PixelMetric = ...
    PM_ToolBarIconSize: QStyle.PixelMetric = ...
    PM_ListViewIconSize: QStyle.PixelMetric = ...
    PM_IconViewIconSize: QStyle.PixelMetric = ...
    PM_SmallIconSize: QStyle.PixelMetric = ...
    PM_LargeIconSize: QStyle.PixelMetric = ...
    PM_FocusFrameVMargin: QStyle.PixelMetric = ...
    PM_FocusFrameHMargin: QStyle.PixelMetric = ...
    PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ...
    PM_CheckBoxLabelSpacing: QStyle.PixelMetric = ...
    PM_TabBarIconSize: QStyle.PixelMetric = ...
    PM_SizeGripSize: QStyle.PixelMetric = ...
    PM_DockWidgetTitleMargin: QStyle.PixelMetric = ...
    PM_MessageBoxIconSize: QStyle.PixelMetric = ...
    PM_ButtonIconSize: QStyle.PixelMetric = ...
    PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ...
    PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ...
    PM_LayoutLeftMargin: QStyle.PixelMetric = ...
    PM_LayoutTopMargin: QStyle.PixelMetric = ...
    PM_LayoutRightMargin: QStyle.PixelMetric = ...
    PM_LayoutBottomMargin: QStyle.PixelMetric = ...
    PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ...
    PM_LayoutVerticalSpacing: QStyle.PixelMetric = ...
    PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ...
    PM_TextCursorWidth: QStyle.PixelMetric = ...
    PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ...
    PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ...
    PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ...
    PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ...
    PM_SubMenuOverlap: QStyle.PixelMetric = ...
    PM_TreeViewIndentation: QStyle.PixelMetric = ...
    PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ...
    PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ...
    PM_TitleBarButtonIconSize: QStyle.PixelMetric = ...
    PM_TitleBarButtonSize: QStyle.PixelMetric = ...
    PM_LineEditIconSize: QStyle.PixelMetric = ...
    PE_Frame: QStyle.PrimitiveElement = ...
    PE_FrameDefaultButton: QStyle.PrimitiveElement = ...
    PE_FrameDockWidget: QStyle.PrimitiveElement = ...
    PE_FrameFocusRect: QStyle.PrimitiveElement = ...
    PE_FrameGroupBox: QStyle.PrimitiveElement = ...
    PE_FrameLineEdit: QStyle.PrimitiveElement = ...
    PE_FrameMenu: QStyle.PrimitiveElement = ...
    PE_FrameStatusBarItem: QStyle.PrimitiveElement = ...
    PE_FrameTabWidget: QStyle.PrimitiveElement = ...
    PE_FrameWindow: QStyle.PrimitiveElement = ...
    PE_FrameButtonBevel: QStyle.PrimitiveElement = ...
    PE_FrameButtonTool: QStyle.PrimitiveElement = ...
    PE_FrameTabBarBase: QStyle.PrimitiveElement = ...
    PE_PanelButtonCommand: QStyle.PrimitiveElement = ...
    PE_PanelButtonBevel: QStyle.PrimitiveElement = ...
    PE_PanelButtonTool: QStyle.PrimitiveElement = ...
    PE_PanelMenuBar: QStyle.PrimitiveElement = ...
    PE_PanelToolBar: QStyle.PrimitiveElement = ...
    PE_PanelLineEdit: QStyle.PrimitiveElement = ...
    PE_IndicatorArrowDown: QStyle.PrimitiveElement = ...
    PE_IndicatorArrowLeft: QStyle.PrimitiveElement = ...
    PE_IndicatorArrowRight: QStyle.PrimitiveElement = ...
    PE_IndicatorArrowUp: QStyle.PrimitiveElement = ...
    PE_IndicatorBranch: QStyle.PrimitiveElement = ...
    PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ...
    PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ...
    PE_IndicatorCheckBox: QStyle.PrimitiveElement = ...
    PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ...
    PE_IndicatorHeaderArrow: QStyle.PrimitiveElement = ...
    PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ...
    PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ...
    PE_IndicatorRadioButton: QStyle.PrimitiveElement = ...
    PE_IndicatorSpinDown: QStyle.PrimitiveElement = ...
    PE_IndicatorSpinMinus: QStyle.PrimitiveElement = ...
    PE_IndicatorSpinPlus: QStyle.PrimitiveElement = ...
    PE_IndicatorSpinUp: QStyle.PrimitiveElement = ...
    PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ...
    PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ...
    PE_PanelTipLabel: QStyle.PrimitiveElement = ...
    PE_IndicatorTabTear: QStyle.PrimitiveElement = ...
    PE_IndicatorTabTearLeft: QStyle.PrimitiveElement = ...
    PE_PanelScrollAreaCorner: QStyle.PrimitiveElement = ...
    PE_Widget: QStyle.PrimitiveElement = ...
    PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ...
    PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ...
    PE_PanelItemViewItem: QStyle.PrimitiveElement = ...
    PE_PanelItemViewRow: QStyle.PrimitiveElement = ...
    PE_PanelStatusBar: QStyle.PrimitiveElement = ...
    PE_IndicatorTabClose: QStyle.PrimitiveElement = ...
    PE_PanelMenu: QStyle.PrimitiveElement = ...
    PE_IndicatorTabTearRight: QStyle.PrimitiveElement = ...
    PE_CustomBase: QStyle.PrimitiveElement = ...
    RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ...
    RSIP_OnMouseClick: QStyle.RequestSoftwareInputPanel = ...
    SP_CustomBase: QStyle.StandardPixmap = ...
    SP_TitleBarMenuButton: QStyle.StandardPixmap = ...
    SP_TitleBarMinButton: QStyle.StandardPixmap = ...
    SP_TitleBarMaxButton: QStyle.StandardPixmap = ...
    SP_TitleBarCloseButton: QStyle.StandardPixmap = ...
    SP_TitleBarNormalButton: QStyle.StandardPixmap = ...
    SP_TitleBarShadeButton: QStyle.StandardPixmap = ...
    SP_TitleBarUnshadeButton: QStyle.StandardPixmap = ...
    SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ...
    SP_DockWidgetCloseButton: QStyle.StandardPixmap = ...
    SP_MessageBoxInformation: QStyle.StandardPixmap = ...
    SP_MessageBoxWarning: QStyle.StandardPixmap = ...
    SP_MessageBoxCritical: QStyle.StandardPixmap = ...
    SP_MessageBoxQuestion: QStyle.StandardPixmap = ...
    SP_DesktopIcon: QStyle.StandardPixmap = ...
    SP_TrashIcon: QStyle.StandardPixmap = ...
    SP_ComputerIcon: QStyle.StandardPixmap = ...
    SP_DriveFDIcon: QStyle.StandardPixmap = ...
    SP_DriveHDIcon: QStyle.StandardPixmap = ...
    SP_DriveCDIcon: QStyle.StandardPixmap = ...
    SP_DriveDVDIcon: QStyle.StandardPixmap = ...
    SP_DriveNetIcon: QStyle.StandardPixmap = ...
    SP_DirOpenIcon: QStyle.StandardPixmap = ...
    SP_DirClosedIcon: QStyle.StandardPixmap = ...
    SP_DirLinkIcon: QStyle.StandardPixmap = ...
    SP_DirLinkOpenIcon: QStyle.StandardPixmap = ...
    SP_FileIcon: QStyle.StandardPixmap = ...
    SP_FileLinkIcon: QStyle.StandardPixmap = ...
    SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ...
    SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ...
    SP_FileDialogStart: QStyle.StandardPixmap = ...
    SP_FileDialogEnd: QStyle.StandardPixmap = ...
    SP_FileDialogToParent: QStyle.StandardPixmap = ...
    SP_FileDialogNewFolder: QStyle.StandardPixmap = ...
    SP_FileDialogDetailedView: QStyle.StandardPixmap = ...
    SP_FileDialogInfoView: QStyle.StandardPixmap = ...
    SP_FileDialogContentsView: QStyle.StandardPixmap = ...
    SP_FileDialogListView: QStyle.StandardPixmap = ...
    SP_FileDialogBack: QStyle.StandardPixmap = ...
    SP_DirIcon: QStyle.StandardPixmap = ...
    SP_DialogOkButton: QStyle.StandardPixmap = ...
    SP_DialogCancelButton: QStyle.StandardPixmap = ...
    SP_DialogHelpButton: QStyle.StandardPixmap = ...
    SP_DialogOpenButton: QStyle.StandardPixmap = ...
    SP_DialogSaveButton: QStyle.StandardPixmap = ...
    SP_DialogCloseButton: QStyle.StandardPixmap = ...
    SP_DialogApplyButton: QStyle.StandardPixmap = ...
    SP_DialogResetButton: QStyle.StandardPixmap = ...
    SP_DialogDiscardButton: QStyle.StandardPixmap = ...
    SP_DialogYesButton: QStyle.StandardPixmap = ...
    SP_DialogNoButton: QStyle.StandardPixmap = ...
    SP_ArrowUp: QStyle.StandardPixmap = ...
    SP_ArrowDown: QStyle.StandardPixmap = ...
    SP_ArrowLeft: QStyle.StandardPixmap = ...
    SP_ArrowRight: QStyle.StandardPixmap = ...
    SP_ArrowBack: QStyle.StandardPixmap = ...
    SP_ArrowForward: QStyle.StandardPixmap = ...
    SP_DirHomeIcon: QStyle.StandardPixmap = ...
    SP_CommandLink: QStyle.StandardPixmap = ...
    SP_VistaShield: QStyle.StandardPixmap = ...
    SP_BrowserReload: QStyle.StandardPixmap = ...
    SP_BrowserStop: QStyle.StandardPixmap = ...
    SP_MediaPlay: QStyle.StandardPixmap = ...
    SP_MediaStop: QStyle.StandardPixmap = ...
    SP_MediaPause: QStyle.StandardPixmap = ...
    SP_MediaSkipForward: QStyle.StandardPixmap = ...
    SP_MediaSkipBackward: QStyle.StandardPixmap = ...
    SP_MediaSeekForward: QStyle.StandardPixmap = ...
    SP_MediaSeekBackward: QStyle.StandardPixmap = ...
    SP_MediaVolume: QStyle.StandardPixmap = ...
    SP_MediaVolumeMuted: QStyle.StandardPixmap = ...
    SP_LineEditClearButton: QStyle.StandardPixmap = ...
    SP_DialogYesToAllButton: QStyle.StandardPixmap = ...
    SP_DialogNoToAllButton: QStyle.StandardPixmap = ...
    SP_DialogSaveAllButton: QStyle.StandardPixmap = ...
    SP_DialogAbortButton: QStyle.StandardPixmap = ...
    SP_DialogRetryButton: QStyle.StandardPixmap = ...
    SP_DialogIgnoreButton: QStyle.StandardPixmap = ...
    SP_RestoreDefaultsButton: QStyle.StandardPixmap = ...
    State_None: QStyle.StateFlag = ...
    State_Enabled: QStyle.StateFlag = ...
    State_Raised: QStyle.StateFlag = ...
    State_Sunken: QStyle.StateFlag = ...
    State_Off: QStyle.StateFlag = ...
    State_NoChange: QStyle.StateFlag = ...
    State_On: QStyle.StateFlag = ...
    State_DownArrow: QStyle.StateFlag = ...
    State_Horizontal: QStyle.StateFlag = ...
    State_HasFocus: QStyle.StateFlag = ...
    State_Top: QStyle.StateFlag = ...
    State_Bottom: QStyle.StateFlag = ...
    State_FocusAtBorder: QStyle.StateFlag = ...
    State_AutoRaise: QStyle.StateFlag = ...
    State_MouseOver: QStyle.StateFlag = ...
    State_UpArrow: QStyle.StateFlag = ...
    State_Selected: QStyle.StateFlag = ...
    State_Active: QStyle.StateFlag = ...
    State_Window: QStyle.StateFlag = ...
    State_Open: QStyle.StateFlag = ...
    State_Children: QStyle.StateFlag = ...
    State_Item: QStyle.StateFlag = ...
    State_Sibling: QStyle.StateFlag = ...
    State_Editing: QStyle.StateFlag = ...
    State_KeyboardFocusChange: QStyle.StateFlag = ...
    State_ReadOnly: QStyle.StateFlag = ...
    State_Small: QStyle.StateFlag = ...
    State_Mini: QStyle.StateFlag = ...
    SH_CustomBase: QStyle.StyleHint = ...
    SH_EtchDisabledText: QStyle.StyleHint = ...
    SH_DitherDisabledText: QStyle.StyleHint = ...
    SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ...
    SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ...
    SH_TabBar_SelectMouseType: QStyle.StyleHint = ...
    SH_TabBar_Alignment: QStyle.StyleHint = ...
    SH_Header_ArrowAlignment: QStyle.StyleHint = ...
    SH_Slider_SnapToValue: QStyle.StyleHint = ...
    SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ...
    SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ...
    SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ...
    SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ...
    SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ...
    SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ...
    SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ...
    SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ...
    SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ...
    SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ...
    SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ...
    SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ...
    SH_Menu_MouseTracking: QStyle.StyleHint = ...
    SH_MenuBar_MouseTracking: QStyle.StyleHint = ...
    SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ...
    SH_Widget_ShareActivation: QStyle.StyleHint = ...
    SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ...
    SH_ComboBox_Popup: QStyle.StyleHint = ...
    SH_TitleBar_NoBorder: QStyle.StyleHint = ...
    SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ...
    SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ...
    SH_RichText_FullWidthSelection: QStyle.StyleHint = ...
    SH_Menu_Scrollable: QStyle.StyleHint = ...
    SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ...
    SH_GroupBox_TextLabelColor: QStyle.StyleHint = ...
    SH_Menu_SloppySubMenus: QStyle.StyleHint = ...
    SH_Table_GridLineColor: QStyle.StyleHint = ...
    SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ...
    SH_DialogButtons_DefaultButton: QStyle.StyleHint = ...
    SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ...
    SH_TabBar_PreferNoArrows: QStyle.StyleHint = ...
    SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ...
    SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ...
    SH_UnderlineShortcut: QStyle.StyleHint = ...
    SH_SpinBox_AnimateButton: QStyle.StyleHint = ...
    SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ...
    SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ...
    SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ...
    SH_ToolTipLabel_Opacity: QStyle.StyleHint = ...
    SH_DrawMenuBarSeparator: QStyle.StyleHint = ...
    SH_TitleBar_ModifyNotification: QStyle.StyleHint = ...
    SH_Button_FocusPolicy: QStyle.StyleHint = ...
    SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ...
    SH_TitleBar_AutoRaise: QStyle.StyleHint = ...
    SH_ToolButton_PopupDelay: QStyle.StyleHint = ...
    SH_FocusFrame_Mask: QStyle.StyleHint = ...
    SH_RubberBand_Mask: QStyle.StyleHint = ...
    SH_WindowFrame_Mask: QStyle.StyleHint = ...
    SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ...
    SH_Dial_BackgroundRole: QStyle.StyleHint = ...
    SH_ComboBox_LayoutDirection: QStyle.StyleHint = ...
    SH_ItemView_EllipsisLocation: QStyle.StyleHint = ...
    SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ...
    SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ...
    SH_ScrollBar_ContextMenu: QStyle.StyleHint = ...
    SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ...
    SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ...
    SH_Slider_PageSetButtons: QStyle.StyleHint = ...
    SH_Menu_KeyboardSearch: QStyle.StyleHint = ...
    SH_TabBar_ElideMode: QStyle.StyleHint = ...
    SH_DialogButtonLayout: QStyle.StyleHint = ...
    SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ...
    SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ...
    SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ...
    SH_MessageBox_CenterButtons: QStyle.StyleHint = ...
    SH_Menu_SelectionWrap: QStyle.StyleHint = ...
    SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ...
    SH_ToolTip_Mask: QStyle.StyleHint = ...
    SH_FocusFrame_AboveWidget: QStyle.StyleHint = ...
    SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ...
    SH_WizardStyle: QStyle.StyleHint = ...
    SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ...
    SH_Menu_Mask: QStyle.StyleHint = ...
    SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ...
    SH_Menu_FadeOutOnHide: QStyle.StyleHint = ...
    SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ...
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ...
    SH_FormLayoutWrapPolicy: QStyle.StyleHint = ...
    SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ...
    SH_ToolBar_Movable: QStyle.StyleHint = ...
    SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ...
    SH_FormLayoutFormAlignment: QStyle.StyleHint = ...
    SH_FormLayoutLabelAlignment: QStyle.StyleHint = ...
    SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ...
    SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ...
    SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ...
    SH_ToolButtonStyle: QStyle.StyleHint = ...
    SH_RequestSoftwareInputPanel: QStyle.StyleHint = ...
    SH_ScrollBar_Transient: QStyle.StyleHint = ...
    SH_Menu_SupportsSections: QStyle.StyleHint = ...
    SH_ToolTip_WakeUpDelay: QStyle.StyleHint = ...
    SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ...
    SH_Widget_Animate: QStyle.StyleHint = ...
    SH_Splitter_OpaqueResize: QStyle.StyleHint = ...
    SH_ComboBox_UseNativePopup: QStyle.StyleHint = ...
    SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ...
    SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ...
    SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ...
    SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ...
    SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ...
    SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ...
    SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ...
    SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ...
    SH_ItemView_ScrollMode: QStyle.StyleHint = ...
    SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ...
    SH_Widget_Animation_Duration: QStyle.StyleHint = ...
    SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ...
    SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ...
    SH_SpinBox_StepModifier: QStyle.StyleHint = ...
    SH_TabBar_AllowWheelScrolling: QStyle.StyleHint = ...
    SC_CustomBase: QStyle.SubControl = ...
    SC_All: QStyle.SubControl = ...
    SC_None: QStyle.SubControl = ...
    SC_ComboBoxFrame: QStyle.SubControl = ...
    SC_DialGroove: QStyle.SubControl = ...
    SC_GroupBoxCheckBox: QStyle.SubControl = ...
    SC_MdiMinButton: QStyle.SubControl = ...
    SC_ScrollBarAddLine: QStyle.SubControl = ...
    SC_SliderGroove: QStyle.SubControl = ...
    SC_SpinBoxUp: QStyle.SubControl = ...
    SC_TitleBarSysMenu: QStyle.SubControl = ...
    SC_ToolButton: QStyle.SubControl = ...
    SC_ComboBoxEditField: QStyle.SubControl = ...
    SC_DialHandle: QStyle.SubControl = ...
    SC_GroupBoxLabel: QStyle.SubControl = ...
    SC_MdiNormalButton: QStyle.SubControl = ...
    SC_ScrollBarSubLine: QStyle.SubControl = ...
    SC_SliderHandle: QStyle.SubControl = ...
    SC_SpinBoxDown: QStyle.SubControl = ...
    SC_TitleBarMinButton: QStyle.SubControl = ...
    SC_ToolButtonMenu: QStyle.SubControl = ...
    SC_ComboBoxArrow: QStyle.SubControl = ...
    SC_DialTickmarks: QStyle.SubControl = ...
    SC_GroupBoxContents: QStyle.SubControl = ...
    SC_MdiCloseButton: QStyle.SubControl = ...
    SC_ScrollBarAddPage: QStyle.SubControl = ...
    SC_SliderTickmarks: QStyle.SubControl = ...
    SC_SpinBoxFrame: QStyle.SubControl = ...
    SC_TitleBarMaxButton: QStyle.SubControl = ...
    SC_ComboBoxListBoxPopup: QStyle.SubControl = ...
    SC_GroupBoxFrame: QStyle.SubControl = ...
    SC_ScrollBarSubPage: QStyle.SubControl = ...
    SC_SpinBoxEditField: QStyle.SubControl = ...
    SC_TitleBarCloseButton: QStyle.SubControl = ...
    SC_ScrollBarFirst: QStyle.SubControl = ...
    SC_TitleBarNormalButton: QStyle.SubControl = ...
    SC_ScrollBarLast: QStyle.SubControl = ...
    SC_TitleBarShadeButton: QStyle.SubControl = ...
    SC_ScrollBarSlider: QStyle.SubControl = ...
    SC_TitleBarUnshadeButton: QStyle.SubControl = ...
    SC_ScrollBarGroove: QStyle.SubControl = ...
    SC_TitleBarContextHelpButton: QStyle.SubControl = ...
    SC_TitleBarLabel: QStyle.SubControl = ...
    SE_CustomBase: QStyle.SubElement = ...
    SE_PushButtonContents: QStyle.SubElement = ...
    SE_PushButtonFocusRect: QStyle.SubElement = ...
    SE_CheckBoxIndicator: QStyle.SubElement = ...
    SE_CheckBoxContents: QStyle.SubElement = ...
    SE_CheckBoxFocusRect: QStyle.SubElement = ...
    SE_CheckBoxClickRect: QStyle.SubElement = ...
    SE_RadioButtonIndicator: QStyle.SubElement = ...
    SE_RadioButtonContents: QStyle.SubElement = ...
    SE_RadioButtonFocusRect: QStyle.SubElement = ...
    SE_RadioButtonClickRect: QStyle.SubElement = ...
    SE_ComboBoxFocusRect: QStyle.SubElement = ...
    SE_SliderFocusRect: QStyle.SubElement = ...
    SE_ProgressBarGroove: QStyle.SubElement = ...
    SE_ProgressBarContents: QStyle.SubElement = ...
    SE_ProgressBarLabel: QStyle.SubElement = ...
    SE_ToolBoxTabContents: QStyle.SubElement = ...
    SE_HeaderLabel: QStyle.SubElement = ...
    SE_HeaderArrow: QStyle.SubElement = ...
    SE_TabWidgetTabBar: QStyle.SubElement = ...
    SE_TabWidgetTabPane: QStyle.SubElement = ...
    SE_TabWidgetTabContents: QStyle.SubElement = ...
    SE_TabWidgetLeftCorner: QStyle.SubElement = ...
    SE_TabWidgetRightCorner: QStyle.SubElement = ...
    SE_ItemViewItemCheckIndicator: QStyle.SubElement = ...
    SE_TabBarTearIndicator: QStyle.SubElement = ...
    SE_TabBarTearIndicatorLeft: QStyle.SubElement = ...
    SE_TreeViewDisclosureItem: QStyle.SubElement = ...
    SE_LineEditContents: QStyle.SubElement = ...
    SE_FrameContents: QStyle.SubElement = ...
    SE_DockWidgetCloseButton: QStyle.SubElement = ...
    SE_DockWidgetFloatButton: QStyle.SubElement = ...
    SE_DockWidgetTitleBarText: QStyle.SubElement = ...
    SE_DockWidgetIcon: QStyle.SubElement = ...
    SE_CheckBoxLayoutItem: QStyle.SubElement = ...
    SE_ComboBoxLayoutItem: QStyle.SubElement = ...
    SE_DateTimeEditLayoutItem: QStyle.SubElement = ...
    SE_LabelLayoutItem: QStyle.SubElement = ...
    SE_ProgressBarLayoutItem: QStyle.SubElement = ...
    SE_PushButtonLayoutItem: QStyle.SubElement = ...
    SE_RadioButtonLayoutItem: QStyle.SubElement = ...
    SE_SliderLayoutItem: QStyle.SubElement = ...
    SE_SpinBoxLayoutItem: QStyle.SubElement = ...
    SE_ToolButtonLayoutItem: QStyle.SubElement = ...
    SE_FrameLayoutItem: QStyle.SubElement = ...
    SE_GroupBoxLayoutItem: QStyle.SubElement = ...
    SE_TabWidgetLayoutItem: QStyle.SubElement = ...
    SE_ItemViewItemDecoration: QStyle.SubElement = ...
    SE_ItemViewItemText: QStyle.SubElement = ...
    SE_ItemViewItemFocusRect: QStyle.SubElement = ...
    SE_TabBarTabLeftButton: QStyle.SubElement = ...
    SE_TabBarTabRightButton: QStyle.SubElement = ...
    SE_TabBarTabText: QStyle.SubElement = ...
    SE_ShapedFrameContents: QStyle.SubElement = ...
    SE_ToolBarHandle: QStyle.SubElement = ...
    SE_TabBarScrollLeftButton: QStyle.SubElement = ...
    SE_TabBarScrollRightButton: QStyle.SubElement = ...
    SE_TabBarTearIndicatorRight: QStyle.SubElement = ...
    SE_PushButtonBevel: QStyle.SubElement = ...

    class ComplexControl(Enum):
        CC_CustomBase: QStyle.ComplexControl = ...
        CC_SpinBox: QStyle.ComplexControl = ...
        CC_ComboBox: QStyle.ComplexControl = ...
        CC_ScrollBar: QStyle.ComplexControl = ...
        CC_Slider: QStyle.ComplexControl = ...
        CC_ToolButton: QStyle.ComplexControl = ...
        CC_TitleBar: QStyle.ComplexControl = ...
        CC_Dial: QStyle.ComplexControl = ...
        CC_GroupBox: QStyle.ComplexControl = ...
        CC_MdiControls: QStyle.ComplexControl = ...

    class ContentsType(Enum):
        CT_CustomBase: QStyle.ContentsType = ...
        CT_PushButton: QStyle.ContentsType = ...
        CT_CheckBox: QStyle.ContentsType = ...
        CT_RadioButton: QStyle.ContentsType = ...
        CT_ToolButton: QStyle.ContentsType = ...
        CT_ComboBox: QStyle.ContentsType = ...
        CT_Splitter: QStyle.ContentsType = ...
        CT_ProgressBar: QStyle.ContentsType = ...
        CT_MenuItem: QStyle.ContentsType = ...
        CT_MenuBarItem: QStyle.ContentsType = ...
        CT_MenuBar: QStyle.ContentsType = ...
        CT_Menu: QStyle.ContentsType = ...
        CT_TabBarTab: QStyle.ContentsType = ...
        CT_Slider: QStyle.ContentsType = ...
        CT_ScrollBar: QStyle.ContentsType = ...
        CT_LineEdit: QStyle.ContentsType = ...
        CT_SpinBox: QStyle.ContentsType = ...
        CT_SizeGrip: QStyle.ContentsType = ...
        CT_TabWidget: QStyle.ContentsType = ...
        CT_DialogButtons: QStyle.ContentsType = ...
        CT_HeaderSection: QStyle.ContentsType = ...
        CT_GroupBox: QStyle.ContentsType = ...
        CT_MdiControls: QStyle.ContentsType = ...
        CT_ItemViewItem: QStyle.ContentsType = ...

    class ControlElement(Enum):
        CE_CustomBase: QStyle.ControlElement = ...
        CE_PushButton: QStyle.ControlElement = ...
        CE_PushButtonBevel: QStyle.ControlElement = ...
        CE_PushButtonLabel: QStyle.ControlElement = ...
        CE_CheckBox: QStyle.ControlElement = ...
        CE_CheckBoxLabel: QStyle.ControlElement = ...
        CE_RadioButton: QStyle.ControlElement = ...
        CE_RadioButtonLabel: QStyle.ControlElement = ...
        CE_TabBarTab: QStyle.ControlElement = ...
        CE_TabBarTabShape: QStyle.ControlElement = ...
        CE_TabBarTabLabel: QStyle.ControlElement = ...
        CE_ProgressBar: QStyle.ControlElement = ...
        CE_ProgressBarGroove: QStyle.ControlElement = ...
        CE_ProgressBarContents: QStyle.ControlElement = ...
        CE_ProgressBarLabel: QStyle.ControlElement = ...
        CE_MenuItem: QStyle.ControlElement = ...
        CE_MenuScroller: QStyle.ControlElement = ...
        CE_MenuVMargin: QStyle.ControlElement = ...
        CE_MenuHMargin: QStyle.ControlElement = ...
        CE_MenuTearoff: QStyle.ControlElement = ...
        CE_MenuEmptyArea: QStyle.ControlElement = ...
        CE_MenuBarItem: QStyle.ControlElement = ...
        CE_MenuBarEmptyArea: QStyle.ControlElement = ...
        CE_ToolButtonLabel: QStyle.ControlElement = ...
        CE_Header: QStyle.ControlElement = ...
        CE_HeaderSection: QStyle.ControlElement = ...
        CE_HeaderLabel: QStyle.ControlElement = ...
        CE_ToolBoxTab: QStyle.ControlElement = ...
        CE_SizeGrip: QStyle.ControlElement = ...
        CE_Splitter: QStyle.ControlElement = ...
        CE_RubberBand: QStyle.ControlElement = ...
        CE_DockWidgetTitle: QStyle.ControlElement = ...
        CE_ScrollBarAddLine: QStyle.ControlElement = ...
        CE_ScrollBarSubLine: QStyle.ControlElement = ...
        CE_ScrollBarAddPage: QStyle.ControlElement = ...
        CE_ScrollBarSubPage: QStyle.ControlElement = ...
        CE_ScrollBarSlider: QStyle.ControlElement = ...
        CE_ScrollBarFirst: QStyle.ControlElement = ...
        CE_ScrollBarLast: QStyle.ControlElement = ...
        CE_FocusFrame: QStyle.ControlElement = ...
        CE_ComboBoxLabel: QStyle.ControlElement = ...
        CE_ToolBar: QStyle.ControlElement = ...
        CE_ToolBoxTabShape: QStyle.ControlElement = ...
        CE_ToolBoxTabLabel: QStyle.ControlElement = ...
        CE_HeaderEmptyArea: QStyle.ControlElement = ...
        CE_ColumnViewGrip: QStyle.ControlElement = ...
        CE_ItemViewItem: QStyle.ControlElement = ...
        CE_ShapedFrame: QStyle.ControlElement = ...

    class PixelMetric(Enum):
        PM_CustomBase: QStyle.PixelMetric = ...
        PM_ButtonMargin: QStyle.PixelMetric = ...
        PM_ButtonDefaultIndicator: QStyle.PixelMetric = ...
        PM_MenuButtonIndicator: QStyle.PixelMetric = ...
        PM_ButtonShiftHorizontal: QStyle.PixelMetric = ...
        PM_ButtonShiftVertical: QStyle.PixelMetric = ...
        PM_DefaultFrameWidth: QStyle.PixelMetric = ...
        PM_SpinBoxFrameWidth: QStyle.PixelMetric = ...
        PM_ComboBoxFrameWidth: QStyle.PixelMetric = ...
        PM_MaximumDragDistance: QStyle.PixelMetric = ...
        PM_ScrollBarExtent: QStyle.PixelMetric = ...
        PM_ScrollBarSliderMin: QStyle.PixelMetric = ...
        PM_SliderThickness: QStyle.PixelMetric = ...
        PM_SliderControlThickness: QStyle.PixelMetric = ...
        PM_SliderLength: QStyle.PixelMetric = ...
        PM_SliderTickmarkOffset: QStyle.PixelMetric = ...
        PM_SliderSpaceAvailable: QStyle.PixelMetric = ...
        PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ...
        PM_DockWidgetHandleExtent: QStyle.PixelMetric = ...
        PM_DockWidgetFrameWidth: QStyle.PixelMetric = ...
        PM_TabBarTabOverlap: QStyle.PixelMetric = ...
        PM_TabBarTabHSpace: QStyle.PixelMetric = ...
        PM_TabBarTabVSpace: QStyle.PixelMetric = ...
        PM_TabBarBaseHeight: QStyle.PixelMetric = ...
        PM_TabBarBaseOverlap: QStyle.PixelMetric = ...
        PM_ProgressBarChunkWidth: QStyle.PixelMetric = ...
        PM_SplitterWidth: QStyle.PixelMetric = ...
        PM_TitleBarHeight: QStyle.PixelMetric = ...
        PM_MenuScrollerHeight: QStyle.PixelMetric = ...
        PM_MenuHMargin: QStyle.PixelMetric = ...
        PM_MenuVMargin: QStyle.PixelMetric = ...
        PM_MenuPanelWidth: QStyle.PixelMetric = ...
        PM_MenuTearoffHeight: QStyle.PixelMetric = ...
        PM_MenuDesktopFrameWidth: QStyle.PixelMetric = ...
        PM_MenuBarPanelWidth: QStyle.PixelMetric = ...
        PM_MenuBarItemSpacing: QStyle.PixelMetric = ...
        PM_MenuBarVMargin: QStyle.PixelMetric = ...
        PM_MenuBarHMargin: QStyle.PixelMetric = ...
        PM_IndicatorWidth: QStyle.PixelMetric = ...
        PM_IndicatorHeight: QStyle.PixelMetric = ...
        PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ...
        PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ...
        PM_DialogButtonsSeparator: QStyle.PixelMetric = ...
        PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ...
        PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ...
        PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ...
        PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ...
        PM_HeaderMargin: QStyle.PixelMetric = ...
        PM_HeaderMarkSize: QStyle.PixelMetric = ...
        PM_HeaderGripMargin: QStyle.PixelMetric = ...
        PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ...
        PM_TabBarTabShiftVertical: QStyle.PixelMetric = ...
        PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ...
        PM_ToolBarFrameWidth: QStyle.PixelMetric = ...
        PM_ToolBarHandleExtent: QStyle.PixelMetric = ...
        PM_ToolBarItemSpacing: QStyle.PixelMetric = ...
        PM_ToolBarItemMargin: QStyle.PixelMetric = ...
        PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ...
        PM_ToolBarExtensionExtent: QStyle.PixelMetric = ...
        PM_SpinBoxSliderHeight: QStyle.PixelMetric = ...
        PM_ToolBarIconSize: QStyle.PixelMetric = ...
        PM_ListViewIconSize: QStyle.PixelMetric = ...
        PM_IconViewIconSize: QStyle.PixelMetric = ...
        PM_SmallIconSize: QStyle.PixelMetric = ...
        PM_LargeIconSize: QStyle.PixelMetric = ...
        PM_FocusFrameVMargin: QStyle.PixelMetric = ...
        PM_FocusFrameHMargin: QStyle.PixelMetric = ...
        PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ...
        PM_CheckBoxLabelSpacing: QStyle.PixelMetric = ...
        PM_TabBarIconSize: QStyle.PixelMetric = ...
        PM_SizeGripSize: QStyle.PixelMetric = ...
        PM_DockWidgetTitleMargin: QStyle.PixelMetric = ...
        PM_MessageBoxIconSize: QStyle.PixelMetric = ...
        PM_ButtonIconSize: QStyle.PixelMetric = ...
        PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ...
        PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ...
        PM_LayoutLeftMargin: QStyle.PixelMetric = ...
        PM_LayoutTopMargin: QStyle.PixelMetric = ...
        PM_LayoutRightMargin: QStyle.PixelMetric = ...
        PM_LayoutBottomMargin: QStyle.PixelMetric = ...
        PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ...
        PM_LayoutVerticalSpacing: QStyle.PixelMetric = ...
        PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ...
        PM_TextCursorWidth: QStyle.PixelMetric = ...
        PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ...
        PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ...
        PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ...
        PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ...
        PM_SubMenuOverlap: QStyle.PixelMetric = ...
        PM_TreeViewIndentation: QStyle.PixelMetric = ...
        PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ...
        PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ...
        PM_TitleBarButtonIconSize: QStyle.PixelMetric = ...
        PM_TitleBarButtonSize: QStyle.PixelMetric = ...
        PM_LineEditIconSize: QStyle.PixelMetric = ...

    class PrimitiveElement(Enum):
        PE_Frame: QStyle.PrimitiveElement = ...
        PE_FrameDefaultButton: QStyle.PrimitiveElement = ...
        PE_FrameDockWidget: QStyle.PrimitiveElement = ...
        PE_FrameFocusRect: QStyle.PrimitiveElement = ...
        PE_FrameGroupBox: QStyle.PrimitiveElement = ...
        PE_FrameLineEdit: QStyle.PrimitiveElement = ...
        PE_FrameMenu: QStyle.PrimitiveElement = ...
        PE_FrameStatusBarItem: QStyle.PrimitiveElement = ...
        PE_FrameTabWidget: QStyle.PrimitiveElement = ...
        PE_FrameWindow: QStyle.PrimitiveElement = ...
        PE_FrameButtonBevel: QStyle.PrimitiveElement = ...
        PE_FrameButtonTool: QStyle.PrimitiveElement = ...
        PE_FrameTabBarBase: QStyle.PrimitiveElement = ...
        PE_PanelButtonCommand: QStyle.PrimitiveElement = ...
        PE_PanelButtonBevel: QStyle.PrimitiveElement = ...
        PE_PanelButtonTool: QStyle.PrimitiveElement = ...
        PE_PanelMenuBar: QStyle.PrimitiveElement = ...
        PE_PanelToolBar: QStyle.PrimitiveElement = ...
        PE_PanelLineEdit: QStyle.PrimitiveElement = ...
        PE_IndicatorArrowDown: QStyle.PrimitiveElement = ...
        PE_IndicatorArrowLeft: QStyle.PrimitiveElement = ...
        PE_IndicatorArrowRight: QStyle.PrimitiveElement = ...
        PE_IndicatorArrowUp: QStyle.PrimitiveElement = ...
        PE_IndicatorBranch: QStyle.PrimitiveElement = ...
        PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ...
        PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ...
        PE_IndicatorCheckBox: QStyle.PrimitiveElement = ...
        PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ...
        PE_IndicatorHeaderArrow: QStyle.PrimitiveElement = ...
        PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ...
        PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ...
        PE_IndicatorRadioButton: QStyle.PrimitiveElement = ...
        PE_IndicatorSpinDown: QStyle.PrimitiveElement = ...
        PE_IndicatorSpinMinus: QStyle.PrimitiveElement = ...
        PE_IndicatorSpinPlus: QStyle.PrimitiveElement = ...
        PE_IndicatorSpinUp: QStyle.PrimitiveElement = ...
        PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ...
        PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ...
        PE_PanelTipLabel: QStyle.PrimitiveElement = ...
        PE_IndicatorTabTear: QStyle.PrimitiveElement = ...
        PE_IndicatorTabTearLeft: QStyle.PrimitiveElement = ...
        PE_PanelScrollAreaCorner: QStyle.PrimitiveElement = ...
        PE_Widget: QStyle.PrimitiveElement = ...
        PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ...
        PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ...
        PE_PanelItemViewItem: QStyle.PrimitiveElement = ...
        PE_PanelItemViewRow: QStyle.PrimitiveElement = ...
        PE_PanelStatusBar: QStyle.PrimitiveElement = ...
        PE_IndicatorTabClose: QStyle.PrimitiveElement = ...
        PE_PanelMenu: QStyle.PrimitiveElement = ...
        PE_IndicatorTabTearRight: QStyle.PrimitiveElement = ...
        PE_CustomBase: QStyle.PrimitiveElement = ...

    class RequestSoftwareInputPanel(Enum):
        RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ...
        RSIP_OnMouseClick: QStyle.RequestSoftwareInputPanel = ...

    class StandardPixmap(Enum):
        SP_CustomBase: QStyle.StandardPixmap = ...
        SP_TitleBarMenuButton: QStyle.StandardPixmap = ...
        SP_TitleBarMinButton: QStyle.StandardPixmap = ...
        SP_TitleBarMaxButton: QStyle.StandardPixmap = ...
        SP_TitleBarCloseButton: QStyle.StandardPixmap = ...
        SP_TitleBarNormalButton: QStyle.StandardPixmap = ...
        SP_TitleBarShadeButton: QStyle.StandardPixmap = ...
        SP_TitleBarUnshadeButton: QStyle.StandardPixmap = ...
        SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ...
        SP_DockWidgetCloseButton: QStyle.StandardPixmap = ...
        SP_MessageBoxInformation: QStyle.StandardPixmap = ...
        SP_MessageBoxWarning: QStyle.StandardPixmap = ...
        SP_MessageBoxCritical: QStyle.StandardPixmap = ...
        SP_MessageBoxQuestion: QStyle.StandardPixmap = ...
        SP_DesktopIcon: QStyle.StandardPixmap = ...
        SP_TrashIcon: QStyle.StandardPixmap = ...
        SP_ComputerIcon: QStyle.StandardPixmap = ...
        SP_DriveFDIcon: QStyle.StandardPixmap = ...
        SP_DriveHDIcon: QStyle.StandardPixmap = ...
        SP_DriveCDIcon: QStyle.StandardPixmap = ...
        SP_DriveDVDIcon: QStyle.StandardPixmap = ...
        SP_DriveNetIcon: QStyle.StandardPixmap = ...
        SP_DirOpenIcon: QStyle.StandardPixmap = ...
        SP_DirClosedIcon: QStyle.StandardPixmap = ...
        SP_DirLinkIcon: QStyle.StandardPixmap = ...
        SP_DirLinkOpenIcon: QStyle.StandardPixmap = ...
        SP_FileIcon: QStyle.StandardPixmap = ...
        SP_FileLinkIcon: QStyle.StandardPixmap = ...
        SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ...
        SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ...
        SP_FileDialogStart: QStyle.StandardPixmap = ...
        SP_FileDialogEnd: QStyle.StandardPixmap = ...
        SP_FileDialogToParent: QStyle.StandardPixmap = ...
        SP_FileDialogNewFolder: QStyle.StandardPixmap = ...
        SP_FileDialogDetailedView: QStyle.StandardPixmap = ...
        SP_FileDialogInfoView: QStyle.StandardPixmap = ...
        SP_FileDialogContentsView: QStyle.StandardPixmap = ...
        SP_FileDialogListView: QStyle.StandardPixmap = ...
        SP_FileDialogBack: QStyle.StandardPixmap = ...
        SP_DirIcon: QStyle.StandardPixmap = ...
        SP_DialogOkButton: QStyle.StandardPixmap = ...
        SP_DialogCancelButton: QStyle.StandardPixmap = ...
        SP_DialogHelpButton: QStyle.StandardPixmap = ...
        SP_DialogOpenButton: QStyle.StandardPixmap = ...
        SP_DialogSaveButton: QStyle.StandardPixmap = ...
        SP_DialogCloseButton: QStyle.StandardPixmap = ...
        SP_DialogApplyButton: QStyle.StandardPixmap = ...
        SP_DialogResetButton: QStyle.StandardPixmap = ...
        SP_DialogDiscardButton: QStyle.StandardPixmap = ...
        SP_DialogYesButton: QStyle.StandardPixmap = ...
        SP_DialogNoButton: QStyle.StandardPixmap = ...
        SP_ArrowUp: QStyle.StandardPixmap = ...
        SP_ArrowDown: QStyle.StandardPixmap = ...
        SP_ArrowLeft: QStyle.StandardPixmap = ...
        SP_ArrowRight: QStyle.StandardPixmap = ...
        SP_ArrowBack: QStyle.StandardPixmap = ...
        SP_ArrowForward: QStyle.StandardPixmap = ...
        SP_DirHomeIcon: QStyle.StandardPixmap = ...
        SP_CommandLink: QStyle.StandardPixmap = ...
        SP_VistaShield: QStyle.StandardPixmap = ...
        SP_BrowserReload: QStyle.StandardPixmap = ...
        SP_BrowserStop: QStyle.StandardPixmap = ...
        SP_MediaPlay: QStyle.StandardPixmap = ...
        SP_MediaStop: QStyle.StandardPixmap = ...
        SP_MediaPause: QStyle.StandardPixmap = ...
        SP_MediaSkipForward: QStyle.StandardPixmap = ...
        SP_MediaSkipBackward: QStyle.StandardPixmap = ...
        SP_MediaSeekForward: QStyle.StandardPixmap = ...
        SP_MediaSeekBackward: QStyle.StandardPixmap = ...
        SP_MediaVolume: QStyle.StandardPixmap = ...
        SP_MediaVolumeMuted: QStyle.StandardPixmap = ...
        SP_LineEditClearButton: QStyle.StandardPixmap = ...
        SP_DialogYesToAllButton: QStyle.StandardPixmap = ...
        SP_DialogNoToAllButton: QStyle.StandardPixmap = ...
        SP_DialogSaveAllButton: QStyle.StandardPixmap = ...
        SP_DialogAbortButton: QStyle.StandardPixmap = ...
        SP_DialogRetryButton: QStyle.StandardPixmap = ...
        SP_DialogIgnoreButton: QStyle.StandardPixmap = ...
        SP_RestoreDefaultsButton: QStyle.StandardPixmap = ...

    class State(object):
        ...

    class StateFlag(Enum):
        State_None: QStyle.StateFlag = ...
        State_Enabled: QStyle.StateFlag = ...
        State_Raised: QStyle.StateFlag = ...
        State_Sunken: QStyle.StateFlag = ...
        State_Off: QStyle.StateFlag = ...
        State_NoChange: QStyle.StateFlag = ...
        State_On: QStyle.StateFlag = ...
        State_DownArrow: QStyle.StateFlag = ...
        State_Horizontal: QStyle.StateFlag = ...
        State_HasFocus: QStyle.StateFlag = ...
        State_Top: QStyle.StateFlag = ...
        State_Bottom: QStyle.StateFlag = ...
        State_FocusAtBorder: QStyle.StateFlag = ...
        State_AutoRaise: QStyle.StateFlag = ...
        State_MouseOver: QStyle.StateFlag = ...
        State_UpArrow: QStyle.StateFlag = ...
        State_Selected: QStyle.StateFlag = ...
        State_Active: QStyle.StateFlag = ...
        State_Window: QStyle.StateFlag = ...
        State_Open: QStyle.StateFlag = ...
        State_Children: QStyle.StateFlag = ...
        State_Item: QStyle.StateFlag = ...
        State_Sibling: QStyle.StateFlag = ...
        State_Editing: QStyle.StateFlag = ...
        State_KeyboardFocusChange: QStyle.StateFlag = ...
        State_ReadOnly: QStyle.StateFlag = ...
        State_Small: QStyle.StateFlag = ...
        State_Mini: QStyle.StateFlag = ...

    class StyleHint(Enum):
        SH_CustomBase: QStyle.StyleHint = ...
        SH_EtchDisabledText: QStyle.StyleHint = ...
        SH_DitherDisabledText: QStyle.StyleHint = ...
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ...
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ...
        SH_TabBar_SelectMouseType: QStyle.StyleHint = ...
        SH_TabBar_Alignment: QStyle.StyleHint = ...
        SH_Header_ArrowAlignment: QStyle.StyleHint = ...
        SH_Slider_SnapToValue: QStyle.StyleHint = ...
        SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ...
        SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ...
        SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ...
        SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ...
        SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ...
        SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ...
        SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ...
        SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ...
        SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ...
        SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ...
        SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ...
        SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ...
        SH_Menu_MouseTracking: QStyle.StyleHint = ...
        SH_MenuBar_MouseTracking: QStyle.StyleHint = ...
        SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ...
        SH_Widget_ShareActivation: QStyle.StyleHint = ...
        SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ...
        SH_ComboBox_Popup: QStyle.StyleHint = ...
        SH_TitleBar_NoBorder: QStyle.StyleHint = ...
        SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ...
        SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ...
        SH_RichText_FullWidthSelection: QStyle.StyleHint = ...
        SH_Menu_Scrollable: QStyle.StyleHint = ...
        SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ...
        SH_GroupBox_TextLabelColor: QStyle.StyleHint = ...
        SH_Menu_SloppySubMenus: QStyle.StyleHint = ...
        SH_Table_GridLineColor: QStyle.StyleHint = ...
        SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ...
        SH_DialogButtons_DefaultButton: QStyle.StyleHint = ...
        SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ...
        SH_TabBar_PreferNoArrows: QStyle.StyleHint = ...
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ...
        SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ...
        SH_UnderlineShortcut: QStyle.StyleHint = ...
        SH_SpinBox_AnimateButton: QStyle.StyleHint = ...
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ...
        SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ...
        SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ...
        SH_ToolTipLabel_Opacity: QStyle.StyleHint = ...
        SH_DrawMenuBarSeparator: QStyle.StyleHint = ...
        SH_TitleBar_ModifyNotification: QStyle.StyleHint = ...
        SH_Button_FocusPolicy: QStyle.StyleHint = ...
        SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ...
        SH_TitleBar_AutoRaise: QStyle.StyleHint = ...
        SH_ToolButton_PopupDelay: QStyle.StyleHint = ...
        SH_FocusFrame_Mask: QStyle.StyleHint = ...
        SH_RubberBand_Mask: QStyle.StyleHint = ...
        SH_WindowFrame_Mask: QStyle.StyleHint = ...
        SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ...
        SH_Dial_BackgroundRole: QStyle.StyleHint = ...
        SH_ComboBox_LayoutDirection: QStyle.StyleHint = ...
        SH_ItemView_EllipsisLocation: QStyle.StyleHint = ...
        SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ...
        SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ...
        SH_ScrollBar_ContextMenu: QStyle.StyleHint = ...
        SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ...
        SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ...
        SH_Slider_PageSetButtons: QStyle.StyleHint = ...
        SH_Menu_KeyboardSearch: QStyle.StyleHint = ...
        SH_TabBar_ElideMode: QStyle.StyleHint = ...
        SH_DialogButtonLayout: QStyle.StyleHint = ...
        SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ...
        SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ...
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ...
        SH_MessageBox_CenterButtons: QStyle.StyleHint = ...
        SH_Menu_SelectionWrap: QStyle.StyleHint = ...
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ...
        SH_ToolTip_Mask: QStyle.StyleHint = ...
        SH_FocusFrame_AboveWidget: QStyle.StyleHint = ...
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ...
        SH_WizardStyle: QStyle.StyleHint = ...
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ...
        SH_Menu_Mask: QStyle.StyleHint = ...
        SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ...
        SH_Menu_FadeOutOnHide: QStyle.StyleHint = ...
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ...
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ...
        SH_FormLayoutWrapPolicy: QStyle.StyleHint = ...
        SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ...
        SH_ToolBar_Movable: QStyle.StyleHint = ...
        SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ...
        SH_FormLayoutFormAlignment: QStyle.StyleHint = ...
        SH_FormLayoutLabelAlignment: QStyle.StyleHint = ...
        SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ...
        SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ...
        SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ...
        SH_ToolButtonStyle: QStyle.StyleHint = ...
        SH_RequestSoftwareInputPanel: QStyle.StyleHint = ...
        SH_ScrollBar_Transient: QStyle.StyleHint = ...
        SH_Menu_SupportsSections: QStyle.StyleHint = ...
        SH_ToolTip_WakeUpDelay: QStyle.StyleHint = ...
        SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ...
        SH_Widget_Animate: QStyle.StyleHint = ...
        SH_Splitter_OpaqueResize: QStyle.StyleHint = ...
        SH_ComboBox_UseNativePopup: QStyle.StyleHint = ...
        SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ...
        SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ...
        SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ...
        SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ...
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ...
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ...
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ...
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ...
        SH_ItemView_ScrollMode: QStyle.StyleHint = ...
        SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ...
        SH_Widget_Animation_Duration: QStyle.StyleHint = ...
        SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ...
        SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ...
        SH_SpinBox_StepModifier: QStyle.StyleHint = ...
        SH_TabBar_AllowWheelScrolling: QStyle.StyleHint = ...

    class SubControl(Enum):
        SC_CustomBase: QStyle.SubControl = ...
        SC_All: QStyle.SubControl = ...
        SC_None: QStyle.SubControl = ...
        SC_ComboBoxFrame: QStyle.SubControl = ...
        SC_DialGroove: QStyle.SubControl = ...
        SC_GroupBoxCheckBox: QStyle.SubControl = ...
        SC_MdiMinButton: QStyle.SubControl = ...
        SC_ScrollBarAddLine: QStyle.SubControl = ...
        SC_SliderGroove: QStyle.SubControl = ...
        SC_SpinBoxUp: QStyle.SubControl = ...
        SC_TitleBarSysMenu: QStyle.SubControl = ...
        SC_ToolButton: QStyle.SubControl = ...
        SC_ComboBoxEditField: QStyle.SubControl = ...
        SC_DialHandle: QStyle.SubControl = ...
        SC_GroupBoxLabel: QStyle.SubControl = ...
        SC_MdiNormalButton: QStyle.SubControl = ...
        SC_ScrollBarSubLine: QStyle.SubControl = ...
        SC_SliderHandle: QStyle.SubControl = ...
        SC_SpinBoxDown: QStyle.SubControl = ...
        SC_TitleBarMinButton: QStyle.SubControl = ...
        SC_ToolButtonMenu: QStyle.SubControl = ...
        SC_ComboBoxArrow: QStyle.SubControl = ...
        SC_DialTickmarks: QStyle.SubControl = ...
        SC_GroupBoxContents: QStyle.SubControl = ...
        SC_MdiCloseButton: QStyle.SubControl = ...
        SC_ScrollBarAddPage: QStyle.SubControl = ...
        SC_SliderTickmarks: QStyle.SubControl = ...
        SC_SpinBoxFrame: QStyle.SubControl = ...
        SC_TitleBarMaxButton: QStyle.SubControl = ...
        SC_ComboBoxListBoxPopup: QStyle.SubControl = ...
        SC_GroupBoxFrame: QStyle.SubControl = ...
        SC_ScrollBarSubPage: QStyle.SubControl = ...
        SC_SpinBoxEditField: QStyle.SubControl = ...
        SC_TitleBarCloseButton: QStyle.SubControl = ...
        SC_ScrollBarFirst: QStyle.SubControl = ...
        SC_TitleBarNormalButton: QStyle.SubControl = ...
        SC_ScrollBarLast: QStyle.SubControl = ...
        SC_TitleBarShadeButton: QStyle.SubControl = ...
        SC_ScrollBarSlider: QStyle.SubControl = ...
        SC_TitleBarUnshadeButton: QStyle.SubControl = ...
        SC_ScrollBarGroove: QStyle.SubControl = ...
        SC_TitleBarContextHelpButton: QStyle.SubControl = ...
        SC_TitleBarLabel: QStyle.SubControl = ...

    class SubControls(object):
        ...

    class SubElement(Enum):
        SE_CustomBase: QStyle.SubElement = ...
        SE_PushButtonContents: QStyle.SubElement = ...
        SE_PushButtonFocusRect: QStyle.SubElement = ...
        SE_CheckBoxIndicator: QStyle.SubElement = ...
        SE_CheckBoxContents: QStyle.SubElement = ...
        SE_CheckBoxFocusRect: QStyle.SubElement = ...
        SE_CheckBoxClickRect: QStyle.SubElement = ...
        SE_RadioButtonIndicator: QStyle.SubElement = ...
        SE_RadioButtonContents: QStyle.SubElement = ...
        SE_RadioButtonFocusRect: QStyle.SubElement = ...
        SE_RadioButtonClickRect: QStyle.SubElement = ...
        SE_ComboBoxFocusRect: QStyle.SubElement = ...
        SE_SliderFocusRect: QStyle.SubElement = ...
        SE_ProgressBarGroove: QStyle.SubElement = ...
        SE_ProgressBarContents: QStyle.SubElement = ...
        SE_ProgressBarLabel: QStyle.SubElement = ...
        SE_ToolBoxTabContents: QStyle.SubElement = ...
        SE_HeaderLabel: QStyle.SubElement = ...
        SE_HeaderArrow: QStyle.SubElement = ...
        SE_TabWidgetTabBar: QStyle.SubElement = ...
        SE_TabWidgetTabPane: QStyle.SubElement = ...
        SE_TabWidgetTabContents: QStyle.SubElement = ...
        SE_TabWidgetLeftCorner: QStyle.SubElement = ...
        SE_TabWidgetRightCorner: QStyle.SubElement = ...
        SE_ItemViewItemCheckIndicator: QStyle.SubElement = ...
        SE_TabBarTearIndicator: QStyle.SubElement = ...
        SE_TabBarTearIndicatorLeft: QStyle.SubElement = ...
        SE_TreeViewDisclosureItem: QStyle.SubElement = ...
        SE_LineEditContents: QStyle.SubElement = ...
        SE_FrameContents: QStyle.SubElement = ...
        SE_DockWidgetCloseButton: QStyle.SubElement = ...
        SE_DockWidgetFloatButton: QStyle.SubElement = ...
        SE_DockWidgetTitleBarText: QStyle.SubElement = ...
        SE_DockWidgetIcon: QStyle.SubElement = ...
        SE_CheckBoxLayoutItem: QStyle.SubElement = ...
        SE_ComboBoxLayoutItem: QStyle.SubElement = ...
        SE_DateTimeEditLayoutItem: QStyle.SubElement = ...
        SE_LabelLayoutItem: QStyle.SubElement = ...
        SE_ProgressBarLayoutItem: QStyle.SubElement = ...
        SE_PushButtonLayoutItem: QStyle.SubElement = ...
        SE_RadioButtonLayoutItem: QStyle.SubElement = ...
        SE_SliderLayoutItem: QStyle.SubElement = ...
        SE_SpinBoxLayoutItem: QStyle.SubElement = ...
        SE_ToolButtonLayoutItem: QStyle.SubElement = ...
        SE_FrameLayoutItem: QStyle.SubElement = ...
        SE_GroupBoxLayoutItem: QStyle.SubElement = ...
        SE_TabWidgetLayoutItem: QStyle.SubElement = ...
        SE_ItemViewItemDecoration: QStyle.SubElement = ...
        SE_ItemViewItemText: QStyle.SubElement = ...
        SE_ItemViewItemFocusRect: QStyle.SubElement = ...
        SE_TabBarTabLeftButton: QStyle.SubElement = ...
        SE_TabBarTabRightButton: QStyle.SubElement = ...
        SE_TabBarTabText: QStyle.SubElement = ...
        SE_ShapedFrameContents: QStyle.SubElement = ...
        SE_ToolBarHandle: QStyle.SubElement = ...
        SE_TabBarScrollLeftButton: QStyle.SubElement = ...
        SE_TabBarScrollRightButton: QStyle.SubElement = ...
        SE_TabBarTearIndicatorRight: QStyle.SubElement = ...
        SE_PushButtonBevel: QStyle.SubElement = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#QStyle-1

        **QStyle::QStyle()**

        Constructs a style object.
        """
        ...

    @staticmethod
    def alignedRect(
        direction: PySide6.QtCore.Qt.LayoutDirection,
        alignment: PySide6.QtCore.Qt.Alignment,
        size: PySide6.QtCore.QSize,
        rectangle: PySide6.QtCore.QRect,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#alignedRect

        **[static] QRect QStyle::alignedRect(Qt::LayoutDirection direction ,
        Qt::Alignment alignment , const QSize & size , const QRect & rectangle
        )**

        Returns a new rectangle of the specified **size** that is aligned to the
        given **rectangle** according to the specified **alignment** and
        **direction**.
        """
        ...

    def combinedLayoutSpacing(
        self,
        controls1: PySide6.QtWidgets.QSizePolicy.ControlTypes,
        controls2: PySide6.QtWidgets.QSizePolicy.ControlTypes,
        orientation: PySide6.QtCore.Qt.Orientation,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#combinedLayoutSpacing

        **int QStyle::combinedLayoutSpacing(QSizePolicy::ControlTypes controls1
        , QSizePolicy::ControlTypes controls2 , Qt::Orientation orientation ,
        QStyleOption * option = nullptr, QWidget * widget = nullptr) const**

        Returns the spacing that should be used between **controls1** and
        **controls2** in a layout. **orientation** specifies whether the
        controls are laid out side by side or stacked vertically. The **option**
        parameter can be used to pass extra information about the parent widget.
        The **widget** parameter is optional and can also be used if **option**
        is `nullptr`.

        **controls1** and **controls2** are OR-combination of zero or more
        **control types** .

        This function is called by the layout system. It is used only if
        **PM_LayoutHorizontalSpacing**  or **PM_LayoutVerticalSpacing**  returns
        a negative value.

        **See also** **layoutSpacing** ().
        """
        ...

    def drawComplexControl(
        self,
        cc: PySide6.QtWidgets.QStyle.ComplexControl,
        opt: PySide6.QtWidgets.QStyleOptionComplex,
        p: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#drawComplexControl

        **[pure virtual] void QStyle::drawComplexControl(QStyle::ComplexControl
        control , const QStyleOptionComplex * option , QPainter * painter ,
        const QWidget * widget = nullptr) const**

        Draws the given **control** using the provided **painter** with the
        style options specified by **option**.

        The **widget** argument is optional and can be used as aid in drawing
        the control.

        The **option** parameter is a pointer to a **QStyleOptionComplex**
        object that can be cast to the correct subclass using the
        **qstyleoption_cast** () function. Note that the `rect` member of the
        specified **option** must be in logical coordinates. Reimplementations
        of this function should use **visualRect** () to change the logical
        coordinates into screen coordinates before calling the **drawPrimitive**
        () or **drawControl** () function.

        The table below is listing the complex control elements and their
        associated style option subclass. The style options contain all the
        parameters required to draw the controls, including
        **QStyleOption::state**  which holds the **style flags**  that are used
        when drawing. The table also describes which flags that are set when
        casting the given **option** to the appropriate subclass.

        Complex Control**QStyleOptionComplex**  SubclassStyle FlagRemark
        **CC_SpinBox** **QStyleOptionSpinBox** **State_Enabled** Set if the spin
        box is enabled.
        **State_HasFocus** Set if the spin box has input
        focus.
        **CC_ComboBox** **QStyleOptionComboBox** **State_Enabled** Set
        if the combobox is enabled.
        **State_HasFocus** Set if the combobox has
        input focus.
        **CC_ScrollBar** **QStyleOptionSlider** **State_Enabled**
        Set if the scroll bar is enabled.
        **State_HasFocus** Set if the scroll
        bar has input focus.
        **CC_Slider** **QStyleOptionSlider**
        **State_Enabled** Set if the slider is enabled.
        **State_HasFocus** Set
        if the slider has input focus.
        **CC_Dial** **QStyleOptionSlider**
        **State_Enabled** Set if the dial is enabled.
        **State_HasFocus** Set
        if the dial has input focus.
        **CC_ToolButton**
        **QStyleOptionToolButton** **State_Enabled** Set if the tool button is
        enabled.
        **State_HasFocus** Set if the tool button has input focus.
        **State_DownArrow** Set if the tool button is down (i.e., a mouse button
        or the space bar is pressed).
        **State_On** Set if the tool button is a
        toggle button and is toggled on.
        **State_AutoRaise** Set if the tool
        button has auto-raise enabled.
        **State_Raised** Set if the button is
        not down, not on, and doesn't contain the mouse when auto-raise is
        enabled.
        **CC_TitleBar** **QStyleOptionTitleBar** **State_Enabled**
        Set if the title bar is enabled.

        **See also** **drawPrimitive** () and **drawControl** ().
        """
        ...

    def drawControl(
        self,
        element: PySide6.QtWidgets.QStyle.ControlElement,
        opt: PySide6.QtWidgets.QStyleOption,
        p: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#drawControl

        **[pure virtual] void QStyle::drawControl(QStyle::ControlElement element
        , const QStyleOption * option , QPainter * painter , const QWidget *
        widget = nullptr) const**

        Draws the given **element** with the provided **painter** with the style
        options specified by **option**.

        The **widget** argument is optional and can be used as aid in drawing
        the control. The **option** parameter is a pointer to a **QStyleOption**
        object that can be cast to the correct subclass using the
        **qstyleoption_cast** () function.

        The table below is listing the control elements and their associated
        style option subclass. The style options contain all the parameters
        required to draw the controls, including **QStyleOption::state**  which
        holds the style flags that are used when drawing. The table also
        describes which flags that are set when casting the given option to the
        appropriate subclass.

        Note that if a control element is not listed here, it is because it uses
        a plain **QStyleOption**  object.

        Control Element**QStyleOption**  SubclassStyle FlagRemark
        **CE_MenuItem** , **CE_MenuBarItem** **QStyleOptionMenuItem**
        **State_Selected** The menu item is currently selected item.
        **State_Enabled** The item is enabled.
        **State_DownArrow** Indicates
        that a scroll down arrow should be drawn.
        **State_UpArrow** Indicates
        that a scroll up arrow should be drawn
        **State_HasFocus** Set if the
        menu bar has input focus.
        **CE_PushButton** , **CE_PushButtonBevel** ,
        **CE_PushButtonLabel** **QStyleOptionButton** **State_Enabled** Set if
        the button is enabled.
        **State_HasFocus** Set if the button has input
        focus.
        **State_Raised** Set if the button is not down, not on and not
        flat.
        **State_On** Set if the button is a toggle button and is toggled
        on.
        **State_Sunken** Set if the button is down (i.e., the mouse button
        or the space bar is pressed on the button).
        **CE_RadioButton** ,
        **CE_RadioButtonLabel** , **CE_CheckBox** , **CE_CheckBoxLabel**
        **QStyleOptionButton** **State_Enabled** Set if the button is enabled.
        **State_HasFocus** Set if the button has input focus.
        **State_On** Set
        if the button is checked.
        **State_Off** Set if the button is not
        checked.
        **State_NoChange** Set if the button is in the NoChange
        state.
        **State_Sunken** Set if the button is down (i.e., the mouse
        button or the space bar is pressed on the button).
        **CE_ProgressBarContents** , **CE_ProgressBarLabel** ,
        **CE_ProgressBarGroove** **QStyleOptionProgressBar** **State_Enabled**
        Set if the progress bar is enabled.
        **State_HasFocus** Set if the
        progress bar has input focus.
        **CE_Header** , **CE_HeaderSection** ,
        **CE_HeaderLabel** **QStyleOptionHeader**
        **CE_TabBarTab** ,
        **CE_TabBarTabShape** , **CE_TabBarTabLabel** **QStyleOptionTab**
        **State_Enabled** Set if the tab bar is enabled.
        **State_Selected**
        The tab bar is the currently selected tab bar.
        **State_HasFocus** Set
        if the tab bar tab has input focus.
        **CE_ToolButtonLabel**
        **QStyleOptionToolButton** **State_Enabled** Set if the tool button is
        enabled.
        **State_HasFocus** Set if the tool button has input focus.
        **State_Sunken** Set if the tool button is down (i.e., a mouse button or
        the space bar is pressed).
        **State_On** Set if the tool button is a
        toggle button and is toggled on.
        **State_AutoRaise** Set if the tool
        button has auto-raise enabled.
        **State_MouseOver** Set if the mouse
        pointer is over the tool button.
        **State_Raised** Set if the button is
        not down and is not on.
        **CE_ToolBoxTab** **QStyleOptionToolBox**
        **State_Selected** The tab is the currently selected tab.
        **CE_HeaderSection** **QStyleOptionHeader** **State_Sunken** Indicates
        that the section is pressed.
        **State_UpArrow** Indicates that the sort
        indicator should be pointing up.
        **State_DownArrow** Indicates that
        the sort indicator should be pointing down.

        **See also** **drawPrimitive** () and **drawComplexControl** ().
        """
        ...

    def drawItemPixmap(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        alignment: int,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#drawItemPixmap

        **[virtual] void QStyle::drawItemPixmap(QPainter * painter , const QRect
        & rectangle , int alignment , const QPixmap & pixmap ) const**

        Draws the given **pixmap** in the specified **rectangle** , according to
        the specified **alignment** , using the provided **painter**.

        **See also** **drawItemText** ().
        """
        ...

    def drawItemText(
        self,
        painter: PySide6.QtGui.QPainter,
        rect: PySide6.QtCore.QRect,
        flags: int,
        pal: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
        enabled: bool,
        text: str,
        textRole: PySide6.QtGui.QPalette.ColorRole = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#drawItemText

        **[virtual] void QStyle::drawItemText(QPainter * painter , const QRect &
        rectangle , int alignment , const QPalette & palette , bool enabled ,
        const QString & text , QPalette::ColorRole textRole = QPalette::NoRole)
        const**

        Draws the given **text** in the specified **rectangle** using the
        provided **painter** and **palette**.

        The text is drawn using the painter's pen, and aligned and wrapped
        according to the specified **alignment**. If an explicit **textRole** is
        specified, the text is drawn using the **palette** 's color for the
        given role. The **enabled** parameter indicates whether or not the item
        is enabled; when reimplementing this function, the **enabled** parameter
        should influence how the item is drawn.

        **See also** **Qt::Alignment**  and **drawItemPixmap** ().
        """
        ...

    def drawPrimitive(
        self,
        pe: PySide6.QtWidgets.QStyle.PrimitiveElement,
        opt: PySide6.QtWidgets.QStyleOption,
        p: PySide6.QtGui.QPainter,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#drawPrimitive

        **[pure virtual] void QStyle::drawPrimitive(QStyle::PrimitiveElement
        element , const QStyleOption * option , QPainter * painter , const
        QWidget * widget = nullptr) const**

        Draws the given primitive **element** with the provided **painter**
        using the style options specified by **option**.

        The **widget** argument is optional and may contain a widget that may
        aid in drawing the primitive element.

        The table below is listing the primitive elements and their associated
        style option subclasses. The style options contain all the parameters
        required to draw the elements, including **QStyleOption::state**  which
        holds the style flags that are used when drawing. The table also
        describes which flags that are set when casting the given option to the
        appropriate subclass.

        Note that if a primitive element is not listed here, it is because it
        uses a plain **QStyleOption**  object.

        Primitive Element**QStyleOption**  SubclassStyle FlagRemark
        **PE_FrameFocusRect** **QStyleOptionFocusRect** **State_FocusAtBorder**
        Whether the focus is is at the border or inside the widget.
        **PE_IndicatorCheckBox** **QStyleOptionButton** **State_NoChange**
        Indicates a "tri-state" checkbox.
        **State_On** Indicates the indicator
        is checked.
        **PE_IndicatorRadioButton** **QStyleOptionButton**
        **State_On** Indicates that a radio button is selected.
        **State_NoChange** Indicates a "tri-state" controller.
        **State_Enabled** Indicates the controller is enabled.
        **PE_IndicatorBranch** **QStyleOption** **State_Children** Indicates
        that the control for expanding the tree to show child items, should be
        drawn.
        **State_Item** Indicates that a horizontal branch (to show a
        child item), should be drawn.
        **State_Open** Indicates that the tree
        branch is expanded.
        **State_Sibling** Indicates that a vertical line
        (to show a sibling item), should be drawn.
        **PE_IndicatorHeaderArrow**
        **QStyleOptionHeader** **State_UpArrow** Indicates that the arrow should
        be drawn up; otherwise it should be down.
        **PE_FrameGroupBox** ,
        **PE_Frame** , **PE_FrameLineEdit** , **PE_FrameMenu** ,
        **PE_FrameDockWidget** , **PE_FrameWindow** **QStyleOptionFrame**
        **State_Sunken** Indicates that the Frame should be sunken.
        **PE_IndicatorToolBarHandle** **QStyleOption** **State_Horizontal**
        Indicates that the window handle is horizontal instead of vertical.
        **PE_IndicatorSpinPlus** , **PE_IndicatorSpinMinus** ,
        **PE_IndicatorSpinUp** , **PE_IndicatorSpinDown**
        ,**QStyleOptionSpinBox** **State_Sunken** Indicates that the button is
        pressed.
        **PE_PanelButtonCommand** **QStyleOptionButton**
        **State_Enabled** Set if the button is enabled.
        **State_HasFocus** Set
        if the button has input focus.
        **State_Raised** Set if the button is
        not down, not on and not flat.
        **State_On** Set if the button is a
        toggle button and is toggled on.
        **State_Sunken** Set if the button is
        down (i.e., the mouse button or the space bar is pressed on the button).

        **See also** **drawComplexControl** () and **drawControl** ().
        """
        ...

    def generatedIconPixmap(
        self,
        iconMode: PySide6.QtGui.QIcon.Mode,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
        opt: PySide6.QtWidgets.QStyleOption,
    ) -> PySide6.QtGui.QPixmap:
        """
        https://doc.qt.io/qt-6/qstyle.html#generatedIconPixmap

        **[pure virtual] QPixmap QStyle::generatedIconPixmap(QIcon::Mode
        iconMode , const QPixmap & pixmap , const QStyleOption * option )
        const**

        Returns a copy of the given **pixmap** , styled to conform to the
        specified **iconMode** and taking into account the palette specified by
        **option**.

        The **option** parameter can pass extra information, but it must contain
        a palette.

        Note that not all pixmaps will conform, in which case the returned
        pixmap is a plain copy.

        **See also** **QIcon** .
        """
        ...

    def hitTestComplexControl(
        self,
        cc: PySide6.QtWidgets.QStyle.ComplexControl,
        opt: PySide6.QtWidgets.QStyleOptionComplex,
        pt: PySide6.QtCore.QPoint,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtWidgets.QStyle.SubControl:
        """
        https://doc.qt.io/qt-6/qstyle.html#hitTestComplexControl

        **[pure virtual] QStyle::SubControl
        QStyle::hitTestComplexControl(QStyle::ComplexControl control , const
        QStyleOptionComplex * option , const QPoint & position , const QWidget *
        widget = nullptr) const**

        Returns the sub control at the given **position** in the given complex
        **control** (with the style options specified by **option** ).

        Note that the **position** is expressed in screen coordinates.

        The **option** argument is a pointer to a **QStyleOptionComplex**
        object (or one of its subclasses). The object can be cast to the
        appropriate type using the **qstyleoption_cast** () function. See
        **drawComplexControl** () for details. The **widget** argument is
        optional and can contain additional information for the function.

        **See also** **drawComplexControl** () and **subControlRect** ().
        """
        ...

    def itemPixmapRect(
        self,
        r: PySide6.QtCore.QRect,
        flags: int,
        pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str],
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#itemPixmapRect

        **[virtual] QRect QStyle::itemPixmapRect(const QRect & rectangle , int
        alignment , const QPixmap & pixmap ) const**

        Returns the area within the given **rectangle** in which to draw the
        specified **pixmap** according to the defined **alignment**.
        """
        ...

    def itemTextRect(
        self,
        fm: PySide6.QtGui.QFontMetrics,
        r: PySide6.QtCore.QRect,
        flags: int,
        enabled: bool,
        text: str,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#itemTextRect

        **[virtual] QRect QStyle::itemTextRect(const QFontMetrics & metrics ,
        const QRect & rectangle , int alignment , bool enabled , const QString &
        text ) const**

        Returns the area within the given **rectangle** in which to draw the
        provided **text** according to the specified font **metrics** and
        **alignment**. The **enabled** parameter indicates whether or not the
        associated item is enabled.

        If the given **rectangle** is larger than the area needed to render the
        **text** , the rectangle that is returned will be offset within
        **rectangle** according to the specified **alignment**. For example, if
        **alignment** is **Qt::AlignCenter** , the returned rectangle will be
        centered within **rectangle**. If the given **rectangle** is smaller
        than the area needed, the returned rectangle will be the smallest
        rectangle large enough to render the **text**.

        **See also** **Qt::Alignment** .
        """
        ...

    def layoutSpacing(
        self,
        control1: PySide6.QtWidgets.QSizePolicy.ControlType,
        control2: PySide6.QtWidgets.QSizePolicy.ControlType,
        orientation: PySide6.QtCore.Qt.Orientation,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#layoutSpacing

        **[pure virtual] int QStyle::layoutSpacing(QSizePolicy::ControlType
        control1 , QSizePolicy::ControlType control2 , Qt::Orientation
        orientation , const QStyleOption * option = nullptr, const QWidget *
        widget = nullptr) const**

        Returns the spacing that should be used between **control1** and
        **control2** in a layout. **orientation** specifies whether the controls
        are laid out side by side or stacked vertically. The **option**
        parameter can be used to pass extra information about the parent widget.
        The **widget** parameter is optional and can also be used if **option**
        is `nullptr`.

        This function is called by the layout system. It is used only if
        **PM_LayoutHorizontalSpacing**  or **PM_LayoutVerticalSpacing**  returns
        a negative value.

        **See also** **combinedLayoutSpacing** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qstyle.html#name

        **[since 6.1] QString QStyle::name() const**

        Returns the name of the style.

        This value can be used to create a style with **QStyleFactory::create**
        ().

        This function was introduced in Qt 6.1.

        **See also** **QStyleFactory::create** ().
        """
        ...

    def pixelMetric(
        self,
        metric: PySide6.QtWidgets.QStyle.PixelMetric,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#pixelMetric

        **[pure virtual] int QStyle::pixelMetric(QStyle::PixelMetric metric ,
        const QStyleOption * option = nullptr, const QWidget * widget = nullptr)
        const**

        Returns the value of the given pixel **metric**.

        The specified **option** and **widget** can be used for calculating the
        metric. In general, the **widget** argument is not used. The **option**
        can be cast to the appropriate type using the **qstyleoption_cast** ()
        function. Note that the **option** may be zero even for PixelMetrics
        that can make use of it. See the table below for the appropriate
        **option** casts:

        Pixel Metric**QStyleOption**  Subclass
        **PM_SliderControlThickness**
        **QStyleOptionSlider**
        **PM_SliderLength** **QStyleOptionSlider**
        **PM_SliderTickmarkOffset** **QStyleOptionSlider**
        **PM_SliderSpaceAvailable** **QStyleOptionSlider**
        **PM_ScrollBarExtent** **QStyleOptionSlider**
        **PM_TabBarTabOverlap**
        **QStyleOptionTab**
        **PM_TabBarTabHSpace** **QStyleOptionTab**
        **PM_TabBarTabVSpace** **QStyleOptionTab**
        **PM_TabBarBaseHeight**
        **QStyleOptionTab**
        **PM_TabBarBaseOverlap** **QStyleOptionTab**

        Some pixel metrics are called from widgets and some are only called
        internally by the style. If the metric is not called by a widget, it is
        the discretion of the style author to make use of it. For some styles,
        this may not be appropriate.
        """
        ...

    @overload
    def polish(self, application: PySide6.QtWidgets.QApplication) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#polish

        **[virtual] void QStyle::polish(QWidget * widget )**

        Initializes the appearance of the given **widget**.

        This function is called for every widget at some point after it has been
        fully created but just **before** it is shown for the very first time.

        Note that the default implementation does nothing. Reasonable actions in
        this function might be to call the QWidget::setBackgroundMode() function
        for the widget. Do not use the function to set, for example, the
        geometry. Reimplementing this function provides a back-door through
        which the appearance of a widget can be changed, but with Qt's style
        engine it is rarely necessary to implement this function; reimplement
        **drawItemPixmap** (), **drawItemText** (), **drawPrimitive** (), etc.
        instead.

        The **QWidget::inherits** () function may provide enough information to
        allow class-specific customizations. But because new **QStyle**
        subclasses are expected to work reasonably with all current and
        **future** widgets, limited use of hard-coded customization is
        recommended.

        **See also** **unpolish** ().
        """
        ...

    @overload
    def polish(
        self,
        palette: Union[
            PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#polish-1

        **[virtual] void QStyle::polish(QApplication * application )**

        This is an overloaded function.

        Late initialization of the given **application** object.
        """
        ...

    @overload
    def polish(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#polish-2

        **[virtual] void QStyle::polish(QPalette & palette )**

        This is an overloaded function.

        Changes the **palette** according to style specific requirements for
        color palettes (if any).

        **See also** **QPalette**  and **QApplication::setPalette** ().
        """
        ...

    def proxy(self) -> PySide6.QtWidgets.QStyle:
        """
        https://doc.qt.io/qt-6/qstyle.html#proxy

        **const QStyle *QStyle::proxy() const**

        This function returns the current proxy for this style. By default most
        styles will return themselves. However when a proxy style is in use, it
        will allow the style to call back into its proxy.
        """
        ...

    def sizeFromContents(
        self,
        ct: PySide6.QtWidgets.QStyle.ContentsType,
        opt: PySide6.QtWidgets.QStyleOption,
        contentsSize: PySide6.QtCore.QSize,
        w: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qstyle.html#sizeFromContents

        **[pure virtual] QSize QStyle::sizeFromContents(QStyle::ContentsType
        type , const QStyleOption * option , const QSize & contentsSize , const
        QWidget * widget = nullptr) const**

        Returns the size of the element described by the specified **option**
        and **type** , based on the provided **contentsSize**.

        The **option** argument is a pointer to a **QStyleOption**  or one of
        its subclasses. The **option** can be cast to the appropriate type using
        the **qstyleoption_cast** () function. The **widget** is an optional
        argument and can contain extra information used for calculating the
        size.

        See the table below for the appropriate **option** casts:

        Contents Type**QStyleOption**  Subclass
        **CT_CheckBox**
        **QStyleOptionButton**
        **CT_ComboBox** **QStyleOptionComboBox**
        **CT_GroupBox** **QStyleOptionGroupBox**
        **CT_HeaderSection**
        **QStyleOptionHeader**
        **CT_ItemViewItem** **QStyleOptionViewItem**
        **CT_LineEdit** **QStyleOptionFrame**
        **CT_MdiControls**
        **QStyleOptionComplex**
        **CT_Menu** **QStyleOption**
        **CT_MenuItem**
        **QStyleOptionMenuItem**
        **CT_MenuBar** **QStyleOptionMenuItem**
        **CT_MenuBarItem** **QStyleOptionMenuItem**
        **CT_ProgressBar**
        **QStyleOptionProgressBar**
        **CT_PushButton** **QStyleOptionButton**
        **CT_RadioButton** **QStyleOptionButton**
        **CT_ScrollBar**
        **QStyleOptionSlider**
        **CT_SizeGrip** **QStyleOption**
        **CT_Slider** **QStyleOptionSlider**
        **CT_SpinBox**
        **QStyleOptionSpinBox**
        **CT_Splitter** **QStyleOption**
        **CT_TabBarTab** **QStyleOptionTab**
        **CT_TabWidget**
        **QStyleOptionTabWidgetFrame**
        **CT_ToolButton**
        **QStyleOptionToolButton**

        **See also** **ContentsType**  and **QStyleOption** .
        """
        ...

    @staticmethod
    def sliderPositionFromValue(
        min: int, max: int, val: int, space: int, upsideDown: bool = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#sliderPositionFromValue

        **[static] int QStyle::sliderPositionFromValue(int min , int max , int
        logicalValue , int span , bool upsideDown = false)**

        Converts the given **logicalValue** to a pixel position. The **min**
        parameter maps to 0, **max** maps to **span** and other values are
        distributed evenly in-between.

        This function can handle the entire integer range without overflow,
        providing that **span** is less than 4096.

        By default, this function assumes that the maximum value is on the right
        for horizontal items and on the bottom for vertical items. Set the
        **upsideDown** parameter to true to reverse this behavior.

        **See also** **sliderValueFromPosition** ().
        """
        ...

    @staticmethod
    def sliderValueFromPosition(
        min: int, max: int, pos: int, space: int, upsideDown: bool = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#sliderValueFromPosition

        **[static] int QStyle::sliderValueFromPosition(int min , int max , int
        position , int span , bool upsideDown = false)**

        Converts the given pixel **position** to a logical value. 0 maps to the
        **min** parameter, **span** maps to **max** and other values are
        distributed evenly in-between.

        This function can handle the entire integer range without overflow.

        By default, this function assumes that the maximum value is on the right
        for horizontal items and on the bottom for vertical items. Set the
        **upsideDown** parameter to true to reverse this behavior.

        **See also** **sliderPositionFromValue** ().
        """
        ...

    def standardIcon(
        self,
        standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap,
        option: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qstyle.html#standardIcon

        **[pure virtual] QIcon QStyle::standardIcon(QStyle::StandardPixmap
        standardIcon , const QStyleOption * option = nullptr, const QWidget *
        widget = nullptr) const**

        Returns an icon for the given **standardIcon**.

        The **standardIcon** is a standard pixmap which can follow some existing
        GUI style or guideline. The **option** argument can be used to pass
        extra information required when defining the appropriate icon. The
        **widget** argument is optional and can also be used to aid the
        determination of the icon.
        """
        ...

    def standardPalette(self) -> PySide6.QtGui.QPalette:
        """
        https://doc.qt.io/qt-6/qstyle.html#standardPalette

        **[virtual] QPalette QStyle::standardPalette() const**

        Returns the style's standard palette.

        Note that on systems that support system colors, the style's standard
        palette is not used. In particular, the Windows Vista and Mac styles do
        not use the standard palette, but make use of native theme engines. With
        these styles, you should not set the palette with
        **QApplication::setPalette** ().

        **See also** **QApplication::setPalette** ().
        """
        ...

    def standardPixmap(
        self,
        standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap,
        opt: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtGui.QPixmap:
        ...

    def styleHint(
        self,
        stylehint: PySide6.QtWidgets.QStyle.StyleHint,
        opt: Optional[PySide6.QtWidgets.QStyleOption] = ...,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
        returnData: Optional[PySide6.QtWidgets.QStyleHintReturn] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstyle.html#styleHint

        **[pure virtual] int QStyle::styleHint(QStyle::StyleHint hint , const
        QStyleOption * option = nullptr, const QWidget * widget = nullptr,
        QStyleHintReturn * returnData = nullptr) const**

        Returns an integer representing the specified style **hint** for the
        given **widget** described by the provided style **option**.

        **returnData** is used when the querying widget needs more detailed data
        than the integer that styleHint() returns. See the **QStyleHintReturn**
        class description for details.
        """
        ...

    def subControlRect(
        self,
        cc: PySide6.QtWidgets.QStyle.ComplexControl,
        opt: PySide6.QtWidgets.QStyleOptionComplex,
        sc: PySide6.QtWidgets.QStyle.SubControl,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#subControlRect

        **[pure virtual] QRect QStyle::subControlRect(QStyle::ComplexControl
        control , const QStyleOptionComplex * option , QStyle::SubControl
        subControl , const QWidget * widget = nullptr) const**

        Returns the rectangle containing the specified **subControl** of the
        given complex **control** (with the style specified by **option** ). The
        rectangle is defined in screen coordinates.

        The **option** argument is a pointer to **QStyleOptionComplex**  or one
        of its subclasses, and can be cast to the appropriate type using the
        **qstyleoption_cast** () function. See **drawComplexControl** () for
        details. The **widget** is optional and can contain additional
        information for the function.

        **See also** **drawComplexControl** ().
        """
        ...

    def subElementRect(
        self,
        subElement: PySide6.QtWidgets.QStyle.SubElement,
        option: PySide6.QtWidgets.QStyleOption,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#subElementRect

        **[pure virtual] QRect QStyle::subElementRect(QStyle::SubElement element
        , const QStyleOption * option , const QWidget * widget = nullptr)
        const**

        Returns the sub-area for the given **element** as described in the
        provided style **option**. The returned rectangle is defined in screen
        coordinates.

        The **widget** argument is optional and can be used to aid determining
        the area. The **QStyleOption**  object can be cast to the appropriate
        type using the **qstyleoption_cast** () function. See the table below
        for the appropriate **option** casts:

        Sub Element**QStyleOption**  Subclass
        **SE_PushButtonContents**
        **QStyleOptionButton**
        **SE_PushButtonFocusRect**
        **QStyleOptionButton**
        **SE_PushButtonBevel** **QStyleOptionButton**
        **SE_CheckBoxIndicator** **QStyleOptionButton**
        **SE_CheckBoxContents** **QStyleOptionButton**
        **SE_CheckBoxFocusRect** **QStyleOptionButton**
        **SE_RadioButtonIndicator** **QStyleOptionButton**
        **SE_RadioButtonContents** **QStyleOptionButton**
        **SE_RadioButtonFocusRect** **QStyleOptionButton**
        **SE_ComboBoxFocusRect** **QStyleOptionComboBox**
        **SE_ProgressBarGroove** **QStyleOptionProgressBar**
        **SE_ProgressBarContents** **QStyleOptionProgressBar**
        **SE_ProgressBarLabel** **QStyleOptionProgressBar**
        """
        ...

    @overload
    def unpolish(self, application: PySide6.QtWidgets.QApplication) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#unpolish

        **[virtual] void QStyle::unpolish(QWidget * widget )**

        Uninitialize the given **widget** 's appearance.

        This function is the counterpart to **polish** (). It is called for
        every polished widget whenever the style is dynamically changed; the
        former style has to unpolish its settings before the new style can
        polish them again.

        Note that unpolish() will only be called if the widget is destroyed.
        This can cause problems in some cases, e.g, if you remove a widget from
        the UI, cache it, and then reinsert it after the style has changed; some
        of Qt's classes cache their widgets.

        **See also** **polish** ().
        """
        ...

    @overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstyle.html#unpolish-1

        **[virtual] void QStyle::unpolish(QApplication * application )**

        This is an overloaded function.

        Uninitialize the given **application**.
        """
        ...

    @staticmethod
    def visualAlignment(
        direction: PySide6.QtCore.Qt.LayoutDirection,
        alignment: PySide6.QtCore.Qt.Alignment,
    ) -> PySide6.QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-6/qstyle.html#visualAlignment

        **[static] Qt::Alignment QStyle::visualAlignment(Qt::LayoutDirection
        direction , Qt::Alignment alignment )**

        Transforms an **alignment** of **Qt::AlignLeft**  or **Qt::AlignRight**
        without **Qt::AlignAbsolute**  into **Qt::AlignLeft**  or
        **Qt::AlignRight**  with **Qt::AlignAbsolute**  according to the layout
        **direction**. The other alignment flags are left untouched.

        If no horizontal alignment was specified, the function returns the
        default alignment for the given layout **direction**.

        **QWidget::layoutDirection**
        """
        ...

    @staticmethod
    def visualPos(
        direction: PySide6.QtCore.Qt.LayoutDirection,
        boundingRect: PySide6.QtCore.QRect,
        logicalPos: PySide6.QtCore.QPoint,
    ) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qstyle.html#visualPos

        **[static] QPoint QStyle::visualPos(Qt::LayoutDirection direction ,
        const QRect & boundingRectangle , const QPoint & logicalPosition )**

        Returns the given **logicalPosition** converted to screen coordinates
        based on the specified **direction**. The **boundingRectangle** is used
        when performing the translation.

        **See also** **QWidget::layoutDirection** .
        """
        ...

    @staticmethod
    def visualRect(
        direction: PySide6.QtCore.Qt.LayoutDirection,
        boundingRect: PySide6.QtCore.QRect,
        logicalRect: PySide6.QtCore.QRect,
    ) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qstyle.html#visualRect

        **[static] QRect QStyle::visualRect(Qt::LayoutDirection direction ,
        const QRect & boundingRectangle , const QRect & logicalRectangle )**

        Returns the given **logicalRectangle** converted to screen coordinates
        based on the specified **direction**. The **boundingRectangle** is used
        when performing the translation.

        This function is provided to support right-to-left desktops, and is
        typically used in implementations of the **subControlRect** () function.

        **See also** **QWidget::layoutDirection** .
        """
        ...
