"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QStatusBar(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qstatusbar.html

    **Detailed Description**

    Each status indicator falls into one of three categories:

    * **Temporary** \\- briefly occupies most of the status bar. Used to explain
    tool tip texts or menu entries, for example.
      * **Normal** \\- occupies part
    of the status bar and may be hidden by temporary messages. Used to display
    the page and line number in a word processor, for example.
      * **Permanent**
    \\- is never hidden. Used for important mode indications, for example, some
    applications put a Caps Lock indicator in the status bar.

    QStatusBar lets you display all three types of indicators.

    Typically, a request for the status bar functionality occurs in relation to
    a **QMainWindow**  object. **QMainWindow**  provides a main application
    window, with a menu bar, tool bars, dock widgets **and** a status bar around
    a large central widget. The status bar can be retrieved using the
    **QMainWindow::statusBar** () function, and replaced using the
    **QMainWindow::setStatusBar** () function.

    Use the **showMessage** () slot to display a **temporary** message:

    void MainWindow::createStatusBar()
        {
    statusBar()->showMessage(tr("Ready"));
        }

    To remove a temporary message, use the **clearMessage** () slot, or set a
    time limit when calling **showMessage** (). For example:

    void MainWindow::print()
        {
        #if defined(QT_PRINTSUPPORT_LIB) &&
    QT_CONFIG(printdialog)
            **QTextDocument**  *document =
    textEdit->document();
            QPrinter printer;

            QPrintDialog
    dlg(&printer, this);
            if (dlg.exec() != **QDialog** ::Accepted) {
    return;
            }

            document->print(&printer);
    statusBar()->showMessage(tr("Ready"), 2000);
        #endif
        }

    Use the **currentMessage** () function to retrieve the temporary message
    currently shown. The QStatusBar class also provide the **messageChanged** ()
    signal which is emitted whenever the temporary status message changes.

    **Normal** and **Permanent** messages are displayed by creating a small
    widget (**QLabel** , **QProgressBar**  or even **QToolButton** ) and then
    adding it to the status bar using the **addWidget** () or the
    **addPermanentWidget** () function. Use the **removeWidget** () function to
    remove such messages from the status bar.

    statusBar()->addWidget(new MyReadWriteIndication);

    By default QStatusBar provides a **QSizeGrip**  in the lower-right corner.
    You can disable it using the **setSizeGripEnabled** () function. Use the
    **isSizeGripEnabled** () function to determine the current status of the
    size grip.

    ![A status bar shown in the Fusion widget style](images/fusion-statusbar-
    sizegrip.png)

    **See also** **QMainWindow** , **QStatusTipEvent** , **GUI Design Handbook:
    Status Bar** , and **Qt Widgets - Application Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#QStatusBar

        **QStatusBar::QStatusBar(QWidget * parent = nullptr)**

        Constructs a status bar with a size grip and the given **parent**.

        **See also** **setSizeGripEnabled** ().
        """
        ...

    def addPermanentWidget(
        self, widget: PySide6.QtWidgets.QWidget, stretch: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#addPermanentWidget

        **void QStatusBar::addPermanentWidget(QWidget * widget , int stretch =
        0)**

        Adds the given **widget** permanently to this status bar, reparenting
        the widget if it isn't already a child of this **QStatusBar**  object.
        The **stretch** parameter is used to compute a suitable size for the
        given **widget** as the status bar grows and shrinks. The default
        stretch factor is 0, i.e giving the widget a minimum of space.

        Permanently means that the widget may not be obscured by temporary
        messages. It is is located at the far right of the status bar.

        **See also** **insertPermanentWidget** (), **removeWidget** (), and
        **addWidget** ().
        """
        ...

    def addWidget(self, widget: PySide6.QtWidgets.QWidget, stretch: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#addWidget

        **void QStatusBar::addWidget(QWidget * widget , int stretch = 0)**

        Adds the given **widget** to this status bar, reparenting the widget if
        it isn't already a child of this **QStatusBar**  object. The **stretch**
        parameter is used to compute a suitable size for the given **widget** as
        the status bar grows and shrinks. The default stretch factor is 0, i.e
        giving the widget a minimum of space.

        The widget is located to the far left of the first permanent widget (see
        **addPermanentWidget** ()) and may be obscured by temporary messages.

        **See also** **insertWidget** (), **removeWidget** (), and
        **addPermanentWidget** ().
        """
        ...

    def clearMessage(self) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#clearMessage

        **[slot] void QStatusBar::clearMessage()**

        Removes any temporary message being shown.

        **See also** **currentMessage** (), **showMessage** (), and
        **removeWidget** ().
        """
        ...

    def currentMessage(self) -> str:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#currentMessage

        **QString QStatusBar::currentMessage() const**

        Returns the temporary message currently shown, or an empty string if
        there is no such message.

        **See also** **showMessage** ().
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#event

        **[override virtual protected] bool QStatusBar::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def hideOrShow(self) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#hideOrShow

        **[protected] void QStatusBar::hideOrShow()**

        Ensures that the right widgets are visible.

        Used by the **showMessage** () and **clearMessage** () functions.
        """
        ...

    def insertPermanentWidget(
        self, index: int, widget: PySide6.QtWidgets.QWidget, stretch: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#insertPermanentWidget

        **int QStatusBar::insertPermanentWidget(int index , QWidget * widget ,
        int stretch = 0)**

        Inserts the given **widget** at the given **index** permanently to this
        status bar, reparenting the widget if it isn't already a child of this
        **QStatusBar**  object. If **index** is out of range, the widget is
        appended (in which case it is the actual index of the widget that is
        returned).

        The **stretch** parameter is used to compute a suitable size for the
        given **widget** as the status bar grows and shrinks. The default
        stretch factor is 0, i.e giving the widget a minimum of space.

        Permanently means that the widget may not be obscured by temporary
        messages. It is is located at the far right of the status bar.

        **See also** **addPermanentWidget** (), **removeWidget** (), and
        **addWidget** ().
        """
        ...

    def insertWidget(
        self, index: int, widget: PySide6.QtWidgets.QWidget, stretch: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#insertWidget

        **int QStatusBar::insertWidget(int index , QWidget * widget , int
        stretch = 0)**

        Inserts the given **widget** at the given **index** to this status bar,
        reparenting the widget if it isn't already a child of this
        **QStatusBar**  object. If **index** is out of range, the widget is
        appended (in which case it is the actual index of the widget that is
        returned).

        The **stretch** parameter is used to compute a suitable size for the
        given **widget** as the status bar grows and shrinks. The default
        stretch factor is 0, i.e giving the widget a minimum of space.

        The widget is located to the far left of the first permanent widget (see
        **addPermanentWidget** ()) and may be obscured by temporary messages.

        **See also** **addWidget** (), **removeWidget** (), and
        **addPermanentWidget** ().
        """
        ...

    def isSizeGripEnabled(self) -> bool:
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#paintEvent

        **[override virtual protected] void QStatusBar::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).

        Shows the temporary message, if appropriate, in response to the paint
        **event**.
        """
        ...

    def reformat(self) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#reformat

        **[protected] void QStatusBar::reformat()**

        Changes the status bar's appearance to account for item changes.

        Special subclasses may need this function, but geometry management will
        usually take care of any necessary rearrangements.
        """
        ...

    def removeWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#removeWidget

        **void QStatusBar::removeWidget(QWidget * widget )**

        Removes the specified **widget** from the status bar.

        **Note:** This function does not delete the widget but **hides** it. To
        add the widget again, you must call both the **addWidget** () and
        **show** () functions.

        **See also** **addWidget** (), **addPermanentWidget** (), and
        **clearMessage** ().
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#resizeEvent

        **[override virtual protected] void QStatusBar::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def setSizeGripEnabled(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#sizeGripEnabled-prop

        **sizeGripEnabled : bool**

        This property holds whether the **QSizeGrip**  in the bottom-right
        corner of the status bar is enabled

        The size grip is enabled by default.

        **Access functions:**

        bool **isSizeGripEnabled** () const
        void **setSizeGripEnabled** (bool)

        **Member Function Documentation**
        """
        ...

    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#showEvent

        **[override virtual protected] void QStatusBar::showEvent(QShowEvent
        *)**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def showMessage(self, text: str, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#showMessage

        **[slot] void QStatusBar::showMessage(const QString & message , int
        timeout = 0)**

        Hides the normal status indications and displays the given **message**
        for the specified number of milli-seconds ( **timeout** ). If
        **timeout** is 0 (default), the **message** remains displayed until the
        **clearMessage** () slot is called or until the showMessage() slot is
        called again to change the message.

        Note that showMessage() is called to show temporary explanations of tool
        tip texts, so passing a **timeout** of 0 is not sufficient to display a
        **permanent message** .

        **See also** **messageChanged** (), **currentMessage** (), and
        **clearMessage** ().
        """
        ...

    @property
    def messageChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qstatusbar.html#messageChanged

        **[signal] void QStatusBar::messageChanged(const QString & message )**

        This signal is emitted whenever the temporary status message changes.
        The new temporary message is passed in the **message** parameter which
        is a null-string when the message has been removed.

        **See also** **showMessage** () and **clearMessage** ().
        """
        ...
